// Code generated by smithy-go-codegen DO NOT EDIT.

package lexruntimev2

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/eventstream"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/eventstream/eventstreamapi"
	"github.com/aws/aws-sdk-go-v2/service/lexruntimev2/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpDeleteSession struct {
}

func (*awsRestjson1_serializeOpDeleteSession) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteSessionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteSessionInput(v *DeleteSessionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotAliasId == nil || len(*v.BotAliasId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botAliasId must not be empty")}
	}
	if v.BotAliasId != nil {
		if err := encoder.SetURI("botAliasId").String(*v.BotAliasId); err != nil {
			return err
		}
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetSession struct {
}

func (*awsRestjson1_serializeOpGetSession) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSessionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSessionInput(v *GetSessionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotAliasId == nil || len(*v.BotAliasId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botAliasId must not be empty")}
	}
	if v.BotAliasId != nil {
		if err := encoder.SetURI("botAliasId").String(*v.BotAliasId); err != nil {
			return err
		}
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPutSession struct {
}

func (*awsRestjson1_serializeOpPutSession) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutSessionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutSessionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutSessionInput(v *PutSessionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotAliasId == nil || len(*v.BotAliasId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botAliasId must not be empty")}
	}
	if v.BotAliasId != nil {
		if err := encoder.SetURI("botAliasId").String(*v.BotAliasId); err != nil {
			return err
		}
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	if v.ResponseContentType != nil && len(*v.ResponseContentType) > 0 {
		locationName := "Responsecontenttype"
		encoder.SetHeader(locationName).String(*v.ResponseContentType)
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutSessionInput(v *PutSessionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Messages != nil {
		ok := object.Key("messages")
		if err := awsRestjson1_serializeDocumentMessages(v.Messages, ok); err != nil {
			return err
		}
	}

	if v.RequestAttributes != nil {
		ok := object.Key("requestAttributes")
		if err := awsRestjson1_serializeDocumentStringMap(v.RequestAttributes, ok); err != nil {
			return err
		}
	}

	if v.SessionState != nil {
		ok := object.Key("sessionState")
		if err := awsRestjson1_serializeDocumentSessionState(v.SessionState, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRecognizeText struct {
}

func (*awsRestjson1_serializeOpRecognizeText) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRecognizeText) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RecognizeTextInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}/text")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRecognizeTextInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRecognizeTextInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRecognizeTextInput(v *RecognizeTextInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotAliasId == nil || len(*v.BotAliasId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botAliasId must not be empty")}
	}
	if v.BotAliasId != nil {
		if err := encoder.SetURI("botAliasId").String(*v.BotAliasId); err != nil {
			return err
		}
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRecognizeTextInput(v *RecognizeTextInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RequestAttributes != nil {
		ok := object.Key("requestAttributes")
		if err := awsRestjson1_serializeDocumentStringMap(v.RequestAttributes, ok); err != nil {
			return err
		}
	}

	if v.SessionState != nil {
		ok := object.Key("sessionState")
		if err := awsRestjson1_serializeDocumentSessionState(v.SessionState, ok); err != nil {
			return err
		}
	}

	if v.Text != nil {
		ok := object.Key("text")
		ok.String(*v.Text)
	}

	return nil
}

type awsRestjson1_serializeOpRecognizeUtterance struct {
}

func (*awsRestjson1_serializeOpRecognizeUtterance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRecognizeUtterance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RecognizeUtteranceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}/utterance")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRecognizeUtteranceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/octet-stream")
	}

	if input.InputStream != nil {
		payload := input.InputStream
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRecognizeUtteranceInput(v *RecognizeUtteranceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotAliasId == nil || len(*v.BotAliasId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botAliasId must not be empty")}
	}
	if v.BotAliasId != nil {
		if err := encoder.SetURI("botAliasId").String(*v.BotAliasId); err != nil {
			return err
		}
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	if v.RequestAttributes != nil && len(*v.RequestAttributes) > 0 {
		locationName := "X-Amz-Lex-Request-Attributes"
		encoder.SetHeader(locationName).String(*v.RequestAttributes)
	}

	if v.RequestContentType != nil && len(*v.RequestContentType) > 0 {
		locationName := "Content-Type"
		encoder.SetHeader(locationName).String(*v.RequestContentType)
	}

	if v.ResponseContentType != nil && len(*v.ResponseContentType) > 0 {
		locationName := "Response-Content-Type"
		encoder.SetHeader(locationName).String(*v.ResponseContentType)
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	if v.SessionState != nil && len(*v.SessionState) > 0 {
		locationName := "X-Amz-Lex-Session-State"
		encoder.SetHeader(locationName).String(*v.SessionState)
	}

	return nil
}

type awsRestjson1_serializeOpStartConversation struct {
}

func (*awsRestjson1_serializeOpStartConversation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartConversation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartConversationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}/conversation")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartConversationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/vnd.amazon.eventstream")

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartConversationInput(v *StartConversationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotAliasId == nil || len(*v.BotAliasId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botAliasId must not be empty")}
	}
	if v.BotAliasId != nil {
		if err := encoder.SetURI("botAliasId").String(*v.BotAliasId); err != nil {
			return err
		}
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if len(v.ConversationMode) > 0 {
		locationName := "X-Amz-Lex-Conversation-Mode"
		encoder.SetHeader(locationName).String(string(v.ConversationMode))
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeEventStreamStartConversationRequestEventStream(v types.StartConversationRequestEventStream, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	switch vv := v.(type) {
	case *types.StartConversationRequestEventStreamMemberConfigurationEvent:
		msg.Headers.Set(eventstreamapi.EventTypeHeader, eventstream.StringValue("ConfigurationEvent"))
		return awsRestjson1_serializeEventMessageConfigurationEvent(&vv.Value, msg)

	case *types.StartConversationRequestEventStreamMemberAudioInputEvent:
		msg.Headers.Set(eventstreamapi.EventTypeHeader, eventstream.StringValue("AudioInputEvent"))
		return awsRestjson1_serializeEventMessageAudioInputEvent(&vv.Value, msg)

	case *types.StartConversationRequestEventStreamMemberDTMFInputEvent:
		msg.Headers.Set(eventstreamapi.EventTypeHeader, eventstream.StringValue("DTMFInputEvent"))
		return awsRestjson1_serializeEventMessageDTMFInputEvent(&vv.Value, msg)

	case *types.StartConversationRequestEventStreamMemberTextInputEvent:
		msg.Headers.Set(eventstreamapi.EventTypeHeader, eventstream.StringValue("TextInputEvent"))
		return awsRestjson1_serializeEventMessageTextInputEvent(&vv.Value, msg)

	case *types.StartConversationRequestEventStreamMemberPlaybackCompletionEvent:
		msg.Headers.Set(eventstreamapi.EventTypeHeader, eventstream.StringValue("PlaybackCompletionEvent"))
		return awsRestjson1_serializeEventMessagePlaybackCompletionEvent(&vv.Value, msg)

	case *types.StartConversationRequestEventStreamMemberDisconnectionEvent:
		msg.Headers.Set(eventstreamapi.EventTypeHeader, eventstream.StringValue("DisconnectionEvent"))
		return awsRestjson1_serializeEventMessageDisconnectionEvent(&vv.Value, msg)

	default:
		return fmt.Errorf("unexpected event message type: %v", v)

	}
}
func awsRestjson1_serializeEventMessageAudioInputEvent(v *types.AudioInputEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	msg.Headers.Set(eventstreamapi.ContentTypeHeader, eventstream.StringValue("application/json"))
	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeDocumentAudioInputEvent(v, jsonEncoder.Value); err != nil {
		return err
	}
	msg.Payload = jsonEncoder.Bytes()
	return nil
}

func awsRestjson1_serializeEventMessageConfigurationEvent(v *types.ConfigurationEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	msg.Headers.Set(eventstreamapi.ContentTypeHeader, eventstream.StringValue("application/json"))
	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeDocumentConfigurationEvent(v, jsonEncoder.Value); err != nil {
		return err
	}
	msg.Payload = jsonEncoder.Bytes()
	return nil
}

func awsRestjson1_serializeEventMessageDisconnectionEvent(v *types.DisconnectionEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	msg.Headers.Set(eventstreamapi.ContentTypeHeader, eventstream.StringValue("application/json"))
	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeDocumentDisconnectionEvent(v, jsonEncoder.Value); err != nil {
		return err
	}
	msg.Payload = jsonEncoder.Bytes()
	return nil
}

func awsRestjson1_serializeEventMessageDTMFInputEvent(v *types.DTMFInputEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	msg.Headers.Set(eventstreamapi.ContentTypeHeader, eventstream.StringValue("application/json"))
	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeDocumentDTMFInputEvent(v, jsonEncoder.Value); err != nil {
		return err
	}
	msg.Payload = jsonEncoder.Bytes()
	return nil
}

func awsRestjson1_serializeEventMessagePlaybackCompletionEvent(v *types.PlaybackCompletionEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	msg.Headers.Set(eventstreamapi.ContentTypeHeader, eventstream.StringValue("application/json"))
	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeDocumentPlaybackCompletionEvent(v, jsonEncoder.Value); err != nil {
		return err
	}
	msg.Payload = jsonEncoder.Bytes()
	return nil
}

func awsRestjson1_serializeEventMessageTextInputEvent(v *types.TextInputEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	msg.Headers.Set(eventstreamapi.ContentTypeHeader, eventstream.StringValue("application/json"))
	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeDocumentTextInputEvent(v, jsonEncoder.Value); err != nil {
		return err
	}
	msg.Payload = jsonEncoder.Bytes()
	return nil
}

func awsRestjson1_serializeDocumentActiveContext(v *types.ActiveContext, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContextAttributes != nil {
		ok := object.Key("contextAttributes")
		if err := awsRestjson1_serializeDocumentActiveContextParametersMap(v.ContextAttributes, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.TimeToLive != nil {
		ok := object.Key("timeToLive")
		if err := awsRestjson1_serializeDocumentActiveContextTimeToLive(v.TimeToLive, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentActiveContextParametersMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentActiveContextsList(v []types.ActiveContext, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentActiveContext(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentActiveContextTimeToLive(v *types.ActiveContextTimeToLive, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TimeToLiveInSeconds != nil {
		ok := object.Key("timeToLiveInSeconds")
		ok.Integer(*v.TimeToLiveInSeconds)
	}

	if v.TurnsToLive != nil {
		ok := object.Key("turnsToLive")
		ok.Integer(*v.TurnsToLive)
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioInputEvent(v *types.AudioInputEvent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioChunk != nil {
		ok := object.Key("audioChunk")
		ok.Base64EncodeBytes(v.AudioChunk)
	}

	if v.ClientTimestampMillis != 0 {
		ok := object.Key("clientTimestampMillis")
		ok.Long(v.ClientTimestampMillis)
	}

	if v.ContentType != nil {
		ok := object.Key("contentType")
		ok.String(*v.ContentType)
	}

	if v.EventId != nil {
		ok := object.Key("eventId")
		ok.String(*v.EventId)
	}

	return nil
}

func awsRestjson1_serializeDocumentButton(v *types.Button, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Text != nil {
		ok := object.Key("text")
		ok.String(*v.Text)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentButtonsList(v []types.Button, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentButton(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentConfigurationEvent(v *types.ConfigurationEvent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientTimestampMillis != 0 {
		ok := object.Key("clientTimestampMillis")
		ok.Long(v.ClientTimestampMillis)
	}

	if v.DisablePlayback {
		ok := object.Key("disablePlayback")
		ok.Boolean(v.DisablePlayback)
	}

	if v.EventId != nil {
		ok := object.Key("eventId")
		ok.String(*v.EventId)
	}

	if v.RequestAttributes != nil {
		ok := object.Key("requestAttributes")
		if err := awsRestjson1_serializeDocumentStringMap(v.RequestAttributes, ok); err != nil {
			return err
		}
	}

	if v.ResponseContentType != nil {
		ok := object.Key("responseContentType")
		ok.String(*v.ResponseContentType)
	}

	if v.SessionState != nil {
		ok := object.Key("sessionState")
		if err := awsRestjson1_serializeDocumentSessionState(v.SessionState, ok); err != nil {
			return err
		}
	}

	if v.WelcomeMessages != nil {
		ok := object.Key("welcomeMessages")
		if err := awsRestjson1_serializeDocumentMessages(v.WelcomeMessages, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDialogAction(v *types.DialogAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.SlotElicitationStyle) > 0 {
		ok := object.Key("slotElicitationStyle")
		ok.String(string(v.SlotElicitationStyle))
	}

	if v.SlotToElicit != nil {
		ok := object.Key("slotToElicit")
		ok.String(*v.SlotToElicit)
	}

	if v.SubSlotToElicit != nil {
		ok := object.Key("subSlotToElicit")
		if err := awsRestjson1_serializeDocumentElicitSubSlot(v.SubSlotToElicit, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentDisconnectionEvent(v *types.DisconnectionEvent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientTimestampMillis != 0 {
		ok := object.Key("clientTimestampMillis")
		ok.Long(v.ClientTimestampMillis)
	}

	if v.EventId != nil {
		ok := object.Key("eventId")
		ok.String(*v.EventId)
	}

	return nil
}

func awsRestjson1_serializeDocumentDTMFInputEvent(v *types.DTMFInputEvent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientTimestampMillis != 0 {
		ok := object.Key("clientTimestampMillis")
		ok.Long(v.ClientTimestampMillis)
	}

	if v.EventId != nil {
		ok := object.Key("eventId")
		ok.String(*v.EventId)
	}

	if v.InputCharacter != nil {
		ok := object.Key("inputCharacter")
		ok.String(*v.InputCharacter)
	}

	return nil
}

func awsRestjson1_serializeDocumentElicitSubSlot(v *types.ElicitSubSlot, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.SubSlotToElicit != nil {
		ok := object.Key("subSlotToElicit")
		if err := awsRestjson1_serializeDocumentElicitSubSlot(v.SubSlotToElicit, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentImageResponseCard(v *types.ImageResponseCard, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Buttons != nil {
		ok := object.Key("buttons")
		if err := awsRestjson1_serializeDocumentButtonsList(v.Buttons, ok); err != nil {
			return err
		}
	}

	if v.ImageUrl != nil {
		ok := object.Key("imageUrl")
		ok.String(*v.ImageUrl)
	}

	if v.Subtitle != nil {
		ok := object.Key("subtitle")
		ok.String(*v.Subtitle)
	}

	if v.Title != nil {
		ok := object.Key("title")
		ok.String(*v.Title)
	}

	return nil
}

func awsRestjson1_serializeDocumentIntent(v *types.Intent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ConfirmationState) > 0 {
		ok := object.Key("confirmationState")
		ok.String(string(v.ConfirmationState))
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Slots != nil {
		ok := object.Key("slots")
		if err := awsRestjson1_serializeDocumentSlots(v.Slots, ok); err != nil {
			return err
		}
	}

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

func awsRestjson1_serializeDocumentMessage(v *types.Message, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Content != nil {
		ok := object.Key("content")
		ok.String(*v.Content)
	}

	if len(v.ContentType) > 0 {
		ok := object.Key("contentType")
		ok.String(string(v.ContentType))
	}

	if v.ImageResponseCard != nil {
		ok := object.Key("imageResponseCard")
		if err := awsRestjson1_serializeDocumentImageResponseCard(v.ImageResponseCard, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMessages(v []types.Message, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMessage(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPlaybackCompletionEvent(v *types.PlaybackCompletionEvent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientTimestampMillis != 0 {
		ok := object.Key("clientTimestampMillis")
		ok.Long(v.ClientTimestampMillis)
	}

	if v.EventId != nil {
		ok := object.Key("eventId")
		ok.String(*v.EventId)
	}

	return nil
}

func awsRestjson1_serializeDocumentRuntimeHintDetails(v *types.RuntimeHintDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RuntimeHintValues != nil {
		ok := object.Key("runtimeHintValues")
		if err := awsRestjson1_serializeDocumentRuntimeHintValuesList(v.RuntimeHintValues, ok); err != nil {
			return err
		}
	}

	if v.SubSlotHints != nil {
		ok := object.Key("subSlotHints")
		if err := awsRestjson1_serializeDocumentSlotHintsSlotMap(v.SubSlotHints, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRuntimeHints(v *types.RuntimeHints, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SlotHints != nil {
		ok := object.Key("slotHints")
		if err := awsRestjson1_serializeDocumentSlotHintsIntentMap(v.SlotHints, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRuntimeHintValue(v *types.RuntimeHintValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Phrase != nil {
		ok := object.Key("phrase")
		ok.String(*v.Phrase)
	}

	return nil
}

func awsRestjson1_serializeDocumentRuntimeHintValuesList(v []types.RuntimeHintValue, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRuntimeHintValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSessionState(v *types.SessionState, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActiveContexts != nil {
		ok := object.Key("activeContexts")
		if err := awsRestjson1_serializeDocumentActiveContextsList(v.ActiveContexts, ok); err != nil {
			return err
		}
	}

	if v.DialogAction != nil {
		ok := object.Key("dialogAction")
		if err := awsRestjson1_serializeDocumentDialogAction(v.DialogAction, ok); err != nil {
			return err
		}
	}

	if v.Intent != nil {
		ok := object.Key("intent")
		if err := awsRestjson1_serializeDocumentIntent(v.Intent, ok); err != nil {
			return err
		}
	}

	if v.OriginatingRequestId != nil {
		ok := object.Key("originatingRequestId")
		ok.String(*v.OriginatingRequestId)
	}

	if v.RuntimeHints != nil {
		ok := object.Key("runtimeHints")
		if err := awsRestjson1_serializeDocumentRuntimeHints(v.RuntimeHints, ok); err != nil {
			return err
		}
	}

	if v.SessionAttributes != nil {
		ok := object.Key("sessionAttributes")
		if err := awsRestjson1_serializeDocumentStringMap(v.SessionAttributes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSlot(v *types.Slot, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Shape) > 0 {
		ok := object.Key("shape")
		ok.String(string(v.Shape))
	}

	if v.SubSlots != nil {
		ok := object.Key("subSlots")
		if err := awsRestjson1_serializeDocumentSlots(v.SubSlots, ok); err != nil {
			return err
		}
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentValue(v.Value, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSlotHintsIntentMap(v map[string]map[string]types.RuntimeHintDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentSlotHintsSlotMap(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSlotHintsSlotMap(v map[string]types.RuntimeHintDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentRuntimeHintDetails(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSlots(v map[string]types.Slot, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentSlot(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentStringMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTextInputEvent(v *types.TextInputEvent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientTimestampMillis != 0 {
		ok := object.Key("clientTimestampMillis")
		ok.Long(v.ClientTimestampMillis)
	}

	if v.EventId != nil {
		ok := object.Key("eventId")
		ok.String(*v.EventId)
	}

	if v.Text != nil {
		ok := object.Key("text")
		ok.String(*v.Text)
	}

	return nil
}

func awsRestjson1_serializeDocumentValue(v *types.Value, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InterpretedValue != nil {
		ok := object.Key("interpretedValue")
		ok.String(*v.InterpretedValue)
	}

	if v.OriginalValue != nil {
		ok := object.Key("originalValue")
		ok.String(*v.OriginalValue)
	}

	if v.ResolvedValues != nil {
		ok := object.Key("resolvedValues")
		if err := awsRestjson1_serializeDocumentStringList(v.ResolvedValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentValues(v []types.Slot, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSlot(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}
