// Code generated by smithy-go-codegen DO NOT EDIT.

package inspector

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List exclusions that are generated by the assessment run.
func (c *Client) ListExclusions(ctx context.Context, params *ListExclusionsInput, optFns ...func(*Options)) (*ListExclusionsOutput, error) {
	if params == nil {
		params = &ListExclusionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListExclusions", params, optFns, c.addOperationListExclusionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListExclusionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListExclusionsInput struct {

	// The ARN of the assessment run that generated the exclusions that you want to
	// list.
	//
	// This member is required.
	AssessmentRunArn *string

	// You can use this parameter to indicate the maximum number of items you want in
	// the response. The default value is 100. The maximum value is 500.
	MaxResults *int32

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the ListExclusionsRequest action.
	// Subsequent calls to the action fill nextToken in the request with the value of
	// nextToken from the previous response to continue listing data.
	NextToken *string

	noSmithyDocumentSerde
}

type ListExclusionsOutput struct {

	// A list of exclusions' ARNs returned by the action.
	//
	// This member is required.
	ExclusionArns []string

	// When a response is generated, if there is more data to be listed, this
	// parameters is present in the response and contains the value to use for the
	// nextToken parameter in a subsequent pagination request. If there is no more data
	// to be listed, this parameter is set to null.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListExclusionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListExclusions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListExclusions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListExclusions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListExclusionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListExclusions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListExclusionsAPIClient is a client that implements the ListExclusions
// operation.
type ListExclusionsAPIClient interface {
	ListExclusions(context.Context, *ListExclusionsInput, ...func(*Options)) (*ListExclusionsOutput, error)
}

var _ ListExclusionsAPIClient = (*Client)(nil)

// ListExclusionsPaginatorOptions is the paginator options for ListExclusions
type ListExclusionsPaginatorOptions struct {
	// You can use this parameter to indicate the maximum number of items you want in
	// the response. The default value is 100. The maximum value is 500.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListExclusionsPaginator is a paginator for ListExclusions
type ListExclusionsPaginator struct {
	options   ListExclusionsPaginatorOptions
	client    ListExclusionsAPIClient
	params    *ListExclusionsInput
	nextToken *string
	firstPage bool
}

// NewListExclusionsPaginator returns a new ListExclusionsPaginator
func NewListExclusionsPaginator(client ListExclusionsAPIClient, params *ListExclusionsInput, optFns ...func(*ListExclusionsPaginatorOptions)) *ListExclusionsPaginator {
	if params == nil {
		params = &ListExclusionsInput{}
	}

	options := ListExclusionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListExclusionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListExclusionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListExclusions page.
func (p *ListExclusionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListExclusionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListExclusions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListExclusions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListExclusions",
	}
}
