// Code generated by smithy-go-codegen DO NOT EDIT.

package firehose

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/firehose/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
	"path"
)

type awsAwsjson11_serializeOpCreateDeliveryStream struct {
}

func (*awsAwsjson11_serializeOpCreateDeliveryStream) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateDeliveryStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDeliveryStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Firehose_20150804.CreateDeliveryStream")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateDeliveryStreamInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteDeliveryStream struct {
}

func (*awsAwsjson11_serializeOpDeleteDeliveryStream) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteDeliveryStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDeliveryStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Firehose_20150804.DeleteDeliveryStream")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteDeliveryStreamInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeDeliveryStream struct {
}

func (*awsAwsjson11_serializeOpDescribeDeliveryStream) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeDeliveryStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDeliveryStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Firehose_20150804.DescribeDeliveryStream")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeDeliveryStreamInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListDeliveryStreams struct {
}

func (*awsAwsjson11_serializeOpListDeliveryStreams) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListDeliveryStreams) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDeliveryStreamsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Firehose_20150804.ListDeliveryStreams")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListDeliveryStreamsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListTagsForDeliveryStream struct {
}

func (*awsAwsjson11_serializeOpListTagsForDeliveryStream) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListTagsForDeliveryStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForDeliveryStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Firehose_20150804.ListTagsForDeliveryStream")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListTagsForDeliveryStreamInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutRecord struct {
}

func (*awsAwsjson11_serializeOpPutRecord) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutRecord) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutRecordInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Firehose_20150804.PutRecord")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutRecordInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutRecordBatch struct {
}

func (*awsAwsjson11_serializeOpPutRecordBatch) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutRecordBatch) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutRecordBatchInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Firehose_20150804.PutRecordBatch")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutRecordBatchInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartDeliveryStreamEncryption struct {
}

func (*awsAwsjson11_serializeOpStartDeliveryStreamEncryption) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartDeliveryStreamEncryption) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartDeliveryStreamEncryptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Firehose_20150804.StartDeliveryStreamEncryption")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartDeliveryStreamEncryptionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStopDeliveryStreamEncryption struct {
}

func (*awsAwsjson11_serializeOpStopDeliveryStreamEncryption) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStopDeliveryStreamEncryption) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopDeliveryStreamEncryptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Firehose_20150804.StopDeliveryStreamEncryption")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStopDeliveryStreamEncryptionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpTagDeliveryStream struct {
}

func (*awsAwsjson11_serializeOpTagDeliveryStream) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpTagDeliveryStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagDeliveryStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Firehose_20150804.TagDeliveryStream")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentTagDeliveryStreamInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUntagDeliveryStream struct {
}

func (*awsAwsjson11_serializeOpUntagDeliveryStream) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUntagDeliveryStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagDeliveryStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Firehose_20150804.UntagDeliveryStream")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUntagDeliveryStreamInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateDestination struct {
}

func (*awsAwsjson11_serializeOpUpdateDestination) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateDestination) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDestinationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("Firehose_20150804.UpdateDestination")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateDestinationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsAwsjson11_serializeDocumentAmazonOpenSearchServerlessBufferingHints(v *types.AmazonOpenSearchServerlessBufferingHints, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IntervalInSeconds != nil {
		ok := object.Key("IntervalInSeconds")
		ok.Integer(*v.IntervalInSeconds)
	}

	if v.SizeInMBs != nil {
		ok := object.Key("SizeInMBs")
		ok.Integer(*v.SizeInMBs)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAmazonOpenSearchServerlessDestinationConfiguration(v *types.AmazonOpenSearchServerlessDestinationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BufferingHints != nil {
		ok := object.Key("BufferingHints")
		if err := awsAwsjson11_serializeDocumentAmazonOpenSearchServerlessBufferingHints(v.BufferingHints, ok); err != nil {
			return err
		}
	}

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if v.CollectionEndpoint != nil {
		ok := object.Key("CollectionEndpoint")
		ok.String(*v.CollectionEndpoint)
	}

	if v.IndexName != nil {
		ok := object.Key("IndexName")
		ok.String(*v.IndexName)
	}

	if v.ProcessingConfiguration != nil {
		ok := object.Key("ProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentProcessingConfiguration(v.ProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RetryOptions != nil {
		ok := object.Key("RetryOptions")
		if err := awsAwsjson11_serializeDocumentAmazonOpenSearchServerlessRetryOptions(v.RetryOptions, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if len(v.S3BackupMode) > 0 {
		ok := object.Key("S3BackupMode")
		ok.String(string(v.S3BackupMode))
	}

	if v.S3Configuration != nil {
		ok := object.Key("S3Configuration")
		if err := awsAwsjson11_serializeDocumentS3DestinationConfiguration(v.S3Configuration, ok); err != nil {
			return err
		}
	}

	if v.VpcConfiguration != nil {
		ok := object.Key("VpcConfiguration")
		if err := awsAwsjson11_serializeDocumentVpcConfiguration(v.VpcConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentAmazonOpenSearchServerlessDestinationUpdate(v *types.AmazonOpenSearchServerlessDestinationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BufferingHints != nil {
		ok := object.Key("BufferingHints")
		if err := awsAwsjson11_serializeDocumentAmazonOpenSearchServerlessBufferingHints(v.BufferingHints, ok); err != nil {
			return err
		}
	}

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if v.CollectionEndpoint != nil {
		ok := object.Key("CollectionEndpoint")
		ok.String(*v.CollectionEndpoint)
	}

	if v.IndexName != nil {
		ok := object.Key("IndexName")
		ok.String(*v.IndexName)
	}

	if v.ProcessingConfiguration != nil {
		ok := object.Key("ProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentProcessingConfiguration(v.ProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RetryOptions != nil {
		ok := object.Key("RetryOptions")
		if err := awsAwsjson11_serializeDocumentAmazonOpenSearchServerlessRetryOptions(v.RetryOptions, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if v.S3Update != nil {
		ok := object.Key("S3Update")
		if err := awsAwsjson11_serializeDocumentS3DestinationUpdate(v.S3Update, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentAmazonOpenSearchServerlessRetryOptions(v *types.AmazonOpenSearchServerlessRetryOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DurationInSeconds != nil {
		ok := object.Key("DurationInSeconds")
		ok.Integer(*v.DurationInSeconds)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAmazonopensearchserviceBufferingHints(v *types.AmazonopensearchserviceBufferingHints, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IntervalInSeconds != nil {
		ok := object.Key("IntervalInSeconds")
		ok.Integer(*v.IntervalInSeconds)
	}

	if v.SizeInMBs != nil {
		ok := object.Key("SizeInMBs")
		ok.Integer(*v.SizeInMBs)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAmazonopensearchserviceDestinationConfiguration(v *types.AmazonopensearchserviceDestinationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BufferingHints != nil {
		ok := object.Key("BufferingHints")
		if err := awsAwsjson11_serializeDocumentAmazonopensearchserviceBufferingHints(v.BufferingHints, ok); err != nil {
			return err
		}
	}

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if v.ClusterEndpoint != nil {
		ok := object.Key("ClusterEndpoint")
		ok.String(*v.ClusterEndpoint)
	}

	if v.DocumentIdOptions != nil {
		ok := object.Key("DocumentIdOptions")
		if err := awsAwsjson11_serializeDocumentDocumentIdOptions(v.DocumentIdOptions, ok); err != nil {
			return err
		}
	}

	if v.DomainARN != nil {
		ok := object.Key("DomainARN")
		ok.String(*v.DomainARN)
	}

	if v.IndexName != nil {
		ok := object.Key("IndexName")
		ok.String(*v.IndexName)
	}

	if len(v.IndexRotationPeriod) > 0 {
		ok := object.Key("IndexRotationPeriod")
		ok.String(string(v.IndexRotationPeriod))
	}

	if v.ProcessingConfiguration != nil {
		ok := object.Key("ProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentProcessingConfiguration(v.ProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RetryOptions != nil {
		ok := object.Key("RetryOptions")
		if err := awsAwsjson11_serializeDocumentAmazonopensearchserviceRetryOptions(v.RetryOptions, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if len(v.S3BackupMode) > 0 {
		ok := object.Key("S3BackupMode")
		ok.String(string(v.S3BackupMode))
	}

	if v.S3Configuration != nil {
		ok := object.Key("S3Configuration")
		if err := awsAwsjson11_serializeDocumentS3DestinationConfiguration(v.S3Configuration, ok); err != nil {
			return err
		}
	}

	if v.TypeName != nil {
		ok := object.Key("TypeName")
		ok.String(*v.TypeName)
	}

	if v.VpcConfiguration != nil {
		ok := object.Key("VpcConfiguration")
		if err := awsAwsjson11_serializeDocumentVpcConfiguration(v.VpcConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentAmazonopensearchserviceDestinationUpdate(v *types.AmazonopensearchserviceDestinationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BufferingHints != nil {
		ok := object.Key("BufferingHints")
		if err := awsAwsjson11_serializeDocumentAmazonopensearchserviceBufferingHints(v.BufferingHints, ok); err != nil {
			return err
		}
	}

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if v.ClusterEndpoint != nil {
		ok := object.Key("ClusterEndpoint")
		ok.String(*v.ClusterEndpoint)
	}

	if v.DocumentIdOptions != nil {
		ok := object.Key("DocumentIdOptions")
		if err := awsAwsjson11_serializeDocumentDocumentIdOptions(v.DocumentIdOptions, ok); err != nil {
			return err
		}
	}

	if v.DomainARN != nil {
		ok := object.Key("DomainARN")
		ok.String(*v.DomainARN)
	}

	if v.IndexName != nil {
		ok := object.Key("IndexName")
		ok.String(*v.IndexName)
	}

	if len(v.IndexRotationPeriod) > 0 {
		ok := object.Key("IndexRotationPeriod")
		ok.String(string(v.IndexRotationPeriod))
	}

	if v.ProcessingConfiguration != nil {
		ok := object.Key("ProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentProcessingConfiguration(v.ProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RetryOptions != nil {
		ok := object.Key("RetryOptions")
		if err := awsAwsjson11_serializeDocumentAmazonopensearchserviceRetryOptions(v.RetryOptions, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if v.S3Update != nil {
		ok := object.Key("S3Update")
		if err := awsAwsjson11_serializeDocumentS3DestinationUpdate(v.S3Update, ok); err != nil {
			return err
		}
	}

	if v.TypeName != nil {
		ok := object.Key("TypeName")
		ok.String(*v.TypeName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAmazonopensearchserviceRetryOptions(v *types.AmazonopensearchserviceRetryOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DurationInSeconds != nil {
		ok := object.Key("DurationInSeconds")
		ok.Integer(*v.DurationInSeconds)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAuthenticationConfiguration(v *types.AuthenticationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Connectivity) > 0 {
		ok := object.Key("Connectivity")
		ok.String(string(v.Connectivity))
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentBufferingHints(v *types.BufferingHints, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IntervalInSeconds != nil {
		ok := object.Key("IntervalInSeconds")
		ok.Integer(*v.IntervalInSeconds)
	}

	if v.SizeInMBs != nil {
		ok := object.Key("SizeInMBs")
		ok.Integer(*v.SizeInMBs)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v *types.CloudWatchLoggingOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("Enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.LogGroupName != nil {
		ok := object.Key("LogGroupName")
		ok.String(*v.LogGroupName)
	}

	if v.LogStreamName != nil {
		ok := object.Key("LogStreamName")
		ok.String(*v.LogStreamName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentColumnToJsonKeyMappings(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentCopyCommand(v *types.CopyCommand, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CopyOptions != nil {
		ok := object.Key("CopyOptions")
		ok.String(*v.CopyOptions)
	}

	if v.DataTableColumns != nil {
		ok := object.Key("DataTableColumns")
		ok.String(*v.DataTableColumns)
	}

	if v.DataTableName != nil {
		ok := object.Key("DataTableName")
		ok.String(*v.DataTableName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDataFormatConversionConfiguration(v *types.DataFormatConversionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("Enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.InputFormatConfiguration != nil {
		ok := object.Key("InputFormatConfiguration")
		if err := awsAwsjson11_serializeDocumentInputFormatConfiguration(v.InputFormatConfiguration, ok); err != nil {
			return err
		}
	}

	if v.OutputFormatConfiguration != nil {
		ok := object.Key("OutputFormatConfiguration")
		if err := awsAwsjson11_serializeDocumentOutputFormatConfiguration(v.OutputFormatConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SchemaConfiguration != nil {
		ok := object.Key("SchemaConfiguration")
		if err := awsAwsjson11_serializeDocumentSchemaConfiguration(v.SchemaConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDeliveryStreamEncryptionConfigurationInput(v *types.DeliveryStreamEncryptionConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyARN != nil {
		ok := object.Key("KeyARN")
		ok.String(*v.KeyARN)
	}

	if len(v.KeyType) > 0 {
		ok := object.Key("KeyType")
		ok.String(string(v.KeyType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentDeserializer(v *types.Deserializer, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HiveJsonSerDe != nil {
		ok := object.Key("HiveJsonSerDe")
		if err := awsAwsjson11_serializeDocumentHiveJsonSerDe(v.HiveJsonSerDe, ok); err != nil {
			return err
		}
	}

	if v.OpenXJsonSerDe != nil {
		ok := object.Key("OpenXJsonSerDe")
		if err := awsAwsjson11_serializeDocumentOpenXJsonSerDe(v.OpenXJsonSerDe, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDocumentIdOptions(v *types.DocumentIdOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DefaultDocumentIdFormat) > 0 {
		ok := object.Key("DefaultDocumentIdFormat")
		ok.String(string(v.DefaultDocumentIdFormat))
	}

	return nil
}

func awsAwsjson11_serializeDocumentDynamicPartitioningConfiguration(v *types.DynamicPartitioningConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("Enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.RetryOptions != nil {
		ok := object.Key("RetryOptions")
		if err := awsAwsjson11_serializeDocumentRetryOptions(v.RetryOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentElasticsearchBufferingHints(v *types.ElasticsearchBufferingHints, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IntervalInSeconds != nil {
		ok := object.Key("IntervalInSeconds")
		ok.Integer(*v.IntervalInSeconds)
	}

	if v.SizeInMBs != nil {
		ok := object.Key("SizeInMBs")
		ok.Integer(*v.SizeInMBs)
	}

	return nil
}

func awsAwsjson11_serializeDocumentElasticsearchDestinationConfiguration(v *types.ElasticsearchDestinationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BufferingHints != nil {
		ok := object.Key("BufferingHints")
		if err := awsAwsjson11_serializeDocumentElasticsearchBufferingHints(v.BufferingHints, ok); err != nil {
			return err
		}
	}

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if v.ClusterEndpoint != nil {
		ok := object.Key("ClusterEndpoint")
		ok.String(*v.ClusterEndpoint)
	}

	if v.DocumentIdOptions != nil {
		ok := object.Key("DocumentIdOptions")
		if err := awsAwsjson11_serializeDocumentDocumentIdOptions(v.DocumentIdOptions, ok); err != nil {
			return err
		}
	}

	if v.DomainARN != nil {
		ok := object.Key("DomainARN")
		ok.String(*v.DomainARN)
	}

	if v.IndexName != nil {
		ok := object.Key("IndexName")
		ok.String(*v.IndexName)
	}

	if len(v.IndexRotationPeriod) > 0 {
		ok := object.Key("IndexRotationPeriod")
		ok.String(string(v.IndexRotationPeriod))
	}

	if v.ProcessingConfiguration != nil {
		ok := object.Key("ProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentProcessingConfiguration(v.ProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RetryOptions != nil {
		ok := object.Key("RetryOptions")
		if err := awsAwsjson11_serializeDocumentElasticsearchRetryOptions(v.RetryOptions, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if len(v.S3BackupMode) > 0 {
		ok := object.Key("S3BackupMode")
		ok.String(string(v.S3BackupMode))
	}

	if v.S3Configuration != nil {
		ok := object.Key("S3Configuration")
		if err := awsAwsjson11_serializeDocumentS3DestinationConfiguration(v.S3Configuration, ok); err != nil {
			return err
		}
	}

	if v.TypeName != nil {
		ok := object.Key("TypeName")
		ok.String(*v.TypeName)
	}

	if v.VpcConfiguration != nil {
		ok := object.Key("VpcConfiguration")
		if err := awsAwsjson11_serializeDocumentVpcConfiguration(v.VpcConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentElasticsearchDestinationUpdate(v *types.ElasticsearchDestinationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BufferingHints != nil {
		ok := object.Key("BufferingHints")
		if err := awsAwsjson11_serializeDocumentElasticsearchBufferingHints(v.BufferingHints, ok); err != nil {
			return err
		}
	}

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if v.ClusterEndpoint != nil {
		ok := object.Key("ClusterEndpoint")
		ok.String(*v.ClusterEndpoint)
	}

	if v.DocumentIdOptions != nil {
		ok := object.Key("DocumentIdOptions")
		if err := awsAwsjson11_serializeDocumentDocumentIdOptions(v.DocumentIdOptions, ok); err != nil {
			return err
		}
	}

	if v.DomainARN != nil {
		ok := object.Key("DomainARN")
		ok.String(*v.DomainARN)
	}

	if v.IndexName != nil {
		ok := object.Key("IndexName")
		ok.String(*v.IndexName)
	}

	if len(v.IndexRotationPeriod) > 0 {
		ok := object.Key("IndexRotationPeriod")
		ok.String(string(v.IndexRotationPeriod))
	}

	if v.ProcessingConfiguration != nil {
		ok := object.Key("ProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentProcessingConfiguration(v.ProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RetryOptions != nil {
		ok := object.Key("RetryOptions")
		if err := awsAwsjson11_serializeDocumentElasticsearchRetryOptions(v.RetryOptions, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if v.S3Update != nil {
		ok := object.Key("S3Update")
		if err := awsAwsjson11_serializeDocumentS3DestinationUpdate(v.S3Update, ok); err != nil {
			return err
		}
	}

	if v.TypeName != nil {
		ok := object.Key("TypeName")
		ok.String(*v.TypeName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentElasticsearchRetryOptions(v *types.ElasticsearchRetryOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DurationInSeconds != nil {
		ok := object.Key("DurationInSeconds")
		ok.Integer(*v.DurationInSeconds)
	}

	return nil
}

func awsAwsjson11_serializeDocumentEncryptionConfiguration(v *types.EncryptionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KMSEncryptionConfig != nil {
		ok := object.Key("KMSEncryptionConfig")
		if err := awsAwsjson11_serializeDocumentKMSEncryptionConfig(v.KMSEncryptionConfig, ok); err != nil {
			return err
		}
	}

	if len(v.NoEncryptionConfig) > 0 {
		ok := object.Key("NoEncryptionConfig")
		ok.String(string(v.NoEncryptionConfig))
	}

	return nil
}

func awsAwsjson11_serializeDocumentExtendedS3DestinationConfiguration(v *types.ExtendedS3DestinationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketARN != nil {
		ok := object.Key("BucketARN")
		ok.String(*v.BucketARN)
	}

	if v.BufferingHints != nil {
		ok := object.Key("BufferingHints")
		if err := awsAwsjson11_serializeDocumentBufferingHints(v.BufferingHints, ok); err != nil {
			return err
		}
	}

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if len(v.CompressionFormat) > 0 {
		ok := object.Key("CompressionFormat")
		ok.String(string(v.CompressionFormat))
	}

	if v.CustomTimeZone != nil {
		ok := object.Key("CustomTimeZone")
		ok.String(*v.CustomTimeZone)
	}

	if v.DataFormatConversionConfiguration != nil {
		ok := object.Key("DataFormatConversionConfiguration")
		if err := awsAwsjson11_serializeDocumentDataFormatConversionConfiguration(v.DataFormatConversionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.DynamicPartitioningConfiguration != nil {
		ok := object.Key("DynamicPartitioningConfiguration")
		if err := awsAwsjson11_serializeDocumentDynamicPartitioningConfiguration(v.DynamicPartitioningConfiguration, ok); err != nil {
			return err
		}
	}

	if v.EncryptionConfiguration != nil {
		ok := object.Key("EncryptionConfiguration")
		if err := awsAwsjson11_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ErrorOutputPrefix != nil {
		ok := object.Key("ErrorOutputPrefix")
		ok.String(*v.ErrorOutputPrefix)
	}

	if v.FileExtension != nil {
		ok := object.Key("FileExtension")
		ok.String(*v.FileExtension)
	}

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	if v.ProcessingConfiguration != nil {
		ok := object.Key("ProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentProcessingConfiguration(v.ProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if v.S3BackupConfiguration != nil {
		ok := object.Key("S3BackupConfiguration")
		if err := awsAwsjson11_serializeDocumentS3DestinationConfiguration(v.S3BackupConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.S3BackupMode) > 0 {
		ok := object.Key("S3BackupMode")
		ok.String(string(v.S3BackupMode))
	}

	return nil
}

func awsAwsjson11_serializeDocumentExtendedS3DestinationUpdate(v *types.ExtendedS3DestinationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketARN != nil {
		ok := object.Key("BucketARN")
		ok.String(*v.BucketARN)
	}

	if v.BufferingHints != nil {
		ok := object.Key("BufferingHints")
		if err := awsAwsjson11_serializeDocumentBufferingHints(v.BufferingHints, ok); err != nil {
			return err
		}
	}

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if len(v.CompressionFormat) > 0 {
		ok := object.Key("CompressionFormat")
		ok.String(string(v.CompressionFormat))
	}

	if v.CustomTimeZone != nil {
		ok := object.Key("CustomTimeZone")
		ok.String(*v.CustomTimeZone)
	}

	if v.DataFormatConversionConfiguration != nil {
		ok := object.Key("DataFormatConversionConfiguration")
		if err := awsAwsjson11_serializeDocumentDataFormatConversionConfiguration(v.DataFormatConversionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.DynamicPartitioningConfiguration != nil {
		ok := object.Key("DynamicPartitioningConfiguration")
		if err := awsAwsjson11_serializeDocumentDynamicPartitioningConfiguration(v.DynamicPartitioningConfiguration, ok); err != nil {
			return err
		}
	}

	if v.EncryptionConfiguration != nil {
		ok := object.Key("EncryptionConfiguration")
		if err := awsAwsjson11_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ErrorOutputPrefix != nil {
		ok := object.Key("ErrorOutputPrefix")
		ok.String(*v.ErrorOutputPrefix)
	}

	if v.FileExtension != nil {
		ok := object.Key("FileExtension")
		ok.String(*v.FileExtension)
	}

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	if v.ProcessingConfiguration != nil {
		ok := object.Key("ProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentProcessingConfiguration(v.ProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if len(v.S3BackupMode) > 0 {
		ok := object.Key("S3BackupMode")
		ok.String(string(v.S3BackupMode))
	}

	if v.S3BackupUpdate != nil {
		ok := object.Key("S3BackupUpdate")
		if err := awsAwsjson11_serializeDocumentS3DestinationUpdate(v.S3BackupUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentHiveJsonSerDe(v *types.HiveJsonSerDe, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TimestampFormats != nil {
		ok := object.Key("TimestampFormats")
		if err := awsAwsjson11_serializeDocumentListOfNonEmptyStrings(v.TimestampFormats, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentHttpEndpointBufferingHints(v *types.HttpEndpointBufferingHints, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IntervalInSeconds != nil {
		ok := object.Key("IntervalInSeconds")
		ok.Integer(*v.IntervalInSeconds)
	}

	if v.SizeInMBs != nil {
		ok := object.Key("SizeInMBs")
		ok.Integer(*v.SizeInMBs)
	}

	return nil
}

func awsAwsjson11_serializeDocumentHttpEndpointCommonAttribute(v *types.HttpEndpointCommonAttribute, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeName != nil {
		ok := object.Key("AttributeName")
		ok.String(*v.AttributeName)
	}

	if v.AttributeValue != nil {
		ok := object.Key("AttributeValue")
		ok.String(*v.AttributeValue)
	}

	return nil
}

func awsAwsjson11_serializeDocumentHttpEndpointCommonAttributesList(v []types.HttpEndpointCommonAttribute, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentHttpEndpointCommonAttribute(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentHttpEndpointConfiguration(v *types.HttpEndpointConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessKey != nil {
		ok := object.Key("AccessKey")
		ok.String(*v.AccessKey)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Url != nil {
		ok := object.Key("Url")
		ok.String(*v.Url)
	}

	return nil
}

func awsAwsjson11_serializeDocumentHttpEndpointDestinationConfiguration(v *types.HttpEndpointDestinationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BufferingHints != nil {
		ok := object.Key("BufferingHints")
		if err := awsAwsjson11_serializeDocumentHttpEndpointBufferingHints(v.BufferingHints, ok); err != nil {
			return err
		}
	}

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if v.EndpointConfiguration != nil {
		ok := object.Key("EndpointConfiguration")
		if err := awsAwsjson11_serializeDocumentHttpEndpointConfiguration(v.EndpointConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ProcessingConfiguration != nil {
		ok := object.Key("ProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentProcessingConfiguration(v.ProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RequestConfiguration != nil {
		ok := object.Key("RequestConfiguration")
		if err := awsAwsjson11_serializeDocumentHttpEndpointRequestConfiguration(v.RequestConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RetryOptions != nil {
		ok := object.Key("RetryOptions")
		if err := awsAwsjson11_serializeDocumentHttpEndpointRetryOptions(v.RetryOptions, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if len(v.S3BackupMode) > 0 {
		ok := object.Key("S3BackupMode")
		ok.String(string(v.S3BackupMode))
	}

	if v.S3Configuration != nil {
		ok := object.Key("S3Configuration")
		if err := awsAwsjson11_serializeDocumentS3DestinationConfiguration(v.S3Configuration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentHttpEndpointDestinationUpdate(v *types.HttpEndpointDestinationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BufferingHints != nil {
		ok := object.Key("BufferingHints")
		if err := awsAwsjson11_serializeDocumentHttpEndpointBufferingHints(v.BufferingHints, ok); err != nil {
			return err
		}
	}

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if v.EndpointConfiguration != nil {
		ok := object.Key("EndpointConfiguration")
		if err := awsAwsjson11_serializeDocumentHttpEndpointConfiguration(v.EndpointConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ProcessingConfiguration != nil {
		ok := object.Key("ProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentProcessingConfiguration(v.ProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RequestConfiguration != nil {
		ok := object.Key("RequestConfiguration")
		if err := awsAwsjson11_serializeDocumentHttpEndpointRequestConfiguration(v.RequestConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RetryOptions != nil {
		ok := object.Key("RetryOptions")
		if err := awsAwsjson11_serializeDocumentHttpEndpointRetryOptions(v.RetryOptions, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if len(v.S3BackupMode) > 0 {
		ok := object.Key("S3BackupMode")
		ok.String(string(v.S3BackupMode))
	}

	if v.S3Update != nil {
		ok := object.Key("S3Update")
		if err := awsAwsjson11_serializeDocumentS3DestinationUpdate(v.S3Update, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentHttpEndpointRequestConfiguration(v *types.HttpEndpointRequestConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CommonAttributes != nil {
		ok := object.Key("CommonAttributes")
		if err := awsAwsjson11_serializeDocumentHttpEndpointCommonAttributesList(v.CommonAttributes, ok); err != nil {
			return err
		}
	}

	if len(v.ContentEncoding) > 0 {
		ok := object.Key("ContentEncoding")
		ok.String(string(v.ContentEncoding))
	}

	return nil
}

func awsAwsjson11_serializeDocumentHttpEndpointRetryOptions(v *types.HttpEndpointRetryOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DurationInSeconds != nil {
		ok := object.Key("DurationInSeconds")
		ok.Integer(*v.DurationInSeconds)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInputFormatConfiguration(v *types.InputFormatConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Deserializer != nil {
		ok := object.Key("Deserializer")
		if err := awsAwsjson11_serializeDocumentDeserializer(v.Deserializer, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisStreamSourceConfiguration(v *types.KinesisStreamSourceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KinesisStreamARN != nil {
		ok := object.Key("KinesisStreamARN")
		ok.String(*v.KinesisStreamARN)
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKMSEncryptionConfig(v *types.KMSEncryptionConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AWSKMSKeyARN != nil {
		ok := object.Key("AWSKMSKeyARN")
		ok.String(*v.AWSKMSKeyARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentListOfNonEmptyStrings(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentListOfNonEmptyStringsWithoutWhitespace(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentMSKSourceConfiguration(v *types.MSKSourceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthenticationConfiguration != nil {
		ok := object.Key("AuthenticationConfiguration")
		if err := awsAwsjson11_serializeDocumentAuthenticationConfiguration(v.AuthenticationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MSKClusterARN != nil {
		ok := object.Key("MSKClusterARN")
		ok.String(*v.MSKClusterARN)
	}

	if v.TopicName != nil {
		ok := object.Key("TopicName")
		ok.String(*v.TopicName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOpenXJsonSerDe(v *types.OpenXJsonSerDe, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CaseInsensitive != nil {
		ok := object.Key("CaseInsensitive")
		ok.Boolean(*v.CaseInsensitive)
	}

	if v.ColumnToJsonKeyMappings != nil {
		ok := object.Key("ColumnToJsonKeyMappings")
		if err := awsAwsjson11_serializeDocumentColumnToJsonKeyMappings(v.ColumnToJsonKeyMappings, ok); err != nil {
			return err
		}
	}

	if v.ConvertDotsInJsonKeysToUnderscores != nil {
		ok := object.Key("ConvertDotsInJsonKeysToUnderscores")
		ok.Boolean(*v.ConvertDotsInJsonKeysToUnderscores)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOrcSerDe(v *types.OrcSerDe, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlockSizeBytes != nil {
		ok := object.Key("BlockSizeBytes")
		ok.Integer(*v.BlockSizeBytes)
	}

	if v.BloomFilterColumns != nil {
		ok := object.Key("BloomFilterColumns")
		if err := awsAwsjson11_serializeDocumentListOfNonEmptyStringsWithoutWhitespace(v.BloomFilterColumns, ok); err != nil {
			return err
		}
	}

	if v.BloomFilterFalsePositiveProbability != nil {
		ok := object.Key("BloomFilterFalsePositiveProbability")
		switch {
		case math.IsNaN(*v.BloomFilterFalsePositiveProbability):
			ok.String("NaN")

		case math.IsInf(*v.BloomFilterFalsePositiveProbability, 1):
			ok.String("Infinity")

		case math.IsInf(*v.BloomFilterFalsePositiveProbability, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.BloomFilterFalsePositiveProbability)

		}
	}

	if len(v.Compression) > 0 {
		ok := object.Key("Compression")
		ok.String(string(v.Compression))
	}

	if v.DictionaryKeyThreshold != nil {
		ok := object.Key("DictionaryKeyThreshold")
		switch {
		case math.IsNaN(*v.DictionaryKeyThreshold):
			ok.String("NaN")

		case math.IsInf(*v.DictionaryKeyThreshold, 1):
			ok.String("Infinity")

		case math.IsInf(*v.DictionaryKeyThreshold, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.DictionaryKeyThreshold)

		}
	}

	if v.EnablePadding != nil {
		ok := object.Key("EnablePadding")
		ok.Boolean(*v.EnablePadding)
	}

	if len(v.FormatVersion) > 0 {
		ok := object.Key("FormatVersion")
		ok.String(string(v.FormatVersion))
	}

	if v.PaddingTolerance != nil {
		ok := object.Key("PaddingTolerance")
		switch {
		case math.IsNaN(*v.PaddingTolerance):
			ok.String("NaN")

		case math.IsInf(*v.PaddingTolerance, 1):
			ok.String("Infinity")

		case math.IsInf(*v.PaddingTolerance, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.PaddingTolerance)

		}
	}

	if v.RowIndexStride != nil {
		ok := object.Key("RowIndexStride")
		ok.Integer(*v.RowIndexStride)
	}

	if v.StripeSizeBytes != nil {
		ok := object.Key("StripeSizeBytes")
		ok.Integer(*v.StripeSizeBytes)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOutputFormatConfiguration(v *types.OutputFormatConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Serializer != nil {
		ok := object.Key("Serializer")
		if err := awsAwsjson11_serializeDocumentSerializer(v.Serializer, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentParquetSerDe(v *types.ParquetSerDe, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlockSizeBytes != nil {
		ok := object.Key("BlockSizeBytes")
		ok.Integer(*v.BlockSizeBytes)
	}

	if len(v.Compression) > 0 {
		ok := object.Key("Compression")
		ok.String(string(v.Compression))
	}

	if v.EnableDictionaryCompression != nil {
		ok := object.Key("EnableDictionaryCompression")
		ok.Boolean(*v.EnableDictionaryCompression)
	}

	if v.MaxPaddingBytes != nil {
		ok := object.Key("MaxPaddingBytes")
		ok.Integer(*v.MaxPaddingBytes)
	}

	if v.PageSizeBytes != nil {
		ok := object.Key("PageSizeBytes")
		ok.Integer(*v.PageSizeBytes)
	}

	if len(v.WriterVersion) > 0 {
		ok := object.Key("WriterVersion")
		ok.String(string(v.WriterVersion))
	}

	return nil
}

func awsAwsjson11_serializeDocumentProcessingConfiguration(v *types.ProcessingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("Enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.Processors != nil {
		ok := object.Key("Processors")
		if err := awsAwsjson11_serializeDocumentProcessorList(v.Processors, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentProcessor(v *types.Processor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsAwsjson11_serializeDocumentProcessorParameterList(v.Parameters, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentProcessorList(v []types.Processor, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentProcessor(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentProcessorParameter(v *types.ProcessorParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ParameterName) > 0 {
		ok := object.Key("ParameterName")
		ok.String(string(v.ParameterName))
	}

	if v.ParameterValue != nil {
		ok := object.Key("ParameterValue")
		ok.String(*v.ParameterValue)
	}

	return nil
}

func awsAwsjson11_serializeDocumentProcessorParameterList(v []types.ProcessorParameter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentProcessorParameter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentPutRecordBatchRequestEntryList(v []types.Record, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentRecord(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentRecord(v *types.Record, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Data != nil {
		ok := object.Key("Data")
		ok.Base64EncodeBytes(v.Data)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRedshiftDestinationConfiguration(v *types.RedshiftDestinationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if v.ClusterJDBCURL != nil {
		ok := object.Key("ClusterJDBCURL")
		ok.String(*v.ClusterJDBCURL)
	}

	if v.CopyCommand != nil {
		ok := object.Key("CopyCommand")
		if err := awsAwsjson11_serializeDocumentCopyCommand(v.CopyCommand, ok); err != nil {
			return err
		}
	}

	if v.Password != nil {
		ok := object.Key("Password")
		ok.String(*v.Password)
	}

	if v.ProcessingConfiguration != nil {
		ok := object.Key("ProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentProcessingConfiguration(v.ProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RetryOptions != nil {
		ok := object.Key("RetryOptions")
		if err := awsAwsjson11_serializeDocumentRedshiftRetryOptions(v.RetryOptions, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if v.S3BackupConfiguration != nil {
		ok := object.Key("S3BackupConfiguration")
		if err := awsAwsjson11_serializeDocumentS3DestinationConfiguration(v.S3BackupConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.S3BackupMode) > 0 {
		ok := object.Key("S3BackupMode")
		ok.String(string(v.S3BackupMode))
	}

	if v.S3Configuration != nil {
		ok := object.Key("S3Configuration")
		if err := awsAwsjson11_serializeDocumentS3DestinationConfiguration(v.S3Configuration, ok); err != nil {
			return err
		}
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRedshiftDestinationUpdate(v *types.RedshiftDestinationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if v.ClusterJDBCURL != nil {
		ok := object.Key("ClusterJDBCURL")
		ok.String(*v.ClusterJDBCURL)
	}

	if v.CopyCommand != nil {
		ok := object.Key("CopyCommand")
		if err := awsAwsjson11_serializeDocumentCopyCommand(v.CopyCommand, ok); err != nil {
			return err
		}
	}

	if v.Password != nil {
		ok := object.Key("Password")
		ok.String(*v.Password)
	}

	if v.ProcessingConfiguration != nil {
		ok := object.Key("ProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentProcessingConfiguration(v.ProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RetryOptions != nil {
		ok := object.Key("RetryOptions")
		if err := awsAwsjson11_serializeDocumentRedshiftRetryOptions(v.RetryOptions, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if len(v.S3BackupMode) > 0 {
		ok := object.Key("S3BackupMode")
		ok.String(string(v.S3BackupMode))
	}

	if v.S3BackupUpdate != nil {
		ok := object.Key("S3BackupUpdate")
		if err := awsAwsjson11_serializeDocumentS3DestinationUpdate(v.S3BackupUpdate, ok); err != nil {
			return err
		}
	}

	if v.S3Update != nil {
		ok := object.Key("S3Update")
		if err := awsAwsjson11_serializeDocumentS3DestinationUpdate(v.S3Update, ok); err != nil {
			return err
		}
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRedshiftRetryOptions(v *types.RedshiftRetryOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DurationInSeconds != nil {
		ok := object.Key("DurationInSeconds")
		ok.Integer(*v.DurationInSeconds)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRetryOptions(v *types.RetryOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DurationInSeconds != nil {
		ok := object.Key("DurationInSeconds")
		ok.Integer(*v.DurationInSeconds)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3DestinationConfiguration(v *types.S3DestinationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketARN != nil {
		ok := object.Key("BucketARN")
		ok.String(*v.BucketARN)
	}

	if v.BufferingHints != nil {
		ok := object.Key("BufferingHints")
		if err := awsAwsjson11_serializeDocumentBufferingHints(v.BufferingHints, ok); err != nil {
			return err
		}
	}

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if len(v.CompressionFormat) > 0 {
		ok := object.Key("CompressionFormat")
		ok.String(string(v.CompressionFormat))
	}

	if v.EncryptionConfiguration != nil {
		ok := object.Key("EncryptionConfiguration")
		if err := awsAwsjson11_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ErrorOutputPrefix != nil {
		ok := object.Key("ErrorOutputPrefix")
		ok.String(*v.ErrorOutputPrefix)
	}

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3DestinationUpdate(v *types.S3DestinationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketARN != nil {
		ok := object.Key("BucketARN")
		ok.String(*v.BucketARN)
	}

	if v.BufferingHints != nil {
		ok := object.Key("BufferingHints")
		if err := awsAwsjson11_serializeDocumentBufferingHints(v.BufferingHints, ok); err != nil {
			return err
		}
	}

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if len(v.CompressionFormat) > 0 {
		ok := object.Key("CompressionFormat")
		ok.String(string(v.CompressionFormat))
	}

	if v.EncryptionConfiguration != nil {
		ok := object.Key("EncryptionConfiguration")
		if err := awsAwsjson11_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ErrorOutputPrefix != nil {
		ok := object.Key("ErrorOutputPrefix")
		ok.String(*v.ErrorOutputPrefix)
	}

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSchemaConfiguration(v *types.SchemaConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("CatalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("DatabaseName")
		ok.String(*v.DatabaseName)
	}

	if v.Region != nil {
		ok := object.Key("Region")
		ok.String(*v.Region)
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if v.TableName != nil {
		ok := object.Key("TableName")
		ok.String(*v.TableName)
	}

	if v.VersionId != nil {
		ok := object.Key("VersionId")
		ok.String(*v.VersionId)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSecurityGroupIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentSerializer(v *types.Serializer, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OrcSerDe != nil {
		ok := object.Key("OrcSerDe")
		if err := awsAwsjson11_serializeDocumentOrcSerDe(v.OrcSerDe, ok); err != nil {
			return err
		}
	}

	if v.ParquetSerDe != nil {
		ok := object.Key("ParquetSerDe")
		if err := awsAwsjson11_serializeDocumentParquetSerDe(v.ParquetSerDe, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSnowflakeDestinationConfiguration(v *types.SnowflakeDestinationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountUrl != nil {
		ok := object.Key("AccountUrl")
		ok.String(*v.AccountUrl)
	}

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if v.ContentColumnName != nil {
		ok := object.Key("ContentColumnName")
		ok.String(*v.ContentColumnName)
	}

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if len(v.DataLoadingOption) > 0 {
		ok := object.Key("DataLoadingOption")
		ok.String(string(v.DataLoadingOption))
	}

	if v.KeyPassphrase != nil {
		ok := object.Key("KeyPassphrase")
		ok.String(*v.KeyPassphrase)
	}

	if v.MetaDataColumnName != nil {
		ok := object.Key("MetaDataColumnName")
		ok.String(*v.MetaDataColumnName)
	}

	if v.PrivateKey != nil {
		ok := object.Key("PrivateKey")
		ok.String(*v.PrivateKey)
	}

	if v.ProcessingConfiguration != nil {
		ok := object.Key("ProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentProcessingConfiguration(v.ProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RetryOptions != nil {
		ok := object.Key("RetryOptions")
		if err := awsAwsjson11_serializeDocumentSnowflakeRetryOptions(v.RetryOptions, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if len(v.S3BackupMode) > 0 {
		ok := object.Key("S3BackupMode")
		ok.String(string(v.S3BackupMode))
	}

	if v.S3Configuration != nil {
		ok := object.Key("S3Configuration")
		if err := awsAwsjson11_serializeDocumentS3DestinationConfiguration(v.S3Configuration, ok); err != nil {
			return err
		}
	}

	if v.Schema != nil {
		ok := object.Key("Schema")
		ok.String(*v.Schema)
	}

	if v.SnowflakeRoleConfiguration != nil {
		ok := object.Key("SnowflakeRoleConfiguration")
		if err := awsAwsjson11_serializeDocumentSnowflakeRoleConfiguration(v.SnowflakeRoleConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SnowflakeVpcConfiguration != nil {
		ok := object.Key("SnowflakeVpcConfiguration")
		if err := awsAwsjson11_serializeDocumentSnowflakeVpcConfiguration(v.SnowflakeVpcConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	if v.User != nil {
		ok := object.Key("User")
		ok.String(*v.User)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSnowflakeDestinationUpdate(v *types.SnowflakeDestinationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountUrl != nil {
		ok := object.Key("AccountUrl")
		ok.String(*v.AccountUrl)
	}

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if v.ContentColumnName != nil {
		ok := object.Key("ContentColumnName")
		ok.String(*v.ContentColumnName)
	}

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if len(v.DataLoadingOption) > 0 {
		ok := object.Key("DataLoadingOption")
		ok.String(string(v.DataLoadingOption))
	}

	if v.KeyPassphrase != nil {
		ok := object.Key("KeyPassphrase")
		ok.String(*v.KeyPassphrase)
	}

	if v.MetaDataColumnName != nil {
		ok := object.Key("MetaDataColumnName")
		ok.String(*v.MetaDataColumnName)
	}

	if v.PrivateKey != nil {
		ok := object.Key("PrivateKey")
		ok.String(*v.PrivateKey)
	}

	if v.ProcessingConfiguration != nil {
		ok := object.Key("ProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentProcessingConfiguration(v.ProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RetryOptions != nil {
		ok := object.Key("RetryOptions")
		if err := awsAwsjson11_serializeDocumentSnowflakeRetryOptions(v.RetryOptions, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if len(v.S3BackupMode) > 0 {
		ok := object.Key("S3BackupMode")
		ok.String(string(v.S3BackupMode))
	}

	if v.S3Update != nil {
		ok := object.Key("S3Update")
		if err := awsAwsjson11_serializeDocumentS3DestinationUpdate(v.S3Update, ok); err != nil {
			return err
		}
	}

	if v.Schema != nil {
		ok := object.Key("Schema")
		ok.String(*v.Schema)
	}

	if v.SnowflakeRoleConfiguration != nil {
		ok := object.Key("SnowflakeRoleConfiguration")
		if err := awsAwsjson11_serializeDocumentSnowflakeRoleConfiguration(v.SnowflakeRoleConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Table != nil {
		ok := object.Key("Table")
		ok.String(*v.Table)
	}

	if v.User != nil {
		ok := object.Key("User")
		ok.String(*v.User)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSnowflakeRetryOptions(v *types.SnowflakeRetryOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DurationInSeconds != nil {
		ok := object.Key("DurationInSeconds")
		ok.Integer(*v.DurationInSeconds)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSnowflakeRoleConfiguration(v *types.SnowflakeRoleConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("Enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.SnowflakeRole != nil {
		ok := object.Key("SnowflakeRole")
		ok.String(*v.SnowflakeRole)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSnowflakeVpcConfiguration(v *types.SnowflakeVpcConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PrivateLinkVpceId != nil {
		ok := object.Key("PrivateLinkVpceId")
		ok.String(*v.PrivateLinkVpceId)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSplunkBufferingHints(v *types.SplunkBufferingHints, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IntervalInSeconds != nil {
		ok := object.Key("IntervalInSeconds")
		ok.Integer(*v.IntervalInSeconds)
	}

	if v.SizeInMBs != nil {
		ok := object.Key("SizeInMBs")
		ok.Integer(*v.SizeInMBs)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSplunkDestinationConfiguration(v *types.SplunkDestinationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BufferingHints != nil {
		ok := object.Key("BufferingHints")
		if err := awsAwsjson11_serializeDocumentSplunkBufferingHints(v.BufferingHints, ok); err != nil {
			return err
		}
	}

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if v.HECAcknowledgmentTimeoutInSeconds != nil {
		ok := object.Key("HECAcknowledgmentTimeoutInSeconds")
		ok.Integer(*v.HECAcknowledgmentTimeoutInSeconds)
	}

	if v.HECEndpoint != nil {
		ok := object.Key("HECEndpoint")
		ok.String(*v.HECEndpoint)
	}

	if len(v.HECEndpointType) > 0 {
		ok := object.Key("HECEndpointType")
		ok.String(string(v.HECEndpointType))
	}

	if v.HECToken != nil {
		ok := object.Key("HECToken")
		ok.String(*v.HECToken)
	}

	if v.ProcessingConfiguration != nil {
		ok := object.Key("ProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentProcessingConfiguration(v.ProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RetryOptions != nil {
		ok := object.Key("RetryOptions")
		if err := awsAwsjson11_serializeDocumentSplunkRetryOptions(v.RetryOptions, ok); err != nil {
			return err
		}
	}

	if len(v.S3BackupMode) > 0 {
		ok := object.Key("S3BackupMode")
		ok.String(string(v.S3BackupMode))
	}

	if v.S3Configuration != nil {
		ok := object.Key("S3Configuration")
		if err := awsAwsjson11_serializeDocumentS3DestinationConfiguration(v.S3Configuration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSplunkDestinationUpdate(v *types.SplunkDestinationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BufferingHints != nil {
		ok := object.Key("BufferingHints")
		if err := awsAwsjson11_serializeDocumentSplunkBufferingHints(v.BufferingHints, ok); err != nil {
			return err
		}
	}

	if v.CloudWatchLoggingOptions != nil {
		ok := object.Key("CloudWatchLoggingOptions")
		if err := awsAwsjson11_serializeDocumentCloudWatchLoggingOptions(v.CloudWatchLoggingOptions, ok); err != nil {
			return err
		}
	}

	if v.HECAcknowledgmentTimeoutInSeconds != nil {
		ok := object.Key("HECAcknowledgmentTimeoutInSeconds")
		ok.Integer(*v.HECAcknowledgmentTimeoutInSeconds)
	}

	if v.HECEndpoint != nil {
		ok := object.Key("HECEndpoint")
		ok.String(*v.HECEndpoint)
	}

	if len(v.HECEndpointType) > 0 {
		ok := object.Key("HECEndpointType")
		ok.String(string(v.HECEndpointType))
	}

	if v.HECToken != nil {
		ok := object.Key("HECToken")
		ok.String(*v.HECToken)
	}

	if v.ProcessingConfiguration != nil {
		ok := object.Key("ProcessingConfiguration")
		if err := awsAwsjson11_serializeDocumentProcessingConfiguration(v.ProcessingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RetryOptions != nil {
		ok := object.Key("RetryOptions")
		if err := awsAwsjson11_serializeDocumentSplunkRetryOptions(v.RetryOptions, ok); err != nil {
			return err
		}
	}

	if len(v.S3BackupMode) > 0 {
		ok := object.Key("S3BackupMode")
		ok.String(string(v.S3BackupMode))
	}

	if v.S3Update != nil {
		ok := object.Key("S3Update")
		if err := awsAwsjson11_serializeDocumentS3DestinationUpdate(v.S3Update, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSplunkRetryOptions(v *types.SplunkRetryOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DurationInSeconds != nil {
		ok := object.Key("DurationInSeconds")
		ok.Integer(*v.DurationInSeconds)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSubnetIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTagDeliveryStreamInputTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentVpcConfiguration(v *types.VpcConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if v.SecurityGroupIds != nil {
		ok := object.Key("SecurityGroupIds")
		if err := awsAwsjson11_serializeDocumentSecurityGroupIdList(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("SubnetIds")
		if err := awsAwsjson11_serializeDocumentSubnetIdList(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateDeliveryStreamInput(v *CreateDeliveryStreamInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AmazonOpenSearchServerlessDestinationConfiguration != nil {
		ok := object.Key("AmazonOpenSearchServerlessDestinationConfiguration")
		if err := awsAwsjson11_serializeDocumentAmazonOpenSearchServerlessDestinationConfiguration(v.AmazonOpenSearchServerlessDestinationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.AmazonopensearchserviceDestinationConfiguration != nil {
		ok := object.Key("AmazonopensearchserviceDestinationConfiguration")
		if err := awsAwsjson11_serializeDocumentAmazonopensearchserviceDestinationConfiguration(v.AmazonopensearchserviceDestinationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.DeliveryStreamEncryptionConfigurationInput != nil {
		ok := object.Key("DeliveryStreamEncryptionConfigurationInput")
		if err := awsAwsjson11_serializeDocumentDeliveryStreamEncryptionConfigurationInput(v.DeliveryStreamEncryptionConfigurationInput, ok); err != nil {
			return err
		}
	}

	if v.DeliveryStreamName != nil {
		ok := object.Key("DeliveryStreamName")
		ok.String(*v.DeliveryStreamName)
	}

	if len(v.DeliveryStreamType) > 0 {
		ok := object.Key("DeliveryStreamType")
		ok.String(string(v.DeliveryStreamType))
	}

	if v.ElasticsearchDestinationConfiguration != nil {
		ok := object.Key("ElasticsearchDestinationConfiguration")
		if err := awsAwsjson11_serializeDocumentElasticsearchDestinationConfiguration(v.ElasticsearchDestinationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ExtendedS3DestinationConfiguration != nil {
		ok := object.Key("ExtendedS3DestinationConfiguration")
		if err := awsAwsjson11_serializeDocumentExtendedS3DestinationConfiguration(v.ExtendedS3DestinationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.HttpEndpointDestinationConfiguration != nil {
		ok := object.Key("HttpEndpointDestinationConfiguration")
		if err := awsAwsjson11_serializeDocumentHttpEndpointDestinationConfiguration(v.HttpEndpointDestinationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.KinesisStreamSourceConfiguration != nil {
		ok := object.Key("KinesisStreamSourceConfiguration")
		if err := awsAwsjson11_serializeDocumentKinesisStreamSourceConfiguration(v.KinesisStreamSourceConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MSKSourceConfiguration != nil {
		ok := object.Key("MSKSourceConfiguration")
		if err := awsAwsjson11_serializeDocumentMSKSourceConfiguration(v.MSKSourceConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RedshiftDestinationConfiguration != nil {
		ok := object.Key("RedshiftDestinationConfiguration")
		if err := awsAwsjson11_serializeDocumentRedshiftDestinationConfiguration(v.RedshiftDestinationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.S3DestinationConfiguration != nil {
		ok := object.Key("S3DestinationConfiguration")
		if err := awsAwsjson11_serializeDocumentS3DestinationConfiguration(v.S3DestinationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SnowflakeDestinationConfiguration != nil {
		ok := object.Key("SnowflakeDestinationConfiguration")
		if err := awsAwsjson11_serializeDocumentSnowflakeDestinationConfiguration(v.SnowflakeDestinationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SplunkDestinationConfiguration != nil {
		ok := object.Key("SplunkDestinationConfiguration")
		if err := awsAwsjson11_serializeDocumentSplunkDestinationConfiguration(v.SplunkDestinationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagDeliveryStreamInputTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteDeliveryStreamInput(v *DeleteDeliveryStreamInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowForceDelete != nil {
		ok := object.Key("AllowForceDelete")
		ok.Boolean(*v.AllowForceDelete)
	}

	if v.DeliveryStreamName != nil {
		ok := object.Key("DeliveryStreamName")
		ok.String(*v.DeliveryStreamName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeDeliveryStreamInput(v *DescribeDeliveryStreamInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeliveryStreamName != nil {
		ok := object.Key("DeliveryStreamName")
		ok.String(*v.DeliveryStreamName)
	}

	if v.ExclusiveStartDestinationId != nil {
		ok := object.Key("ExclusiveStartDestinationId")
		ok.String(*v.ExclusiveStartDestinationId)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListDeliveryStreamsInput(v *ListDeliveryStreamsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DeliveryStreamType) > 0 {
		ok := object.Key("DeliveryStreamType")
		ok.String(string(v.DeliveryStreamType))
	}

	if v.ExclusiveStartDeliveryStreamName != nil {
		ok := object.Key("ExclusiveStartDeliveryStreamName")
		ok.String(*v.ExclusiveStartDeliveryStreamName)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListTagsForDeliveryStreamInput(v *ListTagsForDeliveryStreamInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeliveryStreamName != nil {
		ok := object.Key("DeliveryStreamName")
		ok.String(*v.DeliveryStreamName)
	}

	if v.ExclusiveStartTagKey != nil {
		ok := object.Key("ExclusiveStartTagKey")
		ok.String(*v.ExclusiveStartTagKey)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutRecordBatchInput(v *PutRecordBatchInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeliveryStreamName != nil {
		ok := object.Key("DeliveryStreamName")
		ok.String(*v.DeliveryStreamName)
	}

	if v.Records != nil {
		ok := object.Key("Records")
		if err := awsAwsjson11_serializeDocumentPutRecordBatchRequestEntryList(v.Records, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutRecordInput(v *PutRecordInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeliveryStreamName != nil {
		ok := object.Key("DeliveryStreamName")
		ok.String(*v.DeliveryStreamName)
	}

	if v.Record != nil {
		ok := object.Key("Record")
		if err := awsAwsjson11_serializeDocumentRecord(v.Record, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartDeliveryStreamEncryptionInput(v *StartDeliveryStreamEncryptionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeliveryStreamEncryptionConfigurationInput != nil {
		ok := object.Key("DeliveryStreamEncryptionConfigurationInput")
		if err := awsAwsjson11_serializeDocumentDeliveryStreamEncryptionConfigurationInput(v.DeliveryStreamEncryptionConfigurationInput, ok); err != nil {
			return err
		}
	}

	if v.DeliveryStreamName != nil {
		ok := object.Key("DeliveryStreamName")
		ok.String(*v.DeliveryStreamName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStopDeliveryStreamEncryptionInput(v *StopDeliveryStreamEncryptionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeliveryStreamName != nil {
		ok := object.Key("DeliveryStreamName")
		ok.String(*v.DeliveryStreamName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentTagDeliveryStreamInput(v *TagDeliveryStreamInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeliveryStreamName != nil {
		ok := object.Key("DeliveryStreamName")
		ok.String(*v.DeliveryStreamName)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagDeliveryStreamInputTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUntagDeliveryStreamInput(v *UntagDeliveryStreamInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeliveryStreamName != nil {
		ok := object.Key("DeliveryStreamName")
		ok.String(*v.DeliveryStreamName)
	}

	if v.TagKeys != nil {
		ok := object.Key("TagKeys")
		if err := awsAwsjson11_serializeDocumentTagKeyList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateDestinationInput(v *UpdateDestinationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AmazonOpenSearchServerlessDestinationUpdate != nil {
		ok := object.Key("AmazonOpenSearchServerlessDestinationUpdate")
		if err := awsAwsjson11_serializeDocumentAmazonOpenSearchServerlessDestinationUpdate(v.AmazonOpenSearchServerlessDestinationUpdate, ok); err != nil {
			return err
		}
	}

	if v.AmazonopensearchserviceDestinationUpdate != nil {
		ok := object.Key("AmazonopensearchserviceDestinationUpdate")
		if err := awsAwsjson11_serializeDocumentAmazonopensearchserviceDestinationUpdate(v.AmazonopensearchserviceDestinationUpdate, ok); err != nil {
			return err
		}
	}

	if v.CurrentDeliveryStreamVersionId != nil {
		ok := object.Key("CurrentDeliveryStreamVersionId")
		ok.String(*v.CurrentDeliveryStreamVersionId)
	}

	if v.DeliveryStreamName != nil {
		ok := object.Key("DeliveryStreamName")
		ok.String(*v.DeliveryStreamName)
	}

	if v.DestinationId != nil {
		ok := object.Key("DestinationId")
		ok.String(*v.DestinationId)
	}

	if v.ElasticsearchDestinationUpdate != nil {
		ok := object.Key("ElasticsearchDestinationUpdate")
		if err := awsAwsjson11_serializeDocumentElasticsearchDestinationUpdate(v.ElasticsearchDestinationUpdate, ok); err != nil {
			return err
		}
	}

	if v.ExtendedS3DestinationUpdate != nil {
		ok := object.Key("ExtendedS3DestinationUpdate")
		if err := awsAwsjson11_serializeDocumentExtendedS3DestinationUpdate(v.ExtendedS3DestinationUpdate, ok); err != nil {
			return err
		}
	}

	if v.HttpEndpointDestinationUpdate != nil {
		ok := object.Key("HttpEndpointDestinationUpdate")
		if err := awsAwsjson11_serializeDocumentHttpEndpointDestinationUpdate(v.HttpEndpointDestinationUpdate, ok); err != nil {
			return err
		}
	}

	if v.RedshiftDestinationUpdate != nil {
		ok := object.Key("RedshiftDestinationUpdate")
		if err := awsAwsjson11_serializeDocumentRedshiftDestinationUpdate(v.RedshiftDestinationUpdate, ok); err != nil {
			return err
		}
	}

	if v.S3DestinationUpdate != nil {
		ok := object.Key("S3DestinationUpdate")
		if err := awsAwsjson11_serializeDocumentS3DestinationUpdate(v.S3DestinationUpdate, ok); err != nil {
			return err
		}
	}

	if v.SnowflakeDestinationUpdate != nil {
		ok := object.Key("SnowflakeDestinationUpdate")
		if err := awsAwsjson11_serializeDocumentSnowflakeDestinationUpdate(v.SnowflakeDestinationUpdate, ok); err != nil {
			return err
		}
	}

	if v.SplunkDestinationUpdate != nil {
		ok := object.Key("SplunkDestinationUpdate")
		if err := awsAwsjson11_serializeDocumentSplunkDestinationUpdate(v.SplunkDestinationUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}
