// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockruntime

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockruntime/types"
	"github.com/aws/smithy-go/middleware"
	smithysync "github.com/aws/smithy-go/sync"
	"sync"
)

// Invoke the specified Amazon Bedrock model to run inference using the prompt and
// inference parameters provided in the request body. The response is returned in a
// stream.
//
// To see if a model supports streaming, call [GetFoundationModel] and check the
// responseStreamingSupported field in the response.
//
// The CLI doesn't support InvokeModelWithResponseStream .
//
// For example code, see Invoke model with streaming code example in the Amazon
// Bedrock User Guide.
//
// This operation requires permissions to perform the
// bedrock:InvokeModelWithResponseStream action.
//
// [GetFoundationModel]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetFoundationModel.html
func (c *Client) InvokeModelWithResponseStream(ctx context.Context, params *InvokeModelWithResponseStreamInput, optFns ...func(*Options)) (*InvokeModelWithResponseStreamOutput, error) {
	if params == nil {
		params = &InvokeModelWithResponseStreamInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "InvokeModelWithResponseStream", params, optFns, c.addOperationInvokeModelWithResponseStreamMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*InvokeModelWithResponseStreamOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type InvokeModelWithResponseStreamInput struct {

	// The prompt and inference parameters in the format specified in the contentType
	// in the header. To see the format and content of the request and response bodies
	// for different models, refer to [Inference parameters]. For more information, see [Run inference] in the Bedrock User
	// Guide.
	//
	// [Inference parameters]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
	// [Run inference]: https://docs.aws.amazon.com/bedrock/latest/userguide/api-methods-run.html
	//
	// This member is required.
	Body []byte

	// The unique identifier of the model to invoke to run inference.
	//
	// The modelId to provide depends on the type of model that you use:
	//
	//   - If you use a base model, specify the model ID or its ARN. For a list of
	//   model IDs for base models, see [Amazon Bedrock base model IDs (on-demand throughput)]in the Amazon Bedrock User Guide.
	//
	//   - If you use a provisioned model, specify the ARN of the Provisioned
	//   Throughput. For more information, see [Run inference using a Provisioned Throughput]in the Amazon Bedrock User Guide.
	//
	//   - If you use a custom model, first purchase Provisioned Throughput for it.
	//   Then specify the ARN of the resulting provisioned model. For more information,
	//   see [Use a custom model in Amazon Bedrock]in the Amazon Bedrock User Guide.
	//
	// [Run inference using a Provisioned Throughput]: https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html
	// [Use a custom model in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html
	// [Amazon Bedrock base model IDs (on-demand throughput)]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns
	//
	// This member is required.
	ModelId *string

	// The desired MIME type of the inference body in the response. The default value
	// is application/json .
	Accept *string

	// The MIME type of the input data in the request. The default value is
	// application/json .
	ContentType *string

	// The unique identifier of the guardrail that you want to use. If you don't
	// provide a value, no guardrail is applied to the invocation.
	//
	// An error is thrown in the following situations.
	//
	//   - You don't provide a guardrail identifier but you specify the
	//   amazon-bedrock-guardrailConfig field in the request body.
	//
	//   - You enable the guardrail but the contentType isn't application/json .
	//
	//   - You provide a guardrail identifier, but guardrailVersion isn't specified.
	GuardrailIdentifier *string

	// The version number for the guardrail. The value can also be DRAFT .
	GuardrailVersion *string

	// Specifies whether to enable or disable the Bedrock trace. If enabled, you can
	// see the full Bedrock trace.
	Trace types.Trace

	noSmithyDocumentSerde
}

type InvokeModelWithResponseStreamOutput struct {

	// The MIME type of the inference result.
	//
	// This member is required.
	ContentType *string

	eventStream *InvokeModelWithResponseStreamEventStream

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

// GetStream returns the type to interact with the event stream.
func (o *InvokeModelWithResponseStreamOutput) GetStream() *InvokeModelWithResponseStreamEventStream {
	return o.eventStream
}

func (c *Client) addOperationInvokeModelWithResponseStreamMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpInvokeModelWithResponseStream{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpInvokeModelWithResponseStream{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "InvokeModelWithResponseStream"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addEventStreamInvokeModelWithResponseStreamMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpInvokeModelWithResponseStreamValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opInvokeModelWithResponseStream(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opInvokeModelWithResponseStream(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "InvokeModelWithResponseStream",
	}
}

// InvokeModelWithResponseStreamEventStream provides the event stream handling for the InvokeModelWithResponseStream operation.
//
// For testing and mocking the event stream this type should be initialized via
// the NewInvokeModelWithResponseStreamEventStream constructor function. Using the functional options
// to pass in nested mock behavior.
type InvokeModelWithResponseStreamEventStream struct {
	// ResponseStreamReader is the EventStream reader for the ResponseStream events.
	// This value is automatically set by the SDK when the API call is made Use this
	// member when unit testing your code with the SDK to mock out the EventStream
	// Reader.
	//
	// Must not be nil.
	Reader ResponseStreamReader

	done      chan struct{}
	closeOnce sync.Once
	err       *smithysync.OnceErr
}

// NewInvokeModelWithResponseStreamEventStream initializes an InvokeModelWithResponseStreamEventStream.
// This function should only be used for testing and mocking the InvokeModelWithResponseStreamEventStream
// stream within your application.
//
// The Reader member must be set before reading events from the stream.
func NewInvokeModelWithResponseStreamEventStream(optFns ...func(*InvokeModelWithResponseStreamEventStream)) *InvokeModelWithResponseStreamEventStream {
	es := &InvokeModelWithResponseStreamEventStream{
		done: make(chan struct{}),
		err:  smithysync.NewOnceErr(),
	}
	for _, fn := range optFns {
		fn(es)
	}
	return es
}

// Events returns a channel to read events from.
func (es *InvokeModelWithResponseStreamEventStream) Events() <-chan types.ResponseStream {
	return es.Reader.Events()
}

// Close closes the stream. This will also cause the stream to be closed.
// Close must be called when done using the stream API. Not calling Close
// may result in resource leaks.
//
// Will close the underlying EventStream writer and reader, and no more events can be
// sent or received.
func (es *InvokeModelWithResponseStreamEventStream) Close() error {
	es.closeOnce.Do(es.safeClose)
	return es.Err()
}

func (es *InvokeModelWithResponseStreamEventStream) safeClose() {
	close(es.done)

	es.Reader.Close()
}

// Err returns any error that occurred while reading or writing EventStream Events
// from the service API's response. Returns nil if there were no errors.
func (es *InvokeModelWithResponseStreamEventStream) Err() error {
	if err := es.err.Err(); err != nil {
		return err
	}

	if err := es.Reader.Err(); err != nil {
		return err
	}

	return nil
}

func (es *InvokeModelWithResponseStreamEventStream) waitStreamClose() {
	type errorSet interface {
		ErrorSet() <-chan struct{}
	}

	var outputErrCh <-chan struct{}
	if v, ok := es.Reader.(errorSet); ok {
		outputErrCh = v.ErrorSet()
	}
	var outputClosedCh <-chan struct{}
	if v, ok := es.Reader.(interface{ Closed() <-chan struct{} }); ok {
		outputClosedCh = v.Closed()
	}

	select {
	case <-es.done:
	case <-outputErrCh:
		es.err.SetError(es.Reader.Err())
		es.Close()

	case <-outputClosedCh:
		if err := es.Reader.Err(); err != nil {
			es.err.SetError(es.Reader.Err())
		}
		es.Close()

	}
}
