// Code generated by smithy-go-codegen DO NOT EDIT.

package backup

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/backup/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// This request creates a logical container to where backups may be copied.
//
// This request includes a name, the Region, the maximum number of retention days,
// the minimum number of retention days, and optionally can include tags and a
// creator request ID.
//
// Do not include sensitive data, such as passport numbers, in the name of a
// backup vault.
func (c *Client) CreateLogicallyAirGappedBackupVault(ctx context.Context, params *CreateLogicallyAirGappedBackupVaultInput, optFns ...func(*Options)) (*CreateLogicallyAirGappedBackupVaultOutput, error) {
	if params == nil {
		params = &CreateLogicallyAirGappedBackupVaultInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateLogicallyAirGappedBackupVault", params, optFns, c.addOperationCreateLogicallyAirGappedBackupVaultMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateLogicallyAirGappedBackupVaultOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateLogicallyAirGappedBackupVaultInput struct {

	// This is the name of the vault that is being created.
	//
	// This member is required.
	BackupVaultName *string

	// This is the setting that specifies the maximum retention period that the vault
	// retains its recovery points. If this parameter is not specified, Backup does not
	// enforce a maximum retention period on the recovery points in the vault (allowing
	// indefinite storage).
	//
	// If specified, any backup or copy job to the vault must have a lifecycle policy
	// with a retention period equal to or shorter than the maximum retention period.
	// If the job retention period is longer than that maximum retention period, then
	// the vault fails the backup or copy job, and you should either modify your
	// lifecycle settings or use a different vault.
	//
	// This member is required.
	MaxRetentionDays *int64

	// This setting specifies the minimum retention period that the vault retains its
	// recovery points. If this parameter is not specified, no minimum retention period
	// is enforced.
	//
	// If specified, any backup or copy job to the vault must have a lifecycle policy
	// with a retention period equal to or longer than the minimum retention period. If
	// a job retention period is shorter than that minimum retention period, then the
	// vault fails the backup or copy job, and you should either modify your lifecycle
	// settings or use a different vault.
	//
	// This member is required.
	MinRetentionDays *int64

	// These are the tags that will be included in the newly-created vault.
	BackupVaultTags map[string]string

	// This is the ID of the creation request.
	//
	// This parameter is optional. If used, this parameter must contain 1 to 50
	// alphanumeric or '-_.' characters.
	CreatorRequestId *string

	noSmithyDocumentSerde
}

type CreateLogicallyAirGappedBackupVaultOutput struct {

	// This is the ARN (Amazon Resource Name) of the vault being created.
	BackupVaultArn *string

	// The name of a logical container where backups are stored. Logically air-gapped
	// backup vaults are identified by names that are unique to the account used to
	// create them and the Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	BackupVaultName *string

	// The date and time when the vault was created.
	//
	// This value is in Unix format, Coordinated Universal Time (UTC), and accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	CreationDate *time.Time

	// This is the current state of the vault.
	VaultState types.VaultState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateLogicallyAirGappedBackupVaultMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateLogicallyAirGappedBackupVault{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateLogicallyAirGappedBackupVault{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateLogicallyAirGappedBackupVault"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateLogicallyAirGappedBackupVaultValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateLogicallyAirGappedBackupVault(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateLogicallyAirGappedBackupVault(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateLogicallyAirGappedBackupVault",
	}
}
