//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple8000series

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
)

// VolumesClient contains the methods for the Volumes group.
// Don't use this type directly, use NewVolumesClient() instead.
type VolumesClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewVolumesClient creates a new instance of VolumesClient with the specified values.
// subscriptionID - The subscription id
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewVolumesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*VolumesClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &VolumesClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Creates or updates the volume.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
// deviceName - The device name
// volumeContainerName - The volume container name.
// volumeName - The volume name.
// resourceGroupName - The resource group name
// managerName - The manager name
// parameters - Volume to be created or updated.
// options - VolumesClientBeginCreateOrUpdateOptions contains the optional parameters for the VolumesClient.BeginCreateOrUpdate
// method.
func (client *VolumesClient) BeginCreateOrUpdate(ctx context.Context, deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string, parameters Volume, options *VolumesClientBeginCreateOrUpdateOptions) (*runtime.Poller[VolumesClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, deviceName, volumeContainerName, volumeName, resourceGroupName, managerName, parameters, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[VolumesClientCreateOrUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[VolumesClientCreateOrUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdate - Creates or updates the volume.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
func (client *VolumesClient) createOrUpdate(ctx context.Context, deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string, parameters Volume, options *VolumesClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, deviceName, volumeContainerName, volumeName, resourceGroupName, managerName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *VolumesClient) createOrUpdateCreateRequest(ctx context.Context, deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string, parameters Volume, options *VolumesClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}/volumes/{volumeName}"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{volumeContainerName}", volumeContainerName)
	urlPath = strings.ReplaceAll(urlPath, "{volumeName}", volumeName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// BeginDelete - Deletes the volume.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
// deviceName - The device name
// volumeContainerName - The volume container name.
// volumeName - The volume name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - VolumesClientBeginDeleteOptions contains the optional parameters for the VolumesClient.BeginDelete method.
func (client *VolumesClient) BeginDelete(ctx context.Context, deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string, options *VolumesClientBeginDeleteOptions) (*runtime.Poller[VolumesClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, deviceName, volumeContainerName, volumeName, resourceGroupName, managerName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[VolumesClientDeleteResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[VolumesClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Deletes the volume.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
func (client *VolumesClient) deleteOperation(ctx context.Context, deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string, options *VolumesClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, deviceName, volumeContainerName, volumeName, resourceGroupName, managerName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *VolumesClient) deleteCreateRequest(ctx context.Context, deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string, options *VolumesClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}/volumes/{volumeName}"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{volumeContainerName}", volumeContainerName)
	urlPath = strings.ReplaceAll(urlPath, "{volumeName}", volumeName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// Get - Returns the properties of the specified volume name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
// deviceName - The device name
// volumeContainerName - The volume container name.
// volumeName - The volume name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - VolumesClientGetOptions contains the optional parameters for the VolumesClient.Get method.
func (client *VolumesClient) Get(ctx context.Context, deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string, options *VolumesClientGetOptions) (VolumesClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, deviceName, volumeContainerName, volumeName, resourceGroupName, managerName, options)
	if err != nil {
		return VolumesClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return VolumesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return VolumesClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *VolumesClient) getCreateRequest(ctx context.Context, deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string, options *VolumesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}/volumes/{volumeName}"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{volumeContainerName}", volumeContainerName)
	urlPath = strings.ReplaceAll(urlPath, "{volumeName}", volumeName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *VolumesClient) getHandleResponse(resp *http.Response) (VolumesClientGetResponse, error) {
	result := VolumesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Volume); err != nil {
		return VolumesClientGetResponse{}, err
	}
	return result, nil
}

// NewListByDevicePager - Retrieves all the volumes in a device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
// deviceName - The device name
// resourceGroupName - The resource group name
// managerName - The manager name
// options - VolumesClientListByDeviceOptions contains the optional parameters for the VolumesClient.ListByDevice method.
func (client *VolumesClient) NewListByDevicePager(deviceName string, resourceGroupName string, managerName string, options *VolumesClientListByDeviceOptions) *runtime.Pager[VolumesClientListByDeviceResponse] {
	return runtime.NewPager(runtime.PagingHandler[VolumesClientListByDeviceResponse]{
		More: func(page VolumesClientListByDeviceResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *VolumesClientListByDeviceResponse) (VolumesClientListByDeviceResponse, error) {
			req, err := client.listByDeviceCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
			if err != nil {
				return VolumesClientListByDeviceResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return VolumesClientListByDeviceResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return VolumesClientListByDeviceResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByDeviceHandleResponse(resp)
		},
	})
}

// listByDeviceCreateRequest creates the ListByDevice request.
func (client *VolumesClient) listByDeviceCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *VolumesClientListByDeviceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumes"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByDeviceHandleResponse handles the ListByDevice response.
func (client *VolumesClient) listByDeviceHandleResponse(resp *http.Response) (VolumesClientListByDeviceResponse, error) {
	result := VolumesClientListByDeviceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VolumeList); err != nil {
		return VolumesClientListByDeviceResponse{}, err
	}
	return result, nil
}

// NewListByVolumeContainerPager - Retrieves all the volumes in a volume container.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
// deviceName - The device name
// volumeContainerName - The volume container name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - VolumesClientListByVolumeContainerOptions contains the optional parameters for the VolumesClient.ListByVolumeContainer
// method.
func (client *VolumesClient) NewListByVolumeContainerPager(deviceName string, volumeContainerName string, resourceGroupName string, managerName string, options *VolumesClientListByVolumeContainerOptions) *runtime.Pager[VolumesClientListByVolumeContainerResponse] {
	return runtime.NewPager(runtime.PagingHandler[VolumesClientListByVolumeContainerResponse]{
		More: func(page VolumesClientListByVolumeContainerResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *VolumesClientListByVolumeContainerResponse) (VolumesClientListByVolumeContainerResponse, error) {
			req, err := client.listByVolumeContainerCreateRequest(ctx, deviceName, volumeContainerName, resourceGroupName, managerName, options)
			if err != nil {
				return VolumesClientListByVolumeContainerResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return VolumesClientListByVolumeContainerResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return VolumesClientListByVolumeContainerResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByVolumeContainerHandleResponse(resp)
		},
	})
}

// listByVolumeContainerCreateRequest creates the ListByVolumeContainer request.
func (client *VolumesClient) listByVolumeContainerCreateRequest(ctx context.Context, deviceName string, volumeContainerName string, resourceGroupName string, managerName string, options *VolumesClientListByVolumeContainerOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}/volumes"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{volumeContainerName}", volumeContainerName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByVolumeContainerHandleResponse handles the ListByVolumeContainer response.
func (client *VolumesClient) listByVolumeContainerHandleResponse(resp *http.Response) (VolumesClientListByVolumeContainerResponse, error) {
	result := VolumesClientListByVolumeContainerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VolumeList); err != nil {
		return VolumesClientListByVolumeContainerResponse{}, err
	}
	return result, nil
}

// NewListMetricDefinitionPager - Gets the metric definitions for the specified volume.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
// deviceName - The device name
// volumeContainerName - The volume container name.
// volumeName - The volume name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - VolumesClientListMetricDefinitionOptions contains the optional parameters for the VolumesClient.ListMetricDefinition
// method.
func (client *VolumesClient) NewListMetricDefinitionPager(deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string, options *VolumesClientListMetricDefinitionOptions) *runtime.Pager[VolumesClientListMetricDefinitionResponse] {
	return runtime.NewPager(runtime.PagingHandler[VolumesClientListMetricDefinitionResponse]{
		More: func(page VolumesClientListMetricDefinitionResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *VolumesClientListMetricDefinitionResponse) (VolumesClientListMetricDefinitionResponse, error) {
			req, err := client.listMetricDefinitionCreateRequest(ctx, deviceName, volumeContainerName, volumeName, resourceGroupName, managerName, options)
			if err != nil {
				return VolumesClientListMetricDefinitionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return VolumesClientListMetricDefinitionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return VolumesClientListMetricDefinitionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMetricDefinitionHandleResponse(resp)
		},
	})
}

// listMetricDefinitionCreateRequest creates the ListMetricDefinition request.
func (client *VolumesClient) listMetricDefinitionCreateRequest(ctx context.Context, deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string, options *VolumesClientListMetricDefinitionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}/volumes/{volumeName}/metricsDefinitions"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{volumeContainerName}", volumeContainerName)
	urlPath = strings.ReplaceAll(urlPath, "{volumeName}", volumeName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMetricDefinitionHandleResponse handles the ListMetricDefinition response.
func (client *VolumesClient) listMetricDefinitionHandleResponse(resp *http.Response) (VolumesClientListMetricDefinitionResponse, error) {
	result := VolumesClientListMetricDefinitionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MetricDefinitionList); err != nil {
		return VolumesClientListMetricDefinitionResponse{}, err
	}
	return result, nil
}

// NewListMetricsPager - Gets the metrics for the specified volume.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
// deviceName - The device name
// volumeContainerName - The volume container name.
// volumeName - The volume name.
// resourceGroupName - The resource group name
// managerName - The manager name
// filter - OData Filter options
// options - VolumesClientListMetricsOptions contains the optional parameters for the VolumesClient.ListMetrics method.
func (client *VolumesClient) NewListMetricsPager(deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string, filter string, options *VolumesClientListMetricsOptions) *runtime.Pager[VolumesClientListMetricsResponse] {
	return runtime.NewPager(runtime.PagingHandler[VolumesClientListMetricsResponse]{
		More: func(page VolumesClientListMetricsResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *VolumesClientListMetricsResponse) (VolumesClientListMetricsResponse, error) {
			req, err := client.listMetricsCreateRequest(ctx, deviceName, volumeContainerName, volumeName, resourceGroupName, managerName, filter, options)
			if err != nil {
				return VolumesClientListMetricsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return VolumesClientListMetricsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return VolumesClientListMetricsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMetricsHandleResponse(resp)
		},
	})
}

// listMetricsCreateRequest creates the ListMetrics request.
func (client *VolumesClient) listMetricsCreateRequest(ctx context.Context, deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string, filter string, options *VolumesClientListMetricsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}/volumes/{volumeName}/metrics"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{volumeContainerName}", volumeContainerName)
	urlPath = strings.ReplaceAll(urlPath, "{volumeName}", volumeName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	reqQP.Set("$filter", filter)
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMetricsHandleResponse handles the ListMetrics response.
func (client *VolumesClient) listMetricsHandleResponse(resp *http.Response) (VolumesClientListMetricsResponse, error) {
	result := VolumesClientListMetricsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MetricList); err != nil {
		return VolumesClientListMetricsResponse{}, err
	}
	return result, nil
}
