//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple8000series

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
)

// AlertsClient contains the methods for the Alerts group.
// Don't use this type directly, use NewAlertsClient() instead.
type AlertsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewAlertsClient creates a new instance of AlertsClient with the specified values.
// subscriptionID - The subscription id
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewAlertsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*AlertsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &AlertsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// Clear - Clear the alerts.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
// resourceGroupName - The resource group name
// managerName - The manager name
// parameters - The clear alert request.
// options - AlertsClientClearOptions contains the optional parameters for the AlertsClient.Clear method.
func (client *AlertsClient) Clear(ctx context.Context, resourceGroupName string, managerName string, parameters ClearAlertRequest, options *AlertsClientClearOptions) (AlertsClientClearResponse, error) {
	req, err := client.clearCreateRequest(ctx, resourceGroupName, managerName, parameters, options)
	if err != nil {
		return AlertsClientClearResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AlertsClientClearResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return AlertsClientClearResponse{}, runtime.NewResponseError(resp)
	}
	return AlertsClientClearResponse{}, nil
}

// clearCreateRequest creates the Clear request.
func (client *AlertsClient) clearCreateRequest(ctx context.Context, resourceGroupName string, managerName string, parameters ClearAlertRequest, options *AlertsClientClearOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/clearAlerts"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, runtime.MarshalAsJSON(req, parameters)
}

// NewListByManagerPager - Retrieves all the alerts in a manager.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
// resourceGroupName - The resource group name
// managerName - The manager name
// options - AlertsClientListByManagerOptions contains the optional parameters for the AlertsClient.ListByManager method.
func (client *AlertsClient) NewListByManagerPager(resourceGroupName string, managerName string, options *AlertsClientListByManagerOptions) *runtime.Pager[AlertsClientListByManagerResponse] {
	return runtime.NewPager(runtime.PagingHandler[AlertsClientListByManagerResponse]{
		More: func(page AlertsClientListByManagerResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AlertsClientListByManagerResponse) (AlertsClientListByManagerResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByManagerCreateRequest(ctx, resourceGroupName, managerName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return AlertsClientListByManagerResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return AlertsClientListByManagerResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return AlertsClientListByManagerResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByManagerHandleResponse(resp)
		},
	})
}

// listByManagerCreateRequest creates the ListByManager request.
func (client *AlertsClient) listByManagerCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *AlertsClientListByManagerOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/alerts"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByManagerHandleResponse handles the ListByManager response.
func (client *AlertsClient) listByManagerHandleResponse(resp *http.Response) (AlertsClientListByManagerResponse, error) {
	result := AlertsClientListByManagerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AlertList); err != nil {
		return AlertsClientListByManagerResponse{}, err
	}
	return result, nil
}

// SendTestEmail - Sends a test alert email.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-06-01
// deviceName - The device name
// resourceGroupName - The resource group name
// managerName - The manager name
// parameters - The send test alert email request.
// options - AlertsClientSendTestEmailOptions contains the optional parameters for the AlertsClient.SendTestEmail method.
func (client *AlertsClient) SendTestEmail(ctx context.Context, deviceName string, resourceGroupName string, managerName string, parameters SendTestAlertEmailRequest, options *AlertsClientSendTestEmailOptions) (AlertsClientSendTestEmailResponse, error) {
	req, err := client.sendTestEmailCreateRequest(ctx, deviceName, resourceGroupName, managerName, parameters, options)
	if err != nil {
		return AlertsClientSendTestEmailResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AlertsClientSendTestEmailResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return AlertsClientSendTestEmailResponse{}, runtime.NewResponseError(resp)
	}
	return AlertsClientSendTestEmailResponse{}, nil
}

// sendTestEmailCreateRequest creates the SendTestEmail request.
func (client *AlertsClient) sendTestEmailCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, parameters SendTestAlertEmailRequest, options *AlertsClientSendTestEmailOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/sendTestAlertEmail"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, runtime.MarshalAsJSON(req, parameters)
}
