//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple1200series

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// BackupsClient contains the methods for the Backups group.
// Don't use this type directly, use NewBackupsClient() instead.
type BackupsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewBackupsClient creates a new instance of BackupsClient with the specified values.
// subscriptionID - The subscription id
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewBackupsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*BackupsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &BackupsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginClone - Clones the given backup element to a new disk or share with given details.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// backupName - The backup name.
// elementName - The backup element name.
// resourceGroupName - The resource group name
// managerName - The manager name
// cloneRequest - The clone request.
// options - BackupsClientBeginCloneOptions contains the optional parameters for the BackupsClient.BeginClone method.
func (client *BackupsClient) BeginClone(ctx context.Context, deviceName string, backupName string, elementName string, resourceGroupName string, managerName string, cloneRequest CloneRequest, options *BackupsClientBeginCloneOptions) (*runtime.Poller[BackupsClientCloneResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.clone(ctx, deviceName, backupName, elementName, resourceGroupName, managerName, cloneRequest, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[BackupsClientCloneResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[BackupsClientCloneResponse](options.ResumeToken, client.pl, nil)
	}
}

// Clone - Clones the given backup element to a new disk or share with given details.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
func (client *BackupsClient) clone(ctx context.Context, deviceName string, backupName string, elementName string, resourceGroupName string, managerName string, cloneRequest CloneRequest, options *BackupsClientBeginCloneOptions) (*http.Response, error) {
	req, err := client.cloneCreateRequest(ctx, deviceName, backupName, elementName, resourceGroupName, managerName, cloneRequest, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// cloneCreateRequest creates the Clone request.
func (client *BackupsClient) cloneCreateRequest(ctx context.Context, deviceName string, backupName string, elementName string, resourceGroupName string, managerName string, cloneRequest CloneRequest, options *BackupsClientBeginCloneOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backups/{backupName}/elements/{elementName}/clone"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if backupName == "" {
		return nil, errors.New("parameter backupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{backupName}", url.PathEscape(backupName))
	if elementName == "" {
		return nil, errors.New("parameter elementName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{elementName}", url.PathEscape(elementName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, cloneRequest)
}

// BeginDelete - Deletes the backup.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// backupName - The backup name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - BackupsClientBeginDeleteOptions contains the optional parameters for the BackupsClient.BeginDelete method.
func (client *BackupsClient) BeginDelete(ctx context.Context, deviceName string, backupName string, resourceGroupName string, managerName string, options *BackupsClientBeginDeleteOptions) (*runtime.Poller[BackupsClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, deviceName, backupName, resourceGroupName, managerName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[BackupsClientDeleteResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[BackupsClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Deletes the backup.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
func (client *BackupsClient) deleteOperation(ctx context.Context, deviceName string, backupName string, resourceGroupName string, managerName string, options *BackupsClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, deviceName, backupName, resourceGroupName, managerName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *BackupsClient) deleteCreateRequest(ctx context.Context, deviceName string, backupName string, resourceGroupName string, managerName string, options *BackupsClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backups/{backupName}"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if backupName == "" {
		return nil, errors.New("parameter backupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{backupName}", url.PathEscape(backupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// NewListByDevicePager - Retrieves all the backups in a device. Can be used to get the backups for failover also.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - BackupsClientListByDeviceOptions contains the optional parameters for the BackupsClient.ListByDevice method.
func (client *BackupsClient) NewListByDevicePager(deviceName string, resourceGroupName string, managerName string, options *BackupsClientListByDeviceOptions) *runtime.Pager[BackupsClientListByDeviceResponse] {
	return runtime.NewPager(runtime.PagingHandler[BackupsClientListByDeviceResponse]{
		More: func(page BackupsClientListByDeviceResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *BackupsClientListByDeviceResponse) (BackupsClientListByDeviceResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByDeviceCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return BackupsClientListByDeviceResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return BackupsClientListByDeviceResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return BackupsClientListByDeviceResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByDeviceHandleResponse(resp)
		},
	})
}

// listByDeviceCreateRequest creates the ListByDevice request.
func (client *BackupsClient) listByDeviceCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *BackupsClientListByDeviceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backups"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.ForFailover != nil {
		reqQP.Set("forFailover", strconv.FormatBool(*options.ForFailover))
	}
	reqQP.Set("api-version", "2016-10-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByDeviceHandleResponse handles the ListByDevice response.
func (client *BackupsClient) listByDeviceHandleResponse(resp *http.Response) (BackupsClientListByDeviceResponse, error) {
	result := BackupsClientListByDeviceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupList); err != nil {
		return BackupsClientListByDeviceResponse{}, err
	}
	return result, nil
}

// NewListByManagerPager - Retrieves all the backups in a manager.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// resourceGroupName - The resource group name
// managerName - The manager name
// options - BackupsClientListByManagerOptions contains the optional parameters for the BackupsClient.ListByManager method.
func (client *BackupsClient) NewListByManagerPager(resourceGroupName string, managerName string, options *BackupsClientListByManagerOptions) *runtime.Pager[BackupsClientListByManagerResponse] {
	return runtime.NewPager(runtime.PagingHandler[BackupsClientListByManagerResponse]{
		More: func(page BackupsClientListByManagerResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *BackupsClientListByManagerResponse) (BackupsClientListByManagerResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByManagerCreateRequest(ctx, resourceGroupName, managerName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return BackupsClientListByManagerResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return BackupsClientListByManagerResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return BackupsClientListByManagerResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByManagerHandleResponse(resp)
		},
	})
}

// listByManagerCreateRequest creates the ListByManager request.
func (client *BackupsClient) listByManagerCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *BackupsClientListByManagerOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/backups"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByManagerHandleResponse handles the ListByManager response.
func (client *BackupsClient) listByManagerHandleResponse(resp *http.Response) (BackupsClientListByManagerResponse, error) {
	result := BackupsClientListByManagerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupList); err != nil {
		return BackupsClientListByManagerResponse{}, err
	}
	return result, nil
}
