//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ManagedInstanceVulnerabilityAssessmentsClient contains the methods for the ManagedInstanceVulnerabilityAssessments group.
// Don't use this type directly, use NewManagedInstanceVulnerabilityAssessmentsClient() instead.
type ManagedInstanceVulnerabilityAssessmentsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewManagedInstanceVulnerabilityAssessmentsClient creates a new instance of ManagedInstanceVulnerabilityAssessmentsClient with the specified values.
// subscriptionID - The subscription ID that identifies an Azure subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewManagedInstanceVulnerabilityAssessmentsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ManagedInstanceVulnerabilityAssessmentsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ManagedInstanceVulnerabilityAssessmentsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CreateOrUpdate - Creates or updates the managed instance's vulnerability assessment. Learn more about setting SQL vulnerability
// assessment with managed identity -
// https://docs.microsoft.com/azure/azure-sql/database/sql-database-vulnerability-assessment-storage
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// managedInstanceName - The name of the managed instance for which the vulnerability assessment is defined.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// parameters - The requested resource.
// options - ManagedInstanceVulnerabilityAssessmentsClientCreateOrUpdateOptions contains the optional parameters for the ManagedInstanceVulnerabilityAssessmentsClient.CreateOrUpdate
// method.
func (client *ManagedInstanceVulnerabilityAssessmentsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, parameters ManagedInstanceVulnerabilityAssessment, options *ManagedInstanceVulnerabilityAssessmentsClientCreateOrUpdateOptions) (ManagedInstanceVulnerabilityAssessmentsClientCreateOrUpdateResponse, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, managedInstanceName, vulnerabilityAssessmentName, parameters, options)
	if err != nil {
		return ManagedInstanceVulnerabilityAssessmentsClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagedInstanceVulnerabilityAssessmentsClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return ManagedInstanceVulnerabilityAssessmentsClientCreateOrUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHandleResponse(resp)
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ManagedInstanceVulnerabilityAssessmentsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, managedInstanceName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, parameters ManagedInstanceVulnerabilityAssessment, options *ManagedInstanceVulnerabilityAssessmentsClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managedInstanceName == "" {
		return nil, errors.New("parameter managedInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managedInstanceName}", url.PathEscape(managedInstanceName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *ManagedInstanceVulnerabilityAssessmentsClient) createOrUpdateHandleResponse(resp *http.Response) (ManagedInstanceVulnerabilityAssessmentsClientCreateOrUpdateResponse, error) {
	result := ManagedInstanceVulnerabilityAssessmentsClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagedInstanceVulnerabilityAssessment); err != nil {
		return ManagedInstanceVulnerabilityAssessmentsClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Removes the managed instance's vulnerability assessment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// managedInstanceName - The name of the managed instance for which the vulnerability assessment is defined.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// options - ManagedInstanceVulnerabilityAssessmentsClientDeleteOptions contains the optional parameters for the ManagedInstanceVulnerabilityAssessmentsClient.Delete
// method.
func (client *ManagedInstanceVulnerabilityAssessmentsClient) Delete(ctx context.Context, resourceGroupName string, managedInstanceName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *ManagedInstanceVulnerabilityAssessmentsClientDeleteOptions) (ManagedInstanceVulnerabilityAssessmentsClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, managedInstanceName, vulnerabilityAssessmentName, options)
	if err != nil {
		return ManagedInstanceVulnerabilityAssessmentsClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagedInstanceVulnerabilityAssessmentsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagedInstanceVulnerabilityAssessmentsClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return ManagedInstanceVulnerabilityAssessmentsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ManagedInstanceVulnerabilityAssessmentsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, managedInstanceName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *ManagedInstanceVulnerabilityAssessmentsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managedInstanceName == "" {
		return nil, errors.New("parameter managedInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managedInstanceName}", url.PathEscape(managedInstanceName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// Get - Gets the managed instance's vulnerability assessment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// managedInstanceName - The name of the managed instance for which the vulnerability assessment is defined.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// options - ManagedInstanceVulnerabilityAssessmentsClientGetOptions contains the optional parameters for the ManagedInstanceVulnerabilityAssessmentsClient.Get
// method.
func (client *ManagedInstanceVulnerabilityAssessmentsClient) Get(ctx context.Context, resourceGroupName string, managedInstanceName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *ManagedInstanceVulnerabilityAssessmentsClientGetOptions) (ManagedInstanceVulnerabilityAssessmentsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, managedInstanceName, vulnerabilityAssessmentName, options)
	if err != nil {
		return ManagedInstanceVulnerabilityAssessmentsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagedInstanceVulnerabilityAssessmentsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagedInstanceVulnerabilityAssessmentsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *ManagedInstanceVulnerabilityAssessmentsClient) getCreateRequest(ctx context.Context, resourceGroupName string, managedInstanceName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *ManagedInstanceVulnerabilityAssessmentsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managedInstanceName == "" {
		return nil, errors.New("parameter managedInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managedInstanceName}", url.PathEscape(managedInstanceName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ManagedInstanceVulnerabilityAssessmentsClient) getHandleResponse(resp *http.Response) (ManagedInstanceVulnerabilityAssessmentsClientGetResponse, error) {
	result := ManagedInstanceVulnerabilityAssessmentsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagedInstanceVulnerabilityAssessment); err != nil {
		return ManagedInstanceVulnerabilityAssessmentsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByInstancePager - Gets the managed instance's vulnerability assessment policies.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// managedInstanceName - The name of the managed instance for which the vulnerability assessments is defined.
// options - ManagedInstanceVulnerabilityAssessmentsClientListByInstanceOptions contains the optional parameters for the ManagedInstanceVulnerabilityAssessmentsClient.ListByInstance
// method.
func (client *ManagedInstanceVulnerabilityAssessmentsClient) NewListByInstancePager(resourceGroupName string, managedInstanceName string, options *ManagedInstanceVulnerabilityAssessmentsClientListByInstanceOptions) *runtime.Pager[ManagedInstanceVulnerabilityAssessmentsClientListByInstanceResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagedInstanceVulnerabilityAssessmentsClientListByInstanceResponse]{
		More: func(page ManagedInstanceVulnerabilityAssessmentsClientListByInstanceResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagedInstanceVulnerabilityAssessmentsClientListByInstanceResponse) (ManagedInstanceVulnerabilityAssessmentsClientListByInstanceResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByInstanceCreateRequest(ctx, resourceGroupName, managedInstanceName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ManagedInstanceVulnerabilityAssessmentsClientListByInstanceResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ManagedInstanceVulnerabilityAssessmentsClientListByInstanceResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagedInstanceVulnerabilityAssessmentsClientListByInstanceResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByInstanceHandleResponse(resp)
		},
	})
}

// listByInstanceCreateRequest creates the ListByInstance request.
func (client *ManagedInstanceVulnerabilityAssessmentsClient) listByInstanceCreateRequest(ctx context.Context, resourceGroupName string, managedInstanceName string, options *ManagedInstanceVulnerabilityAssessmentsClientListByInstanceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/vulnerabilityAssessments"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managedInstanceName == "" {
		return nil, errors.New("parameter managedInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managedInstanceName}", url.PathEscape(managedInstanceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByInstanceHandleResponse handles the ListByInstance response.
func (client *ManagedInstanceVulnerabilityAssessmentsClient) listByInstanceHandleResponse(resp *http.Response) (ManagedInstanceVulnerabilityAssessmentsClientListByInstanceResponse, error) {
	result := ManagedInstanceVulnerabilityAssessmentsClientListByInstanceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagedInstanceVulnerabilityAssessmentListResult); err != nil {
		return ManagedInstanceVulnerabilityAssessmentsClientListByInstanceResponse{}, err
	}
	return result, nil
}
