//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armproviderhub

import "time"

type AuthorizationActionMapping struct {
	Desired  *string `json:"desired,omitempty"`
	Original *string `json:"original,omitempty"`
}

type CanaryTrafficRegionRolloutConfiguration struct {
	Regions     []*string `json:"regions,omitempty"`
	SkipRegions []*string `json:"skipRegions,omitempty"`
}

type CheckNameAvailabilitySpecifications struct {
	EnableDefaultValidation           *bool     `json:"enableDefaultValidation,omitempty"`
	ResourceTypesWithCustomValidation []*string `json:"resourceTypesWithCustomValidation,omitempty"`
}

type CheckinManifestInfo struct {
	// REQUIRED
	IsCheckedIn *bool `json:"isCheckedIn,omitempty"`

	// REQUIRED
	StatusMessage *string `json:"statusMessage,omitempty"`
	CommitID      *string `json:"commitId,omitempty"`
	PullRequest   *string `json:"pullRequest,omitempty"`
}

type CheckinManifestParams struct {
	// REQUIRED; The baseline ARM manifest location supplied to the checkin manifest operation.
	BaselineArmManifestLocation *string `json:"baselineArmManifestLocation,omitempty"`

	// REQUIRED; The environment supplied to the checkin manifest operation.
	Environment *string `json:"environment,omitempty"`
}

// ClientCheckinManifestOptions contains the optional parameters for the Client.CheckinManifest method.
type ClientCheckinManifestOptions struct {
	// placeholder for future optional parameters
}

// ClientGenerateManifestOptions contains the optional parameters for the Client.GenerateManifest method.
type ClientGenerateManifestOptions struct {
	// placeholder for future optional parameters
}

// CustomRollout - Rollout details.
type CustomRollout struct {
	// REQUIRED; Properties of the rollout.
	Properties *CustomRolloutProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type CustomRolloutArrayResponseWithContinuation struct {
	// The URL to get to the next set of results, if there are any.
	NextLink *string          `json:"nextLink,omitempty"`
	Value    []*CustomRollout `json:"value,omitempty"`
}

// CustomRolloutProperties - Properties of the rollout.
type CustomRolloutProperties struct {
	// REQUIRED
	Specification     *CustomRolloutPropertiesSpecification `json:"specification,omitempty"`
	ProvisioningState *ProvisioningState                    `json:"provisioningState,omitempty"`
	Status            *CustomRolloutPropertiesStatus        `json:"status,omitempty"`
}

type CustomRolloutPropertiesAutoGenerated struct {
	// REQUIRED
	Specification     *CustomRolloutPropertiesSpecification `json:"specification,omitempty"`
	ProvisioningState *ProvisioningState                    `json:"provisioningState,omitempty"`
	Status            *CustomRolloutPropertiesStatus        `json:"status,omitempty"`
}

type CustomRolloutPropertiesSpecification struct {
	// REQUIRED
	Canary                    *CustomRolloutSpecificationCanary               `json:"canary,omitempty"`
	ProviderRegistration      *CustomRolloutSpecificationProviderRegistration `json:"providerRegistration,omitempty"`
	ResourceTypeRegistrations []*ResourceTypeRegistration                     `json:"resourceTypeRegistrations,omitempty"`
}

type CustomRolloutPropertiesStatus struct {
	CompletedRegions []*string `json:"completedRegions,omitempty"`

	// Dictionary of
	FailedOrSkippedRegions map[string]*ExtendedErrorInfo `json:"failedOrSkippedRegions,omitempty"`
}

type CustomRolloutSpecification struct {
	// REQUIRED
	Canary                    *CustomRolloutSpecificationCanary               `json:"canary,omitempty"`
	ProviderRegistration      *CustomRolloutSpecificationProviderRegistration `json:"providerRegistration,omitempty"`
	ResourceTypeRegistrations []*ResourceTypeRegistration                     `json:"resourceTypeRegistrations,omitempty"`
}

type CustomRolloutSpecificationCanary struct {
	Regions []*string `json:"regions,omitempty"`
}

type CustomRolloutSpecificationProviderRegistration struct {
	Properties *ProviderRegistrationProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type CustomRolloutStatus struct {
	CompletedRegions []*string `json:"completedRegions,omitempty"`

	// Dictionary of
	FailedOrSkippedRegions map[string]*ExtendedErrorInfo `json:"failedOrSkippedRegions,omitempty"`
}

// CustomRolloutsClientCreateOrUpdateOptions contains the optional parameters for the CustomRolloutsClient.CreateOrUpdate
// method.
type CustomRolloutsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// CustomRolloutsClientGetOptions contains the optional parameters for the CustomRolloutsClient.Get method.
type CustomRolloutsClientGetOptions struct {
	// placeholder for future optional parameters
}

// CustomRolloutsClientListByProviderRegistrationOptions contains the optional parameters for the CustomRolloutsClient.ListByProviderRegistration
// method.
type CustomRolloutsClientListByProviderRegistrationOptions struct {
	// placeholder for future optional parameters
}

// DefaultRollout - Default rollout definition.
type DefaultRollout struct {
	// Properties of the rollout.
	Properties *DefaultRolloutProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type DefaultRolloutArrayResponseWithContinuation struct {
	// The URL to get to the next set of results, if there are any.
	NextLink *string           `json:"nextLink,omitempty"`
	Value    []*DefaultRollout `json:"value,omitempty"`
}

// DefaultRolloutProperties - Properties of the rollout.
type DefaultRolloutProperties struct {
	ProvisioningState *ProvisioningState                     `json:"provisioningState,omitempty"`
	Specification     *DefaultRolloutPropertiesSpecification `json:"specification,omitempty"`
	Status            *DefaultRolloutPropertiesStatus        `json:"status,omitempty"`
}

type DefaultRolloutPropertiesAutoGenerated struct {
	ProvisioningState *ProvisioningState                     `json:"provisioningState,omitempty"`
	Specification     *DefaultRolloutPropertiesSpecification `json:"specification,omitempty"`
	Status            *DefaultRolloutPropertiesStatus        `json:"status,omitempty"`
}

type DefaultRolloutPropertiesSpecification struct {
	Canary                    *DefaultRolloutSpecificationCanary                 `json:"canary,omitempty"`
	HighTraffic               *DefaultRolloutSpecificationHighTraffic            `json:"highTraffic,omitempty"`
	LowTraffic                *DefaultRolloutSpecificationLowTraffic             `json:"lowTraffic,omitempty"`
	MediumTraffic             *DefaultRolloutSpecificationMediumTraffic          `json:"mediumTraffic,omitempty"`
	ProviderRegistration      *DefaultRolloutSpecificationProviderRegistration   `json:"providerRegistration,omitempty"`
	ResourceTypeRegistrations []*ResourceTypeRegistration                        `json:"resourceTypeRegistrations,omitempty"`
	RestOfTheWorldGroupOne    *DefaultRolloutSpecificationRestOfTheWorldGroupOne `json:"restOfTheWorldGroupOne,omitempty"`
	RestOfTheWorldGroupTwo    *DefaultRolloutSpecificationRestOfTheWorldGroupTwo `json:"restOfTheWorldGroupTwo,omitempty"`
}

type DefaultRolloutPropertiesStatus struct {
	CompletedRegions []*string `json:"completedRegions,omitempty"`

	// Dictionary of
	FailedOrSkippedRegions           map[string]*ExtendedErrorInfo     `json:"failedOrSkippedRegions,omitempty"`
	NextTrafficRegion                *TrafficRegionCategory            `json:"nextTrafficRegion,omitempty"`
	NextTrafficRegionScheduledTime   *time.Time                        `json:"nextTrafficRegionScheduledTime,omitempty"`
	SubscriptionReregistrationResult *SubscriptionReregistrationResult `json:"subscriptionReregistrationResult,omitempty"`
}

type DefaultRolloutSpecification struct {
	Canary                    *DefaultRolloutSpecificationCanary                 `json:"canary,omitempty"`
	HighTraffic               *DefaultRolloutSpecificationHighTraffic            `json:"highTraffic,omitempty"`
	LowTraffic                *DefaultRolloutSpecificationLowTraffic             `json:"lowTraffic,omitempty"`
	MediumTraffic             *DefaultRolloutSpecificationMediumTraffic          `json:"mediumTraffic,omitempty"`
	ProviderRegistration      *DefaultRolloutSpecificationProviderRegistration   `json:"providerRegistration,omitempty"`
	ResourceTypeRegistrations []*ResourceTypeRegistration                        `json:"resourceTypeRegistrations,omitempty"`
	RestOfTheWorldGroupOne    *DefaultRolloutSpecificationRestOfTheWorldGroupOne `json:"restOfTheWorldGroupOne,omitempty"`
	RestOfTheWorldGroupTwo    *DefaultRolloutSpecificationRestOfTheWorldGroupTwo `json:"restOfTheWorldGroupTwo,omitempty"`
}

type DefaultRolloutSpecificationCanary struct {
	Regions     []*string `json:"regions,omitempty"`
	SkipRegions []*string `json:"skipRegions,omitempty"`
}

type DefaultRolloutSpecificationHighTraffic struct {
	Regions      []*string `json:"regions,omitempty"`
	WaitDuration *string   `json:"waitDuration,omitempty"`
}

type DefaultRolloutSpecificationLowTraffic struct {
	Regions      []*string `json:"regions,omitempty"`
	WaitDuration *string   `json:"waitDuration,omitempty"`
}

type DefaultRolloutSpecificationMediumTraffic struct {
	Regions      []*string `json:"regions,omitempty"`
	WaitDuration *string   `json:"waitDuration,omitempty"`
}

type DefaultRolloutSpecificationProviderRegistration struct {
	Properties *ProviderRegistrationProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type DefaultRolloutSpecificationRestOfTheWorldGroupOne struct {
	Regions      []*string `json:"regions,omitempty"`
	WaitDuration *string   `json:"waitDuration,omitempty"`
}

type DefaultRolloutSpecificationRestOfTheWorldGroupTwo struct {
	Regions      []*string `json:"regions,omitempty"`
	WaitDuration *string   `json:"waitDuration,omitempty"`
}

type DefaultRolloutStatus struct {
	CompletedRegions []*string `json:"completedRegions,omitempty"`

	// Dictionary of
	FailedOrSkippedRegions           map[string]*ExtendedErrorInfo     `json:"failedOrSkippedRegions,omitempty"`
	NextTrafficRegion                *TrafficRegionCategory            `json:"nextTrafficRegion,omitempty"`
	NextTrafficRegionScheduledTime   *time.Time                        `json:"nextTrafficRegionScheduledTime,omitempty"`
	SubscriptionReregistrationResult *SubscriptionReregistrationResult `json:"subscriptionReregistrationResult,omitempty"`
}

// DefaultRolloutsClientBeginCreateOrUpdateOptions contains the optional parameters for the DefaultRolloutsClient.BeginCreateOrUpdate
// method.
type DefaultRolloutsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DefaultRolloutsClientDeleteOptions contains the optional parameters for the DefaultRolloutsClient.Delete method.
type DefaultRolloutsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DefaultRolloutsClientGetOptions contains the optional parameters for the DefaultRolloutsClient.Get method.
type DefaultRolloutsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DefaultRolloutsClientListByProviderRegistrationOptions contains the optional parameters for the DefaultRolloutsClient.ListByProviderRegistration
// method.
type DefaultRolloutsClientListByProviderRegistrationOptions struct {
	// placeholder for future optional parameters
}

// DefaultRolloutsClientStopOptions contains the optional parameters for the DefaultRolloutsClient.Stop method.
type DefaultRolloutsClientStopOptions struct {
	// placeholder for future optional parameters
}

// Error - Standard error object.
type Error struct {
	// READ-ONLY; Server-defined set of error codes.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Array of details about specific errors that led to this reported error.
	Details []*Error `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; Object containing more specific information than the current object about the error.
	InnerError *ErrorInnerError `json:"innerError,omitempty" azure:"ro"`

	// READ-ONLY; Human-readable representation of the error.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Target of the error.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorInnerError - Object containing more specific information than the current object about the error.
type ErrorInnerError struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; Specific error code than was provided by the containing error.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Object containing more specific information than the current object about the error.
	InnerError interface{} `json:"innerError,omitempty" azure:"ro"`
}

// ErrorResponse - Standard error response.
type ErrorResponse struct {
	// Standard error object.
	Error *ErrorResponseError `json:"error,omitempty"`
}

// ErrorResponseError - Standard error object.
type ErrorResponseError struct {
	// READ-ONLY; Server-defined set of error codes.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Array of details about specific errors that led to this reported error.
	Details []*Error `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; Object containing more specific information than the current object about the error.
	InnerError *ErrorInnerError `json:"innerError,omitempty" azure:"ro"`

	// READ-ONLY; Human-readable representation of the error.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Target of the error.
	Target *string `json:"target,omitempty" azure:"ro"`
}

type ExtendedErrorInfo struct {
	AdditionalInfo []*TypedErrorInfo    `json:"additionalInfo,omitempty"`
	Code           *string              `json:"code,omitempty"`
	Details        []*ExtendedErrorInfo `json:"details,omitempty"`
	Message        *string              `json:"message,omitempty"`
	Target         *string              `json:"target,omitempty"`
}

type ExtendedLocationOptions struct {
	SupportedPolicy *string `json:"supportedPolicy,omitempty"`
	Type            *string `json:"type,omitempty"`
}

type ExtensionOptions struct {
	Request  []*ExtensionOptionType `json:"request,omitempty"`
	Response []*ExtensionOptionType `json:"response,omitempty"`
}

type FeaturesRule struct {
	// REQUIRED
	RequiredFeaturesPolicy *FeaturesPolicy `json:"requiredFeaturesPolicy,omitempty"`
}

type IdentityManagement struct {
	Type *IdentityManagementTypes `json:"type,omitempty"`
}

type IdentityManagementProperties struct {
	ApplicationID *string                  `json:"applicationId,omitempty"`
	Type          *IdentityManagementTypes `json:"type,omitempty"`
}

// InnerError - Inner error containing list of errors.
type InnerError struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; Specific error code than was provided by the containing error.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Object containing more specific information than the current object about the error.
	InnerError interface{} `json:"innerError,omitempty" azure:"ro"`
}

type LightHouseAuthorization struct {
	// REQUIRED
	PrincipalID *string `json:"principalId,omitempty"`

	// REQUIRED
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
}

type LinkedAccessCheck struct {
	ActionName       *string `json:"actionName,omitempty"`
	LinkedAction     *string `json:"linkedAction,omitempty"`
	LinkedActionVerb *string `json:"linkedActionVerb,omitempty"`
	LinkedProperty   *string `json:"linkedProperty,omitempty"`
	LinkedType       *string `json:"linkedType,omitempty"`
}

type LinkedOperationRule struct {
	// REQUIRED
	LinkedAction *LinkedAction `json:"linkedAction,omitempty"`

	// REQUIRED
	LinkedOperation *LinkedOperation `json:"linkedOperation,omitempty"`
}

type LoggingHiddenPropertyPath struct {
	HiddenPathsOnRequest  []*string `json:"hiddenPathsOnRequest,omitempty"`
	HiddenPathsOnResponse []*string `json:"hiddenPathsOnResponse,omitempty"`
}

type LoggingRule struct {
	// REQUIRED
	Action *string `json:"action,omitempty"`

	// REQUIRED
	DetailLevel *LoggingDetails `json:"detailLevel,omitempty"`

	// REQUIRED
	Direction           *LoggingDirections              `json:"direction,omitempty"`
	HiddenPropertyPaths *LoggingRuleHiddenPropertyPaths `json:"hiddenPropertyPaths,omitempty"`
}

type LoggingRuleHiddenPropertyPaths struct {
	HiddenPathsOnRequest  []*string `json:"hiddenPathsOnRequest,omitempty"`
	HiddenPathsOnResponse []*string `json:"hiddenPathsOnResponse,omitempty"`
}

type Metadata struct {
	ProviderAuthentication          *MetadataProviderAuthentication          `json:"providerAuthentication,omitempty"`
	ProviderAuthorizations          []*ResourceProviderAuthorization         `json:"providerAuthorizations,omitempty"`
	ThirdPartyProviderAuthorization *MetadataThirdPartyProviderAuthorization `json:"thirdPartyProviderAuthorization,omitempty"`
}

type MetadataProviderAuthentication struct {
	// REQUIRED
	AllowedAudiences []*string `json:"allowedAudiences,omitempty"`
}

type MetadataThirdPartyProviderAuthorization struct {
	Authorizations    []*LightHouseAuthorization `json:"authorizations,omitempty"`
	ManagedByTenantID *string                    `json:"managedByTenantId,omitempty"`
}

type NotificationEndpoint struct {
	Locations               []*string `json:"locations,omitempty"`
	NotificationDestination *string   `json:"notificationDestination,omitempty"`
}

// NotificationRegistration - The notification registration definition.
type NotificationRegistration struct {
	Properties *NotificationRegistrationProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type NotificationRegistrationArrayResponseWithContinuation struct {
	// The URL to get to the next set of results, if there are any.
	NextLink *string                     `json:"nextLink,omitempty"`
	Value    []*NotificationRegistration `json:"value,omitempty"`
}

type NotificationRegistrationProperties struct {
	IncludedEvents        []*string               `json:"includedEvents,omitempty"`
	MessageScope          *MessageScope           `json:"messageScope,omitempty"`
	NotificationEndpoints []*NotificationEndpoint `json:"notificationEndpoints,omitempty"`
	NotificationMode      *NotificationMode       `json:"notificationMode,omitempty"`
	ProvisioningState     *ProvisioningState      `json:"provisioningState,omitempty"`
}

type NotificationRegistrationPropertiesAutoGenerated struct {
	IncludedEvents        []*string               `json:"includedEvents,omitempty"`
	MessageScope          *MessageScope           `json:"messageScope,omitempty"`
	NotificationEndpoints []*NotificationEndpoint `json:"notificationEndpoints,omitempty"`
	NotificationMode      *NotificationMode       `json:"notificationMode,omitempty"`
	ProvisioningState     *ProvisioningState      `json:"provisioningState,omitempty"`
}

// NotificationRegistrationsClientCreateOrUpdateOptions contains the optional parameters for the NotificationRegistrationsClient.CreateOrUpdate
// method.
type NotificationRegistrationsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// NotificationRegistrationsClientDeleteOptions contains the optional parameters for the NotificationRegistrationsClient.Delete
// method.
type NotificationRegistrationsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// NotificationRegistrationsClientGetOptions contains the optional parameters for the NotificationRegistrationsClient.Get
// method.
type NotificationRegistrationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// NotificationRegistrationsClientListByProviderRegistrationOptions contains the optional parameters for the NotificationRegistrationsClient.ListByProviderRegistration
// method.
type NotificationRegistrationsClientListByProviderRegistrationOptions struct {
	// placeholder for future optional parameters
}

// OperationsClientCreateOrUpdateOptions contains the optional parameters for the OperationsClient.CreateOrUpdate method.
type OperationsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// OperationsClientDeleteOptions contains the optional parameters for the OperationsClient.Delete method.
type OperationsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// OperationsClientListByProviderRegistrationOptions contains the optional parameters for the OperationsClient.ListByProviderRegistration
// method.
type OperationsClientListByProviderRegistrationOptions struct {
	// placeholder for future optional parameters
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

type OperationsContent struct {
	// Operations content.
	Properties *OperationsDefinition `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OperationsDefinition - Properties of an Operation.
type OperationsDefinition struct {
	// REQUIRED; Display information of the operation.
	Display *OperationsDefinitionDisplay `json:"display,omitempty"`

	// REQUIRED; Name of the operation.
	Name       *string                         `json:"name,omitempty"`
	ActionType *OperationsDefinitionActionType `json:"actionType,omitempty"`

	// Indicates whether the operation applies to data-plane.
	IsDataAction *bool                       `json:"isDataAction,omitempty"`
	Origin       *OperationsDefinitionOrigin `json:"origin,omitempty"`

	// Anything
	Properties interface{} `json:"properties,omitempty"`
}

type OperationsDefinitionArrayResponseWithContinuation struct {
	// The URL to get to the next set of results, if there are any.
	NextLink *string                 `json:"nextLink,omitempty"`
	Value    []*OperationsDefinition `json:"value,omitempty"`
}

// OperationsDefinitionDisplay - Display information of the operation.
type OperationsDefinitionDisplay struct {
	// REQUIRED
	Description *string `json:"description,omitempty"`

	// REQUIRED
	Operation *string `json:"operation,omitempty"`

	// REQUIRED
	Provider *string `json:"provider,omitempty"`

	// REQUIRED
	Resource *string `json:"resource,omitempty"`
}

type OperationsDisplayDefinition struct {
	// REQUIRED
	Description *string `json:"description,omitempty"`

	// REQUIRED
	Operation *string `json:"operation,omitempty"`

	// REQUIRED
	Provider *string `json:"provider,omitempty"`

	// REQUIRED
	Resource *string `json:"resource,omitempty"`
}

type OperationsPutContent struct {
	// REQUIRED
	Contents []*OperationsDefinition `json:"contents,omitempty"`
}

type ProviderRegistration struct {
	Properties *ProviderRegistrationProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type ProviderRegistrationArrayResponseWithContinuation struct {
	// The URL to get to the next set of results, if there are any.
	NextLink *string                 `json:"nextLink,omitempty"`
	Value    []*ProviderRegistration `json:"value,omitempty"`
}

type ProviderRegistrationProperties struct {
	Capabilities []*ResourceProviderCapabilities                 `json:"capabilities,omitempty"`
	FeaturesRule *ResourceProviderManifestPropertiesFeaturesRule `json:"featuresRule,omitempty"`
	Management   *ResourceProviderManifestPropertiesManagement   `json:"management,omitempty"`

	// Anything
	Metadata                                        interface{}                                                                    `json:"metadata,omitempty"`
	Namespace                                       *string                                                                        `json:"namespace,omitempty"`
	ProviderAuthentication                          *ResourceProviderManifestPropertiesProviderAuthentication                      `json:"providerAuthentication,omitempty"`
	ProviderAuthorizations                          []*ResourceProviderAuthorization                                               `json:"providerAuthorizations,omitempty"`
	ProviderHubMetadata                             *ProviderRegistrationPropertiesProviderHubMetadata                             `json:"providerHubMetadata,omitempty"`
	ProviderType                                    *ResourceProviderType                                                          `json:"providerType,omitempty"`
	ProviderVersion                                 *string                                                                        `json:"providerVersion,omitempty"`
	ProvisioningState                               *ProvisioningState                                                             `json:"provisioningState,omitempty"`
	RequestHeaderOptions                            *ResourceProviderManifestPropertiesRequestHeaderOptions                        `json:"requestHeaderOptions,omitempty"`
	RequiredFeatures                                []*string                                                                      `json:"requiredFeatures,omitempty"`
	SubscriptionLifecycleNotificationSpecifications *ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications `json:"subscriptionLifecycleNotificationSpecifications,omitempty"`
	TemplateDeploymentOptions                       *ResourceProviderManifestPropertiesTemplateDeploymentOptions                   `json:"templateDeploymentOptions,omitempty"`
}

type ProviderRegistrationPropertiesAutoGenerated struct {
	Capabilities []*ResourceProviderCapabilities                 `json:"capabilities,omitempty"`
	FeaturesRule *ResourceProviderManifestPropertiesFeaturesRule `json:"featuresRule,omitempty"`
	Management   *ResourceProviderManifestPropertiesManagement   `json:"management,omitempty"`

	// Anything
	Metadata                                        interface{}                                                                    `json:"metadata,omitempty"`
	Namespace                                       *string                                                                        `json:"namespace,omitempty"`
	ProviderAuthentication                          *ResourceProviderManifestPropertiesProviderAuthentication                      `json:"providerAuthentication,omitempty"`
	ProviderAuthorizations                          []*ResourceProviderAuthorization                                               `json:"providerAuthorizations,omitempty"`
	ProviderHubMetadata                             *ProviderRegistrationPropertiesProviderHubMetadata                             `json:"providerHubMetadata,omitempty"`
	ProviderType                                    *ResourceProviderType                                                          `json:"providerType,omitempty"`
	ProviderVersion                                 *string                                                                        `json:"providerVersion,omitempty"`
	ProvisioningState                               *ProvisioningState                                                             `json:"provisioningState,omitempty"`
	RequestHeaderOptions                            *ResourceProviderManifestPropertiesRequestHeaderOptions                        `json:"requestHeaderOptions,omitempty"`
	RequiredFeatures                                []*string                                                                      `json:"requiredFeatures,omitempty"`
	SubscriptionLifecycleNotificationSpecifications *ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications `json:"subscriptionLifecycleNotificationSpecifications,omitempty"`
	TemplateDeploymentOptions                       *ResourceProviderManifestPropertiesTemplateDeploymentOptions                   `json:"templateDeploymentOptions,omitempty"`
}

type ProviderRegistrationPropertiesProviderHubMetadata struct {
	ProviderAuthentication          *MetadataProviderAuthentication          `json:"providerAuthentication,omitempty"`
	ProviderAuthorizations          []*ResourceProviderAuthorization         `json:"providerAuthorizations,omitempty"`
	ThirdPartyProviderAuthorization *MetadataThirdPartyProviderAuthorization `json:"thirdPartyProviderAuthorization,omitempty"`
}

type ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications struct {
	SoftDeleteTTL                    *string                            `json:"softDeleteTTL,omitempty"`
	SubscriptionStateOverrideActions []*SubscriptionStateOverrideAction `json:"subscriptionStateOverrideActions,omitempty"`
}

// ProviderRegistrationsClientBeginCreateOrUpdateOptions contains the optional parameters for the ProviderRegistrationsClient.BeginCreateOrUpdate
// method.
type ProviderRegistrationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ProviderRegistrationsClientDeleteOptions contains the optional parameters for the ProviderRegistrationsClient.Delete method.
type ProviderRegistrationsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ProviderRegistrationsClientGenerateOperationsOptions contains the optional parameters for the ProviderRegistrationsClient.GenerateOperations
// method.
type ProviderRegistrationsClientGenerateOperationsOptions struct {
	// placeholder for future optional parameters
}

// ProviderRegistrationsClientGetOptions contains the optional parameters for the ProviderRegistrationsClient.Get method.
type ProviderRegistrationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProviderRegistrationsClientListOptions contains the optional parameters for the ProviderRegistrationsClient.List method.
type ProviderRegistrationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type ReRegisterSubscriptionMetadata struct {
	// REQUIRED
	Enabled          *bool  `json:"enabled,omitempty"`
	ConcurrencyLimit *int32 `json:"concurrencyLimit,omitempty"`
}

type RequestHeaderOptions struct {
	OptInHeaders *OptInHeaderType `json:"optInHeaders,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type ResourceMovePolicy struct {
	CrossResourceGroupMoveEnabled *bool `json:"crossResourceGroupMoveEnabled,omitempty"`
	CrossSubscriptionMoveEnabled  *bool `json:"crossSubscriptionMoveEnabled,omitempty"`
	ValidationRequired            *bool `json:"validationRequired,omitempty"`
}

type ResourceProviderAuthentication struct {
	// REQUIRED
	AllowedAudiences []*string `json:"allowedAudiences,omitempty"`
}

type ResourceProviderAuthorization struct {
	ApplicationID             *string `json:"applicationId,omitempty"`
	ManagedByRoleDefinitionID *string `json:"managedByRoleDefinitionId,omitempty"`
	RoleDefinitionID          *string `json:"roleDefinitionId,omitempty"`
}

type ResourceProviderCapabilities struct {
	// REQUIRED
	Effect *ResourceProviderCapabilitiesEffect `json:"effect,omitempty"`

	// REQUIRED
	QuotaID          *string   `json:"quotaId,omitempty"`
	RequiredFeatures []*string `json:"requiredFeatures,omitempty"`
}

type ResourceProviderEndpoint struct {
	APIVersions      []*string                             `json:"apiVersions,omitempty"`
	Enabled          *bool                                 `json:"enabled,omitempty"`
	EndpointURI      *string                               `json:"endpointUri,omitempty"`
	FeaturesRule     *ResourceProviderEndpointFeaturesRule `json:"featuresRule,omitempty"`
	Locations        []*string                             `json:"locations,omitempty"`
	RequiredFeatures []*string                             `json:"requiredFeatures,omitempty"`
	Timeout          *string                               `json:"timeout,omitempty"`
}

type ResourceProviderEndpointFeaturesRule struct {
	// REQUIRED
	RequiredFeaturesPolicy *FeaturesPolicy `json:"requiredFeaturesPolicy,omitempty"`
}

type ResourceProviderManagement struct {
	IncidentContactEmail   *string                                         `json:"incidentContactEmail,omitempty"`
	IncidentRoutingService *string                                         `json:"incidentRoutingService,omitempty"`
	IncidentRoutingTeam    *string                                         `json:"incidentRoutingTeam,omitempty"`
	ManifestOwners         []*string                                       `json:"manifestOwners,omitempty"`
	ResourceAccessPolicy   *ResourceProviderManagementResourceAccessPolicy `json:"resourceAccessPolicy,omitempty"`
	ResourceAccessRoles    []interface{}                                   `json:"resourceAccessRoles,omitempty"`
	SchemaOwners           []*string                                       `json:"schemaOwners,omitempty"`
	ServiceTreeInfos       []*ServiceTreeInfo                              `json:"serviceTreeInfos,omitempty"`
}

type ResourceProviderManifest struct {
	Capabilities                []*ResourceProviderCapabilities       `json:"capabilities,omitempty"`
	FeaturesRule                *ResourceProviderManifestFeaturesRule `json:"featuresRule,omitempty"`
	GlobalNotificationEndpoints []*ResourceProviderEndpoint           `json:"globalNotificationEndpoints,omitempty"`
	Management                  *ResourceProviderManifestManagement   `json:"management,omitempty"`

	// Anything
	Metadata                       interface{}                                             `json:"metadata,omitempty"`
	Namespace                      *string                                                 `json:"namespace,omitempty"`
	ProviderAuthentication         *ResourceProviderManifestProviderAuthentication         `json:"providerAuthentication,omitempty"`
	ProviderAuthorizations         []*ResourceProviderAuthorization                        `json:"providerAuthorizations,omitempty"`
	ProviderType                   *ResourceProviderType                                   `json:"providerType,omitempty"`
	ProviderVersion                *string                                                 `json:"providerVersion,omitempty"`
	ReRegisterSubscriptionMetadata *ResourceProviderManifestReRegisterSubscriptionMetadata `json:"reRegisterSubscriptionMetadata,omitempty"`
	RequestHeaderOptions           *ResourceProviderManifestRequestHeaderOptions           `json:"requestHeaderOptions,omitempty"`
	RequiredFeatures               []*string                                               `json:"requiredFeatures,omitempty"`
	ResourceTypes                  []*ResourceType                                         `json:"resourceTypes,omitempty"`
}

type ResourceProviderManifestFeaturesRule struct {
	// REQUIRED
	RequiredFeaturesPolicy *FeaturesPolicy `json:"requiredFeaturesPolicy,omitempty"`
}

type ResourceProviderManifestManagement struct {
	IncidentContactEmail   *string                                         `json:"incidentContactEmail,omitempty"`
	IncidentRoutingService *string                                         `json:"incidentRoutingService,omitempty"`
	IncidentRoutingTeam    *string                                         `json:"incidentRoutingTeam,omitempty"`
	ManifestOwners         []*string                                       `json:"manifestOwners,omitempty"`
	ResourceAccessPolicy   *ResourceProviderManagementResourceAccessPolicy `json:"resourceAccessPolicy,omitempty"`
	ResourceAccessRoles    []interface{}                                   `json:"resourceAccessRoles,omitempty"`
	SchemaOwners           []*string                                       `json:"schemaOwners,omitempty"`
	ServiceTreeInfos       []*ServiceTreeInfo                              `json:"serviceTreeInfos,omitempty"`
}

type ResourceProviderManifestProperties struct {
	Capabilities []*ResourceProviderCapabilities                 `json:"capabilities,omitempty"`
	FeaturesRule *ResourceProviderManifestPropertiesFeaturesRule `json:"featuresRule,omitempty"`
	Management   *ResourceProviderManifestPropertiesManagement   `json:"management,omitempty"`

	// Anything
	Metadata                  interface{}                                                  `json:"metadata,omitempty"`
	Namespace                 *string                                                      `json:"namespace,omitempty"`
	ProviderAuthentication    *ResourceProviderManifestPropertiesProviderAuthentication    `json:"providerAuthentication,omitempty"`
	ProviderAuthorizations    []*ResourceProviderAuthorization                             `json:"providerAuthorizations,omitempty"`
	ProviderType              *ResourceProviderType                                        `json:"providerType,omitempty"`
	ProviderVersion           *string                                                      `json:"providerVersion,omitempty"`
	RequestHeaderOptions      *ResourceProviderManifestPropertiesRequestHeaderOptions      `json:"requestHeaderOptions,omitempty"`
	RequiredFeatures          []*string                                                    `json:"requiredFeatures,omitempty"`
	TemplateDeploymentOptions *ResourceProviderManifestPropertiesTemplateDeploymentOptions `json:"templateDeploymentOptions,omitempty"`
}

type ResourceProviderManifestPropertiesFeaturesRule struct {
	// REQUIRED
	RequiredFeaturesPolicy *FeaturesPolicy `json:"requiredFeaturesPolicy,omitempty"`
}

type ResourceProviderManifestPropertiesManagement struct {
	IncidentContactEmail   *string                                         `json:"incidentContactEmail,omitempty"`
	IncidentRoutingService *string                                         `json:"incidentRoutingService,omitempty"`
	IncidentRoutingTeam    *string                                         `json:"incidentRoutingTeam,omitempty"`
	ManifestOwners         []*string                                       `json:"manifestOwners,omitempty"`
	ResourceAccessPolicy   *ResourceProviderManagementResourceAccessPolicy `json:"resourceAccessPolicy,omitempty"`
	ResourceAccessRoles    []interface{}                                   `json:"resourceAccessRoles,omitempty"`
	SchemaOwners           []*string                                       `json:"schemaOwners,omitempty"`
	ServiceTreeInfos       []*ServiceTreeInfo                              `json:"serviceTreeInfos,omitempty"`
}

type ResourceProviderManifestPropertiesProviderAuthentication struct {
	// REQUIRED
	AllowedAudiences []*string `json:"allowedAudiences,omitempty"`
}

type ResourceProviderManifestPropertiesRequestHeaderOptions struct {
	OptInHeaders *OptInHeaderType `json:"optInHeaders,omitempty"`
}

type ResourceProviderManifestPropertiesTemplateDeploymentOptions struct {
	PreflightOptions   []*PreflightOption `json:"preflightOptions,omitempty"`
	PreflightSupported *bool              `json:"preflightSupported,omitempty"`
}

type ResourceProviderManifestProviderAuthentication struct {
	// REQUIRED
	AllowedAudiences []*string `json:"allowedAudiences,omitempty"`
}

type ResourceProviderManifestReRegisterSubscriptionMetadata struct {
	// REQUIRED
	Enabled          *bool  `json:"enabled,omitempty"`
	ConcurrencyLimit *int32 `json:"concurrencyLimit,omitempty"`
}

type ResourceProviderManifestRequestHeaderOptions struct {
	OptInHeaders *OptInHeaderType `json:"optInHeaders,omitempty"`
}

type ResourceType struct {
	AllowedUnauthorizedActions  []*string                       `json:"allowedUnauthorizedActions,omitempty"`
	AuthorizationActionMappings []*AuthorizationActionMapping   `json:"authorizationActionMappings,omitempty"`
	DefaultAPIVersion           *string                         `json:"defaultApiVersion,omitempty"`
	DisallowedActionVerbs       []*string                       `json:"disallowedActionVerbs,omitempty"`
	Endpoints                   []*ResourceProviderEndpoint     `json:"endpoints,omitempty"`
	ExtendedLocations           []*ExtendedLocationOptions      `json:"extendedLocations,omitempty"`
	FeaturesRule                *ResourceTypeFeaturesRule       `json:"featuresRule,omitempty"`
	IdentityManagement          *ResourceTypeIdentityManagement `json:"identityManagement,omitempty"`
	LinkedAccessChecks          []*LinkedAccessCheck            `json:"linkedAccessChecks,omitempty"`
	LinkedOperationRules        []*LinkedOperationRule          `json:"linkedOperationRules,omitempty"`
	LoggingRules                []*LoggingRule                  `json:"loggingRules,omitempty"`
	MarketplaceType             *ResourceTypeMarketplaceType    `json:"marketplaceType,omitempty"`

	// Anything
	Metadata                 interface{}                           `json:"metadata,omitempty"`
	Name                     *string                               `json:"name,omitempty"`
	RequestHeaderOptions     *ResourceTypeRequestHeaderOptions     `json:"requestHeaderOptions,omitempty"`
	RequiredFeatures         []*string                             `json:"requiredFeatures,omitempty"`
	ResourceDeletionPolicy   *ManifestResourceDeletionPolicy       `json:"resourceDeletionPolicy,omitempty"`
	ResourceValidation       *ResourceValidation                   `json:"resourceValidation,omitempty"`
	RoutingType              *RoutingType                          `json:"routingType,omitempty"`
	SKULink                  *string                               `json:"skuLink,omitempty"`
	ServiceTreeInfos         []*ServiceTreeInfo                    `json:"serviceTreeInfos,omitempty"`
	SubscriptionStateRules   []*SubscriptionStateRule              `json:"subscriptionStateRules,omitempty"`
	TemplateDeploymentPolicy *ResourceTypeTemplateDeploymentPolicy `json:"templateDeploymentPolicy,omitempty"`
	ThrottlingRules          []*ThrottlingRule                     `json:"throttlingRules,omitempty"`
}

type ResourceTypeEndpoint struct {
	APIVersions      []*string                         `json:"apiVersions,omitempty"`
	Enabled          *bool                             `json:"enabled,omitempty"`
	Extensions       []*ResourceTypeExtension          `json:"extensions,omitempty"`
	FeaturesRule     *ResourceTypeEndpointFeaturesRule `json:"featuresRule,omitempty"`
	Locations        []*string                         `json:"locations,omitempty"`
	RequiredFeatures []*string                         `json:"requiredFeatures,omitempty"`
	Timeout          *string                           `json:"timeout,omitempty"`
}

type ResourceTypeEndpointFeaturesRule struct {
	// REQUIRED
	RequiredFeaturesPolicy *FeaturesPolicy `json:"requiredFeaturesPolicy,omitempty"`
}

type ResourceTypeExtension struct {
	EndpointURI         *string              `json:"endpointUri,omitempty"`
	ExtensionCategories []*ExtensionCategory `json:"extensionCategories,omitempty"`
	Timeout             *string              `json:"timeout,omitempty"`
}

type ResourceTypeExtensionOptions struct {
	ResourceCreationBegin *ResourceTypeExtensionOptionsResourceCreationBegin `json:"resourceCreationBegin,omitempty"`
}

type ResourceTypeExtensionOptionsResourceCreationBegin struct {
	Request  []*ExtensionOptionType `json:"request,omitempty"`
	Response []*ExtensionOptionType `json:"response,omitempty"`
}

type ResourceTypeFeaturesRule struct {
	// REQUIRED
	RequiredFeaturesPolicy *FeaturesPolicy `json:"requiredFeaturesPolicy,omitempty"`
}

type ResourceTypeIdentityManagement struct {
	Type *IdentityManagementTypes `json:"type,omitempty"`
}

type ResourceTypeRegistration struct {
	Properties *ResourceTypeRegistrationProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type ResourceTypeRegistrationArrayResponseWithContinuation struct {
	// The URL to get to the next set of results, if there are any.
	NextLink *string                     `json:"nextLink,omitempty"`
	Value    []*ResourceTypeRegistration `json:"value,omitempty"`
}

type ResourceTypeRegistrationProperties struct {
	AllowedUnauthorizedActions                      []*string                                                                          `json:"allowedUnauthorizedActions,omitempty"`
	AuthorizationActionMappings                     []*AuthorizationActionMapping                                                      `json:"authorizationActionMappings,omitempty"`
	CheckNameAvailabilitySpecifications             *ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecifications             `json:"checkNameAvailabilitySpecifications,omitempty"`
	DefaultAPIVersion                               *string                                                                            `json:"defaultApiVersion,omitempty"`
	DisallowedActionVerbs                           []*string                                                                          `json:"disallowedActionVerbs,omitempty"`
	EnableAsyncOperation                            *bool                                                                              `json:"enableAsyncOperation,omitempty"`
	EnableThirdPartyS2S                             *bool                                                                              `json:"enableThirdPartyS2S,omitempty"`
	Endpoints                                       []*ResourceTypeEndpoint                                                            `json:"endpoints,omitempty"`
	ExtendedLocations                               []*ExtendedLocationOptions                                                         `json:"extendedLocations,omitempty"`
	ExtensionOptions                                *ResourceTypeRegistrationPropertiesExtensionOptions                                `json:"extensionOptions,omitempty"`
	FeaturesRule                                    *ResourceTypeRegistrationPropertiesFeaturesRule                                    `json:"featuresRule,omitempty"`
	IdentityManagement                              *ResourceTypeRegistrationPropertiesIdentityManagement                              `json:"identityManagement,omitempty"`
	IsPureProxy                                     *bool                                                                              `json:"isPureProxy,omitempty"`
	LinkedAccessChecks                              []*LinkedAccessCheck                                                               `json:"linkedAccessChecks,omitempty"`
	LoggingRules                                    []*LoggingRule                                                                     `json:"loggingRules,omitempty"`
	MarketplaceType                                 *ResourceTypeRegistrationPropertiesMarketplaceType                                 `json:"marketplaceType,omitempty"`
	ProvisioningState                               *ProvisioningState                                                                 `json:"provisioningState,omitempty"`
	Regionality                                     *Regionality                                                                       `json:"regionality,omitempty"`
	RequestHeaderOptions                            *ResourceTypeRegistrationPropertiesRequestHeaderOptions                            `json:"requestHeaderOptions,omitempty"`
	RequiredFeatures                                []*string                                                                          `json:"requiredFeatures,omitempty"`
	ResourceDeletionPolicy                          *ResourceDeletionPolicy                                                            `json:"resourceDeletionPolicy,omitempty"`
	ResourceMovePolicy                              *ResourceTypeRegistrationPropertiesResourceMovePolicy                              `json:"resourceMovePolicy,omitempty"`
	RoutingType                                     *RoutingType                                                                       `json:"routingType,omitempty"`
	ServiceTreeInfos                                []*ServiceTreeInfo                                                                 `json:"serviceTreeInfos,omitempty"`
	SubscriptionLifecycleNotificationSpecifications *ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications `json:"subscriptionLifecycleNotificationSpecifications,omitempty"`
	SubscriptionStateRules                          []*SubscriptionStateRule                                                           `json:"subscriptionStateRules,omitempty"`
	SwaggerSpecifications                           []*SwaggerSpecification                                                            `json:"swaggerSpecifications,omitempty"`
	TemplateDeploymentOptions                       *ResourceTypeRegistrationPropertiesTemplateDeploymentOptions                       `json:"templateDeploymentOptions,omitempty"`
	ThrottlingRules                                 []*ThrottlingRule                                                                  `json:"throttlingRules,omitempty"`
}

type ResourceTypeRegistrationPropertiesAutoGenerated struct {
	AllowedUnauthorizedActions                      []*string                                                                          `json:"allowedUnauthorizedActions,omitempty"`
	AuthorizationActionMappings                     []*AuthorizationActionMapping                                                      `json:"authorizationActionMappings,omitempty"`
	CheckNameAvailabilitySpecifications             *ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecifications             `json:"checkNameAvailabilitySpecifications,omitempty"`
	DefaultAPIVersion                               *string                                                                            `json:"defaultApiVersion,omitempty"`
	DisallowedActionVerbs                           []*string                                                                          `json:"disallowedActionVerbs,omitempty"`
	EnableAsyncOperation                            *bool                                                                              `json:"enableAsyncOperation,omitempty"`
	EnableThirdPartyS2S                             *bool                                                                              `json:"enableThirdPartyS2S,omitempty"`
	Endpoints                                       []*ResourceTypeEndpoint                                                            `json:"endpoints,omitempty"`
	ExtendedLocations                               []*ExtendedLocationOptions                                                         `json:"extendedLocations,omitempty"`
	ExtensionOptions                                *ResourceTypeRegistrationPropertiesExtensionOptions                                `json:"extensionOptions,omitempty"`
	FeaturesRule                                    *ResourceTypeRegistrationPropertiesFeaturesRule                                    `json:"featuresRule,omitempty"`
	IdentityManagement                              *ResourceTypeRegistrationPropertiesIdentityManagement                              `json:"identityManagement,omitempty"`
	IsPureProxy                                     *bool                                                                              `json:"isPureProxy,omitempty"`
	LinkedAccessChecks                              []*LinkedAccessCheck                                                               `json:"linkedAccessChecks,omitempty"`
	LoggingRules                                    []*LoggingRule                                                                     `json:"loggingRules,omitempty"`
	MarketplaceType                                 *ResourceTypeRegistrationPropertiesMarketplaceType                                 `json:"marketplaceType,omitempty"`
	ProvisioningState                               *ProvisioningState                                                                 `json:"provisioningState,omitempty"`
	Regionality                                     *Regionality                                                                       `json:"regionality,omitempty"`
	RequestHeaderOptions                            *ResourceTypeRegistrationPropertiesRequestHeaderOptions                            `json:"requestHeaderOptions,omitempty"`
	RequiredFeatures                                []*string                                                                          `json:"requiredFeatures,omitempty"`
	ResourceDeletionPolicy                          *ResourceDeletionPolicy                                                            `json:"resourceDeletionPolicy,omitempty"`
	ResourceMovePolicy                              *ResourceTypeRegistrationPropertiesResourceMovePolicy                              `json:"resourceMovePolicy,omitempty"`
	RoutingType                                     *RoutingType                                                                       `json:"routingType,omitempty"`
	ServiceTreeInfos                                []*ServiceTreeInfo                                                                 `json:"serviceTreeInfos,omitempty"`
	SubscriptionLifecycleNotificationSpecifications *ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications `json:"subscriptionLifecycleNotificationSpecifications,omitempty"`
	SubscriptionStateRules                          []*SubscriptionStateRule                                                           `json:"subscriptionStateRules,omitempty"`
	SwaggerSpecifications                           []*SwaggerSpecification                                                            `json:"swaggerSpecifications,omitempty"`
	TemplateDeploymentOptions                       *ResourceTypeRegistrationPropertiesTemplateDeploymentOptions                       `json:"templateDeploymentOptions,omitempty"`
	ThrottlingRules                                 []*ThrottlingRule                                                                  `json:"throttlingRules,omitempty"`
}

type ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecifications struct {
	EnableDefaultValidation           *bool     `json:"enableDefaultValidation,omitempty"`
	ResourceTypesWithCustomValidation []*string `json:"resourceTypesWithCustomValidation,omitempty"`
}

type ResourceTypeRegistrationPropertiesExtensionOptions struct {
	ResourceCreationBegin *ResourceTypeExtensionOptionsResourceCreationBegin `json:"resourceCreationBegin,omitempty"`
}

type ResourceTypeRegistrationPropertiesFeaturesRule struct {
	// REQUIRED
	RequiredFeaturesPolicy *FeaturesPolicy `json:"requiredFeaturesPolicy,omitempty"`
}

type ResourceTypeRegistrationPropertiesIdentityManagement struct {
	ApplicationID *string                  `json:"applicationId,omitempty"`
	Type          *IdentityManagementTypes `json:"type,omitempty"`
}

type ResourceTypeRegistrationPropertiesRequestHeaderOptions struct {
	OptInHeaders *OptInHeaderType `json:"optInHeaders,omitempty"`
}

type ResourceTypeRegistrationPropertiesResourceMovePolicy struct {
	CrossResourceGroupMoveEnabled *bool `json:"crossResourceGroupMoveEnabled,omitempty"`
	CrossSubscriptionMoveEnabled  *bool `json:"crossSubscriptionMoveEnabled,omitempty"`
	ValidationRequired            *bool `json:"validationRequired,omitempty"`
}

type ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications struct {
	SoftDeleteTTL                    *string                            `json:"softDeleteTTL,omitempty"`
	SubscriptionStateOverrideActions []*SubscriptionStateOverrideAction `json:"subscriptionStateOverrideActions,omitempty"`
}

type ResourceTypeRegistrationPropertiesTemplateDeploymentOptions struct {
	PreflightOptions   []*PreflightOption `json:"preflightOptions,omitempty"`
	PreflightSupported *bool              `json:"preflightSupported,omitempty"`
}

// ResourceTypeRegistrationsClientBeginCreateOrUpdateOptions contains the optional parameters for the ResourceTypeRegistrationsClient.BeginCreateOrUpdate
// method.
type ResourceTypeRegistrationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ResourceTypeRegistrationsClientDeleteOptions contains the optional parameters for the ResourceTypeRegistrationsClient.Delete
// method.
type ResourceTypeRegistrationsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ResourceTypeRegistrationsClientGetOptions contains the optional parameters for the ResourceTypeRegistrationsClient.Get
// method.
type ResourceTypeRegistrationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ResourceTypeRegistrationsClientListByProviderRegistrationOptions contains the optional parameters for the ResourceTypeRegistrationsClient.ListByProviderRegistration
// method.
type ResourceTypeRegistrationsClientListByProviderRegistrationOptions struct {
	// placeholder for future optional parameters
}

type ResourceTypeRequestHeaderOptions struct {
	OptInHeaders *OptInHeaderType `json:"optInHeaders,omitempty"`
}

type ResourceTypeSKU struct {
	// REQUIRED
	SKUSettings       []*SKUSetting      `json:"skuSettings,omitempty"`
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty"`
}

type ResourceTypeTemplateDeploymentPolicy struct {
	// REQUIRED
	Capabilities *TemplateDeploymentCapabilities `json:"capabilities,omitempty"`

	// REQUIRED
	PreflightOptions *TemplateDeploymentPreflightOptions `json:"preflightOptions,omitempty"`
}

type RolloutStatusBase struct {
	CompletedRegions []*string `json:"completedRegions,omitempty"`

	// Dictionary of
	FailedOrSkippedRegions map[string]*ExtendedErrorInfo `json:"failedOrSkippedRegions,omitempty"`
}

type SKUCapability struct {
	// REQUIRED
	Name *string `json:"name,omitempty"`

	// REQUIRED
	Value *string `json:"value,omitempty"`
}

type SKUCapacity struct {
	// REQUIRED
	Minimum   *int32        `json:"minimum,omitempty"`
	Default   *int32        `json:"default,omitempty"`
	Maximum   *int32        `json:"maximum,omitempty"`
	ScaleType *SKUScaleType `json:"scaleType,omitempty"`
}

type SKUCost struct {
	// REQUIRED
	MeterID      *string `json:"meterId,omitempty"`
	ExtendedUnit *string `json:"extendedUnit,omitempty"`
	Quantity     *int32  `json:"quantity,omitempty"`
}

type SKULocationInfo struct {
	// REQUIRED
	Location          *string              `json:"location,omitempty"`
	ExtendedLocations []*string            `json:"extendedLocations,omitempty"`
	Type              *SKULocationInfoType `json:"type,omitempty"`
	ZoneDetails       []*SKUZoneDetail     `json:"zoneDetails,omitempty"`
	Zones             []*string            `json:"zones,omitempty"`
}

type SKUResource struct {
	Properties *SKUResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type SKUResourceArrayResponseWithContinuation struct {
	// The URL to get to the next set of results, if there are any.
	NextLink *string        `json:"nextLink,omitempty"`
	Value    []*SKUResource `json:"value,omitempty"`
}

type SKUResourceProperties struct {
	// REQUIRED
	SKUSettings       []*SKUSetting      `json:"skuSettings,omitempty"`
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty"`
}

type SKUSetting struct {
	// REQUIRED
	Name             *string             `json:"name,omitempty"`
	Capabilities     []*SKUCapability    `json:"capabilities,omitempty"`
	Capacity         *SKUSettingCapacity `json:"capacity,omitempty"`
	Costs            []*SKUCost          `json:"costs,omitempty"`
	Family           *string             `json:"family,omitempty"`
	Kind             *string             `json:"kind,omitempty"`
	LocationInfo     []*SKULocationInfo  `json:"locationInfo,omitempty"`
	Locations        []*string           `json:"locations,omitempty"`
	RequiredFeatures []*string           `json:"requiredFeatures,omitempty"`
	RequiredQuotaIDs []*string           `json:"requiredQuotaIds,omitempty"`
	Size             *string             `json:"size,omitempty"`
	Tier             *string             `json:"tier,omitempty"`
}

type SKUSettingCapacity struct {
	// REQUIRED
	Minimum   *int32        `json:"minimum,omitempty"`
	Default   *int32        `json:"default,omitempty"`
	Maximum   *int32        `json:"maximum,omitempty"`
	ScaleType *SKUScaleType `json:"scaleType,omitempty"`
}

type SKUZoneDetail struct {
	Capabilities []*SKUCapability `json:"capabilities,omitempty"`
	Name         []*string        `json:"name,omitempty"`
}

// SKUsClientCreateOrUpdateNestedResourceTypeFirstOptions contains the optional parameters for the SKUsClient.CreateOrUpdateNestedResourceTypeFirst
// method.
type SKUsClientCreateOrUpdateNestedResourceTypeFirstOptions struct {
	// placeholder for future optional parameters
}

// SKUsClientCreateOrUpdateNestedResourceTypeSecondOptions contains the optional parameters for the SKUsClient.CreateOrUpdateNestedResourceTypeSecond
// method.
type SKUsClientCreateOrUpdateNestedResourceTypeSecondOptions struct {
	// placeholder for future optional parameters
}

// SKUsClientCreateOrUpdateNestedResourceTypeThirdOptions contains the optional parameters for the SKUsClient.CreateOrUpdateNestedResourceTypeThird
// method.
type SKUsClientCreateOrUpdateNestedResourceTypeThirdOptions struct {
	// placeholder for future optional parameters
}

// SKUsClientCreateOrUpdateOptions contains the optional parameters for the SKUsClient.CreateOrUpdate method.
type SKUsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SKUsClientDeleteNestedResourceTypeFirstOptions contains the optional parameters for the SKUsClient.DeleteNestedResourceTypeFirst
// method.
type SKUsClientDeleteNestedResourceTypeFirstOptions struct {
	// placeholder for future optional parameters
}

// SKUsClientDeleteNestedResourceTypeSecondOptions contains the optional parameters for the SKUsClient.DeleteNestedResourceTypeSecond
// method.
type SKUsClientDeleteNestedResourceTypeSecondOptions struct {
	// placeholder for future optional parameters
}

// SKUsClientDeleteNestedResourceTypeThirdOptions contains the optional parameters for the SKUsClient.DeleteNestedResourceTypeThird
// method.
type SKUsClientDeleteNestedResourceTypeThirdOptions struct {
	// placeholder for future optional parameters
}

// SKUsClientDeleteOptions contains the optional parameters for the SKUsClient.Delete method.
type SKUsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SKUsClientGetNestedResourceTypeFirstOptions contains the optional parameters for the SKUsClient.GetNestedResourceTypeFirst
// method.
type SKUsClientGetNestedResourceTypeFirstOptions struct {
	// placeholder for future optional parameters
}

// SKUsClientGetNestedResourceTypeSecondOptions contains the optional parameters for the SKUsClient.GetNestedResourceTypeSecond
// method.
type SKUsClientGetNestedResourceTypeSecondOptions struct {
	// placeholder for future optional parameters
}

// SKUsClientGetNestedResourceTypeThirdOptions contains the optional parameters for the SKUsClient.GetNestedResourceTypeThird
// method.
type SKUsClientGetNestedResourceTypeThirdOptions struct {
	// placeholder for future optional parameters
}

// SKUsClientGetOptions contains the optional parameters for the SKUsClient.Get method.
type SKUsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SKUsClientListByResourceTypeRegistrationsNestedResourceTypeFirstOptions contains the optional parameters for the SKUsClient.ListByResourceTypeRegistrationsNestedResourceTypeFirst
// method.
type SKUsClientListByResourceTypeRegistrationsNestedResourceTypeFirstOptions struct {
	// placeholder for future optional parameters
}

// SKUsClientListByResourceTypeRegistrationsNestedResourceTypeSecondOptions contains the optional parameters for the SKUsClient.ListByResourceTypeRegistrationsNestedResourceTypeSecond
// method.
type SKUsClientListByResourceTypeRegistrationsNestedResourceTypeSecondOptions struct {
	// placeholder for future optional parameters
}

// SKUsClientListByResourceTypeRegistrationsNestedResourceTypeThirdOptions contains the optional parameters for the SKUsClient.ListByResourceTypeRegistrationsNestedResourceTypeThird
// method.
type SKUsClientListByResourceTypeRegistrationsNestedResourceTypeThirdOptions struct {
	// placeholder for future optional parameters
}

// SKUsClientListByResourceTypeRegistrationsOptions contains the optional parameters for the SKUsClient.ListByResourceTypeRegistrations
// method.
type SKUsClientListByResourceTypeRegistrationsOptions struct {
	// placeholder for future optional parameters
}

type ServiceTreeInfo struct {
	ComponentID *string `json:"componentId,omitempty"`
	ServiceID   *string `json:"serviceId,omitempty"`
}

type SubscriptionLifecycleNotificationSpecifications struct {
	SoftDeleteTTL                    *string                            `json:"softDeleteTTL,omitempty"`
	SubscriptionStateOverrideActions []*SubscriptionStateOverrideAction `json:"subscriptionStateOverrideActions,omitempty"`
}

type SubscriptionStateOverrideAction struct {
	// REQUIRED
	Action *SubscriptionNotificationOperation `json:"action,omitempty"`

	// REQUIRED
	State *SubscriptionTransitioningState `json:"state,omitempty"`
}

type SubscriptionStateRule struct {
	AllowedActions []*string          `json:"allowedActions,omitempty"`
	State          *SubscriptionState `json:"state,omitempty"`
}

type SwaggerSpecification struct {
	APIVersions          []*string `json:"apiVersions,omitempty"`
	SwaggerSpecFolderURI *string   `json:"swaggerSpecFolderUri,omitempty"`
}

type TemplateDeploymentOptions struct {
	PreflightOptions   []*PreflightOption `json:"preflightOptions,omitempty"`
	PreflightSupported *bool              `json:"preflightSupported,omitempty"`
}

type TemplateDeploymentPolicy struct {
	// REQUIRED
	Capabilities *TemplateDeploymentCapabilities `json:"capabilities,omitempty"`

	// REQUIRED
	PreflightOptions *TemplateDeploymentPreflightOptions `json:"preflightOptions,omitempty"`
}

type ThirdPartyProviderAuthorization struct {
	Authorizations    []*LightHouseAuthorization `json:"authorizations,omitempty"`
	ManagedByTenantID *string                    `json:"managedByTenantId,omitempty"`
}

type ThrottlingMetric struct {
	// REQUIRED
	Limit *int64 `json:"limit,omitempty"`

	// REQUIRED
	Type     *ThrottlingMetricType `json:"type,omitempty"`
	Interval *string               `json:"interval,omitempty"`
}

type ThrottlingRule struct {
	// REQUIRED
	Action *string `json:"action,omitempty"`

	// REQUIRED
	Metrics          []*ThrottlingMetric `json:"metrics,omitempty"`
	RequiredFeatures []*string           `json:"requiredFeatures,omitempty"`
}

type TrafficRegionRolloutConfiguration struct {
	Regions      []*string `json:"regions,omitempty"`
	WaitDuration *string   `json:"waitDuration,omitempty"`
}

type TrafficRegions struct {
	Regions []*string `json:"regions,omitempty"`
}

type TypedErrorInfo struct {
	// REQUIRED
	Type *string `json:"type,omitempty"`

	// READ-ONLY; Anything
	Info interface{} `json:"info,omitempty" azure:"ro"`
}
