//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmobilenetwork

import "time"

// Ambr - Aggregate maximum bit rate.
type Ambr struct {
	// REQUIRED; Downlink bit rate.
	Downlink *string `json:"downlink,omitempty"`

	// REQUIRED; Uplink bit rate.
	Uplink *string `json:"uplink,omitempty"`
}

// Arp - Allocation and Retention Priority (ARP) parameters.
type Arp struct {
	// REQUIRED; ARP preemption capability.
	PreemptCap *PreemptionCapability `json:"preemptCap,omitempty"`

	// REQUIRED; ARP preemption vulnerability
	PreemptVuln *PreemptionVulnerability `json:"preemptVuln,omitempty"`

	// REQUIRED; ARP priority level.
	PriorityLevel *int32 `json:"priorityLevel,omitempty"`
}

// AttachedDataNetwork - Attached data network resource.
type AttachedDataNetwork struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; Data network properties.
	Properties *AttachedDataNetworkPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AttachedDataNetworkListResult - Response for attached data network API service call.
type AttachedDataNetworkListResult struct {
	// A list of data networks in a resource group.
	Value []*AttachedDataNetwork `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AttachedDataNetworkPropertiesFormat - Data network properties.
type AttachedDataNetworkPropertiesFormat struct {
	// REQUIRED; The user plane interface on the data network. For 5G networks, this is the N6 interface. For 4G networks, this
	// is the SGi interface.
	UserPlaneDataInterface *InterfaceProperties `json:"userPlaneDataInterface,omitempty"`

	// The DNS servers to signal to UEs to use for this attached data network.
	DNSAddresses []*string `json:"dnsAddresses,omitempty"`

	// The network address and port translation (NAPT) configuration. If this is not specified, the attached data network will
	// use a default NAPT configuration with NAPT enabled.
	NaptConfiguration *NaptConfiguration `json:"naptConfiguration,omitempty"`

	// The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will dynamically
	// assign IP addresses to UEs. The packet core instance assigns an IP
	// address to a UE when the UE sets up a PDU session. You must define at least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix.
	// If you define both, they must be of the same
	// size.
	UserEquipmentAddressPoolPrefix []*string `json:"userEquipmentAddressPoolPrefix,omitempty"`

	// The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will assign
	// static IP addresses to UEs. The packet core instance assigns an IP address
	// to a UE when the UE sets up a PDU session. The static IP address for a specific UE is set in StaticIPConfiguration on the
	// corresponding SIM resource. At least one of userEquipmentAddressPoolPrefix and
	// userEquipmentStaticAddressPoolPrefix must be defined. If both are defined, they must be of the same size.
	UserEquipmentStaticAddressPoolPrefix []*string `json:"userEquipmentStaticAddressPoolPrefix,omitempty"`

	// READ-ONLY; The provisioning state of the attached data network resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// AttachedDataNetworkResourceID - Reference to an attached data network resource.
type AttachedDataNetworkResourceID struct {
	// REQUIRED; Attached data network resource ID.
	ID *string `json:"id,omitempty"`
}

// AttachedDataNetworksClientBeginCreateOrUpdateOptions contains the optional parameters for the AttachedDataNetworksClient.BeginCreateOrUpdate
// method.
type AttachedDataNetworksClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AttachedDataNetworksClientBeginDeleteOptions contains the optional parameters for the AttachedDataNetworksClient.BeginDelete
// method.
type AttachedDataNetworksClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AttachedDataNetworksClientGetOptions contains the optional parameters for the AttachedDataNetworksClient.Get method.
type AttachedDataNetworksClientGetOptions struct {
	// placeholder for future optional parameters
}

// AttachedDataNetworksClientListByPacketCoreDataPlaneOptions contains the optional parameters for the AttachedDataNetworksClient.ListByPacketCoreDataPlane
// method.
type AttachedDataNetworksClientListByPacketCoreDataPlaneOptions struct {
	// placeholder for future optional parameters
}

// AttachedDataNetworksClientUpdateTagsOptions contains the optional parameters for the AttachedDataNetworksClient.UpdateTags
// method.
type AttachedDataNetworksClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// AzureStackEdgeDeviceResourceID - Reference to an Azure Arc custom location resource.
type AzureStackEdgeDeviceResourceID struct {
	// REQUIRED; Azure Stack Edge device resource ID.
	ID *string `json:"id,omitempty"`
}

// ConnectedClusterResourceID - Reference to an Azure Arc custom location resource.
type ConnectedClusterResourceID struct {
	// REQUIRED; Azure Arc connected cluster resource ID.
	ID *string `json:"id,omitempty"`
}

// CustomLocationResourceID - Reference to an Azure Arc custom location resource.
type CustomLocationResourceID struct {
	// REQUIRED; Azure Arc custom location resource ID.
	ID *string `json:"id,omitempty"`
}

// DataNetwork - Data network resource.
type DataNetwork struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Data network properties.
	Properties *DataNetworkPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DataNetworkConfiguration - Settings controlling data network use
type DataNetworkConfiguration struct {
	// REQUIRED; List of services that can be used as part of this SIM policy. The list must not contain duplicate items and must
	// contain at least one item.
	AllowedServices []*ServiceResourceID `json:"allowedServices,omitempty"`

	// REQUIRED; A reference to the data network that these settings apply to
	DataNetwork *DataNetworkResourceID `json:"dataNetwork,omitempty"`

	// REQUIRED; Aggregate maximum bit rate across all non-GBR QoS flows of a given PDU session. See 3GPP TS23.501 section 5.7.2.6
	// for a full description of the Session-AMBR.
	SessionAmbr *Ambr `json:"sessionAmbr,omitempty"`

	// Allowed session types in addition to the default session type. Must not duplicate the default session type.
	AdditionalAllowedSessionTypes []*PduSessionType `json:"additionalAllowedSessionTypes,omitempty"`

	// Default QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority,
	// if the settings of preemptionCapability and preemptionVulnerability allow
	// it. 1 is the highest level of priority. If this field is not specified then 5qi is used to derive the ARP value. See 3GPP
	// TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
	AllocationAndRetentionPriorityLevel *int32 `json:"allocationAndRetentionPriorityLevel,omitempty"`

	// The default PDU session type, which is used if the UE does not request a specific session type.
	DefaultSessionType *PduSessionType `json:"defaultSessionType,omitempty"`

	// Default QoS Flow 5G QoS Indicator value. The 5QI identifies a specific QoS forwarding treatment to be provided to a flow.
	// This must not be a standardized 5QI value corresponding to a GBR (guaranteed
	// bit rate) QoS Flow. The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66, 67, 71, 72, 73, 74, 75, 76, 82, 83, 84, and 85.
	// See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5QI parameter,
	// and table 5.7.4-1 for the definition of which are the GBR 5QI values.
	FiveQi *int32 `json:"5qi,omitempty"`

	// Default QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another
	// QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a
	// full description of the ARP parameters.
	PreemptionCapability *PreemptionCapability `json:"preemptionCapability,omitempty"`

	// Default QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted
	// by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2
	// for a full description of the ARP parameters.
	PreemptionVulnerability *PreemptionVulnerability `json:"preemptionVulnerability,omitempty"`
}

// DataNetworkListResult - Response for data network API service call.
type DataNetworkListResult struct {
	// A list of data networks.
	Value []*DataNetwork `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DataNetworkPropertiesFormat - Data network properties.
type DataNetworkPropertiesFormat struct {
	// An optional description for this data network.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; The provisioning state of the data network resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// DataNetworkResourceID - Reference to a data network resource.
type DataNetworkResourceID struct {
	// REQUIRED; Data network resource ID.
	ID *string `json:"id,omitempty"`
}

// DataNetworksClientBeginCreateOrUpdateOptions contains the optional parameters for the DataNetworksClient.BeginCreateOrUpdate
// method.
type DataNetworksClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DataNetworksClientBeginDeleteOptions contains the optional parameters for the DataNetworksClient.BeginDelete method.
type DataNetworksClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DataNetworksClientGetOptions contains the optional parameters for the DataNetworksClient.Get method.
type DataNetworksClientGetOptions struct {
	// placeholder for future optional parameters
}

// DataNetworksClientListByMobileNetworkOptions contains the optional parameters for the DataNetworksClient.ListByMobileNetwork
// method.
type DataNetworksClientListByMobileNetworkOptions struct {
	// placeholder for future optional parameters
}

// DataNetworksClientUpdateTagsOptions contains the optional parameters for the DataNetworksClient.UpdateTags method.
type DataNetworksClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// InterfaceProperties - Interface properties
type InterfaceProperties struct {
	// The IPv4 address.
	IPv4Address *string `json:"ipv4Address,omitempty"`

	// The default IPv4 gateway (router).
	IPv4Gateway *string `json:"ipv4Gateway,omitempty"`

	// The IPv4 subnet.
	IPv4Subnet *string `json:"ipv4Subnet,omitempty"`

	// The logical name for this interface. This should match one of the interfaces configured on your Azure Stack Edge device.
	Name *string `json:"name,omitempty"`
}

// KeyVaultCertificate - An Azure key vault certificate.
type KeyVaultCertificate struct {
	// The certificate URL, unversioned. For example: https://contosovault.vault.azure.net/certificates/ingress.
	CertificateURL *string `json:"certificateUrl,omitempty"`
}

// KeyVaultKey - An Azure key vault key.
type KeyVaultKey struct {
	// The key URL, unversioned. For example: https://contosovault.vault.azure.net/keys/azureKey.
	KeyURL *string `json:"keyUrl,omitempty"`
}

// ListResult - Response for mobile networks API service call.
type ListResult struct {
	// A list of mobile networks in a resource group.
	Value []*MobileNetwork `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// LocalDiagnosticsAccessConfiguration - The kubernetes ingress configuration to control access to packet core diagnostics
// over local APIs.
type LocalDiagnosticsAccessConfiguration struct {
	// The HTTPS server TLS certificate used to secure local access to diagnostics.
	HTTPSServerCertificate *KeyVaultCertificate `json:"httpsServerCertificate,omitempty"`
}

// ManagedServiceIdentity - Managed service identity (system assigned and/or user assigned identities)
type ManagedServiceIdentity struct {
	// REQUIRED; Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
	Type *ManagedServiceIdentityType `json:"type,omitempty"`

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// MobileNetwork - Mobile network resource.
type MobileNetwork struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; Mobile network properties.
	Properties *PropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MobileNetworksClientBeginCreateOrUpdateOptions contains the optional parameters for the MobileNetworksClient.BeginCreateOrUpdate
// method.
type MobileNetworksClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MobileNetworksClientBeginDeleteOptions contains the optional parameters for the MobileNetworksClient.BeginDelete method.
type MobileNetworksClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MobileNetworksClientBeginListSimIDsOptions contains the optional parameters for the MobileNetworksClient.BeginListSimIDs
// method.
type MobileNetworksClientBeginListSimIDsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MobileNetworksClientGetOptions contains the optional parameters for the MobileNetworksClient.Get method.
type MobileNetworksClientGetOptions struct {
	// placeholder for future optional parameters
}

// MobileNetworksClientListByResourceGroupOptions contains the optional parameters for the MobileNetworksClient.ListByResourceGroup
// method.
type MobileNetworksClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// MobileNetworksClientListBySubscriptionOptions contains the optional parameters for the MobileNetworksClient.ListBySubscription
// method.
type MobileNetworksClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// MobileNetworksClientUpdateTagsOptions contains the optional parameters for the MobileNetworksClient.UpdateTags method.
type MobileNetworksClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// NaptConfiguration - The network address and port translation settings to use for the attached data network.
type NaptConfiguration struct {
	// Whether NAPT is enabled for connections to this attached data network.
	Enabled *NaptEnabled `json:"enabled,omitempty"`

	// Maximum number of UDP and TCP pinholes that can be open simultaneously on the core interface. For 5G networks, this is
	// the N6 interface. For 4G networks, this is the SGi interface.
	PinholeLimits *int32 `json:"pinholeLimits,omitempty"`

	// Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.
	PinholeTimeouts *PinholeTimeouts `json:"pinholeTimeouts,omitempty"`

	// Range of port numbers to use as translated ports on each translated address. If not specified and NAPT is enabled, this
	// range defaults to 1,024 - 49,999. (Ports under 1,024 should not be used because
	// these are special purpose ports reserved by IANA. Ports 50,000 and above are reserved for non-NAPT use.)
	PortRange *PortRange `json:"portRange,omitempty"`

	// The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be recycled for use by
	// another pinhole. All hold times must be minimum 1 second.
	PortReuseHoldTime *PortReuseHoldTimes `json:"portReuseHoldTime,omitempty"`
}

// Operation - Object that describes a single Microsoft.MobileNetwork operation.
type Operation struct {
	// Indicates whether the operation applies to data-plane.
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// READ-ONLY; The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty" azure:"ro"`

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty" azure:"ro"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Description of the operation.
	Description *string `json:"description,omitempty"`

	// Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft.MobileNetwork
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed: Registration definition, registration assignment etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationList - List of the operations.
type OperationList struct {
	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of Microsoft.MobileNetwork operations.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PacketCoreControlPlane - Packet core control plane resource.
type PacketCoreControlPlane struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; Packet core control plane Properties.
	Properties *PacketCoreControlPlanePropertiesFormat `json:"properties,omitempty"`

	// The identity used to retrieve the ingress certificate from Azure key vault.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PacketCoreControlPlaneListResult - Response for packet core control planes API service call.
type PacketCoreControlPlaneListResult struct {
	// A list of packet core control planes in a resource group.
	Value []*PacketCoreControlPlane `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PacketCoreControlPlanePropertiesFormat - Packet core control plane properties.
type PacketCoreControlPlanePropertiesFormat struct {
	// REQUIRED; The control plane interface on the access network. For 5G networks, this is the N2 interface. For 4G networks,
	// this is the S1-MME interface.
	ControlPlaneAccessInterface *InterfaceProperties `json:"controlPlaneAccessInterface,omitempty"`

	// REQUIRED; Mobile network in which this packet core control plane is deployed.
	MobileNetwork *ResourceID `json:"mobileNetwork,omitempty"`

	// REQUIRED; The SKU defining the throughput and SIM allowances for this packet core control plane deployment.
	SKU *BillingSKU `json:"sku,omitempty"`

	// The core network technology generation (5G core or EPC / 4G core).
	CoreNetworkTechnology *CoreNetworkType `json:"coreNetworkTechnology,omitempty"`

	// Settings to allow interoperability with third party components e.g. RANs and UEs.
	InteropSettings interface{} `json:"interopSettings,omitempty"`

	// The kubernetes ingress configuration to control access to packet core diagnostics over local APIs.
	LocalDiagnosticsAccess *LocalDiagnosticsAccessConfiguration `json:"localDiagnosticsAccess,omitempty"`

	// The platform where the packet core is deployed.
	Platform *PlatformConfiguration `json:"platform,omitempty"`

	// The version of the packet core software that is deployed.
	Version *string `json:"version,omitempty"`

	// READ-ONLY; The provisioning state of the packet core control plane resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PacketCoreControlPlaneVersion - Packet core control plane version resource.
type PacketCoreControlPlaneVersion struct {
	// REQUIRED; Packet core control plane version properties.
	Properties *PacketCoreControlPlaneVersionPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PacketCoreControlPlaneVersionListResult - Response for packet core control plane version API service call.
type PacketCoreControlPlaneVersionListResult struct {
	// A list of supported packet core control plane versions.
	Value []*PacketCoreControlPlaneVersion `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PacketCoreControlPlaneVersionPropertiesFormat - Packet core control plane version properties.
type PacketCoreControlPlaneVersionPropertiesFormat struct {
	// Indicates whether this is the recommended version to use for new packet core control plane deployments.
	RecommendedVersion *RecommendedVersion `json:"recommendedVersion,omitempty"`

	// The state of this packet core control plane version.
	VersionState *VersionState `json:"versionState,omitempty"`

	// READ-ONLY; The provisioning state of the packet core control plane version resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PacketCoreControlPlaneVersionsClientGetOptions contains the optional parameters for the PacketCoreControlPlaneVersionsClient.Get
// method.
type PacketCoreControlPlaneVersionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PacketCoreControlPlaneVersionsClientListByResourceGroupOptions contains the optional parameters for the PacketCoreControlPlaneVersionsClient.ListByResourceGroup
// method.
type PacketCoreControlPlaneVersionsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PacketCoreControlPlanesClientBeginCreateOrUpdateOptions contains the optional parameters for the PacketCoreControlPlanesClient.BeginCreateOrUpdate
// method.
type PacketCoreControlPlanesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PacketCoreControlPlanesClientBeginDeleteOptions contains the optional parameters for the PacketCoreControlPlanesClient.BeginDelete
// method.
type PacketCoreControlPlanesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PacketCoreControlPlanesClientGetOptions contains the optional parameters for the PacketCoreControlPlanesClient.Get method.
type PacketCoreControlPlanesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PacketCoreControlPlanesClientListByResourceGroupOptions contains the optional parameters for the PacketCoreControlPlanesClient.ListByResourceGroup
// method.
type PacketCoreControlPlanesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PacketCoreControlPlanesClientListBySubscriptionOptions contains the optional parameters for the PacketCoreControlPlanesClient.ListBySubscription
// method.
type PacketCoreControlPlanesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// PacketCoreControlPlanesClientUpdateTagsOptions contains the optional parameters for the PacketCoreControlPlanesClient.UpdateTags
// method.
type PacketCoreControlPlanesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// PacketCoreDataPlane - Packet core data plane resource.
type PacketCoreDataPlane struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; Packet core data plane Properties.
	Properties *PacketCoreDataPlanePropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PacketCoreDataPlaneListResult - Response for packet core data planes API service call.
type PacketCoreDataPlaneListResult struct {
	// A list of packet core data planes in a resource group.
	Value []*PacketCoreDataPlane `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PacketCoreDataPlanePropertiesFormat - Packet core data plane properties.
type PacketCoreDataPlanePropertiesFormat struct {
	// REQUIRED; The user plane interface on the access network. For 5G networks, this is the N3 interface. For 4G networks, this
	// is the S1-U interface.
	UserPlaneAccessInterface *InterfaceProperties `json:"userPlaneAccessInterface,omitempty"`

	// READ-ONLY; The provisioning state of the packet core data plane resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PacketCoreDataPlanesClientBeginCreateOrUpdateOptions contains the optional parameters for the PacketCoreDataPlanesClient.BeginCreateOrUpdate
// method.
type PacketCoreDataPlanesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PacketCoreDataPlanesClientBeginDeleteOptions contains the optional parameters for the PacketCoreDataPlanesClient.BeginDelete
// method.
type PacketCoreDataPlanesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PacketCoreDataPlanesClientGetOptions contains the optional parameters for the PacketCoreDataPlanesClient.Get method.
type PacketCoreDataPlanesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PacketCoreDataPlanesClientListByPacketCoreControlPlaneOptions contains the optional parameters for the PacketCoreDataPlanesClient.ListByPacketCoreControlPlane
// method.
type PacketCoreDataPlanesClientListByPacketCoreControlPlaneOptions struct {
	// placeholder for future optional parameters
}

// PacketCoreDataPlanesClientUpdateTagsOptions contains the optional parameters for the PacketCoreDataPlanesClient.UpdateTags
// method.
type PacketCoreDataPlanesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// PccRuleConfiguration - Data flow policy rule configuration
type PccRuleConfiguration struct {
	// REQUIRED; The name of the rule. This must be unique within the parent service. You must not use any of the following reserved
	// strings - default, requested or service.
	RuleName *string `json:"ruleName,omitempty"`

	// REQUIRED; A precedence value that is used to decide between data flow policy rules when identifying the QoS values to use
	// for a particular SIM. A lower value means a higher priority. This value should be unique
	// among all data flow policy rules configured in the mobile network.
	RulePrecedence *int32 `json:"rulePrecedence,omitempty"`

	// REQUIRED; The set of data flow templates to use for this data flow policy rule.
	ServiceDataFlowTemplates []*ServiceDataFlowTemplate `json:"serviceDataFlowTemplates,omitempty"`

	// The QoS policy to use for packets matching this rule. If this field is null then the parent service will define the QoS
	// settings.
	RuleQosPolicy *PccRuleQosPolicy `json:"ruleQosPolicy,omitempty"`

	// Determines whether flows that match this data flow policy rule are permitted.
	TrafficControl *TrafficControlPermission `json:"trafficControl,omitempty"`
}

// PccRuleQosPolicy - Data flow policy rule QoS policy
type PccRuleQosPolicy struct {
	// REQUIRED; The maximum bit rate (MBR) for all service data flows that use this data flow policy rule or service.
	MaximumBitRate *Ambr `json:"maximumBitRate,omitempty"`

	// QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if
	// the settings of preemptionCapability and preemptionVulnerability allow it. 1 is
	// the highest level of priority. If this field is not specified then 5qi is used to derive the ARP value. See 3GPP TS23.501
	// section 5.7.2.2 for a full description of the ARP parameters.
	AllocationAndRetentionPriorityLevel *int32 `json:"allocationAndRetentionPriorityLevel,omitempty"`

	// QoS Flow 5G QoS Indicator value. The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. This
	// must not be a standardized 5QI value corresponding to a GBR (guaranteed bit rate)
	// QoS Flow. The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66, 67, 71, 72, 73, 74, 75, 76, 82, 83, 84, and 85. See 3GPP
	// TS23.501 section 5.7.2.1 for a full description of the 5QI parameter, and table
	// 5.7.4-1 for the definition of which are the GBR 5QI values.
	FiveQi *int32 `json:"5qi,omitempty"`

	// The guaranteed bit rate (GBR) for all service data flows that use this data flow policy rule. This is an optional setting.
	// If you do not provide a value, there will be no GBR set for the data flow
	// policy rule that uses this QoS definition.
	GuaranteedBitRate *Ambr `json:"guaranteedBitRate,omitempty"`

	// QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow
	// with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full
	// description of the ARP parameters.
	PreemptionCapability *PreemptionCapability `json:"preemptionCapability,omitempty"`

	// QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a
	// QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a
	// full description of the ARP parameters.
	PreemptionVulnerability *PreemptionVulnerability `json:"preemptionVulnerability,omitempty"`
}

// PinholeTimeouts - Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.
type PinholeTimeouts struct {
	// Pinhole timeout for ICMP pinholes in seconds. Default for ICMP Echo is 60 seconds, as per RFC 5508 section 3.2.
	Icmp *int32 `json:"icmp,omitempty"`

	// Pinhole timeout for TCP pinholes in seconds. Default for TCP is 2 hours 4 minutes, as per RFC 5382 section 5.
	TCP *int32 `json:"tcp,omitempty"`

	// Pinhole timeout for UDP pinholes in seconds. Default for UDP is 5 minutes, as per RFC 4787 section 4.3.
	UDP *int32 `json:"udp,omitempty"`
}

// PlatformConfiguration - The platform where the packet core is deployed.
type PlatformConfiguration struct {
	// REQUIRED; The platform type where packet core is deployed.
	Type *PlatformType `json:"type,omitempty"`

	// The Azure Stack Edge device where where the packet core is deployed. If the device is part of a fault tolerant pair, either
	// device in the pair can be specified.
	AzureStackEdgeDevice *AzureStackEdgeDeviceResourceID `json:"azureStackEdgeDevice,omitempty"`

	// Azure Arc connected cluster where the packet core is deployed.
	ConnectedCluster *ConnectedClusterResourceID `json:"connectedCluster,omitempty"`

	// Azure Arc custom location where the packet core is deployed.
	CustomLocation *CustomLocationResourceID `json:"customLocation,omitempty"`
}

// PlmnID - Public land mobile network (PLMN) ID.
type PlmnID struct {
	// REQUIRED; Mobile country code (MCC).
	Mcc *string `json:"mcc,omitempty"`

	// REQUIRED; Mobile network code (MNC).
	Mnc *string `json:"mnc,omitempty"`
}

// PortRange - Range of port numbers to use as translated ports on each translated address. If not specified and NAPT is enabled,
// this range defaults to 1,024 - 49,999. (Ports under 1,024 should not be used because
// these are special purpose ports reserved by IANA. Ports 50,000 and above are reserved for non-NAPT use.)
type PortRange struct {
	// The maximum port number
	MaxPort *int32 `json:"maxPort,omitempty"`

	// The minimum port number
	MinPort *int32 `json:"minPort,omitempty"`
}

// PortReuseHoldTimes - The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be
// recycled for use by another pinhole. All hold times must be minimum 1 second.
type PortReuseHoldTimes struct {
	// Minimum time in seconds that will pass before a TCP port that was used by a closed pinhole can be reused. Default for TCP
	// is 2 minutes.
	TCP *int32 `json:"tcp,omitempty"`

	// Minimum time in seconds that will pass before a UDP port that was used by a closed pinhole can be reused. Default for UDP
	// is 1 minute.
	UDP *int32 `json:"udp,omitempty"`
}

// PropertiesFormat - Mobile network properties.
type PropertiesFormat struct {
	// REQUIRED; The unique public land mobile network identifier for the network. This is made up of the mobile country code
	// and mobile network code, as defined in https://www.itu.int/rec/T-REC-E.212. The values
	// 001-01 and 001-001 can be used for testing and the values 999-99 and 999-999 can be used on internal private networks.
	PublicLandMobileNetworkIdentifier *PlmnID `json:"publicLandMobileNetworkIdentifier,omitempty"`

	// READ-ONLY; The provisioning state of the mobile network resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The mobile network resource identifier
	ServiceKey *string `json:"serviceKey,omitempty" azure:"ro"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// QosPolicy - QoS policy
type QosPolicy struct {
	// REQUIRED; The maximum bit rate (MBR) for all service data flows that use this data flow policy rule or service.
	MaximumBitRate *Ambr `json:"maximumBitRate,omitempty"`

	// QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if
	// the settings of preemptionCapability and preemptionVulnerability allow it. 1 is
	// the highest level of priority. If this field is not specified then 5qi is used to derive the ARP value. See 3GPP TS23.501
	// section 5.7.2.2 for a full description of the ARP parameters.
	AllocationAndRetentionPriorityLevel *int32 `json:"allocationAndRetentionPriorityLevel,omitempty"`

	// QoS Flow 5G QoS Indicator value. The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. This
	// must not be a standardized 5QI value corresponding to a GBR (guaranteed bit rate)
	// QoS Flow. The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66, 67, 71, 72, 73, 74, 75, 76, 82, 83, 84, and 85. See 3GPP
	// TS23.501 section 5.7.2.1 for a full description of the 5QI parameter, and table
	// 5.7.4-1 for the definition of which are the GBR 5QI values.
	FiveQi *int32 `json:"5qi,omitempty"`

	// QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow
	// with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full
	// description of the ARP parameters.
	PreemptionCapability *PreemptionCapability `json:"preemptionCapability,omitempty"`

	// QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a
	// QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a
	// full description of the ARP parameters.
	PreemptionVulnerability *PreemptionVulnerability `json:"preemptionVulnerability,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceID - Reference to a mobile network resource.
type ResourceID struct {
	// REQUIRED; Mobile network resource ID.
	ID *string `json:"id,omitempty"`
}

// Service resource.
type Service struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; Service Properties.
	Properties *ServicePropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceDataFlowTemplate - Data flow template
type ServiceDataFlowTemplate struct {
	// REQUIRED; The direction of this flow.
	Direction *SdfDirection `json:"direction,omitempty"`

	// REQUIRED; A list of the allowed protocol(s) for this flow. If you want this flow to be able to use any protocol within
	// the internet protocol suite, use the value ip. If you only want to allow a selection of
	// protocols, you must use the corresponding IANA Assigned Internet Protocol Number for each protocol, as described in https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml.
	// For
	// example, for UDP, you must use 17. If you use the value ip then you must leave the field port unspecified.
	Protocol []*string `json:"protocol,omitempty"`

	// REQUIRED; The remote IP address(es) to which UEs will connect for this flow. If you want to allow connections on any IP
	// address, use the value any. Otherwise, you must provide each of the remote IP addresses to
	// which the packet core instance will connect for this flow. You must provide each IP address in CIDR notation, including
	// the netmask (for example, 192.0.2.54/24).
	RemoteIPList []*string `json:"remoteIpList,omitempty"`

	// REQUIRED; The name of the data flow template. This must be unique within the parent data flow policy rule. You must not
	// use any of the following reserved strings - default, requested or service.
	TemplateName *string `json:"templateName,omitempty"`

	// The port(s) to which UEs will connect for this flow. You can specify zero or more ports or port ranges. If you specify
	// one or more ports or port ranges then you must specify a value other than ip in
	// the protocol field. This is an optional setting. If you do not specify it then connections will be allowed on all ports.
	// Port ranges must be specified as -. For example: [8080, 8082-8085].
	Ports []*string `json:"ports,omitempty"`
}

// ServiceListResult - Response for services API service call.
type ServiceListResult struct {
	// A list of services.
	Value []*Service `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ServicePropertiesFormat - Service properties.
type ServicePropertiesFormat struct {
	// REQUIRED; The set of data flow policy rules that make up this service.
	PccRules []*PccRuleConfiguration `json:"pccRules,omitempty"`

	// REQUIRED; A precedence value that is used to decide between services when identifying the QoS values to use for a particular
	// SIM. A lower value means a higher priority. This value should be unique among all
	// services configured in the mobile network.
	ServicePrecedence *int32 `json:"servicePrecedence,omitempty"`

	// The QoS policy to use for packets matching this service. This can be overridden for particular flows using the ruleQosPolicy
	// field in a PccRuleConfiguration. If this field is null then the UE's SIM
	// policy will define the QoS settings.
	ServiceQosPolicy *QosPolicy `json:"serviceQosPolicy,omitempty"`

	// READ-ONLY; The provisioning state of the service resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ServiceResourceID - Reference to a service resource.
type ServiceResourceID struct {
	// REQUIRED; Service resource ID.
	ID *string `json:"id,omitempty"`
}

// ServicesClientBeginCreateOrUpdateOptions contains the optional parameters for the ServicesClient.BeginCreateOrUpdate method.
type ServicesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientBeginDeleteOptions contains the optional parameters for the ServicesClient.BeginDelete method.
type ServicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientGetOptions contains the optional parameters for the ServicesClient.Get method.
type ServicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientListByMobileNetworkOptions contains the optional parameters for the ServicesClient.ListByMobileNetwork method.
type ServicesClientListByMobileNetworkOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientUpdateTagsOptions contains the optional parameters for the ServicesClient.UpdateTags method.
type ServicesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// Sim - SIM resource.
type Sim struct {
	// REQUIRED; SIM Properties.
	Properties *SimPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SimGroup - SIM group resource.
type SimGroup struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; SIM group Properties.
	Properties *SimGroupPropertiesFormat `json:"properties,omitempty"`

	// The identity used to retrieve the encryption key from Azure key vault.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SimGroupListResult - Response for list SIM groups API service call.
type SimGroupListResult struct {
	// A list of SIM groups in a resource group.
	Value []*SimGroup `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SimGroupPropertiesFormat - SIM group properties.
type SimGroupPropertiesFormat struct {
	// A key to encrypt the SIM data that belongs to this SIM group.
	EncryptionKey *KeyVaultKey `json:"encryptionKey,omitempty"`

	// Mobile network that this SIM belongs to
	MobileNetwork *ResourceID `json:"mobileNetwork,omitempty"`

	// READ-ONLY; The provisioning state of the SIM group resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// SimGroupResourceID - Reference to a SIM group resource.
type SimGroupResourceID struct {
	// REQUIRED; SIM group resource ID.
	ID *string `json:"id,omitempty"`
}

// SimGroupsClientBeginCreateOrUpdateOptions contains the optional parameters for the SimGroupsClient.BeginCreateOrUpdate
// method.
type SimGroupsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SimGroupsClientBeginDeleteOptions contains the optional parameters for the SimGroupsClient.BeginDelete method.
type SimGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SimGroupsClientGetOptions contains the optional parameters for the SimGroupsClient.Get method.
type SimGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SimGroupsClientListByResourceGroupOptions contains the optional parameters for the SimGroupsClient.ListByResourceGroup
// method.
type SimGroupsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// SimGroupsClientListBySubscriptionOptions contains the optional parameters for the SimGroupsClient.ListBySubscription method.
type SimGroupsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// SimGroupsClientUpdateTagsOptions contains the optional parameters for the SimGroupsClient.UpdateTags method.
type SimGroupsClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// SimIDListResult - Response for list SIM IDs API service call.
type SimIDListResult struct {
	// A list of SIM IDs.
	Value []*SubResource `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SimListResult - Response for list SIMs API service call.
type SimListResult struct {
	// A list of SIMs in a resource group.
	Value []*Sim `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SimPoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the SimPoliciesClient.BeginCreateOrUpdate
// method.
type SimPoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SimPoliciesClientBeginDeleteOptions contains the optional parameters for the SimPoliciesClient.BeginDelete method.
type SimPoliciesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SimPoliciesClientGetOptions contains the optional parameters for the SimPoliciesClient.Get method.
type SimPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SimPoliciesClientListByMobileNetworkOptions contains the optional parameters for the SimPoliciesClient.ListByMobileNetwork
// method.
type SimPoliciesClientListByMobileNetworkOptions struct {
	// placeholder for future optional parameters
}

// SimPoliciesClientUpdateTagsOptions contains the optional parameters for the SimPoliciesClient.UpdateTags method.
type SimPoliciesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// SimPolicy - SIM policy resource.
type SimPolicy struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; SIM policy Properties.
	Properties *SimPolicyPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SimPolicyListResult - Response for SIM policies API service call.
type SimPolicyListResult struct {
	// A list of SIM policies.
	Value []*SimPolicy `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SimPolicyPropertiesFormat - SIM policy properties.
type SimPolicyPropertiesFormat struct {
	// REQUIRED; The default slice to use if the UE does not explicitly specify it. This slice must exist in the sliceConfigurations
	// map.
	DefaultSlice *SliceResourceID `json:"defaultSlice,omitempty"`

	// REQUIRED; The allowed slices and the settings to use for them. The list must not contain duplicate items and must contain
	// at least one item.
	SliceConfigurations []*SliceConfiguration `json:"sliceConfigurations,omitempty"`

	// REQUIRED; Aggregate maximum bit rate across all non-GBR QoS flows of all PDU sessions of a given UE. See 3GPP TS23.501
	// section 5.7.2.6 for a full description of the UE-AMBR.
	UeAmbr *Ambr `json:"ueAmbr,omitempty"`

	// Interval for the UE periodic registration update procedure, in seconds.
	RegistrationTimer *int32 `json:"registrationTimer,omitempty"`

	// RAT/Frequency Selection Priority Index, defined in 3GPP TS 36.413. This is an optional setting and by default is unspecified.
	RfspIndex *int32 `json:"rfspIndex,omitempty"`

	// READ-ONLY; The provisioning state of the SIM policy resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// SimPolicyResourceID - Reference to a SIM policy resource.
type SimPolicyResourceID struct {
	// REQUIRED; SIM policy resource ID.
	ID *string `json:"id,omitempty"`
}

// SimPropertiesFormat - SIM properties.
type SimPropertiesFormat struct {
	// REQUIRED; The international mobile subscriber identity (IMSI) for the SIM.
	InternationalMobileSubscriberIdentity *string `json:"internationalMobileSubscriberIdentity,omitempty"`

	// The Ki value for the SIM.
	AuthenticationKey *string `json:"authenticationKey,omitempty"`

	// An optional free-form text field that can be used to record the device type this SIM is associated with, for example 'Video
	// camera'. The Azure portal allows SIMs to be grouped and filtered based on
	// this value.
	DeviceType *string `json:"deviceType,omitempty"`

	// The integrated circuit card ID (ICCID) for the SIM.
	IntegratedCircuitCardIdentifier *string `json:"integratedCircuitCardIdentifier,omitempty"`

	// The Opc value for the SIM.
	OperatorKeyCode *string `json:"operatorKeyCode,omitempty"`

	// The SIM policy used by this SIM.
	SimPolicy *SimPolicyResourceID `json:"simPolicy,omitempty"`

	// A list of static IP addresses assigned to this SIM. Each address is assigned at a defined network scope, made up of {attached
	// data network, slice}.
	StaticIPConfiguration []*SimStaticIPProperties `json:"staticIpConfiguration,omitempty"`

	// READ-ONLY; The provisioning state of the SIM resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The state of the SIM resource.
	SimState *SimState `json:"simState,omitempty" azure:"ro"`
}

// SimStaticIPProperties - Static IP configuration for a SIM, scoped to a particular attached data network and slice.
type SimStaticIPProperties struct {
	// The attached data network on which the static IP address will be used. The combination of attached data network and slice
	// defines the network scope of the IP address.
	AttachedDataNetwork *AttachedDataNetworkResourceID `json:"attachedDataNetwork,omitempty"`

	// The network slice on which the static IP address will be used. The combination of attached data network and slice defines
	// the network scope of the IP address.
	Slice *SliceResourceID `json:"slice,omitempty"`

	// The static IP configuration for the SIM to use at the defined network scope.
	StaticIP *SimStaticIPPropertiesStaticIP `json:"staticIp,omitempty"`
}

// SimStaticIPPropertiesStaticIP - The static IP configuration for the SIM to use at the defined network scope.
type SimStaticIPPropertiesStaticIP struct {
	// The IPv4 address assigned to the SIM at this network scope. This address must be in the userEquipmentStaticAddressPoolPrefix
	// defined in the attached data network.
	IPv4Address *string `json:"ipv4Address,omitempty"`
}

// SimsClientBeginCreateOrUpdateOptions contains the optional parameters for the SimsClient.BeginCreateOrUpdate method.
type SimsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SimsClientBeginDeleteOptions contains the optional parameters for the SimsClient.BeginDelete method.
type SimsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SimsClientGetOptions contains the optional parameters for the SimsClient.Get method.
type SimsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SimsClientListBySimGroupOptions contains the optional parameters for the SimsClient.ListBySimGroup method.
type SimsClientListBySimGroupOptions struct {
	// placeholder for future optional parameters
}

// Site resource.
type Site struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Site properties.
	Properties *SitePropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SiteListResult - Response for sites API service call.
type SiteListResult struct {
	// A list of sites in a mobile network.
	Value []*Site `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SitePropertiesFormat - Site properties.
type SitePropertiesFormat struct {
	// An array of IDs of the network functions deployed on the site, maintained by the user.
	NetworkFunctions []*SubResource `json:"networkFunctions,omitempty"`

	// READ-ONLY; The provisioning state of the site resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// SitesClientBeginCreateOrUpdateOptions contains the optional parameters for the SitesClient.BeginCreateOrUpdate method.
type SitesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SitesClientBeginDeleteOptions contains the optional parameters for the SitesClient.BeginDelete method.
type SitesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SitesClientGetOptions contains the optional parameters for the SitesClient.Get method.
type SitesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SitesClientListByMobileNetworkOptions contains the optional parameters for the SitesClient.ListByMobileNetwork method.
type SitesClientListByMobileNetworkOptions struct {
	// placeholder for future optional parameters
}

// SitesClientUpdateTagsOptions contains the optional parameters for the SitesClient.UpdateTags method.
type SitesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// Slice - Network slice resource.
type Slice struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; Slice properties.
	Properties *SlicePropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SliceConfiguration - Per-slice settings
type SliceConfiguration struct {
	// REQUIRED; The allowed data networks and the settings to use for them. The list must not contain duplicate items and must
	// contain at least one item.
	DataNetworkConfigurations []*DataNetworkConfiguration `json:"dataNetworkConfigurations,omitempty"`

	// REQUIRED; The default data network to use if the UE does not explicitly specify it. Configuration for this object must
	// exist in the dataNetworkConfigurations map.
	DefaultDataNetwork *DataNetworkResourceID `json:"defaultDataNetwork,omitempty"`

	// REQUIRED; A reference to the slice that these settings apply to
	Slice *SliceResourceID `json:"slice,omitempty"`
}

// SliceListResult - Response for network slice API service call.
type SliceListResult struct {
	// A list of network slices in a mobile network.
	Value []*Slice `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SlicePropertiesFormat - Network slice properties.
type SlicePropertiesFormat struct {
	// REQUIRED; Single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
	Snssai *Snssai `json:"snssai,omitempty"`

	// An optional description for this network slice.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; The provisioning state of the network slice resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// SliceResourceID - Reference to a slice resource.
type SliceResourceID struct {
	// REQUIRED; Slice resource ID.
	ID *string `json:"id,omitempty"`
}

// SlicesClientBeginCreateOrUpdateOptions contains the optional parameters for the SlicesClient.BeginCreateOrUpdate method.
type SlicesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SlicesClientBeginDeleteOptions contains the optional parameters for the SlicesClient.BeginDelete method.
type SlicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SlicesClientGetOptions contains the optional parameters for the SlicesClient.Get method.
type SlicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SlicesClientListByMobileNetworkOptions contains the optional parameters for the SlicesClient.ListByMobileNetwork method.
type SlicesClientListByMobileNetworkOptions struct {
	// placeholder for future optional parameters
}

// SlicesClientUpdateTagsOptions contains the optional parameters for the SlicesClient.UpdateTags method.
type SlicesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// Snssai - Single-network slice selection assistance information (S-NSSAI).
type Snssai struct {
	// REQUIRED; Slice/service type (SST).
	Sst *int32 `json:"sst,omitempty"`

	// Slice differentiator (SD).
	Sd *string `json:"sd,omitempty"`
}

// SubResource - Reference to another sub resource.
type SubResource struct {
	// REQUIRED; Resource ID.
	ID *string `json:"id,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}
