//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdeploymentmanager

const (
	moduleName    = "armdeploymentmanager"
	moduleVersion = "v0.4.0"
)

// DeploymentMode - Describes the type of ARM deployment to be performed on the resource.
type DeploymentMode string

const (
	DeploymentModeIncremental DeploymentMode = "Incremental"
	DeploymentModeComplete    DeploymentMode = "Complete"
)

// PossibleDeploymentModeValues returns the possible values for the DeploymentMode const type.
func PossibleDeploymentModeValues() []DeploymentMode {
	return []DeploymentMode{
		DeploymentModeIncremental,
		DeploymentModeComplete,
	}
}

// RestAuthLocation - The location of the authentication key/value pair in the request.
type RestAuthLocation string

const (
	RestAuthLocationQuery  RestAuthLocation = "Query"
	RestAuthLocationHeader RestAuthLocation = "Header"
)

// PossibleRestAuthLocationValues returns the possible values for the RestAuthLocation const type.
func PossibleRestAuthLocationValues() []RestAuthLocation {
	return []RestAuthLocation{
		RestAuthLocationQuery,
		RestAuthLocationHeader,
	}
}

// RestAuthType - The authentication type.
type RestAuthType string

const (
	RestAuthTypeAPIKey          RestAuthType = "ApiKey"
	RestAuthTypeRolloutIdentity RestAuthType = "RolloutIdentity"
)

// PossibleRestAuthTypeValues returns the possible values for the RestAuthType const type.
func PossibleRestAuthTypeValues() []RestAuthType {
	return []RestAuthType{
		RestAuthTypeAPIKey,
		RestAuthTypeRolloutIdentity,
	}
}

// RestMatchQuantifier - Indicates whether any or all of the expressions should match with the response content.
type RestMatchQuantifier string

const (
	RestMatchQuantifierAll RestMatchQuantifier = "All"
	RestMatchQuantifierAny RestMatchQuantifier = "Any"
)

// PossibleRestMatchQuantifierValues returns the possible values for the RestMatchQuantifier const type.
func PossibleRestMatchQuantifierValues() []RestMatchQuantifier {
	return []RestMatchQuantifier{
		RestMatchQuantifierAll,
		RestMatchQuantifierAny,
	}
}

// RestRequestMethod - The HTTP method to use for the request.
type RestRequestMethod string

const (
	RestRequestMethodGET  RestRequestMethod = "GET"
	RestRequestMethodPOST RestRequestMethod = "POST"
)

// PossibleRestRequestMethodValues returns the possible values for the RestRequestMethod const type.
func PossibleRestRequestMethodValues() []RestRequestMethod {
	return []RestRequestMethod{
		RestRequestMethodGET,
		RestRequestMethodPOST,
	}
}

// StepType - The type of step.
type StepType string

const (
	StepTypeWait        StepType = "Wait"
	StepTypeHealthCheck StepType = "HealthCheck"
)

// PossibleStepTypeValues returns the possible values for the StepType const type.
func PossibleStepTypeValues() []StepType {
	return []StepType{
		StepTypeWait,
		StepTypeHealthCheck,
	}
}
