//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcontainerregistry

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AgentPool.
func (a AgentPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolUpdateParameters.
func (a AgentPoolUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ConnectedRegistryProperties.
func (c ConnectedRegistryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "activation", c.Activation)
	populate(objectMap, "clientTokenIds", c.ClientTokenIDs)
	populate(objectMap, "connectionState", c.ConnectionState)
	populateTimeRFC3339(objectMap, "lastActivityTime", c.LastActivityTime)
	populate(objectMap, "logging", c.Logging)
	populate(objectMap, "loginServer", c.LoginServer)
	populate(objectMap, "mode", c.Mode)
	populate(objectMap, "notificationsList", c.NotificationsList)
	populate(objectMap, "parent", c.Parent)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "statusDetails", c.StatusDetails)
	populate(objectMap, "version", c.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectedRegistryProperties.
func (c *ConnectedRegistryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activation":
			err = unpopulate(val, "Activation", &c.Activation)
			delete(rawMsg, key)
		case "clientTokenIds":
			err = unpopulate(val, "ClientTokenIDs", &c.ClientTokenIDs)
			delete(rawMsg, key)
		case "connectionState":
			err = unpopulate(val, "ConnectionState", &c.ConnectionState)
			delete(rawMsg, key)
		case "lastActivityTime":
			err = unpopulateTimeRFC3339(val, "LastActivityTime", &c.LastActivityTime)
			delete(rawMsg, key)
		case "logging":
			err = unpopulate(val, "Logging", &c.Logging)
			delete(rawMsg, key)
		case "loginServer":
			err = unpopulate(val, "LoginServer", &c.LoginServer)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &c.Mode)
			delete(rawMsg, key)
		case "notificationsList":
			err = unpopulate(val, "NotificationsList", &c.NotificationsList)
			delete(rawMsg, key)
		case "parent":
			err = unpopulate(val, "Parent", &c.Parent)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &c.StatusDetails)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &c.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectedRegistryUpdateParameters.
func (c ConnectedRegistryUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ConnectedRegistryUpdateProperties.
func (c ConnectedRegistryUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientTokenIds", c.ClientTokenIDs)
	populate(objectMap, "logging", c.Logging)
	populate(objectMap, "notificationsList", c.NotificationsList)
	populate(objectMap, "syncProperties", c.SyncProperties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Credentials.
func (c Credentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customRegistries", c.CustomRegistries)
	populate(objectMap, "sourceRegistry", c.SourceRegistry)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DockerBuildRequest.
func (d DockerBuildRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentConfiguration", d.AgentConfiguration)
	populate(objectMap, "agentPoolName", d.AgentPoolName)
	populate(objectMap, "arguments", d.Arguments)
	populate(objectMap, "credentials", d.Credentials)
	populate(objectMap, "dockerFilePath", d.DockerFilePath)
	populate(objectMap, "imageNames", d.ImageNames)
	populate(objectMap, "isArchiveEnabled", d.IsArchiveEnabled)
	populate(objectMap, "isPushEnabled", d.IsPushEnabled)
	populate(objectMap, "logTemplate", d.LogTemplate)
	populate(objectMap, "noCache", d.NoCache)
	populate(objectMap, "platform", d.Platform)
	populate(objectMap, "sourceLocation", d.SourceLocation)
	populate(objectMap, "target", d.Target)
	populate(objectMap, "timeout", d.Timeout)
	objectMap["type"] = "DockerBuildRequest"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DockerBuildRequest.
func (d *DockerBuildRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentConfiguration":
			err = unpopulate(val, "AgentConfiguration", &d.AgentConfiguration)
			delete(rawMsg, key)
		case "agentPoolName":
			err = unpopulate(val, "AgentPoolName", &d.AgentPoolName)
			delete(rawMsg, key)
		case "arguments":
			err = unpopulate(val, "Arguments", &d.Arguments)
			delete(rawMsg, key)
		case "credentials":
			err = unpopulate(val, "Credentials", &d.Credentials)
			delete(rawMsg, key)
		case "dockerFilePath":
			err = unpopulate(val, "DockerFilePath", &d.DockerFilePath)
			delete(rawMsg, key)
		case "imageNames":
			err = unpopulate(val, "ImageNames", &d.ImageNames)
			delete(rawMsg, key)
		case "isArchiveEnabled":
			err = unpopulate(val, "IsArchiveEnabled", &d.IsArchiveEnabled)
			delete(rawMsg, key)
		case "isPushEnabled":
			err = unpopulate(val, "IsPushEnabled", &d.IsPushEnabled)
			delete(rawMsg, key)
		case "logTemplate":
			err = unpopulate(val, "LogTemplate", &d.LogTemplate)
			delete(rawMsg, key)
		case "noCache":
			err = unpopulate(val, "NoCache", &d.NoCache)
			delete(rawMsg, key)
		case "platform":
			err = unpopulate(val, "Platform", &d.Platform)
			delete(rawMsg, key)
		case "sourceLocation":
			err = unpopulate(val, "SourceLocation", &d.SourceLocation)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &d.Target)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &d.Timeout)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DockerBuildStep.
func (d DockerBuildStep) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "arguments", d.Arguments)
	populate(objectMap, "baseImageDependencies", d.BaseImageDependencies)
	populate(objectMap, "contextAccessToken", d.ContextAccessToken)
	populate(objectMap, "contextPath", d.ContextPath)
	populate(objectMap, "dockerFilePath", d.DockerFilePath)
	populate(objectMap, "imageNames", d.ImageNames)
	populate(objectMap, "isPushEnabled", d.IsPushEnabled)
	populate(objectMap, "noCache", d.NoCache)
	populate(objectMap, "target", d.Target)
	objectMap["type"] = StepTypeDocker
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DockerBuildStep.
func (d *DockerBuildStep) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arguments":
			err = unpopulate(val, "Arguments", &d.Arguments)
			delete(rawMsg, key)
		case "baseImageDependencies":
			err = unpopulate(val, "BaseImageDependencies", &d.BaseImageDependencies)
			delete(rawMsg, key)
		case "contextAccessToken":
			err = unpopulate(val, "ContextAccessToken", &d.ContextAccessToken)
			delete(rawMsg, key)
		case "contextPath":
			err = unpopulate(val, "ContextPath", &d.ContextPath)
			delete(rawMsg, key)
		case "dockerFilePath":
			err = unpopulate(val, "DockerFilePath", &d.DockerFilePath)
			delete(rawMsg, key)
		case "imageNames":
			err = unpopulate(val, "ImageNames", &d.ImageNames)
			delete(rawMsg, key)
		case "isPushEnabled":
			err = unpopulate(val, "IsPushEnabled", &d.IsPushEnabled)
			delete(rawMsg, key)
		case "noCache":
			err = unpopulate(val, "NoCache", &d.NoCache)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &d.Target)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DockerBuildStepUpdateParameters.
func (d DockerBuildStepUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "arguments", d.Arguments)
	populate(objectMap, "contextAccessToken", d.ContextAccessToken)
	populate(objectMap, "contextPath", d.ContextPath)
	populate(objectMap, "dockerFilePath", d.DockerFilePath)
	populate(objectMap, "imageNames", d.ImageNames)
	populate(objectMap, "isPushEnabled", d.IsPushEnabled)
	populate(objectMap, "noCache", d.NoCache)
	populate(objectMap, "target", d.Target)
	objectMap["type"] = StepTypeDocker
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DockerBuildStepUpdateParameters.
func (d *DockerBuildStepUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arguments":
			err = unpopulate(val, "Arguments", &d.Arguments)
			delete(rawMsg, key)
		case "contextAccessToken":
			err = unpopulate(val, "ContextAccessToken", &d.ContextAccessToken)
			delete(rawMsg, key)
		case "contextPath":
			err = unpopulate(val, "ContextPath", &d.ContextPath)
			delete(rawMsg, key)
		case "dockerFilePath":
			err = unpopulate(val, "DockerFilePath", &d.DockerFilePath)
			delete(rawMsg, key)
		case "imageNames":
			err = unpopulate(val, "ImageNames", &d.ImageNames)
			delete(rawMsg, key)
		case "isPushEnabled":
			err = unpopulate(val, "IsPushEnabled", &d.IsPushEnabled)
			delete(rawMsg, key)
		case "noCache":
			err = unpopulate(val, "NoCache", &d.NoCache)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &d.Target)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncodedTaskRunRequest.
func (e EncodedTaskRunRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentConfiguration", e.AgentConfiguration)
	populate(objectMap, "agentPoolName", e.AgentPoolName)
	populate(objectMap, "credentials", e.Credentials)
	populate(objectMap, "encodedTaskContent", e.EncodedTaskContent)
	populate(objectMap, "encodedValuesContent", e.EncodedValuesContent)
	populate(objectMap, "isArchiveEnabled", e.IsArchiveEnabled)
	populate(objectMap, "logTemplate", e.LogTemplate)
	populate(objectMap, "platform", e.Platform)
	populate(objectMap, "sourceLocation", e.SourceLocation)
	populate(objectMap, "timeout", e.Timeout)
	objectMap["type"] = "EncodedTaskRunRequest"
	populate(objectMap, "values", e.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncodedTaskRunRequest.
func (e *EncodedTaskRunRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentConfiguration":
			err = unpopulate(val, "AgentConfiguration", &e.AgentConfiguration)
			delete(rawMsg, key)
		case "agentPoolName":
			err = unpopulate(val, "AgentPoolName", &e.AgentPoolName)
			delete(rawMsg, key)
		case "credentials":
			err = unpopulate(val, "Credentials", &e.Credentials)
			delete(rawMsg, key)
		case "encodedTaskContent":
			err = unpopulate(val, "EncodedTaskContent", &e.EncodedTaskContent)
			delete(rawMsg, key)
		case "encodedValuesContent":
			err = unpopulate(val, "EncodedValuesContent", &e.EncodedValuesContent)
			delete(rawMsg, key)
		case "isArchiveEnabled":
			err = unpopulate(val, "IsArchiveEnabled", &e.IsArchiveEnabled)
			delete(rawMsg, key)
		case "logTemplate":
			err = unpopulate(val, "LogTemplate", &e.LogTemplate)
			delete(rawMsg, key)
		case "platform":
			err = unpopulate(val, "Platform", &e.Platform)
			delete(rawMsg, key)
		case "sourceLocation":
			err = unpopulate(val, "SourceLocation", &e.SourceLocation)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &e.Timeout)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &e.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncodedTaskStep.
func (e EncodedTaskStep) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "baseImageDependencies", e.BaseImageDependencies)
	populate(objectMap, "contextAccessToken", e.ContextAccessToken)
	populate(objectMap, "contextPath", e.ContextPath)
	populate(objectMap, "encodedTaskContent", e.EncodedTaskContent)
	populate(objectMap, "encodedValuesContent", e.EncodedValuesContent)
	objectMap["type"] = StepTypeEncodedTask
	populate(objectMap, "values", e.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncodedTaskStep.
func (e *EncodedTaskStep) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "baseImageDependencies":
			err = unpopulate(val, "BaseImageDependencies", &e.BaseImageDependencies)
			delete(rawMsg, key)
		case "contextAccessToken":
			err = unpopulate(val, "ContextAccessToken", &e.ContextAccessToken)
			delete(rawMsg, key)
		case "contextPath":
			err = unpopulate(val, "ContextPath", &e.ContextPath)
			delete(rawMsg, key)
		case "encodedTaskContent":
			err = unpopulate(val, "EncodedTaskContent", &e.EncodedTaskContent)
			delete(rawMsg, key)
		case "encodedValuesContent":
			err = unpopulate(val, "EncodedValuesContent", &e.EncodedValuesContent)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &e.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncodedTaskStepUpdateParameters.
func (e EncodedTaskStepUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contextAccessToken", e.ContextAccessToken)
	populate(objectMap, "contextPath", e.ContextPath)
	populate(objectMap, "encodedTaskContent", e.EncodedTaskContent)
	populate(objectMap, "encodedValuesContent", e.EncodedValuesContent)
	objectMap["type"] = StepTypeEncodedTask
	populate(objectMap, "values", e.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncodedTaskStepUpdateParameters.
func (e *EncodedTaskStepUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contextAccessToken":
			err = unpopulate(val, "ContextAccessToken", &e.ContextAccessToken)
			delete(rawMsg, key)
		case "contextPath":
			err = unpopulate(val, "ContextPath", &e.ContextPath)
			delete(rawMsg, key)
		case "encodedTaskContent":
			err = unpopulate(val, "EncodedTaskContent", &e.EncodedTaskContent)
			delete(rawMsg, key)
		case "encodedValuesContent":
			err = unpopulate(val, "EncodedValuesContent", &e.EncodedValuesContent)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &e.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventContent.
func (e *EventContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &e.Action)
			delete(rawMsg, key)
		case "actor":
			err = unpopulate(val, "Actor", &e.Actor)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "request":
			err = unpopulate(val, "Request", &e.Request)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &e.Source)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateTimeRFC3339(val, "Timestamp", &e.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportPipelineProperties.
func (e ExportPipelineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "options", e.Options)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type FileTaskRunRequest.
func (f FileTaskRunRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentConfiguration", f.AgentConfiguration)
	populate(objectMap, "agentPoolName", f.AgentPoolName)
	populate(objectMap, "credentials", f.Credentials)
	populate(objectMap, "isArchiveEnabled", f.IsArchiveEnabled)
	populate(objectMap, "logTemplate", f.LogTemplate)
	populate(objectMap, "platform", f.Platform)
	populate(objectMap, "sourceLocation", f.SourceLocation)
	populate(objectMap, "taskFilePath", f.TaskFilePath)
	populate(objectMap, "timeout", f.Timeout)
	objectMap["type"] = "FileTaskRunRequest"
	populate(objectMap, "values", f.Values)
	populate(objectMap, "valuesFilePath", f.ValuesFilePath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileTaskRunRequest.
func (f *FileTaskRunRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentConfiguration":
			err = unpopulate(val, "AgentConfiguration", &f.AgentConfiguration)
			delete(rawMsg, key)
		case "agentPoolName":
			err = unpopulate(val, "AgentPoolName", &f.AgentPoolName)
			delete(rawMsg, key)
		case "credentials":
			err = unpopulate(val, "Credentials", &f.Credentials)
			delete(rawMsg, key)
		case "isArchiveEnabled":
			err = unpopulate(val, "IsArchiveEnabled", &f.IsArchiveEnabled)
			delete(rawMsg, key)
		case "logTemplate":
			err = unpopulate(val, "LogTemplate", &f.LogTemplate)
			delete(rawMsg, key)
		case "platform":
			err = unpopulate(val, "Platform", &f.Platform)
			delete(rawMsg, key)
		case "sourceLocation":
			err = unpopulate(val, "SourceLocation", &f.SourceLocation)
			delete(rawMsg, key)
		case "taskFilePath":
			err = unpopulate(val, "TaskFilePath", &f.TaskFilePath)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &f.Timeout)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &f.Values)
			delete(rawMsg, key)
		case "valuesFilePath":
			err = unpopulate(val, "ValuesFilePath", &f.ValuesFilePath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileTaskStep.
func (f FileTaskStep) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "baseImageDependencies", f.BaseImageDependencies)
	populate(objectMap, "contextAccessToken", f.ContextAccessToken)
	populate(objectMap, "contextPath", f.ContextPath)
	populate(objectMap, "taskFilePath", f.TaskFilePath)
	objectMap["type"] = StepTypeFileTask
	populate(objectMap, "values", f.Values)
	populate(objectMap, "valuesFilePath", f.ValuesFilePath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileTaskStep.
func (f *FileTaskStep) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "baseImageDependencies":
			err = unpopulate(val, "BaseImageDependencies", &f.BaseImageDependencies)
			delete(rawMsg, key)
		case "contextAccessToken":
			err = unpopulate(val, "ContextAccessToken", &f.ContextAccessToken)
			delete(rawMsg, key)
		case "contextPath":
			err = unpopulate(val, "ContextPath", &f.ContextPath)
			delete(rawMsg, key)
		case "taskFilePath":
			err = unpopulate(val, "TaskFilePath", &f.TaskFilePath)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &f.Values)
			delete(rawMsg, key)
		case "valuesFilePath":
			err = unpopulate(val, "ValuesFilePath", &f.ValuesFilePath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileTaskStepUpdateParameters.
func (f FileTaskStepUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contextAccessToken", f.ContextAccessToken)
	populate(objectMap, "contextPath", f.ContextPath)
	populate(objectMap, "taskFilePath", f.TaskFilePath)
	objectMap["type"] = StepTypeFileTask
	populate(objectMap, "values", f.Values)
	populate(objectMap, "valuesFilePath", f.ValuesFilePath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileTaskStepUpdateParameters.
func (f *FileTaskStepUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contextAccessToken":
			err = unpopulate(val, "ContextAccessToken", &f.ContextAccessToken)
			delete(rawMsg, key)
		case "contextPath":
			err = unpopulate(val, "ContextPath", &f.ContextPath)
			delete(rawMsg, key)
		case "taskFilePath":
			err = unpopulate(val, "TaskFilePath", &f.TaskFilePath)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &f.Values)
			delete(rawMsg, key)
		case "valuesFilePath":
			err = unpopulate(val, "ValuesFilePath", &f.ValuesFilePath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenerateCredentialsParameters.
func (g GenerateCredentialsParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "expiry", g.Expiry)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "tokenId", g.TokenID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenerateCredentialsParameters.
func (g *GenerateCredentialsParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiry":
			err = unpopulateTimeRFC3339(val, "Expiry", &g.Expiry)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "tokenId":
			err = unpopulate(val, "TokenID", &g.TokenID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProperties.
func (i IdentityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", i.PrincipalID)
	populate(objectMap, "tenantId", i.TenantID)
	populate(objectMap, "type", i.Type)
	populate(objectMap, "userAssignedIdentities", i.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ImageUpdateTrigger.
func (i ImageUpdateTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "images", i.Images)
	populateTimeRFC3339(objectMap, "timestamp", i.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageUpdateTrigger.
func (i *ImageUpdateTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "images":
			err = unpopulate(val, "Images", &i.Images)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateTimeRFC3339(val, "Timestamp", &i.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImportImageParameters.
func (i ImportImageParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "mode", i.Mode)
	populate(objectMap, "source", i.Source)
	populate(objectMap, "targetTags", i.TargetTags)
	populate(objectMap, "untaggedTargetRepositories", i.UntaggedTargetRepositories)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ImportPipelineProperties.
func (i ImportPipelineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "options", i.Options)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "source", i.Source)
	populate(objectMap, "trigger", i.Trigger)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultProperties.
func (k KeyVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", k.Identity)
	populate(objectMap, "keyIdentifier", k.KeyIdentifier)
	populate(objectMap, "keyRotationEnabled", k.KeyRotationEnabled)
	populateTimeRFC3339(objectMap, "lastKeyRotationTimestamp", k.LastKeyRotationTimestamp)
	populate(objectMap, "versionedKeyIdentifier", k.VersionedKeyIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultProperties.
func (k *KeyVaultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &k.Identity)
			delete(rawMsg, key)
		case "keyIdentifier":
			err = unpopulate(val, "KeyIdentifier", &k.KeyIdentifier)
			delete(rawMsg, key)
		case "keyRotationEnabled":
			err = unpopulate(val, "KeyRotationEnabled", &k.KeyRotationEnabled)
			delete(rawMsg, key)
		case "lastKeyRotationTimestamp":
			err = unpopulateTimeRFC3339(val, "LastKeyRotationTimestamp", &k.LastKeyRotationTimestamp)
			delete(rawMsg, key)
		case "versionedKeyIdentifier":
			err = unpopulate(val, "VersionedKeyIdentifier", &k.VersionedKeyIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkRuleSet.
func (n NetworkRuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "defaultAction", n.DefaultAction)
	populate(objectMap, "ipRules", n.IPRules)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OverrideTaskStepProperties.
func (o OverrideTaskStepProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "arguments", o.Arguments)
	populate(objectMap, "contextPath", o.ContextPath)
	populate(objectMap, "file", o.File)
	populate(objectMap, "target", o.Target)
	populate(objectMap, "updateTriggerToken", o.UpdateTriggerToken)
	populate(objectMap, "values", o.Values)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PipelineRunRequest.
func (p PipelineRunRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "artifacts", p.Artifacts)
	populate(objectMap, "catalogDigest", p.CatalogDigest)
	populate(objectMap, "pipelineResourceId", p.PipelineResourceID)
	populate(objectMap, "source", p.Source)
	populate(objectMap, "target", p.Target)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PipelineRunResponse.
func (p PipelineRunResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "catalogDigest", p.CatalogDigest)
	populateTimeRFC3339(objectMap, "finishTime", p.FinishTime)
	populate(objectMap, "importedArtifacts", p.ImportedArtifacts)
	populate(objectMap, "pipelineRunErrorMessage", p.PipelineRunErrorMessage)
	populate(objectMap, "progress", p.Progress)
	populate(objectMap, "source", p.Source)
	populateTimeRFC3339(objectMap, "startTime", p.StartTime)
	populate(objectMap, "status", p.Status)
	populate(objectMap, "target", p.Target)
	populate(objectMap, "trigger", p.Trigger)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PipelineRunResponse.
func (p *PipelineRunResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "catalogDigest":
			err = unpopulate(val, "CatalogDigest", &p.CatalogDigest)
			delete(rawMsg, key)
		case "finishTime":
			err = unpopulateTimeRFC3339(val, "FinishTime", &p.FinishTime)
			delete(rawMsg, key)
		case "importedArtifacts":
			err = unpopulate(val, "ImportedArtifacts", &p.ImportedArtifacts)
			delete(rawMsg, key)
		case "pipelineRunErrorMessage":
			err = unpopulate(val, "PipelineRunErrorMessage", &p.PipelineRunErrorMessage)
			delete(rawMsg, key)
		case "progress":
			err = unpopulate(val, "Progress", &p.Progress)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &p.Source)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &p.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &p.Target)
			delete(rawMsg, key)
		case "trigger":
			err = unpopulate(val, "Trigger", &p.Trigger)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PipelineSourceTriggerDescriptor.
func (p PipelineSourceTriggerDescriptor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "timestamp", p.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PipelineSourceTriggerDescriptor.
func (p *PipelineSourceTriggerDescriptor) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "timestamp":
			err = unpopulateTimeRFC3339(val, "Timestamp", &p.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Registry.
func (r Registry) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "identity", r.Identity)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "sku", r.SKU)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RegistryProperties.
func (r RegistryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "adminUserEnabled", r.AdminUserEnabled)
	populate(objectMap, "anonymousPullEnabled", r.AnonymousPullEnabled)
	populateTimeRFC3339(objectMap, "creationDate", r.CreationDate)
	populate(objectMap, "dataEndpointEnabled", r.DataEndpointEnabled)
	populate(objectMap, "dataEndpointHostNames", r.DataEndpointHostNames)
	populate(objectMap, "encryption", r.Encryption)
	populate(objectMap, "loginServer", r.LoginServer)
	populate(objectMap, "networkRuleBypassOptions", r.NetworkRuleBypassOptions)
	populate(objectMap, "networkRuleSet", r.NetworkRuleSet)
	populate(objectMap, "policies", r.Policies)
	populate(objectMap, "privateEndpointConnections", r.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", r.PublicNetworkAccess)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "zoneRedundancy", r.ZoneRedundancy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegistryProperties.
func (r *RegistryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminUserEnabled":
			err = unpopulate(val, "AdminUserEnabled", &r.AdminUserEnabled)
			delete(rawMsg, key)
		case "anonymousPullEnabled":
			err = unpopulate(val, "AnonymousPullEnabled", &r.AnonymousPullEnabled)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateTimeRFC3339(val, "CreationDate", &r.CreationDate)
			delete(rawMsg, key)
		case "dataEndpointEnabled":
			err = unpopulate(val, "DataEndpointEnabled", &r.DataEndpointEnabled)
			delete(rawMsg, key)
		case "dataEndpointHostNames":
			err = unpopulate(val, "DataEndpointHostNames", &r.DataEndpointHostNames)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &r.Encryption)
			delete(rawMsg, key)
		case "loginServer":
			err = unpopulate(val, "LoginServer", &r.LoginServer)
			delete(rawMsg, key)
		case "networkRuleBypassOptions":
			err = unpopulate(val, "NetworkRuleBypassOptions", &r.NetworkRuleBypassOptions)
			delete(rawMsg, key)
		case "networkRuleSet":
			err = unpopulate(val, "NetworkRuleSet", &r.NetworkRuleSet)
			delete(rawMsg, key)
		case "policies":
			err = unpopulate(val, "Policies", &r.Policies)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &r.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &r.PublicNetworkAccess)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "zoneRedundancy":
			err = unpopulate(val, "ZoneRedundancy", &r.ZoneRedundancy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegistryUpdateParameters.
func (r RegistryUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", r.Identity)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "sku", r.SKU)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Replication.
func (r Replication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationUpdateParameters.
func (r ReplicationUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RetentionPolicy.
func (r RetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "days", r.Days)
	populateTimeRFC3339(objectMap, "lastUpdatedTime", r.LastUpdatedTime)
	populate(objectMap, "status", r.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RetentionPolicy.
func (r *RetentionPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "days":
			err = unpopulate(val, "Days", &r.Days)
			delete(rawMsg, key)
		case "lastUpdatedTime":
			err = unpopulateTimeRFC3339(val, "LastUpdatedTime", &r.LastUpdatedTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunFilter.
func (r *RunFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentPoolName":
			err = unpopulate(val, "AgentPoolName", &r.AgentPoolName)
			delete(rawMsg, key)
		case "createTime":
			err = unpopulateTimeRFC3339(val, "CreateTime", &r.CreateTime)
			delete(rawMsg, key)
		case "finishTime":
			err = unpopulateTimeRFC3339(val, "FinishTime", &r.FinishTime)
			delete(rawMsg, key)
		case "isArchiveEnabled":
			err = unpopulate(val, "IsArchiveEnabled", &r.IsArchiveEnabled)
			delete(rawMsg, key)
		case "outputImageManifests":
			err = unpopulate(val, "OutputImageManifests", &r.OutputImageManifests)
			delete(rawMsg, key)
		case "runId":
			err = unpopulate(val, "RunID", &r.RunID)
			delete(rawMsg, key)
		case "runType":
			err = unpopulate(val, "RunType", &r.RunType)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "taskName":
			err = unpopulate(val, "TaskName", &r.TaskName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunProperties.
func (r RunProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentConfiguration", r.AgentConfiguration)
	populate(objectMap, "agentPoolName", r.AgentPoolName)
	populateTimeRFC3339(objectMap, "createTime", r.CreateTime)
	populate(objectMap, "customRegistries", r.CustomRegistries)
	populateTimeRFC3339(objectMap, "finishTime", r.FinishTime)
	populate(objectMap, "imageUpdateTrigger", r.ImageUpdateTrigger)
	populate(objectMap, "isArchiveEnabled", r.IsArchiveEnabled)
	populateTimeRFC3339(objectMap, "lastUpdatedTime", r.LastUpdatedTime)
	populate(objectMap, "logArtifact", r.LogArtifact)
	populate(objectMap, "outputImages", r.OutputImages)
	populate(objectMap, "platform", r.Platform)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "runErrorMessage", r.RunErrorMessage)
	populate(objectMap, "runId", r.RunID)
	populate(objectMap, "runType", r.RunType)
	populate(objectMap, "sourceRegistryAuth", r.SourceRegistryAuth)
	populate(objectMap, "sourceTrigger", r.SourceTrigger)
	populateTimeRFC3339(objectMap, "startTime", r.StartTime)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "task", r.Task)
	populate(objectMap, "timerTrigger", r.TimerTrigger)
	populate(objectMap, "updateTriggerToken", r.UpdateTriggerToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunProperties.
func (r *RunProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentConfiguration":
			err = unpopulate(val, "AgentConfiguration", &r.AgentConfiguration)
			delete(rawMsg, key)
		case "agentPoolName":
			err = unpopulate(val, "AgentPoolName", &r.AgentPoolName)
			delete(rawMsg, key)
		case "createTime":
			err = unpopulateTimeRFC3339(val, "CreateTime", &r.CreateTime)
			delete(rawMsg, key)
		case "customRegistries":
			err = unpopulate(val, "CustomRegistries", &r.CustomRegistries)
			delete(rawMsg, key)
		case "finishTime":
			err = unpopulateTimeRFC3339(val, "FinishTime", &r.FinishTime)
			delete(rawMsg, key)
		case "imageUpdateTrigger":
			err = unpopulate(val, "ImageUpdateTrigger", &r.ImageUpdateTrigger)
			delete(rawMsg, key)
		case "isArchiveEnabled":
			err = unpopulate(val, "IsArchiveEnabled", &r.IsArchiveEnabled)
			delete(rawMsg, key)
		case "lastUpdatedTime":
			err = unpopulateTimeRFC3339(val, "LastUpdatedTime", &r.LastUpdatedTime)
			delete(rawMsg, key)
		case "logArtifact":
			err = unpopulate(val, "LogArtifact", &r.LogArtifact)
			delete(rawMsg, key)
		case "outputImages":
			err = unpopulate(val, "OutputImages", &r.OutputImages)
			delete(rawMsg, key)
		case "platform":
			err = unpopulate(val, "Platform", &r.Platform)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "runErrorMessage":
			err = unpopulate(val, "RunErrorMessage", &r.RunErrorMessage)
			delete(rawMsg, key)
		case "runId":
			err = unpopulate(val, "RunID", &r.RunID)
			delete(rawMsg, key)
		case "runType":
			err = unpopulate(val, "RunType", &r.RunType)
			delete(rawMsg, key)
		case "sourceRegistryAuth":
			err = unpopulate(val, "SourceRegistryAuth", &r.SourceRegistryAuth)
			delete(rawMsg, key)
		case "sourceTrigger":
			err = unpopulate(val, "SourceTrigger", &r.SourceTrigger)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "task":
			err = unpopulate(val, "Task", &r.Task)
			delete(rawMsg, key)
		case "timerTrigger":
			err = unpopulate(val, "TimerTrigger", &r.TimerTrigger)
			delete(rawMsg, key)
		case "updateTriggerToken":
			err = unpopulate(val, "UpdateTriggerToken", &r.UpdateTriggerToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunUpdateParameters.
func (r RunUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "isArchiveEnabled", r.IsArchiveEnabled)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ScopeMapProperties.
func (s ScopeMapProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actions", s.Actions)
	populateTimeRFC3339(objectMap, "creationDate", s.CreationDate)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScopeMapProperties.
func (s *ScopeMapProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &s.Actions)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateTimeRFC3339(val, "CreationDate", &s.CreationDate)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScopeMapPropertiesUpdateParameters.
func (s ScopeMapPropertiesUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actions", s.Actions)
	populate(objectMap, "description", s.Description)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ScopeMapUpdateParameters.
func (s ScopeMapUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SoftDeletePolicy.
func (s SoftDeletePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "lastUpdatedTime", s.LastUpdatedTime)
	populate(objectMap, "retentionDays", s.RetentionDays)
	populate(objectMap, "status", s.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SoftDeletePolicy.
func (s *SoftDeletePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastUpdatedTime":
			err = unpopulateTimeRFC3339(val, "LastUpdatedTime", &s.LastUpdatedTime)
			delete(rawMsg, key)
		case "retentionDays":
			err = unpopulate(val, "RetentionDays", &s.RetentionDays)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceTrigger.
func (s SourceTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", s.Name)
	populate(objectMap, "sourceRepository", s.SourceRepository)
	populate(objectMap, "sourceTriggerEvents", s.SourceTriggerEvents)
	populate(objectMap, "status", s.Status)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SourceTriggerUpdateParameters.
func (s SourceTriggerUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", s.Name)
	populate(objectMap, "sourceRepository", s.SourceRepository)
	populate(objectMap, "sourceTriggerEvents", s.SourceTriggerEvents)
	populate(objectMap, "status", s.Status)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Status.
func (s Status) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "displayStatus", s.DisplayStatus)
	populate(objectMap, "message", s.Message)
	populateTimeRFC3339(objectMap, "timestamp", s.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Status.
func (s *Status) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayStatus":
			err = unpopulate(val, "DisplayStatus", &s.DisplayStatus)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &s.Message)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateTimeRFC3339(val, "Timestamp", &s.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatusDetailProperties.
func (s StatusDetailProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", s.Code)
	populate(objectMap, "correlationId", s.CorrelationID)
	populate(objectMap, "description", s.Description)
	populateTimeRFC3339(objectMap, "timestamp", s.Timestamp)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatusDetailProperties.
func (s *StatusDetailProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &s.Code)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &s.CorrelationID)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateTimeRFC3339(val, "Timestamp", &s.Timestamp)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SyncProperties.
func (s SyncProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "gatewayEndpoint", s.GatewayEndpoint)
	populateTimeRFC3339(objectMap, "lastSyncTime", s.LastSyncTime)
	populate(objectMap, "messageTtl", s.MessageTTL)
	populate(objectMap, "schedule", s.Schedule)
	populate(objectMap, "syncWindow", s.SyncWindow)
	populate(objectMap, "tokenId", s.TokenID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SyncProperties.
func (s *SyncProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "gatewayEndpoint":
			err = unpopulate(val, "GatewayEndpoint", &s.GatewayEndpoint)
			delete(rawMsg, key)
		case "lastSyncTime":
			err = unpopulateTimeRFC3339(val, "LastSyncTime", &s.LastSyncTime)
			delete(rawMsg, key)
		case "messageTtl":
			err = unpopulate(val, "MessageTTL", &s.MessageTTL)
			delete(rawMsg, key)
		case "schedule":
			err = unpopulate(val, "Schedule", &s.Schedule)
			delete(rawMsg, key)
		case "syncWindow":
			err = unpopulate(val, "SyncWindow", &s.SyncWindow)
			delete(rawMsg, key)
		case "tokenId":
			err = unpopulate(val, "TokenID", &s.TokenID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Task.
func (t Task) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "identity", t.Identity)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TaskProperties.
func (t TaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentConfiguration", t.AgentConfiguration)
	populate(objectMap, "agentPoolName", t.AgentPoolName)
	populateTimeRFC3339(objectMap, "creationDate", t.CreationDate)
	populate(objectMap, "credentials", t.Credentials)
	populate(objectMap, "isSystemTask", t.IsSystemTask)
	populate(objectMap, "logTemplate", t.LogTemplate)
	populate(objectMap, "platform", t.Platform)
	populate(objectMap, "provisioningState", t.ProvisioningState)
	populate(objectMap, "status", t.Status)
	populate(objectMap, "step", t.Step)
	populate(objectMap, "timeout", t.Timeout)
	populate(objectMap, "trigger", t.Trigger)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TaskProperties.
func (t *TaskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentConfiguration":
			err = unpopulate(val, "AgentConfiguration", &t.AgentConfiguration)
			delete(rawMsg, key)
		case "agentPoolName":
			err = unpopulate(val, "AgentPoolName", &t.AgentPoolName)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateTimeRFC3339(val, "CreationDate", &t.CreationDate)
			delete(rawMsg, key)
		case "credentials":
			err = unpopulate(val, "Credentials", &t.Credentials)
			delete(rawMsg, key)
		case "isSystemTask":
			err = unpopulate(val, "IsSystemTask", &t.IsSystemTask)
			delete(rawMsg, key)
		case "logTemplate":
			err = unpopulate(val, "LogTemplate", &t.LogTemplate)
			delete(rawMsg, key)
		case "platform":
			err = unpopulate(val, "Platform", &t.Platform)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &t.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &t.Status)
			delete(rawMsg, key)
		case "step":
			t.Step, err = unmarshalTaskStepPropertiesClassification(val)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &t.Timeout)
			delete(rawMsg, key)
		case "trigger":
			err = unpopulate(val, "Trigger", &t.Trigger)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TaskPropertiesUpdateParameters.
func (t TaskPropertiesUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentConfiguration", t.AgentConfiguration)
	populate(objectMap, "agentPoolName", t.AgentPoolName)
	populate(objectMap, "credentials", t.Credentials)
	populate(objectMap, "logTemplate", t.LogTemplate)
	populate(objectMap, "platform", t.Platform)
	populate(objectMap, "status", t.Status)
	populate(objectMap, "step", t.Step)
	populate(objectMap, "timeout", t.Timeout)
	populate(objectMap, "trigger", t.Trigger)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TaskPropertiesUpdateParameters.
func (t *TaskPropertiesUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentConfiguration":
			err = unpopulate(val, "AgentConfiguration", &t.AgentConfiguration)
			delete(rawMsg, key)
		case "agentPoolName":
			err = unpopulate(val, "AgentPoolName", &t.AgentPoolName)
			delete(rawMsg, key)
		case "credentials":
			err = unpopulate(val, "Credentials", &t.Credentials)
			delete(rawMsg, key)
		case "logTemplate":
			err = unpopulate(val, "LogTemplate", &t.LogTemplate)
			delete(rawMsg, key)
		case "platform":
			err = unpopulate(val, "Platform", &t.Platform)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &t.Status)
			delete(rawMsg, key)
		case "step":
			t.Step, err = unmarshalTaskStepUpdateParametersClassification(val)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &t.Timeout)
			delete(rawMsg, key)
		case "trigger":
			err = unpopulate(val, "Trigger", &t.Trigger)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TaskRunProperties.
func (t TaskRunProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "forceUpdateTag", t.ForceUpdateTag)
	populate(objectMap, "provisioningState", t.ProvisioningState)
	populate(objectMap, "runRequest", t.RunRequest)
	populate(objectMap, "runResult", t.RunResult)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TaskRunProperties.
func (t *TaskRunProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "forceUpdateTag":
			err = unpopulate(val, "ForceUpdateTag", &t.ForceUpdateTag)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &t.ProvisioningState)
			delete(rawMsg, key)
		case "runRequest":
			t.RunRequest, err = unmarshalRunRequestClassification(val)
			delete(rawMsg, key)
		case "runResult":
			err = unpopulate(val, "RunResult", &t.RunResult)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TaskRunPropertiesUpdateParameters.
func (t TaskRunPropertiesUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "forceUpdateTag", t.ForceUpdateTag)
	populate(objectMap, "runRequest", t.RunRequest)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TaskRunPropertiesUpdateParameters.
func (t *TaskRunPropertiesUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "forceUpdateTag":
			err = unpopulate(val, "ForceUpdateTag", &t.ForceUpdateTag)
			delete(rawMsg, key)
		case "runRequest":
			t.RunRequest, err = unmarshalRunRequestClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TaskRunRequest.
func (t TaskRunRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentPoolName", t.AgentPoolName)
	populate(objectMap, "isArchiveEnabled", t.IsArchiveEnabled)
	populate(objectMap, "logTemplate", t.LogTemplate)
	populate(objectMap, "overrideTaskStepProperties", t.OverrideTaskStepProperties)
	populate(objectMap, "taskId", t.TaskID)
	objectMap["type"] = "TaskRunRequest"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TaskRunRequest.
func (t *TaskRunRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentPoolName":
			err = unpopulate(val, "AgentPoolName", &t.AgentPoolName)
			delete(rawMsg, key)
		case "isArchiveEnabled":
			err = unpopulate(val, "IsArchiveEnabled", &t.IsArchiveEnabled)
			delete(rawMsg, key)
		case "logTemplate":
			err = unpopulate(val, "LogTemplate", &t.LogTemplate)
			delete(rawMsg, key)
		case "overrideTaskStepProperties":
			err = unpopulate(val, "OverrideTaskStepProperties", &t.OverrideTaskStepProperties)
			delete(rawMsg, key)
		case "taskId":
			err = unpopulate(val, "TaskID", &t.TaskID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TaskRunUpdateParameters.
func (t TaskRunUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", t.Identity)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TaskStepProperties.
func (t TaskStepProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "baseImageDependencies", t.BaseImageDependencies)
	populate(objectMap, "contextAccessToken", t.ContextAccessToken)
	populate(objectMap, "contextPath", t.ContextPath)
	objectMap["type"] = t.Type
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TaskUpdateParameters.
func (t TaskUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", t.Identity)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TokenCertificate.
func (t TokenCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "encodedPemCertificate", t.EncodedPemCertificate)
	populateTimeRFC3339(objectMap, "expiry", t.Expiry)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "thumbprint", t.Thumbprint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TokenCertificate.
func (t *TokenCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encodedPemCertificate":
			err = unpopulate(val, "EncodedPemCertificate", &t.EncodedPemCertificate)
			delete(rawMsg, key)
		case "expiry":
			err = unpopulateTimeRFC3339(val, "Expiry", &t.Expiry)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &t.Thumbprint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TokenCredentialsProperties.
func (t TokenCredentialsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "certificates", t.Certificates)
	populate(objectMap, "passwords", t.Passwords)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TokenPassword.
func (t TokenPassword) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", t.CreationTime)
	populateTimeRFC3339(objectMap, "expiry", t.Expiry)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TokenPassword.
func (t *TokenPassword) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &t.CreationTime)
			delete(rawMsg, key)
		case "expiry":
			err = unpopulateTimeRFC3339(val, "Expiry", &t.Expiry)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TokenProperties.
func (t TokenProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationDate", t.CreationDate)
	populate(objectMap, "credentials", t.Credentials)
	populate(objectMap, "provisioningState", t.ProvisioningState)
	populate(objectMap, "scopeMapId", t.ScopeMapID)
	populate(objectMap, "status", t.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TokenProperties.
func (t *TokenProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationDate":
			err = unpopulateTimeRFC3339(val, "CreationDate", &t.CreationDate)
			delete(rawMsg, key)
		case "credentials":
			err = unpopulate(val, "Credentials", &t.Credentials)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &t.ProvisioningState)
			delete(rawMsg, key)
		case "scopeMapId":
			err = unpopulate(val, "ScopeMapID", &t.ScopeMapID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &t.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TokenUpdateParameters.
func (t TokenUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", t.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TriggerProperties.
func (t TriggerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "baseImageTrigger", t.BaseImageTrigger)
	populate(objectMap, "sourceTriggers", t.SourceTriggers)
	populate(objectMap, "timerTriggers", t.TimerTriggers)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TriggerUpdateParameters.
func (t TriggerUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "baseImageTrigger", t.BaseImageTrigger)
	populate(objectMap, "sourceTriggers", t.SourceTriggers)
	populate(objectMap, "timerTriggers", t.TimerTriggers)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Webhook.
func (w Webhook) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", w.ID)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "systemData", w.SystemData)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WebhookCreateParameters.
func (w WebhookCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", w.Location)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WebhookProperties.
func (w WebhookProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actions", w.Actions)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	populate(objectMap, "scope", w.Scope)
	populate(objectMap, "status", w.Status)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WebhookPropertiesCreateParameters.
func (w WebhookPropertiesCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actions", w.Actions)
	populate(objectMap, "customHeaders", w.CustomHeaders)
	populate(objectMap, "scope", w.Scope)
	populate(objectMap, "serviceUri", w.ServiceURI)
	populate(objectMap, "status", w.Status)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WebhookPropertiesUpdateParameters.
func (w WebhookPropertiesUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actions", w.Actions)
	populate(objectMap, "customHeaders", w.CustomHeaders)
	populate(objectMap, "scope", w.Scope)
	populate(objectMap, "serviceUri", w.ServiceURI)
	populate(objectMap, "status", w.Status)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WebhookUpdateParameters.
func (w WebhookUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
