//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcommerce

import (
	"encoding/json"
	"fmt"
)

// UnmarshalJSON implements the json.Unmarshaller interface for type MeterInfo.
func (m *MeterInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "EffectiveDate":
			err = unpopulateTimeRFC3339(val, "EffectiveDate", &m.EffectiveDate)
			delete(rawMsg, key)
		case "IncludedQuantity":
			err = unpopulate(val, "IncludedQuantity", &m.IncludedQuantity)
			delete(rawMsg, key)
		case "MeterCategory":
			err = unpopulate(val, "MeterCategory", &m.MeterCategory)
			delete(rawMsg, key)
		case "MeterId":
			err = unpopulate(val, "MeterID", &m.MeterID)
			delete(rawMsg, key)
		case "MeterName":
			err = unpopulate(val, "MeterName", &m.MeterName)
			delete(rawMsg, key)
		case "MeterRates":
			err = unpopulate(val, "MeterRates", &m.MeterRates)
			delete(rawMsg, key)
		case "MeterRegion":
			err = unpopulate(val, "MeterRegion", &m.MeterRegion)
			delete(rawMsg, key)
		case "MeterSubCategory":
			err = unpopulate(val, "MeterSubCategory", &m.MeterSubCategory)
			delete(rawMsg, key)
		case "MeterTags":
			err = unpopulate(val, "MeterTags", &m.MeterTags)
			delete(rawMsg, key)
		case "Unit":
			err = unpopulate(val, "Unit", &m.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MonetaryCommitment.
func (m *MonetaryCommitment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "EffectiveDate":
			err = unpopulateTimeRFC3339(val, "EffectiveDate", &m.EffectiveDate)
			delete(rawMsg, key)
		case "ExcludedMeterIds":
			err = unpopulate(val, "ExcludedMeterIDs", &m.ExcludedMeterIDs)
			delete(rawMsg, key)
		case "Name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "TieredDiscount":
			err = unpopulate(val, "TieredDiscount", &m.TieredDiscount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MonetaryCredit.
func (m *MonetaryCredit) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "Credit":
			err = unpopulate(val, "Credit", &m.Credit)
			delete(rawMsg, key)
		case "EffectiveDate":
			err = unpopulateTimeRFC3339(val, "EffectiveDate", &m.EffectiveDate)
			delete(rawMsg, key)
		case "ExcludedMeterIds":
			err = unpopulate(val, "ExcludedMeterIDs", &m.ExcludedMeterIDs)
			delete(rawMsg, key)
		case "Name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OfferTermInfoAutoGenerated.
func (o *OfferTermInfoAutoGenerated) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "EffectiveDate":
			err = unpopulateTimeRFC3339(val, "EffectiveDate", &o.EffectiveDate)
			delete(rawMsg, key)
		case "Name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecurringCharge.
func (r *RecurringCharge) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "EffectiveDate":
			err = unpopulateTimeRFC3339(val, "EffectiveDate", &r.EffectiveDate)
			delete(rawMsg, key)
		case "Name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "RecurringCharge":
			err = unpopulate(val, "RecurringCharge", &r.RecurringCharge)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceRateCardInfo.
func (r *ResourceRateCardInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "Currency":
			err = unpopulate(val, "Currency", &r.Currency)
			delete(rawMsg, key)
		case "IsTaxIncluded":
			err = unpopulate(val, "IsTaxIncluded", &r.IsTaxIncluded)
			delete(rawMsg, key)
		case "Locale":
			err = unpopulate(val, "Locale", &r.Locale)
			delete(rawMsg, key)
		case "Meters":
			err = unpopulate(val, "Meters", &r.Meters)
			delete(rawMsg, key)
		case "OfferTerms":
			r.OfferTerms, err = unmarshalOfferTermInfoAutoGeneratedClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsageSample.
func (u *UsageSample) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "infoFields":
			err = unpopulate(val, "InfoFields", &u.InfoFields)
			delete(rawMsg, key)
		case "instanceData":
			err = unpopulate(val, "InstanceData", &u.InstanceData)
			delete(rawMsg, key)
		case "meterCategory":
			err = unpopulate(val, "MeterCategory", &u.MeterCategory)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &u.MeterID)
			delete(rawMsg, key)
		case "meterName":
			err = unpopulate(val, "MeterName", &u.MeterName)
			delete(rawMsg, key)
		case "meterRegion":
			err = unpopulate(val, "MeterRegion", &u.MeterRegion)
			delete(rawMsg, key)
		case "meterSubCategory":
			err = unpopulate(val, "MeterSubCategory", &u.MeterSubCategory)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &u.Quantity)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &u.SubscriptionID)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &u.Unit)
			delete(rawMsg, key)
		case "usageEndTime":
			err = unpopulateTimeRFC3339(val, "UsageEndTime", &u.UsageEndTime)
			delete(rawMsg, key)
		case "usageStartTime":
			err = unpopulateTimeRFC3339(val, "UsageStartTime", &u.UsageStartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
