//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armappservice_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2022-03-01/examples/CheckDomainAvailability.json
func ExampleDomainsClient_CheckAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappservice.NewDomainsClient("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.CheckAvailability(ctx,
		armappservice.NameIdentifier{
			Name: to.Ptr("abcd.com"),
		},
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2022-03-01/examples/ListDomainsBySubscription.json
func ExampleDomainsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappservice.NewDomainsClient("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := client.NewListPager(nil)
	for pager.More() {
		nextResult, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range nextResult.Value {
			// TODO: use page item
			_ = v
		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2022-03-01/examples/GetDomainControlCenterSsoRequest.json
func ExampleDomainsClient_GetControlCenterSsoRequest() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappservice.NewDomainsClient("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.GetControlCenterSsoRequest(ctx,
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2022-03-01/examples/ListDomainRecommendations.json
func ExampleDomainsClient_NewListRecommendationsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappservice.NewDomainsClient("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := client.NewListRecommendationsPager(armappservice.DomainRecommendationSearchParameters{
		Keywords:                 to.Ptr("example1"),
		MaxDomainRecommendations: to.Ptr[int32](10),
	},
		nil)
	for pager.More() {
		nextResult, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range nextResult.Value {
			// TODO: use page item
			_ = v
		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2022-03-01/examples/ListDomainsByResourceGroup.json
func ExampleDomainsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappservice.NewDomainsClient("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := client.NewListByResourceGroupPager("testrg123",
		nil)
	for pager.More() {
		nextResult, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range nextResult.Value {
			// TODO: use page item
			_ = v
		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2022-03-01/examples/GetDomain.json
func ExampleDomainsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappservice.NewDomainsClient("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.Get(ctx,
		"testrg123",
		"example.com",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2022-03-01/examples/CreateAppServiceDomain.json
func ExampleDomainsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappservice.NewDomainsClient("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := client.BeginCreateOrUpdate(ctx,
		"testrg123",
		"example.com",
		armappservice.Domain{
			Location: to.Ptr("global"),
			Tags:     map[string]*string{},
			Properties: &armappservice.DomainProperties{
				AuthCode:  to.Ptr("exampleAuthCode"),
				AutoRenew: to.Ptr(true),
				Consent: &armappservice.DomainPurchaseConsent{
					AgreedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-10T19:30:53Z"); return t }()),
					AgreedBy: to.Ptr("192.0.2.1"),
					AgreementKeys: []*string{
						to.Ptr("agreementKey1")},
				},
				ContactAdmin: &armappservice.Contact{
					AddressMailing: &armappservice.Address{
						Address1:   to.Ptr("3400 State St"),
						City:       to.Ptr("Chicago"),
						Country:    to.Ptr("United States"),
						PostalCode: to.Ptr("67098"),
						State:      to.Ptr("IL"),
					},
					Email:        to.Ptr("admin@email.com"),
					Fax:          to.Ptr("1-245-534-2242"),
					JobTitle:     to.Ptr("Admin"),
					NameFirst:    to.Ptr("John"),
					NameLast:     to.Ptr("Doe"),
					NameMiddle:   to.Ptr(""),
					Organization: to.Ptr("Microsoft Inc."),
					Phone:        to.Ptr("1-245-534-2242"),
				},
				ContactBilling: &armappservice.Contact{
					AddressMailing: &armappservice.Address{
						Address1:   to.Ptr("3400 State St"),
						City:       to.Ptr("Chicago"),
						Country:    to.Ptr("United States"),
						PostalCode: to.Ptr("67098"),
						State:      to.Ptr("IL"),
					},
					Email:        to.Ptr("billing@email.com"),
					Fax:          to.Ptr("1-245-534-2242"),
					JobTitle:     to.Ptr("Billing"),
					NameFirst:    to.Ptr("John"),
					NameLast:     to.Ptr("Doe"),
					NameMiddle:   to.Ptr(""),
					Organization: to.Ptr("Microsoft Inc."),
					Phone:        to.Ptr("1-245-534-2242"),
				},
				ContactRegistrant: &armappservice.Contact{
					AddressMailing: &armappservice.Address{
						Address1:   to.Ptr("3400 State St"),
						City:       to.Ptr("Chicago"),
						Country:    to.Ptr("United States"),
						PostalCode: to.Ptr("67098"),
						State:      to.Ptr("IL"),
					},
					Email:        to.Ptr("registrant@email.com"),
					Fax:          to.Ptr("1-245-534-2242"),
					JobTitle:     to.Ptr("Registrant"),
					NameFirst:    to.Ptr("John"),
					NameLast:     to.Ptr("Doe"),
					NameMiddle:   to.Ptr(""),
					Organization: to.Ptr("Microsoft Inc."),
					Phone:        to.Ptr("1-245-534-2242"),
				},
				ContactTech: &armappservice.Contact{
					AddressMailing: &armappservice.Address{
						Address1:   to.Ptr("3400 State St"),
						City:       to.Ptr("Chicago"),
						Country:    to.Ptr("United States"),
						PostalCode: to.Ptr("67098"),
						State:      to.Ptr("IL"),
					},
					Email:        to.Ptr("tech@email.com"),
					Fax:          to.Ptr("1-245-534-2242"),
					JobTitle:     to.Ptr("Tech"),
					NameFirst:    to.Ptr("John"),
					NameLast:     to.Ptr("Doe"),
					NameMiddle:   to.Ptr(""),
					Organization: to.Ptr("Microsoft Inc."),
					Phone:        to.Ptr("1-245-534-2242"),
				},
				DNSType: to.Ptr(armappservice.DNSTypeDefaultDomainRegistrarDNS),
				Privacy: to.Ptr(false),
			},
		},
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2022-03-01/examples/DeleteAppServiceDomain.json
func ExampleDomainsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappservice.NewDomainsClient("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = client.Delete(ctx,
		"testrg123",
		"example.com",
		&armappservice.DomainsClientDeleteOptions{ForceHardDeleteDomain: to.Ptr(true)})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2022-03-01/examples/UpdateAppServiceDomain.json
func ExampleDomainsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappservice.NewDomainsClient("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.Update(ctx,
		"testrg123",
		"example.com",
		armappservice.DomainPatchResource{
			Properties: &armappservice.DomainPatchResourceProperties{
				AuthCode:  to.Ptr("exampleAuthCode"),
				AutoRenew: to.Ptr(true),
				Consent: &armappservice.DomainPurchaseConsent{
					AgreedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-10T19:30:53Z"); return t }()),
					AgreedBy: to.Ptr("192.0.2.1"),
					AgreementKeys: []*string{
						to.Ptr("agreementKey1")},
				},
				ContactAdmin: &armappservice.Contact{
					AddressMailing: &armappservice.Address{
						Address1:   to.Ptr("3400 State St"),
						City:       to.Ptr("Chicago"),
						Country:    to.Ptr("United States"),
						PostalCode: to.Ptr("67098"),
						State:      to.Ptr("IL"),
					},
					Email:        to.Ptr("admin@email.com"),
					Fax:          to.Ptr("1-245-534-2242"),
					JobTitle:     to.Ptr("Admin"),
					NameFirst:    to.Ptr("John"),
					NameLast:     to.Ptr("Doe"),
					NameMiddle:   to.Ptr(""),
					Organization: to.Ptr("Microsoft Inc."),
					Phone:        to.Ptr("1-245-534-2242"),
				},
				ContactBilling: &armappservice.Contact{
					AddressMailing: &armappservice.Address{
						Address1:   to.Ptr("3400 State St"),
						City:       to.Ptr("Chicago"),
						Country:    to.Ptr("United States"),
						PostalCode: to.Ptr("67098"),
						State:      to.Ptr("IL"),
					},
					Email:        to.Ptr("billing@email.com"),
					Fax:          to.Ptr("1-245-534-2242"),
					JobTitle:     to.Ptr("Billing"),
					NameFirst:    to.Ptr("John"),
					NameLast:     to.Ptr("Doe"),
					NameMiddle:   to.Ptr(""),
					Organization: to.Ptr("Microsoft Inc."),
					Phone:        to.Ptr("1-245-534-2242"),
				},
				ContactRegistrant: &armappservice.Contact{
					AddressMailing: &armappservice.Address{
						Address1:   to.Ptr("3400 State St"),
						City:       to.Ptr("Chicago"),
						Country:    to.Ptr("United States"),
						PostalCode: to.Ptr("67098"),
						State:      to.Ptr("IL"),
					},
					Email:        to.Ptr("registrant@email.com"),
					Fax:          to.Ptr("1-245-534-2242"),
					JobTitle:     to.Ptr("Registrant"),
					NameFirst:    to.Ptr("John"),
					NameLast:     to.Ptr("Doe"),
					NameMiddle:   to.Ptr(""),
					Organization: to.Ptr("Microsoft Inc."),
					Phone:        to.Ptr("1-245-534-2242"),
				},
				ContactTech: &armappservice.Contact{
					AddressMailing: &armappservice.Address{
						Address1:   to.Ptr("3400 State St"),
						City:       to.Ptr("Chicago"),
						Country:    to.Ptr("United States"),
						PostalCode: to.Ptr("67098"),
						State:      to.Ptr("IL"),
					},
					Email:        to.Ptr("tech@email.com"),
					Fax:          to.Ptr("1-245-534-2242"),
					JobTitle:     to.Ptr("Tech"),
					NameFirst:    to.Ptr("John"),
					NameLast:     to.Ptr("Doe"),
					NameMiddle:   to.Ptr(""),
					Organization: to.Ptr("Microsoft Inc."),
					Phone:        to.Ptr("1-245-534-2242"),
				},
				DNSType: to.Ptr(armappservice.DNSTypeDefaultDomainRegistrarDNS),
				Privacy: to.Ptr(false),
			},
		},
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2022-03-01/examples/ListDomainOwnershipIdentifiers.json
func ExampleDomainsClient_NewListOwnershipIdentifiersPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappservice.NewDomainsClient("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := client.NewListOwnershipIdentifiersPager("testrg123",
		"example.com",
		nil)
	for pager.More() {
		nextResult, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range nextResult.Value {
			// TODO: use page item
			_ = v
		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2022-03-01/examples/GetDomainOwnershipIdentifier.json
func ExampleDomainsClient_GetOwnershipIdentifier() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappservice.NewDomainsClient("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.GetOwnershipIdentifier(ctx,
		"testrg123",
		"example.com",
		"SampleOwnershipId",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2022-03-01/examples/CreateAppServiceDomainOwnershipIdentifier.json
func ExampleDomainsClient_CreateOrUpdateOwnershipIdentifier() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappservice.NewDomainsClient("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.CreateOrUpdateOwnershipIdentifier(ctx,
		"testrg123",
		"example.com",
		"SampleOwnershipId",
		armappservice.DomainOwnershipIdentifier{
			Properties: &armappservice.DomainOwnershipIdentifierProperties{
				OwnershipID: to.Ptr("SampleOwnershipId"),
			},
		},
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2022-03-01/examples/DeleteAppServiceDomainOwnershipIdentifier.json
func ExampleDomainsClient_DeleteOwnershipIdentifier() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappservice.NewDomainsClient("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = client.DeleteOwnershipIdentifier(ctx,
		"testrg123",
		"example.com",
		"ownershipIdentifier",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2022-03-01/examples/UpdateAppServiceDomainOwnershipIdentifier.json
func ExampleDomainsClient_UpdateOwnershipIdentifier() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappservice.NewDomainsClient("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.UpdateOwnershipIdentifier(ctx,
		"testrg123",
		"example.com",
		"SampleOwnershipId",
		armappservice.DomainOwnershipIdentifier{
			Properties: &armappservice.DomainOwnershipIdentifierProperties{
				OwnershipID: to.Ptr("SampleOwnershipId"),
			},
		},
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2022-03-01/examples/RenewDomain.json
func ExampleDomainsClient_Renew() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappservice.NewDomainsClient("3dddfa4f-cedf-4dc0-ba29-b6d1a69ab545", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = client.Renew(ctx,
		"RG",
		"example.com",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/web/resource-manager/Microsoft.DomainRegistration/stable/2022-03-01/examples/TransferOutDomain.json
func ExampleDomainsClient_TransferOut() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armappservice.NewDomainsClient("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.TransferOut(ctx,
		"testrg123",
		"example.com",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}
