/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.misc;

import geotrans3.exception.CoordinateConversionException;
import java.text.DecimalFormat;
import java.util.StringTokenizer;

public class StringToVal {
    private final int Lat_String = 1;
    private final int Long_String = 2;
    private int lonRange = 0;
    private boolean leadingZeros = false;
    private char latLonSeparator = (char)32;
    private int precision = 5;

    public void showLeadingZeros(boolean bl) {
        this.leadingZeros = bl;
    }

    public void setSeparator(char c) {
        this.latLonSeparator = c;
    }

    public char getSeparator() {
        return this.latLonSeparator;
    }

    public void setLongRange(int n) {
        this.lonRange = n;
    }

    public int getLongRange() {
        return this.lonRange;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public String longitudeToString(double d, boolean bl, boolean bl2, boolean bl3) throws CoordinateConversionException {
        try {
            double d2 = 0.0;
            double d3 = d;
            if (d3 > -1.0E-8 && d3 < 1.0E-8) {
                d3 = 0.0;
            }
            switch (this.lonRange) {
                case 0: {
                    if (d3 > 180.0) {
                        d2 = Math.abs(d3 - 360.0);
                        break;
                    }
                    d2 = Math.abs(d3);
                    break;
                }
                case 1: {
                    d2 = d3 < 0.0 ? d3 + 360.0 : d3;
                }
            }
            String string = this.degreesToString(d2, bl2, bl3, 2);
            switch (this.lonRange) {
                case 0: {
                    if (bl) {
                        if (d3 > 180.0 || d3 < 0.0) {
                            string = string + 'W';
                            break;
                        }
                        string = string + 'E';
                        break;
                    }
                    if (!(d3 > 180.0) && !(d3 < 0.0)) break;
                    String string2 = string;
                    string = '-' + string2;
                    break;
                }
                case 1: {
                    if (!bl) break;
                    string = string + 'E';
                }
            }
            return string;
        }
        catch (Exception exception) {
            throw new CoordinateConversionException("Longitude out of range\n");
        }
    }

    public String latitudeToString(double d, boolean bl, boolean bl2, boolean bl3) throws CoordinateConversionException {
        try {
            double d2 = Math.abs(d);
            double d3 = d;
            if (d3 > -1.0E-8 && d3 < 1.0E-8) {
                d3 = 0.0;
            }
            String string = this.degreesToString(d2, bl2, bl3, 1);
            if (bl) {
                string = d3 < 0.0 ? string + 'S' : string + 'N';
            } else if (d3 < 0.0) {
                String string2 = string;
                string = '-' + string2;
            }
            return string;
        }
        catch (Exception exception) {
            throw new CoordinateConversionException("Latitude out of range\n");
        }
    }

    private String degreesToString(double d, boolean bl, boolean bl2, int n) {
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        if (!bl || this.precision == 0) {
            d = this.roundDMS(d, this.precision);
            string = this.leadingZeros ? (n == 1 ? (Math.abs(d) < 10.0 ? "0" + Double.toString(d) : Double.toString(d)) : (Math.abs(d) < 10.0 ? "00" + Double.toString(d) : (Math.abs(d) < 100.0 ? "0" + Double.toString(d) : Double.toString(d)))) : Double.toString(d);
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setMinimumFractionDigits(this.precision);
            string = decimalFormat.format(Double.parseDouble(string));
            return this.addFractionZeros(string, this.precision);
        }
        if (bl && !bl2 || this.precision <= 2) {
            n2 = (int)d;
            d2 = (d - (double)n2) * 60.0;
            n3 = (int)(d2 = this.roundDMS(d2, this.precision - 2));
            if (n3 >= 60) {
                n3 -= 60;
                ++n2;
            }
            if (d2 >= 60.0) {
                d2 -= 60.0;
            }
            if (this.leadingZeros) {
                string = n == 1 ? (Math.abs(n2) < 10 ? "0" + Integer.toString(n2) + this.latLonSeparator : Integer.toString(n2) + this.latLonSeparator) : (Math.abs(n2) < 10 ? "00" + Integer.toString(n2) + this.latLonSeparator : (Math.abs(n2) < 100 ? "0" + Integer.toString(n2) + this.latLonSeparator : Integer.toString(n2) + this.latLonSeparator));
                string2 = n3 < 10 ? "0" + this.doubleToString(d2, this.precision - 2) : this.doubleToString(d2, this.precision - 2);
            } else {
                string = Integer.toString(n2) + this.latLonSeparator;
                string2 = this.doubleToString(d2, this.precision - 2);
            }
            if (this.precision <= 2) {
                return string + Integer.toString(n3);
            }
            return this.addFractionZeros(string + string2, this.precision - 2);
        }
        n2 = (int)d;
        d2 = (d - (double)n2) * 60.0;
        n3 = (int)d2;
        d3 = (d2 - (double)n3) * 60.0;
        n4 = (int)(d3 = this.roundDMS(d3, this.precision - 4));
        if (n4 >= 60) {
            n4 -= 60;
            if (++n3 >= 60) {
                ++n2;
                n3 -= 60;
            }
        }
        if (this.precision <= 4) {
            if (this.leadingZeros) {
                string = n == 1 ? (Math.abs(n2) < 10 ? "0" + Integer.toString(n2) + this.latLonSeparator : Integer.toString(n2) + this.latLonSeparator) : (Math.abs(n2) < 10 ? "00" + Integer.toString(n2) + this.latLonSeparator : (Math.abs(n2) < 100 ? "0" + Integer.toString(n2) + this.latLonSeparator : Integer.toString(n2) + this.latLonSeparator));
                string2 = n3 < 10 ? "0" + Integer.toString(n3) + this.latLonSeparator : Integer.toString(n3) + this.latLonSeparator;
                string3 = n4 < 10 ? "0" + Integer.toString(n4) : Integer.toString(n4);
            } else {
                string = Integer.toString(n2) + this.latLonSeparator;
                string2 = Integer.toString(n3) + this.latLonSeparator;
                string3 = Integer.toString(n4);
            }
            return string + string2 + string3;
        }
        if (d3 >= 60.0) {
            d3 -= 60.0;
        }
        if (this.leadingZeros) {
            string = n == 1 ? (Math.abs(n2) < 10 ? "0" + Long.toString(n2) + this.latLonSeparator : Long.toString(n2) + this.latLonSeparator) : (Math.abs(n2) < 10 ? "00" + Long.toString(n2) + this.latLonSeparator : (Math.abs(n2) < 100 ? "0" + Long.toString(n2) + this.latLonSeparator : Long.toString(n2) + this.latLonSeparator));
            string2 = n3 < 10 ? "0" + Long.toString(n3) + this.latLonSeparator : Long.toString(n3) + this.latLonSeparator;
            string3 = n4 < 10 ? "0" + this.doubleToString(d3, this.precision - 4) : this.doubleToString(d3, this.precision - 4);
        } else {
            string = Long.toString(n2) + this.latLonSeparator;
            string2 = Long.toString(n3) + this.latLonSeparator;
            string3 = this.doubleToString(d3, this.precision - 4);
        }
        return this.addFractionZeros(string + string2 + string3, this.precision - 4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double stringToLongitude(String string) throws CoordinateConversionException {
        try {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            int n = 1;
            char[] cArray = new char[string.length() + 1];
            if (string == null || string.length() <= 0) throw new CoordinateConversionException("A value must be entered\n");
            cArray = string.toCharArray();
            String string2 = string;
            if (!this.validCoord(cArray, 2)) throw new CoordinateConversionException("Longitude out of range\n");
            if (string.charAt(0) == '-') {
                n = -1;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " :/WwEeNnSs");
            int n2 = stringTokenizer.countTokens();
            String string3 = stringTokenizer.nextToken();
            if (string3 != null) {
                d2 = Double.parseDouble(string3);
            }
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (string3 != null) {
                    d3 = Double.parseDouble(string3);
                }
                if (stringTokenizer.hasMoreTokens() && (string3 = stringTokenizer.nextToken()) != null) {
                    d4 = Double.parseDouble(string3);
                }
            }
            int n3 = string.indexOf(78);
            int n4 = string.indexOf(110);
            int n5 = string.indexOf(83);
            int n6 = string.indexOf(115);
            if (n3 != -1 || n4 != -1 || n5 != -1 || n6 != -1) {
                throw new CoordinateConversionException("Invalid Hemisphere\n");
            }
            int n7 = string.indexOf(69);
            int n8 = string.indexOf(101);
            if ((n7 != -1 || n8 != -1) && n == -1) {
                throw new CoordinateConversionException("Mismatched sign and hemisphere \n");
            }
            int n9 = string.indexOf(87);
            int n10 = string.indexOf(119);
            if (n9 != -1 || n10 != -1) {
                if (n == -1) {
                    throw new CoordinateConversionException("Mismatched sign and hemisphere \n");
                }
                n = -1;
            }
            if (d4 >= 60.0 || d4 < 0.0) {
                throw new CoordinateConversionException("Seconds value out of range\n");
            }
            if (d3 >= 60.0 || d3 < 0.0) {
                throw new CoordinateConversionException("Minutes value out of range\n");
            }
            if (!(d2 != -180.0 && d2 != 360.0 || d3 == 0.0 && d4 == 0.0)) {
                throw new CoordinateConversionException("Longitude out of range\n");
            }
            d = (Math.abs(d2) + d3 / 60.0 + d4 / 3600.0) * (double)n;
            if (d > 180.0) {
                d -= 360.0;
            }
            if (d < -180.0) {
                d += 360.0;
            }
            if (!(d > 180.0) && !(d < -180.0)) return d;
            throw new CoordinateConversionException("Degrees value out of range\n");
        }
        catch (Exception exception) {
            throw new CoordinateConversionException(exception.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double stringToLatitude(String string) throws CoordinateConversionException {
        try {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            int n = 1;
            char[] cArray = new char[string.length() + 1];
            if (string == null) throw new CoordinateConversionException("A value must be entered\n");
            if (string.length() <= 0) throw new CoordinateConversionException("A value must be entered\n");
            cArray = string.toCharArray();
            String string2 = string;
            if (!this.validCoord(cArray, 1)) throw new CoordinateConversionException("Latitude out of range\n");
            if (string.charAt(0) == '-') {
                n = -1;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " :/WwEeNnSs");
            int n2 = stringTokenizer.countTokens();
            String string3 = stringTokenizer.nextToken();
            if (string3 != null) {
                d2 = Double.parseDouble(string3);
            }
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (string3 != null) {
                    d3 = Double.parseDouble(string3);
                }
                if (stringTokenizer.hasMoreTokens() && (string3 = stringTokenizer.nextToken()) != null) {
                    d4 = Double.parseDouble(string3);
                }
            }
            int n3 = string.indexOf(87);
            int n4 = string.indexOf(119);
            int n5 = string.indexOf(69);
            int n6 = string.indexOf(101);
            if (n3 != -1) throw new CoordinateConversionException("Invalid Hemisphere\n");
            if (n4 != -1) throw new CoordinateConversionException("Invalid Hemisphere\n");
            if (n5 != -1) throw new CoordinateConversionException("Invalid Hemisphere\n");
            if (n6 != -1) {
                throw new CoordinateConversionException("Invalid Hemisphere\n");
            }
            int n7 = string.indexOf(78);
            int n8 = string.indexOf(110);
            if ((n7 != -1 || n8 != -1) && n == -1) {
                throw new CoordinateConversionException("Mismatched sign and hemisphere \n");
            }
            int n9 = string.indexOf(83);
            int n10 = string.indexOf(115);
            if (n9 != -1 || n10 != -1) {
                if (n == -1) {
                    throw new CoordinateConversionException("Mismatched sign and hemisphere \n");
                }
                n = -1;
            }
            if (d4 >= 60.0) throw new CoordinateConversionException("Seconds value out of range\n");
            if (d4 < 0.0) {
                throw new CoordinateConversionException("Seconds value out of range\n");
            }
            if (d3 >= 60.0) throw new CoordinateConversionException("Minutes value out of range\n");
            if (d3 < 0.0) {
                throw new CoordinateConversionException("Minutes value out of range\n");
            }
            if (d2 < -90.0) throw new CoordinateConversionException("Degrees value out of range\n");
            if (d2 > 90.0) {
                throw new CoordinateConversionException("Degrees value out of range\n");
            }
            if (d2 != -90.0) {
                if (d2 != 90.0) return (Math.abs(d2) + d3 / 60.0 + d4 / 3600.0) * (double)n;
            }
            if (d3 != 0.0) throw new CoordinateConversionException("Latitude out of range\n");
            if (d4 == 0.0) return (Math.abs(d2) + d3 / 60.0 + d4 / 3600.0) * (double)n;
            throw new CoordinateConversionException("Latitude out of range\n");
        }
        catch (Exception exception) {
            throw new CoordinateConversionException(exception.getMessage());
        }
    }

    public String surveyFeetToString(double d) {
        return this.meterToString(d);
    }

    public String meterToString(double d) {
        double d2 = this.roundMeter(d);
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setGroupingUsed(false);
        if (this.precision > 4) {
            decimalFormat.setMinimumFractionDigits(this.precision - 5);
            decimalFormat.setMaximumFractionDigits(this.precision - 5);
        } else {
            decimalFormat.setMinimumFractionDigits(0);
            decimalFormat.setMaximumFractionDigits(0);
        }
        return decimalFormat.format(d2);
    }

    public String doubleToString(double d, int n) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setGroupingUsed(false);
        decimalFormat.setMinimumFractionDigits(n);
        decimalFormat.setMaximumFractionDigits(n);
        return decimalFormat.format(d);
    }

    public double stringToDouble(String string) throws CoordinateConversionException {
        double d = 0.0;
        if (string != null && string.length() > 0) {
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CoordinateConversionException("Entry must be numeric\n");
            }
        } else {
            throw new CoordinateConversionException("A value must be entered\n");
        }
        return d;
    }

    public int stringToInt(String string) throws CoordinateConversionException {
        int n = 0;
        if (string != null && string.length() > 0) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CoordinateConversionException("Entry must be numeric\n");
            }
        } else {
            throw new CoordinateConversionException("A value must be entered\n");
        }
        return n;
    }

    private boolean validCoord(char[] cArray, int n) {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        boolean bl3 = true;
        int n3 = 0;
        if (cArray != null) {
            int n4 = cArray.length;
            if (n3 < n4 && (cArray[n3] == '-' || cArray[n3] == '+')) {
                bl2 = true;
                ++n3;
            }
            while (n3 < n4 && bl3) {
                if (cArray[n3] == '.') {
                    if (bl) {
                        bl3 = false;
                        continue;
                    }
                    bl = true;
                    ++n3;
                    continue;
                }
                if (Character.isDigit(cArray[n3])) {
                    ++n3;
                    continue;
                }
                if (cArray[n3] == ' ' || cArray[n3] == '/' || cArray[n3] == ':') {
                    if (n2 >= 3) {
                        bl3 = false;
                        continue;
                    }
                    ++n3;
                    ++n2;
                    continue;
                }
                if (Character.isLetter(cArray[n3])) {
                    String string = "";
                    string = String.valueOf(cArray[n3]);
                    if ((string.equalsIgnoreCase("N") || string.equalsIgnoreCase("S")) && n == 1 || (string.equalsIgnoreCase("W") || string.equalsIgnoreCase("E")) && n == 2) {
                        if (bl2) {
                            bl3 = false;
                        }
                        if (++n3 == n4) continue;
                        bl3 = false;
                        continue;
                    }
                    bl3 = false;
                    continue;
                }
                bl3 = false;
            }
        }
        return bl3;
    }

    private double roundMeter(double d) {
        double d2 = 1.0;
        long l = 0L;
        int n = 1;
        switch (this.precision) {
            case 0: {
                d2 = 100000.0;
                break;
            }
            case 1: {
                d2 = 10000.0;
                break;
            }
            case 2: {
                d2 = 1000.0;
                break;
            }
            case 3: {
                d2 = 100.0;
                break;
            }
            case 4: {
                d2 = 10.0;
                break;
            }
            case 5: {
                d2 = 1.0;
                break;
            }
            case 6: {
                d2 = 0.1;
                break;
            }
            case 7: {
                d2 = 0.01;
                break;
            }
            case 8: {
                d2 = 0.001;
            }
        }
        if (d < 0.0) {
            n = -1;
        }
        double d3 = Math.abs(d / d2);
        double d4 = (long)d3;
        l = (long)d3;
        double d5 = d3 - d4;
        if (d5 > 0.5 || d5 == 0.5 && l % 2L == 1L) {
            d4 += 1.0;
        }
        double d6 = d4 * d2 * (double)n;
        return d6;
    }

    private double roundDMS(double d, int n) {
        double d2 = 0.0;
        d2 = d * Math.pow(10.0, n);
        double d3 = (long)d2;
        double d4 = d2 - d3;
        if (d2 - d3 > 0.5 || d2 - d3 == 0.5 && d3 % 2.0 == 1.0) {
            return (d3 + 1.0) / Math.pow(10.0, n);
        }
        return d3 / Math.pow(10.0, n);
    }

    private String addFractionZeros(String string, int n) {
        int n2 = string.length();
        int n3 = string.indexOf(".", 0) + 1;
        for (int i = n2 - n3; i < n; ++i) {
            string = string + "0";
        }
        return string;
    }
}

