/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.gui;

import geotrans3.coordinates.Accuracy;
import geotrans3.coordinates.BNGCoordinates;
import geotrans3.coordinates.CartesianCoordinates;
import geotrans3.coordinates.CoordinateTuple;
import geotrans3.coordinates.GARSCoordinates;
import geotrans3.coordinates.GEOREFCoordinates;
import geotrans3.coordinates.GeodeticCoordinates;
import geotrans3.coordinates.MGRSorUSNGCoordinates;
import geotrans3.coordinates.MapProjectionCoordinates;
import geotrans3.coordinates.StringCoordinates;
import geotrans3.coordinates.UPSCoordinates;
import geotrans3.coordinates.UTMCoordinates;
import geotrans3.exception.CoordinateConversionException;
import geotrans3.misc.FormatOptions;
import geotrans3.misc.Source;
import geotrans3.misc.StringHandler;
import geotrans3.utility.Platform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;

public class CoordPanel
extends JPanel {
    private StringHandler stringHandler;
    private FormatOptions formatOptions;
    private boolean useNSEW;
    private boolean useMinutes;
    private boolean useSeconds;
    private char hemisphere;
    private long zone;
    private boolean usePrevAccuracies;
    private boolean _3dConversion;
    private Accuracy currentAccuracy;
    private int HeightUnitType;
    private JLabel _2CoordFieldsLabelA;
    private JLabel _2CoordFieldsLabelB;
    private JPanel _2CoordFieldsPanel;
    private JTextField _2CoordFieldsTextFieldA;
    private JTextField _2CoordFieldsTextFieldB;
    private JLabel _3CoordFieldsLabelA;
    private JLabel _3CoordFieldsLabelB;
    private JLabel _3CoordFieldsLabelC;
    private JLabel _3CoordFieldsLabelUnit_C;
    private Font _3CoordFieldsLabelUnitFont_C;
    private JPanel _3CoordFieldsPanel;
    private JTextField _3CoordFieldsTextFieldA;
    private JTextField _3CoordFieldsTextFieldB;
    private JTextField _3CoordFieldsTextFieldC;
    private JLabel ce90Label;
    private JTextField ce90TextField;
    private JLayeredPane coordLayeredPane;
    private JPanel errorsPanel;
    private JPanel inputErrorPanel;
    private JLabel le90Label;
    private JTextField le90TextField;
    private JPanel outputErrorPanel;
    private JLabel se90Label;
    private JTextField se90TextField;
    private JComboBox sourcesComboBox;
    private JLabel sourcesLabel;
    private JLabel tempLabel1;
    private JLabel tempLabel2;
    private JTextField tempTextField1;
    private JTextField tempTextField2;

    public void setHeightType(int n) {
        this.HeightUnitType = n;
    }

    public CoordPanel(FormatOptions formatOptions, StringHandler stringHandler) {
        this.formatOptions = formatOptions;
        this.stringHandler = stringHandler;
        this.usePrevAccuracies = false;
        this._3dConversion = false;
        this.currentAccuracy = new Accuracy();
        this.setFormat();
        this.initComponents();
        this.tempLabel1.setVisible(false);
        this.tempLabel2.setVisible(false);
        this.tempTextField1.setVisible(false);
        this.tempTextField2.setVisible(false);
        if (Platform.isJavaV1_3) {
            this._3CoordFieldsLabelA.setForeground(Color.black);
            this._3CoordFieldsLabelB.setForeground(Color.black);
            this._3CoordFieldsLabelC.setForeground(Color.black);
            this._3CoordFieldsLabelUnit_C.setForeground(Color.black);
            this._2CoordFieldsLabelA.setForeground(Color.black);
            this._2CoordFieldsLabelB.setForeground(Color.black);
            this.ce90Label.setForeground(Color.black);
            this.le90Label.setForeground(Color.black);
            this.se90Label.setForeground(Color.black);
            this.sourcesLabel.setForeground(Color.black);
        }
        this.setPanelSizes();
        this.fillAccuracyList();
        if (Platform.isUnix) {
            this._3CoordFieldsLabelA.setFont(new Font("Dialog", 1, 10));
            this._3CoordFieldsLabelB.setFont(new Font("Dialog", 1, 10));
            this._3CoordFieldsLabelC.setFont(new Font("Dialog", 1, 10));
            this._3CoordFieldsLabelUnit_C.setFont(new Font("Dialog", 1, 10));
            this._2CoordFieldsLabelA.setFont(new Font("Dialog", 1, 10));
            this._2CoordFieldsLabelB.setFont(new Font("Dialog", 1, 10));
            this.ce90Label.setFont(new Font("Dialog", 1, 10));
            this.le90Label.setFont(new Font("Dialog", 1, 10));
            this.se90Label.setFont(new Font("Dialog", 1, 10));
            this.sourcesLabel.setFont(new Font("Dialog", 1, 10));
            this.sourcesComboBox.setFont(new Font("Dialog", 1, 10));
            this.sourcesComboBox.setMaximumSize(new Dimension(265, 22));
            this.sourcesComboBox.setMinimumSize(new Dimension(265, 22));
            this.sourcesComboBox.setPreferredSize(new Dimension(265, 22));
            this.ce90TextField.setToolTipText("90% CE");
            this.le90TextField.setToolTipText("90% LE");
            this.se90TextField.setToolTipText("90% SE");
        }
    }

    private void initComponents() {
        this.coordLayeredPane = new JLayeredPane();
        this._3CoordFieldsPanel = new JPanel();
        this._3CoordFieldsLabelA = new JLabel();
        this._3CoordFieldsLabelB = new JLabel();
        this._3CoordFieldsLabelC = new JLabel();
        this._3CoordFieldsLabelUnit_C = new JLabel();
        this._3CoordFieldsLabelUnitFont_C = this._3CoordFieldsLabelUnit_C.getFont();
        this._3CoordFieldsTextFieldA = new JTextField();
        this._3CoordFieldsTextFieldB = new JTextField();
        this._3CoordFieldsTextFieldC = new JTextField();
        this._2CoordFieldsPanel = new JPanel();
        this._2CoordFieldsLabelA = new JLabel();
        this._2CoordFieldsLabelB = new JLabel();
        this._2CoordFieldsTextFieldA = new JTextField();
        this._2CoordFieldsTextFieldB = new JTextField();
        this.tempLabel1 = new JLabel();
        this.tempLabel2 = new JLabel();
        this.tempTextField1 = new JTextField();
        this.tempTextField2 = new JTextField();
        this.errorsPanel = new JPanel();
        this.outputErrorPanel = new JPanel();
        this.ce90Label = new JLabel();
        this.le90Label = new JLabel();
        this.se90Label = new JLabel();
        this.ce90TextField = new JTextField();
        this.le90TextField = new JTextField();
        this.se90TextField = new JTextField();
        this.inputErrorPanel = new JPanel();
        this.sourcesLabel = new JLabel();
        this.sourcesComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(439, 80));
        this.setPreferredSize(new Dimension(439, 80));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                CoordPanel.this.formComponentResized(componentEvent);
            }
        });
        this.coordLayeredPane.setMaximumSize(new Dimension(439, 36));
        this.coordLayeredPane.setMinimumSize(new Dimension(439, 38));
        this.coordLayeredPane.setPreferredSize(new Dimension(460, 38));
        this.coordLayeredPane.setOpaque(true);
        this._3CoordFieldsPanel.setLayout(null);
        this._3CoordFieldsPanel.setMaximumSize(new Dimension(339, 36));
        this._3CoordFieldsPanel.setMinimumSize(new Dimension(339, 36));
        this._3CoordFieldsPanel.setPreferredSize(new Dimension(339, 36));
        this._3CoordFieldsPanel.setOpaque(false);
        this._3CoordFieldsLabelA.setText("X (m):");
        this._3CoordFieldsLabelA.setMaximumSize(new Dimension(105, 16));
        this._3CoordFieldsLabelA.setMinimumSize(new Dimension(105, 16));
        this._3CoordFieldsLabelA.setPreferredSize(new Dimension(105, 16));
        this._3CoordFieldsLabelA.setOpaque(true);
        this._3CoordFieldsPanel.add(this._3CoordFieldsLabelA);
        this._3CoordFieldsLabelA.setBounds(0, 0, 138, 18);
        this._3CoordFieldsLabelB.setText("Y (m):");
        this._3CoordFieldsLabelB.setMaximumSize(new Dimension(105, 16));
        this._3CoordFieldsLabelB.setMinimumSize(new Dimension(105, 16));
        this._3CoordFieldsLabelB.setPreferredSize(new Dimension(105, 16));
        this._3CoordFieldsLabelB.setOpaque(true);
        this._3CoordFieldsPanel.add(this._3CoordFieldsLabelB);
        this._3CoordFieldsLabelB.setBounds(150, 0, 138, 18);
        this._3CoordFieldsLabelC.setText("Z");
        this._3CoordFieldsLabelC.setHorizontalAlignment(4);
        this._3CoordFieldsLabelC.setMaximumSize(new Dimension(105, 16));
        this._3CoordFieldsLabelC.setMinimumSize(new Dimension(105, 16));
        this._3CoordFieldsLabelC.setPreferredSize(new Dimension(105, 16));
        this._3CoordFieldsLabelC.setOpaque(true);
        this._3CoordFieldsPanel.add(this._3CoordFieldsLabelC);
        this._3CoordFieldsLabelC.setBounds(300, 0, 7, 18);
        this._3CoordFieldsLabelUnit_C.setText("(m):");
        if (UIManager.getLookAndFeel().getName().equalsIgnoreCase("Metal")) {
            this._3CoordFieldsLabelUnit_C.setFont(this._3CoordFieldsLabelUnitFont_C);
        } else {
            this._3CoordFieldsLabelUnit_C.setFont(this._3CoordFieldsLabelUnit_C.getFont().deriveFont(0));
        }
        this._3CoordFieldsLabelUnit_C.setMaximumSize(new Dimension(105, 16));
        this._3CoordFieldsLabelUnit_C.setMinimumSize(new Dimension(105, 16));
        this._3CoordFieldsLabelUnit_C.setPreferredSize(new Dimension(105, 16));
        this._3CoordFieldsLabelUnit_C.setOpaque(true);
        this._3CoordFieldsPanel.add(this._3CoordFieldsLabelUnit_C);
        this._3CoordFieldsLabelUnit_C.setBounds(310, 0, 30, 18);
        this._3CoordFieldsTextFieldA.setText("0.0");
        this._3CoordFieldsTextFieldA.setBorder(new BevelBorder(1));
        this._3CoordFieldsTextFieldA.setMinimumSize(new Dimension(105, 20));
        this._3CoordFieldsTextFieldA.setPreferredSize(new Dimension(105, 20));
        this._3CoordFieldsPanel.add(this._3CoordFieldsTextFieldA);
        this._3CoordFieldsTextFieldA.setBounds(0, 18, 138, 18);
        this._3CoordFieldsTextFieldB.setText("0.0");
        this._3CoordFieldsTextFieldB.setBorder(new BevelBorder(1));
        this._3CoordFieldsTextFieldB.setMinimumSize(new Dimension(105, 20));
        this._3CoordFieldsTextFieldB.setPreferredSize(new Dimension(105, 20));
        this._3CoordFieldsPanel.add(this._3CoordFieldsTextFieldB);
        this._3CoordFieldsTextFieldB.setBounds(150, 18, 138, 18);
        this._3CoordFieldsTextFieldC.setText("0.0");
        this._3CoordFieldsTextFieldC.setBorder(new BevelBorder(1));
        this._3CoordFieldsTextFieldC.setMinimumSize(new Dimension(105, 20));
        this._3CoordFieldsTextFieldC.setPreferredSize(new Dimension(105, 20));
        this._3CoordFieldsPanel.add(this._3CoordFieldsTextFieldC);
        this._3CoordFieldsTextFieldC.setBounds(300, 18, 138, 18);
        this._3CoordFieldsPanel.setBounds(2, 2, 439, 37);
        this.coordLayeredPane.add((Component)this._3CoordFieldsPanel, JLayeredPane.DEFAULT_LAYER);
        this._2CoordFieldsPanel.setLayout(new GridBagLayout());
        this._2CoordFieldsPanel.setMaximumSize(new Dimension(229, 36));
        this._2CoordFieldsPanel.setMinimumSize(new Dimension(229, 36));
        this._2CoordFieldsPanel.setPreferredSize(new Dimension(229, 36));
        this._2CoordFieldsPanel.setOpaque(false);
        this._2CoordFieldsLabelA.setText("Easting / X (m):");
        this._2CoordFieldsLabelA.setAlignmentX(1.0f);
        this._2CoordFieldsLabelA.setMaximumSize(new Dimension(106, 16));
        this._2CoordFieldsLabelA.setMinimumSize(new Dimension(106, 16));
        this._2CoordFieldsLabelA.setPreferredSize(new Dimension(106, 16));
        this._2CoordFieldsLabelA.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this._2CoordFieldsPanel.add((Component)this._2CoordFieldsLabelA, gridBagConstraints);
        this._2CoordFieldsLabelB.setText("Northing / Y (m):");
        this._2CoordFieldsLabelB.setMaximumSize(new Dimension(106, 16));
        this._2CoordFieldsLabelB.setMinimumSize(new Dimension(106, 16));
        this._2CoordFieldsLabelB.setPreferredSize(new Dimension(106, 16));
        this._2CoordFieldsLabelB.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this._2CoordFieldsPanel.add((Component)this._2CoordFieldsLabelB, gridBagConstraints);
        this._2CoordFieldsTextFieldA.setText("0.0");
        this._2CoordFieldsTextFieldA.setAlignmentX(1.0f);
        this._2CoordFieldsTextFieldA.setBorder(new BevelBorder(1));
        this._2CoordFieldsTextFieldA.setMargin(new Insets(0, 0, 5, 0));
        this._2CoordFieldsTextFieldA.setMinimumSize(new Dimension(106, 20));
        this._2CoordFieldsTextFieldA.setPreferredSize(new Dimension(106, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 1, 6);
        this._2CoordFieldsPanel.add((Component)this._2CoordFieldsTextFieldA, gridBagConstraints);
        this._2CoordFieldsTextFieldB.setText("0.0");
        this._2CoordFieldsTextFieldB.setBorder(new BevelBorder(1));
        this._2CoordFieldsTextFieldB.setMargin(new Insets(0, 0, 5, 0));
        this._2CoordFieldsTextFieldB.setMinimumSize(new Dimension(106, 20));
        this._2CoordFieldsTextFieldB.setPreferredSize(new Dimension(106, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 1, 6);
        this._2CoordFieldsPanel.add((Component)this._2CoordFieldsTextFieldB, gridBagConstraints);
        this.tempLabel1.setText("Easting / X (m):");
        this.tempLabel1.setAlignmentX(1.0f);
        this.tempLabel1.setMaximumSize(new Dimension(106, 16));
        this.tempLabel1.setMinimumSize(new Dimension(106, 16));
        this.tempLabel1.setPreferredSize(new Dimension(106, 16));
        this.tempLabel1.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 6);
        this._2CoordFieldsPanel.add((Component)this.tempLabel1, gridBagConstraints);
        this.tempLabel2.setText("Northing / Y (m):");
        this.tempLabel2.setMaximumSize(new Dimension(106, 16));
        this.tempLabel2.setMinimumSize(new Dimension(106, 16));
        this.tempLabel2.setPreferredSize(new Dimension(106, 16));
        this.tempLabel2.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this._2CoordFieldsPanel.add((Component)this.tempLabel2, gridBagConstraints);
        this.tempTextField1.setText("0.0");
        this.tempTextField1.setAlignmentX(1.0f);
        this.tempTextField1.setBorder(new BevelBorder(1));
        this.tempTextField1.setMargin(new Insets(0, 0, 5, 0));
        this.tempTextField1.setMinimumSize(new Dimension(106, 20));
        this.tempTextField1.setPreferredSize(new Dimension(106, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 1, 6);
        this._2CoordFieldsPanel.add((Component)this.tempTextField1, gridBagConstraints);
        this.tempTextField2.setText("0.0");
        this.tempTextField2.setBorder(new BevelBorder(1));
        this.tempTextField2.setMargin(new Insets(0, 0, 5, 0));
        this.tempTextField2.setMinimumSize(new Dimension(106, 20));
        this.tempTextField2.setPreferredSize(new Dimension(106, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 1, 0);
        this._2CoordFieldsPanel.add((Component)this.tempTextField2, gridBagConstraints);
        this._2CoordFieldsPanel.setBounds(4, 2, 460, 45);
        this.coordLayeredPane.add((Component)this._2CoordFieldsPanel, JLayeredPane.DEFAULT_LAYER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        this.add((Component)this.coordLayeredPane, gridBagConstraints);
        this.errorsPanel.setLayout(new GridBagLayout());
        this.errorsPanel.setMinimumSize(new Dimension(460, 40));
        this.errorsPanel.setPreferredSize(new Dimension(460, 40));
        this.errorsPanel.setOpaque(false);
        this.outputErrorPanel.setLayout(new GridBagLayout());
        this.outputErrorPanel.setMinimumSize(new Dimension(170, 40));
        this.outputErrorPanel.setPreferredSize(new Dimension(170, 40));
        this.outputErrorPanel.setOpaque(false);
        this.ce90Label.setText("90% CE:");
        this.ce90Label.setMaximumSize(new Dimension(48, 16));
        this.ce90Label.setMinimumSize(new Dimension(48, 16));
        this.ce90Label.setPreferredSize(new Dimension(48, 16));
        this.ce90Label.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.outputErrorPanel.add((Component)this.ce90Label, gridBagConstraints);
        this.le90Label.setText("90% LE:");
        this.le90Label.setMaximumSize(new Dimension(48, 16));
        this.le90Label.setMinimumSize(new Dimension(48, 16));
        this.le90Label.setPreferredSize(new Dimension(48, 16));
        this.le90Label.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.outputErrorPanel.add((Component)this.le90Label, gridBagConstraints);
        this.se90Label.setText("90% SE:");
        this.se90Label.setMaximumSize(new Dimension(48, 16));
        this.se90Label.setMinimumSize(new Dimension(48, 16));
        this.se90Label.setPreferredSize(new Dimension(48, 16));
        this.se90Label.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.outputErrorPanel.add((Component)this.se90Label, gridBagConstraints);
        this.ce90TextField.setToolTipText("");
        this.ce90TextField.setBorder(new BevelBorder(1));
        this.ce90TextField.setMinimumSize(new Dimension(48, 20));
        this.ce90TextField.setPreferredSize(new Dimension(48, 20));
        this.ce90TextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                CoordPanel.this.accuracyTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.outputErrorPanel.add((Component)this.ce90TextField, gridBagConstraints);
        this.le90TextField.setToolTipText("");
        this.le90TextField.setBorder(new BevelBorder(1));
        this.le90TextField.setMinimumSize(new Dimension(48, 20));
        this.le90TextField.setPreferredSize(new Dimension(48, 20));
        this.le90TextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                CoordPanel.this.accuracyTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.outputErrorPanel.add((Component)this.le90TextField, gridBagConstraints);
        this.se90TextField.setToolTipText("");
        this.se90TextField.setBorder(new BevelBorder(1));
        this.se90TextField.setMinimumSize(new Dimension(48, 20));
        this.se90TextField.setPreferredSize(new Dimension(48, 20));
        this.se90TextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                CoordPanel.this.accuracyTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.outputErrorPanel.add((Component)this.se90TextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 5);
        this.errorsPanel.add((Component)this.outputErrorPanel, gridBagConstraints);
        this.inputErrorPanel.setLayout(new GridBagLayout());
        this.inputErrorPanel.setMinimumSize(new Dimension(265, 40));
        this.inputErrorPanel.setPreferredSize(new Dimension(265, 40));
        this.sourcesLabel.setHorizontalAlignment(2);
        this.sourcesLabel.setText("Sources:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.inputErrorPanel.add((Component)this.sourcesLabel, gridBagConstraints);
        this.sourcesComboBox.setMinimumSize(new Dimension(265, 23));
        this.sourcesComboBox.setPreferredSize(new Dimension(265, 23));
        this.sourcesComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoordPanel.this.sourcesComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.inputErrorPanel.add((Component)this.sourcesComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 3);
        this.errorsPanel.add((Component)this.inputErrorPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        this.add((Component)this.errorsPanel, gridBagConstraints);
    }

    private void accuracyTextFieldKeyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c != '\n') {
            this.usePrevAccuracies = false;
        }
    }

    private void sourcesComboBoxActionPerformed(ActionEvent actionEvent) {
        this.updateAccuracy(false);
    }

    private void formComponentResized(ComponentEvent componentEvent) {
        this.setPanelSizes();
    }

    private void fillAccuracyList() {
        try {
            long l = Source.count();
            int n = 0;
            while ((long)n < l) {
                this.sourcesComboBox.addItem(Source.name(n));
                ++n;
            }
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(new JFrame(), coordinateConversionException.getMessage());
        }
    }

    private void setOneCoord() {
        this._2CoordFieldsPanel.setVisible(false);
        this._3CoordFieldsPanel.setVisible(true);
        this.coordLayeredPane.moveToFront(this._3CoordFieldsPanel);
        this._3CoordFieldsLabelA.setVisible(false);
        this._3CoordFieldsLabelC.setVisible(false);
        this._3CoordFieldsLabelUnit_C.setVisible(false);
        this._3CoordFieldsTextFieldA.setVisible(false);
        this._3CoordFieldsTextFieldC.setVisible(false);
        this._3CoordFieldsLabelB.setText("Coordinate String:");
    }

    private void setTwoCoords() {
        this._3CoordFieldsPanel.setVisible(false);
        this._2CoordFieldsPanel.setVisible(true);
        this.coordLayeredPane.moveToFront(this._2CoordFieldsPanel);
        this._2CoordFieldsLabelA.setText("Easting / X (m):");
        this._2CoordFieldsLabelB.setText("Northing / Y (m):");
        this._2CoordFieldsTextFieldA.setText("0");
        this._2CoordFieldsTextFieldB.setText("0");
    }

    private void setThreeCoords() {
        this._2CoordFieldsPanel.setVisible(false);
        this._3CoordFieldsPanel.setVisible(true);
        this.coordLayeredPane.moveToFront(this._3CoordFieldsPanel);
        this._3CoordFieldsLabelA.setVisible(true);
        this._3CoordFieldsLabelC.setVisible(true);
        this._3CoordFieldsLabelUnit_C.setVisible(true);
        this._3CoordFieldsTextFieldA.setVisible(true);
        this._3CoordFieldsTextFieldC.setVisible(true);
        this.setHeightFieldEditable();
        this._3CoordFieldsLabelA.setText("X (m):");
        this._3CoordFieldsLabelB.setText("Y (m):");
        this._3CoordFieldsLabelC.setText("Z");
        this._3CoordFieldsLabelC.setBounds(300, 0, 7, 18);
        this._3CoordFieldsLabelUnit_C.setText("(m):");
        if (UIManager.getLookAndFeel().getName().equalsIgnoreCase("Metal")) {
            this._3CoordFieldsLabelUnit_C.setFont(this._3CoordFieldsLabelUnitFont_C);
        } else {
            this._3CoordFieldsLabelUnit_C.setFont(this._3CoordFieldsLabelUnit_C.getFont().deriveFont(0));
        }
        this._3CoordFieldsLabelUnit_C.setBounds(310, 0, 30, 18);
        this._3CoordFieldsTextFieldA.setText("0");
        this._3CoordFieldsTextFieldB.setText("0");
        this._3CoordFieldsTextFieldC.setText("0");
    }

    private void setFormat() {
        this.useNSEW = this.formatOptions.getUseNSEW();
        this.useMinutes = this.formatOptions.getUseMinutes();
        this.useSeconds = this.formatOptions.getUseSeconds();
        this.stringHandler.setPrecision(this.formatOptions.getPrecision());
    }

    private void setPanelSizes() {
        Dimension dimension = new Dimension();
        dimension = this.coordLayeredPane.getSize();
        this._2CoordFieldsPanel.setBounds(0, 0, dimension.width, dimension.height);
        this._3CoordFieldsPanel.setBounds(0, 0, dimension.width, dimension.height);
        this._2CoordFieldsPanel.updateUI();
        this._3CoordFieldsPanel.updateUI();
    }

    public CoordinateTuple initTargetCoordinates(int n) throws CoordinateConversionException {
        switch (n) {
            case 0: {
                return new MapProjectionCoordinates(0);
            }
            case 1: {
                return new MapProjectionCoordinates(1);
            }
            case 2: {
                return new MapProjectionCoordinates(2);
            }
            case 4: {
                return new MapProjectionCoordinates(4);
            }
            case 5: {
                return new MapProjectionCoordinates(5);
            }
            case 6: {
                return new MapProjectionCoordinates(6);
            }
            case 7: {
                return new MapProjectionCoordinates(7);
            }
            case 8: {
                return new MapProjectionCoordinates(8);
            }
            case 13: {
                return new MapProjectionCoordinates(13);
            }
            case 14: {
                return new MapProjectionCoordinates(14);
            }
            case 15: {
                return new MapProjectionCoordinates(15);
            }
            case 17: {
                return new MapProjectionCoordinates(17);
            }
            case 18: {
                return new MapProjectionCoordinates(18);
            }
            case 20: {
                return new MapProjectionCoordinates(20);
            }
            case 21: {
                return new MapProjectionCoordinates(21);
            }
            case 23: {
                return new MapProjectionCoordinates(23);
            }
            case 22: {
                return new MapProjectionCoordinates(22);
            }
            case 24: {
                return new MapProjectionCoordinates(24);
            }
            case 25: {
                return new MapProjectionCoordinates(25);
            }
            case 26: {
                return new MapProjectionCoordinates(26);
            }
            case 27: {
                return new MapProjectionCoordinates(27);
            }
            case 28: {
                return new MapProjectionCoordinates(28);
            }
            case 29: {
                return new MapProjectionCoordinates(29);
            }
            case 30: {
                return new MapProjectionCoordinates(30);
            }
            case 31: {
                return new MapProjectionCoordinates(31);
            }
            case 32: {
                return new MapProjectionCoordinates(32);
            }
            case 36: {
                return new MapProjectionCoordinates(36);
            }
            case 10: {
                return new GeodeticCoordinates(10);
            }
            case 9: {
                return new CartesianCoordinates(9);
            }
            case 16: {
                return new CartesianCoordinates(16);
            }
            case 3: {
                return new BNGCoordinates(3, this.formatOptions.getPrecision());
            }
            case 12: {
                return new GARSCoordinates(12, this.formatOptions.getPrecision());
            }
            case 11: {
                return new GEOREFCoordinates(11, this.formatOptions.getPrecision());
            }
            case 19: 
            case 38: {
                return new MGRSorUSNGCoordinates(19, this.formatOptions.getPrecision());
            }
            case 35: {
                return new MGRSorUSNGCoordinates(35, this.formatOptions.getPrecision());
            }
            case 33: {
                return new UPSCoordinates(33);
            }
            case 34: {
                return new UTMCoordinates(34);
            }
            case 37: {
                return new MapProjectionCoordinates(37);
            }
        }
        throw new CoordinateConversionException("Invalid coordinate type");
    }

    public boolean setCoordinates(int n, int n2, int n3, CoordinateTuple coordinateTuple) {
        boolean bl = true;
        this.setFormat();
        try {
            switch (n3) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 36: 
                case 37: {
                    MapProjectionCoordinates mapProjectionCoordinates = (MapProjectionCoordinates)coordinateTuple;
                    this._2CoordFieldsTextFieldA.setText(this.stringHandler.meterToString(mapProjectionCoordinates.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.stringHandler.meterToString(mapProjectionCoordinates.getNorthing()));
                    break;
                }
                case 3: 
                case 11: 
                case 12: 
                case 19: 
                case 35: {
                    StringCoordinates stringCoordinates = (StringCoordinates)coordinateTuple;
                    this._3CoordFieldsTextFieldB.setText(stringCoordinates.getCoordinateString());
                    break;
                }
                case 38: {
                    StringCoordinates stringCoordinates = (StringCoordinates)coordinateTuple;
                    String string = stringCoordinates.getCoordinateString();
                    if (this.formatOptions.getPrecision() == 0) {
                        this._3CoordFieldsTextFieldB.setText(string + "00");
                        break;
                    }
                    this._3CoordFieldsTextFieldB.setText(string);
                    break;
                }
                case 9: 
                case 16: {
                    CartesianCoordinates cartesianCoordinates = (CartesianCoordinates)coordinateTuple;
                    this._3CoordFieldsTextFieldA.setText(this.stringHandler.meterToString(cartesianCoordinates.getX()));
                    this._3CoordFieldsTextFieldB.setText(this.stringHandler.meterToString(cartesianCoordinates.getY()));
                    this._3CoordFieldsTextFieldC.setText(this.stringHandler.meterToString(cartesianCoordinates.getZ()));
                    break;
                }
                case 10: {
                    GeodeticCoordinates geodeticCoordinates = (GeodeticCoordinates)coordinateTuple;
                    this._3CoordFieldsTextFieldA.setText(this.stringHandler.longitudeToString(geodeticCoordinates.getLongitude() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3CoordFieldsTextFieldB.setText(this.stringHandler.latitudeToString(geodeticCoordinates.getLatitude() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    if (this.formatOptions.getHeightUnit() == 1) {
                        double d = 0.3048006096012192;
                        this._3CoordFieldsTextFieldC.setText(this.stringHandler.surveyFeetToString(geodeticCoordinates.getHeight() / d));
                        break;
                    }
                    this._3CoordFieldsTextFieldC.setText(this.stringHandler.meterToString(geodeticCoordinates.getHeight()));
                    break;
                }
                case 33: {
                    UPSCoordinates uPSCoordinates = (UPSCoordinates)coordinateTuple;
                    this.hemisphere = uPSCoordinates.getHemisphere();
                    this._2CoordFieldsTextFieldA.setText(this.stringHandler.meterToString(uPSCoordinates.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.stringHandler.meterToString(uPSCoordinates.getNorthing()));
                    break;
                }
                case 34: {
                    UTMCoordinates uTMCoordinates = (UTMCoordinates)coordinateTuple;
                    this.hemisphere = uTMCoordinates.getHemisphere();
                    this.zone = uTMCoordinates.getZone();
                    this._2CoordFieldsTextFieldA.setText(this.stringHandler.meterToString(uTMCoordinates.getEasting()));
                    this._2CoordFieldsTextFieldB.setText(this.stringHandler.meterToString(uTMCoordinates.getNorthing()));
                    break;
                }
                default: {
                    throw new CoordinateConversionException("Invalid coordinate type");
                }
            }
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.setErrorMessage(true, coordinateConversionException.getMessage());
            bl = false;
        }
        return bl;
    }

    public CoordinateTuple getCoordinates(int n, int n2, int n3) throws CoordinateConversionException {
        switch (n3) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: {
                MapProjectionCoordinates mapProjectionCoordinates = new MapProjectionCoordinates(n3, this.stringHandler.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.stringHandler.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                return mapProjectionCoordinates;
            }
            case 19: {
                MGRSorUSNGCoordinates mGRSorUSNGCoordinates = new MGRSorUSNGCoordinates(n3, this._3CoordFieldsTextFieldB.getText().trim(), this.formatOptions.getPrecision());
                return mGRSorUSNGCoordinates;
            }
            case 3: {
                BNGCoordinates bNGCoordinates = new BNGCoordinates(n3, this._3CoordFieldsTextFieldB.getText().trim(), this.formatOptions.getPrecision());
                return bNGCoordinates;
            }
            case 12: {
                GARSCoordinates gARSCoordinates = new GARSCoordinates(n3, this._3CoordFieldsTextFieldB.getText().trim(), this.formatOptions.getPrecision());
                return gARSCoordinates;
            }
            case 11: {
                GEOREFCoordinates gEOREFCoordinates = new GEOREFCoordinates(n3, this._3CoordFieldsTextFieldB.getText().trim(), this.formatOptions.getPrecision());
                return gEOREFCoordinates;
            }
            case 35: {
                MGRSorUSNGCoordinates mGRSorUSNGCoordinates = new MGRSorUSNGCoordinates(n3, this._3CoordFieldsTextFieldB.getText().trim(), this.formatOptions.getPrecision());
                return mGRSorUSNGCoordinates;
            }
            case 38: {
                String string = this._3CoordFieldsTextFieldB.getText().trim();
                int n4 = string.length();
                MGRSorUSNGCoordinates mGRSorUSNGCoordinates = string.charAt(n4 - 1) == '0' && string.charAt(n4 - 2) == '0' ? new MGRSorUSNGCoordinates(19, string.substring(0, n4 - 2), this.formatOptions.getPrecision()) : new MGRSorUSNGCoordinates(19, string, this.formatOptions.getPrecision());
                return mGRSorUSNGCoordinates;
            }
            case 9: 
            case 16: {
                CartesianCoordinates cartesianCoordinates = new CartesianCoordinates(n3, this.stringHandler.stringToDouble(this._3CoordFieldsTextFieldA.getText().trim(), "Invalid X"), this.stringHandler.stringToDouble(this._3CoordFieldsTextFieldB.getText().trim(), "Invalid Y"), this.stringHandler.stringToDouble(this._3CoordFieldsTextFieldC.getText().trim(), "Invalid Z"));
                return cartesianCoordinates;
            }
            case 10: {
                double d = this.stringHandler.stringToDouble(this._3CoordFieldsTextFieldC.getText().trim(), "Invalid Height");
                if (this.formatOptions.getHeightUnit() == 1) {
                    double d2 = 3.2808333333333333;
                    d /= d2;
                }
                GeodeticCoordinates geodeticCoordinates = new GeodeticCoordinates(n3, this.stringHandler.stringToLongitude(this._3CoordFieldsTextFieldA.getText().trim(), "Invalid Longitude"), this.stringHandler.stringToLatitude(this._3CoordFieldsTextFieldB.getText().trim(), "Invalid Latitude"), d);
                return geodeticCoordinates;
            }
            case 33: {
                UPSCoordinates uPSCoordinates = new UPSCoordinates(n3, this.hemisphere, this.stringHandler.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.stringHandler.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                return uPSCoordinates;
            }
            case 34: {
                UTMCoordinates uTMCoordinates = new UTMCoordinates(n3, this.zone, this.hemisphere, this.stringHandler.stringToDouble(this._2CoordFieldsTextFieldA.getText().trim(), "Invalid Easting"), this.stringHandler.stringToDouble(this._2CoordFieldsTextFieldB.getText().trim(), "Invalid Northing"));
                return uTMCoordinates;
            }
        }
        throw new CoordinateConversionException("Invalid coordinate type");
    }

    public void createCoordPanel(int n) {
        this.setFormat();
        switch (n) {
            case 9: {
                this.setThreeCoords();
                break;
            }
            case 10: {
                this._2CoordFieldsPanel.setVisible(false);
                this._3CoordFieldsPanel.setVisible(true);
                this.coordLayeredPane.moveToFront(this._3CoordFieldsPanel);
                this._3CoordFieldsLabelA.setVisible(true);
                this._3CoordFieldsLabelC.setVisible(true);
                this._3CoordFieldsLabelUnit_C.setVisible(true);
                this._3CoordFieldsTextFieldA.setVisible(true);
                this._3CoordFieldsTextFieldC.setVisible(true);
                this.setHeightFieldEditable();
                this._3CoordFieldsLabelA.setText("Longitude:");
                this._3CoordFieldsLabelB.setText("Latitude:");
                this._3CoordFieldsLabelC.setText("Height");
                this._3CoordFieldsLabelC.setBounds(296, 0, 39, 18);
                if (this.formatOptions.getHeightUnit() == 0) {
                    this._3CoordFieldsLabelUnit_C.setText("(m):");
                    if (UIManager.getLookAndFeel().getName().equalsIgnoreCase("Metal")) {
                        this._3CoordFieldsLabelUnit_C.setFont(this._3CoordFieldsLabelUnitFont_C);
                    } else {
                        this._3CoordFieldsLabelUnit_C.setFont(this._3CoordFieldsLabelUnit_C.getFont().deriveFont(0));
                    }
                } else {
                    this._3CoordFieldsLabelUnit_C.setText("(ft):");
                    if (UIManager.getLookAndFeel().getName().equalsIgnoreCase("Metal")) {
                        this._3CoordFieldsLabelUnit_C.setFont(this._3CoordFieldsLabelUnit_C.getFont().deriveFont(3));
                    } else {
                        this._3CoordFieldsLabelUnit_C.setFont(this._3CoordFieldsLabelUnit_C.getFont().deriveFont(2));
                    }
                }
                this._3CoordFieldsLabelUnit_C.setBounds(339, 0, 30, 18);
                try {
                    this._3CoordFieldsTextFieldA.setText(this.stringHandler.longitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3CoordFieldsTextFieldB.setText(this.stringHandler.latitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
                }
                catch (CoordinateConversionException coordinateConversionException) {
                    this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
                }
                this._3CoordFieldsTextFieldC.setText("0");
                break;
            }
            case 11: {
                this.setOneCoord();
                this._3CoordFieldsTextFieldB.setText("NGAA0000000000");
                break;
            }
            case 12: {
                this.setOneCoord();
                this._3CoordFieldsTextFieldB.setText("361HN37");
                break;
            }
            case 38: {
                this.setOneCoord();
                this._3CoordFieldsTextFieldB.setText("31NEA00");
                break;
            }
            case 19: {
                this.setOneCoord();
                this._3CoordFieldsTextFieldB.setText("31NEA0000000000");
                break;
            }
            case 3: {
                this.setOneCoord();
                this._3CoordFieldsTextFieldB.setText("SV 0000000000");
                break;
            }
            case 22: {
                this.setTwoCoords();
                this._2CoordFieldsTextFieldA.setText("2510000");
                this._2CoordFieldsTextFieldB.setText("6023150");
                break;
            }
            case 33: {
                this.setTwoCoords();
                this._2CoordFieldsTextFieldA.setText("2000000");
                this._2CoordFieldsTextFieldB.setText("2000000");
                break;
            }
            case 35: {
                this.setOneCoord();
                this._3CoordFieldsTextFieldB.setText("31NEA0000000000");
                break;
            }
            case 34: {
                this.setTwoCoords();
                this._2CoordFieldsTextFieldA.setText("500000");
                break;
            }
            case 16: {
                this.setThreeCoords();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: {
                this.setTwoCoords();
                break;
            }
        }
    }

    public void resetOutputErrors() {
        this.ce90TextField.setText("N/A");
        this.le90TextField.setText("N/A");
        this.se90TextField.setText("N/A");
    }

    public void setAccuracy(Accuracy accuracy, boolean bl) {
        this.currentAccuracy = accuracy;
        double d = accuracy.getCE90();
        double d2 = accuracy.getLE90();
        double d3 = accuracy.getSE90();
        if (bl) {
            int n = this.formatOptions.getPrecision();
            double d4 = 100000.0 / Math.sqrt(12.0);
            for (int i = 0; i < n; ++i) {
                d4 /= 10.0;
            }
            if (d2 > 0.0) {
                double d5 = 1.6449 * d4;
                d2 = Math.sqrt(d2 * d2 + d5 * d5);
            }
            if (d > 0.0) {
                double d6 = 2.146 * d4;
                d = Math.sqrt(d * d + d6 * d6);
            }
            if (d3 > 0.0) {
                double d7 = 2.146 * d4;
                d3 = Math.sqrt(d3 * d3 + d7 * d7);
            }
        }
        if (d == -1.0) {
            this.ce90TextField.setText("Unk");
        } else {
            this.stringHandler.setNumberFormat(this.ce90TextField, d, 0);
        }
        if (!this._3dConversion) {
            this.le90TextField.setText("N/A");
            this.se90TextField.setText("N/A");
        } else {
            if (d2 == -1.0) {
                this.le90TextField.setText("Unk");
            } else {
                this.stringHandler.setNumberFormat(this.le90TextField, d2, 0);
            }
            if (d3 == -1.0) {
                this.se90TextField.setText("Unk");
            } else {
                this.stringHandler.setNumberFormat(this.se90TextField, d3, 0);
            }
        }
    }

    public Accuracy getAccuracy() {
        if (!this.usePrevAccuracies) {
            String string = this.ce90TextField.getText().trim();
            String string2 = this.le90TextField.getText().trim();
            String string3 = this.se90TextField.getText().trim();
            double d = string.equals("Unk") || string.equals("N/A") ? -1.0 : this.stringHandler.stringToDouble(string, "Invalid CE 90");
            double d2 = string2.equals("Unk") || string2.equals("N/A") ? -1.0 : this.stringHandler.stringToDouble(string2, "Invalid LE 90");
            double d3 = string3.equals("Unk") || string3.equals("N/A") ? -1.0 : this.stringHandler.stringToDouble(string3, "Invalid SE 90");
            this.currentAccuracy = new Accuracy(d, d2, d3);
        }
        return this.currentAccuracy;
    }

    public void updateSrcErrors(boolean bl, boolean bl2) {
        this.le90TextField.setEditable(bl);
        this.se90TextField.setEditable(bl);
        this._3dConversion = bl;
        this.updateAccuracy(bl2);
    }

    public void updateAccuracy(boolean bl) {
        try {
            int n = this.sourcesComboBox.getSelectedIndex();
            Accuracy accuracy = Source.accuracy(n);
            this.setAccuracy(accuracy, bl);
            this.usePrevAccuracies = false;
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
    }

    public void setHeightText(String string) {
        this._3CoordFieldsTextFieldC.setText(string);
    }

    public void setHeightFieldUneditable() {
        this._3CoordFieldsTextFieldC.setEditable(false);
    }

    public void setHeightFieldEditable() {
        this._3CoordFieldsTextFieldC.setEditable(true);
    }

    public void setHeightFieldEditable(boolean bl) {
        this._3CoordFieldsTextFieldC.setEditable(bl);
    }

    public void setHemisphere(char c) {
        this.hemisphere = c;
    }

    public void setZone(int n) {
        this.zone = n;
    }

    public char getHemisphere() {
        return this.hemisphere;
    }

    public long getZone() {
        return this.zone;
    }

    public void setDefaults(FormatOptions formatOptions, StringHandler stringHandler) {
        this.formatOptions = formatOptions;
        this.stringHandler = stringHandler;
    }
}

