/* Contributed by Nicola Pero <nicola.pero@meta-innovation.com>, May 2011.  */
/* { dg-do run } */
/* { dg-skip-if "No API#2 pre-Darwin9" { *-*-darwin[5-8]* } { "-fnext-runtime" } { "" } } */

#include <objc/runtime.h>
#include <stdlib.h>

int main(int argc, void **args)
{
#ifdef __GNU_LIBOBJC__
  /* This special test tests that, if you have a selector already
     registered in the runtime with full type information, you can use
     sel_registerTypedName() to get it even if you specify the type
     with incorrect argframe information.  This is helpful as
     selectors generated by the compiler (which have correct argframe
     information) are usually registered before hand-written ones
     (which often have incorrect argframe information, but need the
     correct one).

     Note that in this hand-written test, even the type information of
     the first selector may be wrong (on this machine); but that's OK
     as we'll never actually use the selectors.  */
  SEL selector1 = sel_registerTypedName ("testMethod", "i8@0:4");
  SEL selector2 = sel_registerTypedName ("testMethod", "i8@8:8");
  
  /* We compare the selectors using ==, not using sel_isEqual().  This
     is because we are testing internals of the runtime and we know
     that in the current implementation they should be identical if
     the stuff is to work as expected.  Don't do this at home.  */
  if (selector1 != selector2)
    abort ();
#endif

  return 0;
}
