/* Generated by Frama-C */
#include "stddef.h"
#include "stdio.h"
#include "stdlib.h"
extern int __e_acsl_sound_verdict;

/*@ requires valid_memptr: \valid(memptr);
    requires
      alignment_is_a_suitable_power_of_two:
        alignment ≥ sizeof(void *) ∧
        ((size_t)alignment & ((size_t)alignment - 1)) ≡ 0;
    assigns __fc_heap_status, \result;
    assigns __fc_heap_status
      \from (indirect: alignment), size, __fc_heap_status;
    assigns \result
      \from (indirect: alignment), (indirect: size),
            (indirect: __fc_heap_status);
    allocates *\old(memptr);
    
    behavior allocation:
      assumes can_allocate: is_allocable(size);
      ensures allocation: \fresh{Old, Here}(*\old(memptr),\old(size));
      ensures result_zero: \result ≡ 0;
      assigns __fc_heap_status, \result;
      assigns __fc_heap_status
        \from (indirect: alignment), size, __fc_heap_status;
      assigns \result
        \from (indirect: alignment), (indirect: size),
              (indirect: __fc_heap_status);
    
    behavior no_allocation:
      assumes cannot_allocate: ¬is_allocable(size);
      ensures result_non_zero: \result < 0 ∨ \result > 0;
      assigns \result;
      assigns \result \from (indirect: alignment);
      allocates \nothing;
    
    complete behaviors no_allocation, allocation;
    disjoint behaviors no_allocation, allocation;
 */
int __gen_e_acsl_posix_memalign(void **memptr, size_t alignment, size_t size);

void *aligned_alloc(size_t alignment, size_t size);

int main(int argc, char const **argv)
{
  int __retres;
  char *a;
  __e_acsl_memory_init(& argc,(char ***)(& argv),(size_t)8);
  __e_acsl_store_block((void *)(& a),(size_t)8);
  char **memptr = malloc(sizeof(void *));
  __e_acsl_store_block((void *)(& memptr),(size_t)8);
  __e_acsl_full_init((void *)(& memptr));
  int res2 =
    __gen_e_acsl_posix_memalign((void **)memptr,(unsigned long)256,
                                (unsigned long)15);
  char *p = *memptr;
  __e_acsl_store_block((void *)(& p),(size_t)8);
  __e_acsl_full_init((void *)(& p));
  {
    int __gen_e_acsl_initialized;
    int __gen_e_acsl_and;
    __gen_e_acsl_initialized = __e_acsl_initialized((void *)(& p),
                                                    sizeof(char *));
    if (__gen_e_acsl_initialized) {
      int __gen_e_acsl_valid;
      __gen_e_acsl_valid = __e_acsl_valid((void *)p,sizeof(char),(void *)p,
                                          (void *)(& p));
      __gen_e_acsl_and = __gen_e_acsl_valid;
    }
    else __gen_e_acsl_and = 0;
    __e_acsl_assert(__gen_e_acsl_and,"Assertion","main","\\valid(p)",
                    "tests/memory/memalign.c",15);
  }
  /*@ assert \valid(p); */ ;
  {
    unsigned long __gen_e_acsl_block_length;
    __gen_e_acsl_block_length = __e_acsl_block_length((void *)p);
    __e_acsl_assert(__gen_e_acsl_block_length == 15UL,"Assertion","main",
                    "\\block_length(p) == 15","tests/memory/memalign.c",16);
  }
  /*@ assert \block_length(p) ≡ 15; */ ;
  {
    int __gen_e_acsl_freeable;
    __gen_e_acsl_freeable = __e_acsl_freeable((void *)p);
    __e_acsl_assert(__gen_e_acsl_freeable,"Assertion","main","\\freeable(p)",
                    "tests/memory/memalign.c",17);
  }
  /*@ assert \freeable(p); */ ;
  free((void *)p);
  {
    int __gen_e_acsl_initialized_2;
    int __gen_e_acsl_and_2;
    __gen_e_acsl_initialized_2 = __e_acsl_initialized((void *)(& p),
                                                      sizeof(char *));
    if (__gen_e_acsl_initialized_2) {
      int __gen_e_acsl_valid_2;
      __gen_e_acsl_valid_2 = __e_acsl_valid((void *)p,sizeof(char),(void *)p,
                                            (void *)(& p));
      __gen_e_acsl_and_2 = __gen_e_acsl_valid_2;
    }
    else __gen_e_acsl_and_2 = 0;
    __e_acsl_assert(! __gen_e_acsl_and_2,"Assertion","main","!\\valid(p)",
                    "tests/memory/memalign.c",19);
  }
  /*@ assert ¬\valid(p); */ ;
  __e_acsl_full_init((void *)(& a));
  a = (char *)aligned_alloc((unsigned long)256,(unsigned long)12);
  __e_acsl_assert(a == (char *)0,"Assertion","main","a == \\null",
                  "tests/memory/memalign.c",23);
  /*@ assert a ≡ \null; */ ;
  __e_acsl_full_init((void *)(& a));
  a = (char *)aligned_alloc((unsigned long)255,(unsigned long)512);
  __e_acsl_assert(a == (char *)0,"Assertion","main","a == \\null",
                  "tests/memory/memalign.c",26);
  /*@ assert a ≡ \null; */ ;
  __e_acsl_full_init((void *)(& a));
  a = (char *)aligned_alloc((unsigned long)0,(unsigned long)512);
  __e_acsl_assert(a == (char *)0,"Assertion","main","a == \\null",
                  "tests/memory/memalign.c",29);
  /*@ assert a ≡ \null; */ ;
  __e_acsl_full_init((void *)(& a));
  a = (char *)aligned_alloc((unsigned long)256,(unsigned long)512);
  __e_acsl_assert(a != (char *)0,"Assertion","main","a != \\null",
                  "tests/memory/memalign.c",32);
  /*@ assert a ≢ \null; */ ;
  {
    int __gen_e_acsl_initialized_3;
    int __gen_e_acsl_and_3;
    __gen_e_acsl_initialized_3 = __e_acsl_initialized((void *)(& a),
                                                      sizeof(char *));
    if (__gen_e_acsl_initialized_3) {
      int __gen_e_acsl_valid_3;
      __gen_e_acsl_valid_3 = __e_acsl_valid((void *)a,sizeof(char),(void *)a,
                                            (void *)(& a));
      __gen_e_acsl_and_3 = __gen_e_acsl_valid_3;
    }
    else __gen_e_acsl_and_3 = 0;
    __e_acsl_assert(__gen_e_acsl_and_3,"Assertion","main","\\valid(a)",
                    "tests/memory/memalign.c",33);
  }
  /*@ assert \valid(a); */ ;
  {
    unsigned long __gen_e_acsl_block_length_2;
    __gen_e_acsl_block_length_2 = __e_acsl_block_length((void *)a);
    __e_acsl_assert(__gen_e_acsl_block_length_2 == 512UL,"Assertion","main",
                    "\\block_length(a) == 512","tests/memory/memalign.c",34);
  }
  /*@ assert \block_length(a) ≡ 512; */ ;
  {
    int __gen_e_acsl_freeable_2;
    __gen_e_acsl_freeable_2 = __e_acsl_freeable((void *)a);
    __e_acsl_assert(__gen_e_acsl_freeable_2,"Assertion","main",
                    "\\freeable(a)","tests/memory/memalign.c",35);
  }
  /*@ assert \freeable(a); */ ;
  free((void *)a);
  {
    int __gen_e_acsl_initialized_4;
    int __gen_e_acsl_and_4;
    __gen_e_acsl_initialized_4 = __e_acsl_initialized((void *)(& a),
                                                      sizeof(char *));
    if (__gen_e_acsl_initialized_4) {
      int __gen_e_acsl_valid_4;
      __gen_e_acsl_valid_4 = __e_acsl_valid((void *)a,sizeof(char),(void *)a,
                                            (void *)(& a));
      __gen_e_acsl_and_4 = __gen_e_acsl_valid_4;
    }
    else __gen_e_acsl_and_4 = 0;
    __e_acsl_assert(! __gen_e_acsl_and_4,"Assertion","main","!\\valid(a)",
                    "tests/memory/memalign.c",38);
  }
  /*@ assert ¬\valid(a); */ ;
  __retres = 0;
  __e_acsl_delete_block((void *)(& a));
  __e_acsl_delete_block((void *)(& p));
  __e_acsl_delete_block((void *)(& memptr));
  __e_acsl_memory_clean();
  return __retres;
}

/*@ requires valid_memptr: \valid(memptr);
    requires
      alignment_is_a_suitable_power_of_two:
        alignment ≥ sizeof(void *) ∧
        ((size_t)alignment & ((size_t)alignment - 1)) ≡ 0;
    assigns __fc_heap_status, \result;
    assigns __fc_heap_status
      \from (indirect: alignment), size, __fc_heap_status;
    assigns \result
      \from (indirect: alignment), (indirect: size),
            (indirect: __fc_heap_status);
    allocates *\old(memptr);
    
    behavior allocation:
      assumes can_allocate: is_allocable(size);
      ensures allocation: \fresh{Old, Here}(*\old(memptr),\old(size));
      ensures result_zero: \result ≡ 0;
      assigns __fc_heap_status, \result;
      assigns __fc_heap_status
        \from (indirect: alignment), size, __fc_heap_status;
      assigns \result
        \from (indirect: alignment), (indirect: size),
              (indirect: __fc_heap_status);
    
    behavior no_allocation:
      assumes cannot_allocate: ¬is_allocable(size);
      ensures result_non_zero: \result < 0 ∨ \result > 0;
      assigns \result;
      assigns \result \from (indirect: alignment);
      allocates \nothing;
    
    complete behaviors no_allocation, allocation;
    disjoint behaviors no_allocation, allocation;
 */
int __gen_e_acsl_posix_memalign(void **memptr, size_t alignment, size_t size)
{
  __e_acsl_contract_t *__gen_e_acsl_contract;
  int __retres;
  {
    int __gen_e_acsl_valid;
    int __gen_e_acsl_and;
    __e_acsl_store_block((void *)(& memptr),(size_t)8);
    __gen_e_acsl_contract = __e_acsl_contract_init((size_t)2);
    __gen_e_acsl_valid = __e_acsl_valid((void *)memptr,sizeof(void *),
                                        (void *)memptr,(void *)(& memptr));
    __e_acsl_assert(__gen_e_acsl_valid,"Precondition","posix_memalign",
                    "\\valid(memptr)","FRAMAC_SHARE/libc/stdlib.h",666);
    if (alignment >= 8UL) {
      __e_acsl_mpz_t __gen_e_acsl_;
      __e_acsl_mpz_t __gen_e_acsl__2;
      __e_acsl_mpz_t __gen_e_acsl_sub;
      __e_acsl_mpz_t __gen_e_acsl_band;
      unsigned long __gen_e_acsl__3;
      __gmpz_init_set_ui(__gen_e_acsl_,alignment);
      __gmpz_init_set_si(__gen_e_acsl__2,1L);
      __gmpz_init(__gen_e_acsl_sub);
      __gmpz_sub(__gen_e_acsl_sub,
                 (__e_acsl_mpz_struct const *)(__gen_e_acsl_),
                 (__e_acsl_mpz_struct const *)(__gen_e_acsl__2));
      __gmpz_init(__gen_e_acsl_band);
      __gmpz_and(__gen_e_acsl_band,
                 (__e_acsl_mpz_struct const *)(__gen_e_acsl_),
                 (__e_acsl_mpz_struct const *)(__gen_e_acsl_sub));
      __gen_e_acsl__3 = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl_band));
      __gen_e_acsl_and = __gen_e_acsl__3 == 0UL;
      __gmpz_clear(__gen_e_acsl_);
      __gmpz_clear(__gen_e_acsl__2);
      __gmpz_clear(__gen_e_acsl_sub);
      __gmpz_clear(__gen_e_acsl_band);
    }
    else __gen_e_acsl_and = 0;
    __e_acsl_assert(__gen_e_acsl_and,"Precondition","posix_memalign",
                    "alignment >= sizeof(void *) &&\n((size_t)alignment & ((size_t)alignment - 1)) == 0",
                    "FRAMAC_SHARE/libc/stdlib.h",668);
  }
  __retres = posix_memalign(memptr,alignment,size);
  {
    int __gen_e_acsl_assumes_value;
    __gen_e_acsl_assumes_value = __e_acsl_contract_get_behavior_assumes
    ((__e_acsl_contract_t const *)__gen_e_acsl_contract,(size_t)0);
    if (__gen_e_acsl_assumes_value) __e_acsl_assert(__retres == 0,
                                                    "Postcondition",
                                                    "posix_memalign",
                                                    "allocation: \\result == 0",
                                                    "FRAMAC_SHARE/libc/stdlib.h",
                                                    680);
    __gen_e_acsl_assumes_value = __e_acsl_contract_get_behavior_assumes
    ((__e_acsl_contract_t const *)__gen_e_acsl_contract,(size_t)1);
    if (__gen_e_acsl_assumes_value) {
      int __gen_e_acsl_or;
      if (__retres < 0) __gen_e_acsl_or = 1;
      else __gen_e_acsl_or = __retres > 0;
      __e_acsl_assert(__gen_e_acsl_or,"Postcondition","posix_memalign",
                      "no_allocation: \\result < 0 || \\result > 0",
                      "FRAMAC_SHARE/libc/stdlib.h",685);
    }
    __e_acsl_contract_clean(__gen_e_acsl_contract);
    __e_acsl_delete_block((void *)(& memptr));
    return __retres;
  }
}


