#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

import string

from fenrirscreenreader.core import debug


def get_current_word(curr_x, curr_y, curr_text):
    line_break = False
    end_of_screen = False
    if curr_text == "":
        return -1, -1, "", end_of_screen, line_break
    if curr_text.strip(string.whitespace) == "":
        return curr_x, curr_y, "", end_of_screen, line_break
    x = curr_x
    y = curr_y
    curr_word = ""
    wrapped_lines = curr_text.split("\n")
    curr_line = wrapped_lines[y]
    found = False
    while not found:
        if not curr_line[x] in string.whitespace:
            if x == 0:
                found = True
            else:
                if curr_line[x - 1] in string.whitespace:
                    found = True
        if not found:
            if x - 1 < 0:
                if y - 1 < 0:
                    line_break = False
                    end_of_screen = True
                    return curr_x, curr_y, "", end_of_screen, line_break
                else:
                    y -= 1
                    curr_line = wrapped_lines[y]
                    x = len(curr_line) - 1
                    line_break = True
            else:
                x -= 1
    if found:
        curr_word = curr_line[x:]
        for d in string.whitespace:
            delimiter_pos = curr_word.find(d)
            if delimiter_pos != -1:
                curr_word = curr_word[:delimiter_pos]
        return x, y, curr_word, end_of_screen, line_break
    return curr_x, curr_y, "", False, False


def get_prev_word(curr_x, curr_y, curr_text):
    line_break = False
    end_of_screen = False
    if curr_text == "":
        return -1, -1, "", end_of_screen, line_break
    if curr_text.strip(string.whitespace) == "":
        return curr_x, curr_y, "", end_of_screen, line_break
    x, y, curr_word, end_of_screen, line_break_curr_word = get_current_word(
        curr_x, curr_y, curr_text
    )
    if end_of_screen:
        return x, y, curr_word, end_of_screen, line_break
    wrapped_lines = curr_text.split("\n")
    curr_line = wrapped_lines[y]
    if x - 1 < 0:
        if y - 1 < 0:
            line_break = False
            end_of_screen = True
            return curr_x, curr_y, "", end_of_screen, line_break
        else:
            y -= 1
            curr_line = wrapped_lines[y]
            x = len(curr_line) - 1
            line_break = True
    else:
        x -= 1
    line_break_curr_word = line_break or line_break_curr_word
    x, y, curr_word, end_of_screen, line_break = get_current_word(
        x, y, curr_text
    )
    line_break = line_break or line_break_curr_word
    return x, y, curr_word, end_of_screen, line_break


def get_next_word(curr_x, curr_y, curr_text):
    line_break = False
    end_of_screen = False
    if curr_text == "":
        return -1, -1, "", end_of_screen, line_break
    if curr_text.strip(string.whitespace) == "":
        return curr_x, curr_y, "", end_of_screen, line_break
    x = curr_x
    y = curr_y
    curr_word = ""
    wrapped_lines = curr_text.split("\n")
    curr_line = wrapped_lines[y]
    found = False
    while not found:
        if not found:
            if x + 1 > len(curr_line) - 1:
                if y + 1 > len(wrapped_lines) - 1:
                    line_break = False
                    end_of_screen = True
                    return curr_x, curr_y, "", end_of_screen, line_break
                else:
                    y += 1
                    curr_line = wrapped_lines[y]
                    x = 0
                    line_break = True
            else:
                x += 1
        if not curr_line[x] in string.whitespace:
            if x == 0:
                found = True
            else:
                if curr_line[x - 1] in string.whitespace:
                    found = True
    if found:
        curr_word = curr_line[x:]
        for d in string.whitespace:
            delimiter_pos = curr_word.find(d)
            if delimiter_pos != -1:
                curr_word = curr_word[:delimiter_pos]
        return x, y, curr_word, end_of_screen, line_break
    return curr_x, curr_y, "", False, False
