#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _
from fenrirscreenreader.utils import line_utils


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("moves review to the next line ")

    def run(self):
        self.env["screen"]["oldCursorReview"] = self.env["screen"][
            "newCursorReview"
        ]
        if not self.env["screen"]["newCursorReview"]:
            self.env["screen"]["newCursorReview"] = self.env["screen"][
                "new_cursor"
            ].copy()

        (
            self.env["screen"]["newCursorReview"]["x"],
            self.env["screen"]["newCursorReview"]["y"],
            nextLine,
            end_of_screen,
        ) = line_utils.get_next_line(
            self.env["screen"]["newCursorReview"]["x"],
            self.env["screen"]["newCursorReview"]["y"],
            self.env["screen"]["new_content_text"],
        )

        if nextLine.isspace():
            self.env["runtime"]["OutputManager"].present_text(
                _("blank"), sound_icon="EmptyLine", interrupt=True, flush=False
            )
        else:
            self.env["runtime"]["OutputManager"].present_text(
                nextLine, interrupt=True, flush=False
            )
        if end_of_screen:
            if self.env["runtime"]["SettingsManager"].get_setting_as_bool(
                "review", "end_of_screen"
            ):
                self.env["runtime"]["OutputManager"].present_text(
                    _("end of screen"),
                    interrupt=True,
                    sound_icon="EndOfScreen",
                )

    def set_callback(self, callback):
        pass
