#!/bin/bash
set -e

export HOME="${AUTOPKGTEST_TMP:-$HOME}"
port=41234

# find a port for our serve to listen in
while ( ss -lt src :$port | grep LISTEN )
do
    port=$(( port + 1 ))
done

cd "$AUTOPKGTEST_TMP"
# start local http server
python3 -m http.server "$port" &
HTTP_PID=$!
trap 'kill $HTTP_PID' EXIT TERM INT
# let the http server settle down
sleep 2

dirb "http://localhost:$port/" /usr/share/dirb/wordlists/small.txt -z 20
