/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __viewwin
#define __viewwin

#include "box.h"

struct viewport { // opengl viewport

  int width, height;
  int xmax, ymax;
  float xmax_1, ymax_1; // 1.0 / xmax , 1.0 / ymax

  // for constant size handle of vertex/tangent in curve editors
  //
  static int handle_radius;
  static float handle_factor;

  viewport ();
  void operator() (int width, int height);
  void calc (int w, int h);
  bool inside (int x, int y);

};

struct window : box<float> { // curve editor

  float mousex, mousey; // mouse in window co-ords
  int prev_mousex, prev_mousey; // prev mouse in mouse co-ords

  void locate_mouse (); // find mouse in window co-ords
  void update_mouse (); // update mouse in window co-ords

  float vwx, vwy; // for view-win transform; to locate mouse in window
  void calc_viewwin ();

  static int PAN_RATE, ZOOM_RATE; // num pan, zooms per second
  static float PAN_AMOUNT, ZOOM_AMOUNT; // pan, zoom amount per key press
  static double PAN_REPEAT, ZOOM_REPEAT; // key repeat time
  static void calc_repeats ();

  float pan_x, pan_y;
  void calc_panxy ();
  void panx (int dir);
  void pany (int dir);

  float aspect_ratio;
  float width_1, height_1; // 1.0 / width, 1.0 / height

  window ();
  window (float l, float b, float r, float t);
  void set (float l, float b, float r, float t);
  void get (float& l, float& b, float& r, float& t);

  void zoom (int dir);

  void project ();

  float handle_radius, handle_radius2;
  float sus_handle_radius;
  void calc_handle_radius ();

  inline void calc () {
    calc_repeats ();
    calc_panxy ();
    calc_viewwin ();
    calc_handle_radius ();
    locate_mouse ();
  }


};

inline void view2win (int vx, int vy, float& wx, float& wy, viewport& view, window& win) {

  float xr = vx * view.xmax_1;
  float yr = 1 - vy * view.ymax_1;

  wx = win.left + xr * win.width;
  wy = win.bottom + yr * win.height;

}

inline void win2view (float wx, float wy, int& vx, int& vy, window& win, viewport& view) {

  float xr = (wx - win.left) * win.width_1;
  float yr = (wy - win.bottom) * win.height_1;
  vx = (int) (xr * view.xmax);
  vy = (int) (yr * view.ymax);

}

#endif
