import dataclasses
import textwrap


@dataclasses.dataclass(slots=True, frozen=True)
class PublicNamedStyle:
    name: str
    long_description: str


ALL_PUBLIC_NAMED_STYLES = {
    s.name: s
    for s in [
        PublicNamedStyle(
            "black",
            long_description=textwrap.dedent(
                """\
                Uncompromising file formatting of Debian packaging files
        
                By using it, you  agree to cede control over minutiae of hand-formatting. In
                return, the formatter gives you speed, determinism, and freedom from style
                discussions about formatting.
        
                The `black` style is inspired by the `black` Python code formatter. Like with
                `black`, the style will evolve over time.
            """
            ),
        ),
    ]
}
