/** @file user_interface_options_dialog.cpp */

// Copyright (C) 2018-2022 Sanford Rockowitz <rockowitz@minsoft.com>
// SPDX-License-Identifier: GPL-2.0-or-later

#include "user_interface_options_dialog.h"

// generated by uic from userInterfaceOptions_ui.ui:
#include "ui_user_interface_options_dialog.h"

#include <assert.h>
#include <QtCore/QDebug>

#include "base/core.h"
#include "base/user_interface_options_state.h"
#include "help/help_dialog.h"
#include "help/help_browser.h"


void UserInterfaceOptionsDialog::setCkrChanged(bool required)
{
      _ui->ckrCheckBox->setChecked(required);
}


UserInterfaceOptionsDialog::UserInterfaceOptionsDialog(
           UserInterfaceOptionsState * state,
           QWidget *parent)
    :  QDialog(parent)
    ,  _ui(new Ui::  UserInterfaceOptionsDialog)
    , _cls(strdup(metaObject()->className()))
    , _state(state)
{
    bool debug = false;
    TRACECF(debug, "Constructor starting");
    _ui->setupUi(this);
    setWindowFlag(Qt::WindowContextHelpButtonHint, false);
    // setWindowFlag(Qt::WindowMaximizeButtonHint, false);  // no effect
    setWindowTitle("ddcui - User Interface Options");
    // setUSource(state->ncValuesSource);
    TRACECF(debug, "Constructor done");
}


UserInterfaceOptionsDialog::~UserInterfaceOptionsDialog()
{
    delete _ui;
    free((void*) _cls);
}


void UserInterfaceOptionsDialog::setDialogBoxControlKeyRequired(bool onoff) {
   Qt::CheckState stateToSet = Qt::Unchecked;
   if (onoff)
      stateToSet = Qt::Checked;

   _ui->ckrCheckBox->setChecked(stateToSet);
}


void UserInterfaceOptionsDialog::on_actionButtonBox_accepted()
{
    bool debugFunc = false;
    bool newCtrlKeyRequired  = _ui->ckrCheckBox->isChecked();
    TRACECF(debugFunc, "Executing. Value read from ckr checkbox; %s", SBOOL(newCtrlKeyRequired));

    TRACECF(debugFunc, "Calling _state->setControlKey_Required(%s)", SBOOL(newCtrlKeyRequired));

    _state->setControlKeyRequired(newCtrlKeyRequired);

    // not needed, automatically emitted when dialog accepted, by accept() or done()
    // emit userInterfaceDialog_accepted(_state);  // probably not needed

    TRACECF(debugFunc, "Before calling accept()");
    accept();  // causes accepted() to be emitted
}


void UserInterfaceOptionsDialog::on_actionButtonBox_helpRequested()
{
    // TRACE();
#ifdef OLD
    QString fn(":/docs/help_ui_options.html");
    QFile f(fn);
    f.open(QFile::ReadOnly | QFile::Text);
    QTextStream in(&f);

    QString htmlText = in.readAll();

    // qDebug() << htmlText;

    // doesn't show dialog box
    // HelpDialog2("ddcui Help - Other Options", htmlText, this);

    HelpDialog2* hd = new HelpDialog2(this);
    hd->setText(htmlText);
    hd->setWindowTitle("ddcui Help - User Interface Options");
    hd->show();
#else
    // HelpBrowser::showPage(":docs/help_ui_options.html", false);

    HelpDialog* hd = new HelpDialog(this);
    hd->setSource("qrc:docs/help_ui_options.html");
    hd->exec();
#endif
}


// Reset
void UserInterfaceOptionsDialog::on_actionButtonBox_clicked(QAbstractButton* button)
{
   if(button== (QAbstractButton*) _ui->actionButtonBox->button(QDialogButtonBox::Reset) ){
      // TRACEC("Reset");

      // Pressing the reset button does not close the dialog box
      // Reset the state in UserInterfaceOptionsState
      // Do not emit a changed() message and do not close the dialog

      _state->_controlKeyRequired = UserInterfaceOptionsState::CkrDefault;
       setDialogBoxControlKeyRequired(UserInterfaceOptionsState::CkrDefault);
   }
}

