info = {
    "name": "ur",
    "date_order": "DMY",
    "january": [
        "جنوری"
    ],
    "february": [
        "فروری"
    ],
    "march": [
        "مارچ"
    ],
    "april": [
        "اپریل"
    ],
    "may": [
        "مئی"
    ],
    "june": [
        "جون"
    ],
    "july": [
        "جولائی"
    ],
    "august": [
        "اگست"
    ],
    "september": [
        "ستمبر"
    ],
    "october": [
        "اکتوبر"
    ],
    "november": [
        "نومبر"
    ],
    "december": [
        "دسمبر"
    ],
    "monday": [
        "سوموار"
    ],
    "tuesday": [
        "منگل"
    ],
    "wednesday": [
        "بدھ"
    ],
    "thursday": [
        "جمعرات"
    ],
    "friday": [
        "جمعہ"
    ],
    "saturday": [
        "ہفتہ"
    ],
    "sunday": [
        "اتوار"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "سال"
    ],
    "month": [
        "ماہ",
        "مہینہ"
    ],
    "week": [
        "ہفتہ"
    ],
    "day": [
        "دن"
    ],
    "hour": [
        "گھنٹہ"
    ],
    "minute": [
        "منٹ"
    ],
    "second": [
        "سیکنڈ"
    ],
    "relative-type": {
        "0 day ago": [
            "آج"
        ],
        "0 hour ago": [
            "اس گھنٹے"
        ],
        "0 minute ago": [
            "اس منٹ"
        ],
        "0 month ago": [
            "اس مہینہ"
        ],
        "0 second ago": [
            "اب"
        ],
        "0 week ago": [
            "اس ہفتہ"
        ],
        "0 year ago": [
            "اس سال"
        ],
        "1 day ago": [
            "گزشتہ کل"
        ],
        "1 month ago": [
            "پچھلے مہینہ"
        ],
        "1 week ago": [
            "پچھلے ہفتہ"
        ],
        "1 year ago": [
            "گزشتہ سال"
        ],
        "in 1 day": [
            "آئندہ کل"
        ],
        "in 1 month": [
            "اگلے مہینہ"
        ],
        "in 1 week": [
            "اگلے ہفتہ"
        ],
        "in 1 year": [
            "اگلے سال"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+[.,]?\\d*) دن پہلے",
            "(\\d+[.,]?\\d*) دنوں پہلے"
        ],
        "\\1 hour ago": [
            "(\\d+[.,]?\\d*) گھنٹہ پہلے",
            "(\\d+[.,]?\\d*) گھنٹے پہلے"
        ],
        "\\1 minute ago": [
            "(\\d+[.,]?\\d*) منٹ پہلے"
        ],
        "\\1 month ago": [
            "(\\d+[.,]?\\d*) ماہ قبل",
            "(\\d+[.,]?\\d*) ماہ پہلے",
            "(\\d+[.,]?\\d*) مہینہ پہلے",
            "(\\d+[.,]?\\d*) مہینے پہلے"
        ],
        "\\1 second ago": [
            "(\\d+[.,]?\\d*) سیکنڈ پہلے"
        ],
        "\\1 week ago": [
            "(\\d+[.,]?\\d*) ہفتہ پہلے",
            "(\\d+[.,]?\\d*) ہفتے پہلے"
        ],
        "\\1 year ago": [
            "(\\d+[.,]?\\d*) سال پہلے"
        ],
        "in \\1 day": [
            "(\\d+[.,]?\\d*) دن میں",
            "(\\d+[.,]?\\d*) دنوں میں"
        ],
        "in \\1 hour": [
            "(\\d+[.,]?\\d*) گھنٹوں میں",
            "(\\d+[.,]?\\d*) گھنٹہ میں",
            "(\\d+[.,]?\\d*) گھنٹے میں"
        ],
        "in \\1 minute": [
            "(\\d+[.,]?\\d*) منٹ میں"
        ],
        "in \\1 month": [
            "(\\d+[.,]?\\d*) ماہ میں",
            "(\\d+[.,]?\\d*) مہینہ میں",
            "(\\d+[.,]?\\d*) مہینے میں"
        ],
        "in \\1 second": [
            "(\\d+[.,]?\\d*) سیکنڈ میں"
        ],
        "in \\1 week": [
            "(\\d+[.,]?\\d*) ہفتہ میں",
            "(\\d+[.,]?\\d*) ہفتے میں"
        ],
        "in \\1 year": [
            "(\\d+[.,]?\\d*) سال میں"
        ]
    },
    "locale_specific": {
        "ur-IN": {
            "name": "ur-IN",
            "monday": [
                "پیر"
            ],
            "relative-type": {
                "0 month ago": [
                    "اس ماہ"
                ],
                "1 month ago": [
                    "گزشتہ ماہ"
                ],
                "1 week ago": [
                    "گزشتہ ہفتہ"
                ],
                "in 1 month": [
                    "اگلے ماہ"
                ]
            },
            "relative-type-regex": {
                "\\1 day ago": [
                    "(\\d+[.,]?\\d*) دن قبل"
                ],
                "\\1 hour ago": [
                    "(\\d+[.,]?\\d*) گھنٹہ قبل",
                    "(\\d+[.,]?\\d*) گھنٹے قبل"
                ],
                "\\1 minute ago": [
                    "(\\d+[.,]?\\d*) منٹ قبل"
                ],
                "\\1 second ago": [
                    "(\\d+[.,]?\\d*) سیکنڈ قبل"
                ],
                "\\1 week ago": [
                    "(\\d+[.,]?\\d*) ہفتہ قبل",
                    "(\\d+[.,]?\\d*) ہفتے قبل"
                ],
                "\\1 year ago": [
                    "(\\d+[.,]?\\d*) سالوں پہلے"
                ],
                "in \\1 week": [
                    "(\\d+[.,]?\\d*) ہفتوں میں"
                ],
                "in \\1 year": [
                    "(\\d+[.,]?\\d*) سالوں میں"
                ]
            }
        }
    },
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
