/*-*- mode:c;indent-tabs-mode:nil;c-basic-offset:2;tab-width:8;coding:utf-8 -*-│
│ vi: set et ft=c ts=2 sts=2 sw=2 fenc=utf-8                               :vi │
╞══════════════════════════════════════════════════════════════════════════════╡
│ Copyright 2020 Justine Alexandra Roberts Tunney                              │
│                                                                              │
│ Permission to use, copy, modify, and/or distribute this software for         │
│ any purpose with or without fee is hereby granted, provided that the         │
│ above copyright notice and this permission notice appear in all copies.      │
│                                                                              │
│ THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL                │
│ WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED                │
│ WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE             │
│ AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL         │
│ DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR        │
│ PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER               │
│ TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR             │
│ PERFORMANCE OF THIS SOFTWARE.                                                │
╚─────────────────────────────────────────────────────────────────────────────*/
#include "test.h"
#include <stdbool.h>

#define BANE         0x8000000000000000
#define BANE1        0x8000000000000001
#define BANE2        0x8000000000000002
#define IMAX         0x7fffffffffffffff
#define IMAX2        0xfffffffffffffffd
#define I128(HI, LO) ((LO) | (unsigned __int128)(HI) << 64)

__int128 add128(__int128 x, __int128 y) {
  return x + y;
}

__int128 sub128x5(__int128 a, __int128 b, __int128 c, __int128 d, __int128 e) {
  return a - b - c - d - e;
}

__int128 sub128x6(int f, __int128 a, __int128 b, __int128 c, __int128 d,
                  __int128 e) {
  return f - a - b - c - d - e;
}

void lotsOfArgs(const char *file, int line, const char *func, __int128 beg,
                __int128 end, __int128 got, const char *gotcode, bool isfatal) {
}

void testLang128(void) {
  lotsOfArgs(__FILE__, __LINE__, __FUNCTION__, 0, 0, 0, "", false);
  ASSERT(16, sizeof(__int128));
  ASSERT(16, sizeof(unsigned __int128));
  ASSERT(16, _Alignof(__int128));
  ASSERT(16, ({
           struct T {
             __int128 x;
           };
           _Alignof(struct T);
         }));
  ASSERT(16, ({
           struct __attribute__((__aligned__(16))) T {
             __int128 x;
           };
           _Alignof(struct T);
         }));
  ASSERT128(7, ({
              __int128 i = 2;
              i += 5;
              i;
            }));
  ASSERT128(I128(0xffffffffffffffff, 0xffffffffffffffff), ({
              __int128 i = 0;
              add128(i, -1);
            }));
  ASSERT128(I128(0x3a8eaaa2e9af03f5, 0xd7ed730a55920176),
            sub128x5(I128(0x0db9cd085ab6ba38, 0xdaf9c05f15896b5f),
                     I128(0xb6429ba7b5b38454, 0x4061839d268a0a78),
                     I128(0x19a0da005190a5ac, 0x755fa06484419e38),
                     I128(0xafc6e44400b9eadd, 0x05e5afdb2e66cdb8),
                     I128(0x5380c8796909a165, 0x47657977e6c4f381)));
  ASSERT128(I128(0x1f1b109234418f84, 0x21f9f24c8535e4f0),
            sub128x6(0x5ab6ba38, I128(0x0db9cd085ab6ba38, 0xdaf9c05f15896b5f),
                     I128(0xb6429ba7b5b38454, 0x4061839d268a0a78),
                     I128(0x19a0da005190a5ac, 0x755fa06484419e38),
                     I128(0xafc6e44400b9eadd, 0x05e5afdb2e66cdb8),
                     I128(0x5380c8796909a165, 0x47657977e6c4f381)));
}

void testCompare128(void) {
  __int128 x = 1, y = 2;
  ASSERT(0, x == y);
  ASSERT(1, x != y);
  ASSERT(1, x < y);
  ASSERT(1, x <= y);
  ASSERT(0, x > y);
  ASSERT(0, x >= y);
  ASSERT(1, x >= x);
  x = I128(-1ul, 2);
  y = I128(0xfffffffffffffff0, 2);
  ASSERT(0, x == y);
}

void testCastDblInt128(void) {
  int k;
  double f;
  __int128 i, w;
  k = 110;
  i = 1;
  i <<= k;
  f = i;
  f /= 2;
  i = f;
  w = 1;
  w <<= k - 1;
  ASSERT128(w, i);
}

void testCastDblUint128(void) {
  double f;
  unsigned __int128 i;
  i = 0x0000ffffffffffff;
  ++i;
  f = i;
  --f;
  i = f;
  --i;
  ASSERT128(0x0000fffffffffffe, i);
}

void testCastLdblInt128(void) {
  int k;
  __int128 i, w;
  long double f;
  k = 110;
  i = 1;
  i <<= k;
  f = i;
  f /= 2;
  i = f;
  w = 1;
  w <<= k - 1;
  ASSERT128(w, i);
}

void testCastLdblUint128(void) {
  long double f;
  unsigned __int128 i;
  i = 0xffffffffffffffff;
  ++i;
  f = i;
  --f;
  i = f;
  --i;
  ASSERT128(0xfffffffffffffffe, i);
}

void testAdd128(void) {
  __int128 x, y;
  x = I128(0, 0);
  y = I128(0, 0);
  ASSERT128(I128(0, 0), x + y);
  x = I128(0, 0);
  y = I128(0, 2);
  ASSERT128(I128(0, 2), x + y);
  x = I128(0, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, BANE), x + y);
  x = I128(0, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0, -1ul), x + y);
  x = I128(0, 0);
  y = I128(2, 0);
  ASSERT128(I128(2, 0), x + y);
  x = I128(0, 0);
  y = I128(2, 2);
  ASSERT128(I128(2, 2), x + y);
  x = I128(0, 0);
  y = I128(2, BANE);
  ASSERT128(I128(2, BANE), x + y);
  x = I128(0, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(2, -1ul), x + y);
  x = I128(0, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 0), x + y);
  x = I128(0, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 2), x + y);
  x = I128(0, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, BANE), x + y);
  x = I128(0, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, -1ul), x + y);
  x = I128(0, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 0), x + y);
  x = I128(0, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 2), x + y);
  x = I128(0, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE), x + y);
  x = I128(0, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, -1ul), x + y);
  x = I128(0, 2);
  y = I128(0, 0);
  ASSERT128(I128(0, 2), x + y);
  x = I128(0, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 4), x + y);
  x = I128(0, 2);
  y = I128(0, BANE);
  ASSERT128(I128(0, BANE2), x + y);
  x = I128(0, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(1, 1), x + y);
  x = I128(0, 2);
  y = I128(2, 0);
  ASSERT128(I128(2, 2), x + y);
  x = I128(0, 2);
  y = I128(2, 2);
  ASSERT128(I128(2, 4), x + y);
  x = I128(0, 2);
  y = I128(2, BANE);
  ASSERT128(I128(2, BANE2), x + y);
  x = I128(0, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(3, 1), x + y);
  x = I128(0, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 2), x + y);
  x = I128(0, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 4), x + y);
  x = I128(0, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, BANE2), x + y);
  x = I128(0, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE1, 1), x + y);
  x = I128(0, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 2), x + y);
  x = I128(0, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 4), x + y);
  x = I128(0, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE2), x + y);
  x = I128(0, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 1), x + y);
  x = I128(0, BANE);
  y = I128(0, 0);
  ASSERT128(I128(0, BANE), x + y);
  x = I128(0, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0, BANE2), x + y);
  x = I128(0, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(1, 0), x + y);
  x = I128(0, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(1, IMAX), x + y);
  x = I128(0, BANE);
  y = I128(2, 0);
  ASSERT128(I128(2, BANE), x + y);
  x = I128(0, BANE);
  y = I128(2, 2);
  ASSERT128(I128(2, BANE2), x + y);
  x = I128(0, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(3, 0), x + y);
  x = I128(0, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(3, IMAX), x + y);
  x = I128(0, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, BANE), x + y);
  x = I128(0, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, BANE2), x + y);
  x = I128(0, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE1, 0), x + y);
  x = I128(0, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE1, IMAX), x + y);
  x = I128(0, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, BANE), x + y);
  x = I128(0, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, BANE2), x + y);
  x = I128(0, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x + y);
  x = I128(0, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, IMAX), x + y);
  x = I128(0, -1ul);
  y = I128(0, 0);
  ASSERT128(I128(0, -1ul), x + y);
  x = I128(0, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(1, 1), x + y);
  x = I128(0, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(1, IMAX), x + y);
  x = I128(0, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(1, 0xfffffffffffffffe), x + y);
  x = I128(0, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(2, -1ul), x + y);
  x = I128(0, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(3, 1), x + y);
  x = I128(0, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(3, IMAX), x + y);
  x = I128(0, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(3, 0xfffffffffffffffe), x + y);
  x = I128(0, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, -1ul), x + y);
  x = I128(0, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE1, 1), x + y);
  x = I128(0, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE1, IMAX), x + y);
  x = I128(0, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE1, 0xfffffffffffffffe), x + y);
  x = I128(0, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, -1ul), x + y);
  x = I128(0, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 1), x + y);
  x = I128(0, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, IMAX), x + y);
  x = I128(0, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0xfffffffffffffffe), x + y);
  x = I128(2, 0);
  y = I128(0, 0);
  ASSERT128(I128(2, 0), x + y);
  x = I128(2, 0);
  y = I128(0, 2);
  ASSERT128(I128(2, 2), x + y);
  x = I128(2, 0);
  y = I128(0, BANE);
  ASSERT128(I128(2, BANE), x + y);
  x = I128(2, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(2, -1ul), x + y);
  x = I128(2, 0);
  y = I128(2, 0);
  ASSERT128(I128(4, 0), x + y);
  x = I128(2, 0);
  y = I128(2, 2);
  ASSERT128(I128(4, 2), x + y);
  x = I128(2, 0);
  y = I128(2, BANE);
  ASSERT128(I128(4, BANE), x + y);
  x = I128(2, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(4, -1ul), x + y);
  x = I128(2, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE2, 0), x + y);
  x = I128(2, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE2, 2), x + y);
  x = I128(2, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE2, BANE), x + y);
  x = I128(2, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE2, -1ul), x + y);
  x = I128(2, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(1, 0), x + y);
  x = I128(2, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(1, 2), x + y);
  x = I128(2, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(1, BANE), x + y);
  x = I128(2, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(1, -1ul), x + y);
  x = I128(2, 2);
  y = I128(0, 0);
  ASSERT128(I128(2, 2), x + y);
  x = I128(2, 2);
  y = I128(0, 2);
  ASSERT128(I128(2, 4), x + y);
  x = I128(2, 2);
  y = I128(0, BANE);
  ASSERT128(I128(2, BANE2), x + y);
  x = I128(2, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(3, 1), x + y);
  x = I128(2, 2);
  y = I128(2, 0);
  ASSERT128(I128(4, 2), x + y);
  x = I128(2, 2);
  y = I128(2, 2);
  ASSERT128(I128(4, 4), x + y);
  x = I128(2, 2);
  y = I128(2, BANE);
  ASSERT128(I128(4, BANE2), x + y);
  x = I128(2, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(5, 1), x + y);
  x = I128(2, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE2, 2), x + y);
  x = I128(2, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE2, 4), x + y);
  x = I128(2, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE2, BANE2), x + y);
  x = I128(2, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0x8000000000000003, 1), x + y);
  x = I128(2, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(1, 2), x + y);
  x = I128(2, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(1, 4), x + y);
  x = I128(2, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(1, BANE2), x + y);
  x = I128(2, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(2, 1), x + y);
  x = I128(2, BANE);
  y = I128(0, 0);
  ASSERT128(I128(2, BANE), x + y);
  x = I128(2, BANE);
  y = I128(0, 2);
  ASSERT128(I128(2, BANE2), x + y);
  x = I128(2, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(3, 0), x + y);
  x = I128(2, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(3, IMAX), x + y);
  x = I128(2, BANE);
  y = I128(2, 0);
  ASSERT128(I128(4, BANE), x + y);
  x = I128(2, BANE);
  y = I128(2, 2);
  ASSERT128(I128(4, BANE2), x + y);
  x = I128(2, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(5, 0), x + y);
  x = I128(2, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(5, IMAX), x + y);
  x = I128(2, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE2, BANE), x + y);
  x = I128(2, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE2, BANE2), x + y);
  x = I128(2, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0x8000000000000003, 0), x + y);
  x = I128(2, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0x8000000000000003, IMAX), x + y);
  x = I128(2, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(1, BANE), x + y);
  x = I128(2, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(1, BANE2), x + y);
  x = I128(2, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(2, 0), x + y);
  x = I128(2, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(2, IMAX), x + y);
  x = I128(2, -1ul);
  y = I128(0, 0);
  ASSERT128(I128(2, -1ul), x + y);
  x = I128(2, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(3, 1), x + y);
  x = I128(2, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(3, IMAX), x + y);
  x = I128(2, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(3, 0xfffffffffffffffe), x + y);
  x = I128(2, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(4, -1ul), x + y);
  x = I128(2, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(5, 1), x + y);
  x = I128(2, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(5, IMAX), x + y);
  x = I128(2, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(5, 0xfffffffffffffffe), x + y);
  x = I128(2, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE2, -1ul), x + y);
  x = I128(2, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(0x8000000000000003, 1), x + y);
  x = I128(2, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(0x8000000000000003, IMAX), x + y);
  x = I128(2, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0x8000000000000003, 0xfffffffffffffffe), x + y);
  x = I128(2, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(1, -1ul), x + y);
  x = I128(2, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(2, 1), x + y);
  x = I128(2, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(2, IMAX), x + y);
  x = I128(2, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(2, 0xfffffffffffffffe), x + y);
  x = I128(BANE, 0);
  y = I128(0, 0);
  ASSERT128(I128(BANE, 0), x + y);
  x = I128(BANE, 0);
  y = I128(0, 2);
  ASSERT128(I128(BANE, 2), x + y);
  x = I128(BANE, 0);
  y = I128(0, BANE);
  ASSERT128(I128(BANE, BANE), x + y);
  x = I128(BANE, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(BANE, -1ul), x + y);
  x = I128(BANE, 0);
  y = I128(2, 0);
  ASSERT128(I128(BANE2, 0), x + y);
  x = I128(BANE, 0);
  y = I128(2, 2);
  ASSERT128(I128(BANE2, 2), x + y);
  x = I128(BANE, 0);
  y = I128(2, BANE);
  ASSERT128(I128(BANE2, BANE), x + y);
  x = I128(BANE, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(BANE2, -1ul), x + y);
  x = I128(BANE, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x + y);
  x = I128(BANE, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 2), x + y);
  x = I128(BANE, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, BANE), x + y);
  x = I128(BANE, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, -1ul), x + y);
  x = I128(BANE, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(IMAX, 0), x + y);
  x = I128(BANE, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(IMAX, 2), x + y);
  x = I128(BANE, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(IMAX, BANE), x + y);
  x = I128(BANE, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX, -1ul), x + y);
  x = I128(BANE, 2);
  y = I128(0, 0);
  ASSERT128(I128(BANE, 2), x + y);
  x = I128(BANE, 2);
  y = I128(0, 2);
  ASSERT128(I128(BANE, 4), x + y);
  x = I128(BANE, 2);
  y = I128(0, BANE);
  ASSERT128(I128(BANE, BANE2), x + y);
  x = I128(BANE, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(BANE1, 1), x + y);
  x = I128(BANE, 2);
  y = I128(2, 0);
  ASSERT128(I128(BANE2, 2), x + y);
  x = I128(BANE, 2);
  y = I128(2, 2);
  ASSERT128(I128(BANE2, 4), x + y);
  x = I128(BANE, 2);
  y = I128(2, BANE);
  ASSERT128(I128(BANE2, BANE2), x + y);
  x = I128(BANE, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(0x8000000000000003, 1), x + y);
  x = I128(BANE, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 2), x + y);
  x = I128(BANE, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 4), x + y);
  x = I128(BANE, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, BANE2), x + y);
  x = I128(BANE, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(1, 1), x + y);
  x = I128(BANE, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(IMAX, 2), x + y);
  x = I128(BANE, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(IMAX, 4), x + y);
  x = I128(BANE, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(IMAX, BANE2), x + y);
  x = I128(BANE, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(BANE, 1), x + y);
  x = I128(BANE, BANE);
  y = I128(0, 0);
  ASSERT128(I128(BANE, BANE), x + y);
  x = I128(BANE, BANE);
  y = I128(0, 2);
  ASSERT128(I128(BANE, BANE2), x + y);
  x = I128(BANE, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(BANE1, 0), x + y);
  x = I128(BANE, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(BANE1, IMAX), x + y);
  x = I128(BANE, BANE);
  y = I128(2, 0);
  ASSERT128(I128(BANE2, BANE), x + y);
  x = I128(BANE, BANE);
  y = I128(2, 2);
  ASSERT128(I128(BANE2, BANE2), x + y);
  x = I128(BANE, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0x8000000000000003, 0), x + y);
  x = I128(BANE, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(0x8000000000000003, IMAX), x + y);
  x = I128(BANE, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, BANE), x + y);
  x = I128(BANE, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(0, BANE2), x + y);
  x = I128(BANE, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(1, 0), x + y);
  x = I128(BANE, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(1, IMAX), x + y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(IMAX, BANE), x + y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(IMAX, BANE2), x + y);
  x = I128(BANE, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(BANE, 0), x + y);
  x = I128(BANE, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(BANE, IMAX), x + y);
  x = I128(BANE, -1ul);
  y = I128(0, 0);
  ASSERT128(I128(BANE, -1ul), x + y);
  x = I128(BANE, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(BANE1, 1), x + y);
  x = I128(BANE, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(BANE1, IMAX), x + y);
  x = I128(BANE, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(BANE1, 0xfffffffffffffffe), x + y);
  x = I128(BANE, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(BANE2, -1ul), x + y);
  x = I128(BANE, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(0x8000000000000003, 1), x + y);
  x = I128(BANE, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0x8000000000000003, IMAX), x + y);
  x = I128(BANE, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0x8000000000000003, 0xfffffffffffffffe), x + y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(0, -1ul), x + y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(1, 1), x + y);
  x = I128(BANE, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(1, IMAX), x + y);
  x = I128(BANE, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(1, 0xfffffffffffffffe), x + y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(IMAX, -1ul), x + y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(BANE, 1), x + y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(BANE, IMAX), x + y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(BANE, 0xfffffffffffffffe), x + y);
  x = I128(-1ul, 0);
  y = I128(0, 0);
  ASSERT128(I128(-1ul, 0), x + y);
  x = I128(-1ul, 0);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, 2), x + y);
  x = I128(-1ul, 0);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, BANE), x + y);
  x = I128(-1ul, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, -1ul), x + y);
  x = I128(-1ul, 0);
  y = I128(2, 0);
  ASSERT128(I128(1, 0), x + y);
  x = I128(-1ul, 0);
  y = I128(2, 2);
  ASSERT128(I128(1, 2), x + y);
  x = I128(-1ul, 0);
  y = I128(2, BANE);
  ASSERT128(I128(1, BANE), x + y);
  x = I128(-1ul, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(1, -1ul), x + y);
  x = I128(-1ul, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(IMAX, 0), x + y);
  x = I128(-1ul, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(IMAX, 2), x + y);
  x = I128(-1ul, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(IMAX, BANE), x + y);
  x = I128(-1ul, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(IMAX, -1ul), x + y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0xfffffffffffffffe, 0), x + y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(0xfffffffffffffffe, 2), x + y);
  x = I128(-1ul, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0xfffffffffffffffe, BANE), x + y);
  x = I128(-1ul, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0xfffffffffffffffe, -1ul), x + y);
  x = I128(-1ul, 2);
  y = I128(0, 0);
  ASSERT128(I128(-1ul, 2), x + y);
  x = I128(-1ul, 2);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, 4), x + y);
  x = I128(-1ul, 2);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, BANE2), x + y);
  x = I128(-1ul, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 1), x + y);
  x = I128(-1ul, 2);
  y = I128(2, 0);
  ASSERT128(I128(1, 2), x + y);
  x = I128(-1ul, 2);
  y = I128(2, 2);
  ASSERT128(I128(1, 4), x + y);
  x = I128(-1ul, 2);
  y = I128(2, BANE);
  ASSERT128(I128(1, BANE2), x + y);
  x = I128(-1ul, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(2, 1), x + y);
  x = I128(-1ul, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(IMAX, 2), x + y);
  x = I128(-1ul, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(IMAX, 4), x + y);
  x = I128(-1ul, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(IMAX, BANE2), x + y);
  x = I128(-1ul, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, 1), x + y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(0xfffffffffffffffe, 2), x + y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0xfffffffffffffffe, 4), x + y);
  x = I128(-1ul, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0xfffffffffffffffe, BANE2), x + y);
  x = I128(-1ul, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, 1), x + y);
  x = I128(-1ul, BANE);
  y = I128(0, 0);
  ASSERT128(I128(-1ul, BANE), x + y);
  x = I128(-1ul, BANE);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, BANE2), x + y);
  x = I128(-1ul, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x + y);
  x = I128(-1ul, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, IMAX), x + y);
  x = I128(-1ul, BANE);
  y = I128(2, 0);
  ASSERT128(I128(1, BANE), x + y);
  x = I128(-1ul, BANE);
  y = I128(2, 2);
  ASSERT128(I128(1, BANE2), x + y);
  x = I128(-1ul, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(2, 0), x + y);
  x = I128(-1ul, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(2, IMAX), x + y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(IMAX, BANE), x + y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(IMAX, BANE2), x + y);
  x = I128(-1ul, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, 0), x + y);
  x = I128(-1ul, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, IMAX), x + y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(0xfffffffffffffffe, BANE), x + y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(0xfffffffffffffffe, BANE2), x + y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, 0), x + y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, IMAX), x + y);
  x = I128(-1ul, -1ul);
  y = I128(0, 0);
  ASSERT128(I128(-1ul, -1ul), x + y);
  x = I128(-1ul, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(0, 1), x + y);
  x = I128(-1ul, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(0, IMAX), x + y);
  x = I128(-1ul, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0xfffffffffffffffe), x + y);
  x = I128(-1ul, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(1, -1ul), x + y);
  x = I128(-1ul, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(2, 1), x + y);
  x = I128(-1ul, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(2, IMAX), x + y);
  x = I128(-1ul, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(2, 0xfffffffffffffffe), x + y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(IMAX, -1ul), x + y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 1), x + y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, IMAX), x + y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, 0xfffffffffffffffe), x + y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(0xfffffffffffffffe, -1ul), x + y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 1), x + y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, IMAX), x + y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x + y);
}

void testSub128(void) {
  __int128 x, y;
  x = I128(0, 0);
  y = I128(0, 0);
  ASSERT128(I128(0, 0), x - y);
  x = I128(0, 0);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x - y);
  x = I128(0, 0);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, BANE), x - y);
  x = I128(0, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, 1), x - y);
  x = I128(0, 0);
  y = I128(2, 0);
  ASSERT128(I128(0xfffffffffffffffe, 0), x - y);
  x = I128(0, 0);
  y = I128(2, 2);
  ASSERT128(I128(IMAX2, 0xfffffffffffffffe), x - y);
  x = I128(0, 0);
  y = I128(2, BANE);
  ASSERT128(I128(IMAX2, BANE), x - y);
  x = I128(0, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(IMAX2, 1), x - y);
  x = I128(0, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 0), x - y);
  x = I128(0, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(IMAX, 0xfffffffffffffffe), x - y);
  x = I128(0, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(IMAX, BANE), x - y);
  x = I128(0, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(IMAX, 1), x - y);
  x = I128(0, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(1, 0), x - y);
  x = I128(0, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0xfffffffffffffffe), x - y);
  x = I128(0, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, BANE), x - y);
  x = I128(0, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 1), x - y);
  x = I128(0, 2);
  y = I128(0, 0);
  ASSERT128(I128(0, 2), x - y);
  x = I128(0, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x - y);
  x = I128(0, 2);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, BANE2), x - y);
  x = I128(0, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, 3), x - y);
  x = I128(0, 2);
  y = I128(2, 0);
  ASSERT128(I128(0xfffffffffffffffe, 2), x - y);
  x = I128(0, 2);
  y = I128(2, 2);
  ASSERT128(I128(0xfffffffffffffffe, 0), x - y);
  x = I128(0, 2);
  y = I128(2, BANE);
  ASSERT128(I128(IMAX2, BANE2), x - y);
  x = I128(0, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(IMAX2, 3), x - y);
  x = I128(0, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 2), x - y);
  x = I128(0, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 0), x - y);
  x = I128(0, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(IMAX, BANE2), x - y);
  x = I128(0, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(IMAX, 3), x - y);
  x = I128(0, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(1, 2), x - y);
  x = I128(0, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(1, 0), x - y);
  x = I128(0, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, BANE2), x - y);
  x = I128(0, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 3), x - y);
  x = I128(0, BANE);
  y = I128(0, 0);
  ASSERT128(I128(0, BANE), x - y);
  x = I128(0, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0, 0x7ffffffffffffffe), x - y);
  x = I128(0, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x - y);
  x = I128(0, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, BANE1), x - y);
  x = I128(0, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0xfffffffffffffffe, BANE), x - y);
  x = I128(0, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0xfffffffffffffffe, 0x7ffffffffffffffe), x - y);
  x = I128(0, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0xfffffffffffffffe, 0), x - y);
  x = I128(0, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(IMAX2, BANE1), x - y);
  x = I128(0, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, BANE), x - y);
  x = I128(0, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 0x7ffffffffffffffe), x - y);
  x = I128(0, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, 0), x - y);
  x = I128(0, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(IMAX, BANE1), x - y);
  x = I128(0, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(1, BANE), x - y);
  x = I128(0, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(1, 0x7ffffffffffffffe), x - y);
  x = I128(0, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(1, 0), x - y);
  x = I128(0, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, BANE1), x - y);
  x = I128(0, -1ul);
  y = I128(0, 0);
  ASSERT128(I128(0, -1ul), x - y);
  x = I128(0, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(0, IMAX2), x - y);
  x = I128(0, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(0, IMAX), x - y);
  x = I128(0, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x - y);
  x = I128(0, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0xfffffffffffffffe, -1ul), x - y);
  x = I128(0, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(0xfffffffffffffffe, IMAX2), x - y);
  x = I128(0, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0xfffffffffffffffe, IMAX), x - y);
  x = I128(0, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0xfffffffffffffffe, 0), x - y);
  x = I128(0, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, -1ul), x - y);
  x = I128(0, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, IMAX2), x - y);
  x = I128(0, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, IMAX), x - y);
  x = I128(0, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, 0), x - y);
  x = I128(0, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(1, -1ul), x - y);
  x = I128(0, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(1, IMAX2), x - y);
  x = I128(0, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(1, IMAX), x - y);
  x = I128(0, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(1, 0), x - y);
  x = I128(2, 0);
  y = I128(0, 0);
  ASSERT128(I128(2, 0), x - y);
  x = I128(2, 0);
  y = I128(0, 2);
  ASSERT128(I128(1, 0xfffffffffffffffe), x - y);
  x = I128(2, 0);
  y = I128(0, BANE);
  ASSERT128(I128(1, BANE), x - y);
  x = I128(2, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(1, 1), x - y);
  x = I128(2, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x - y);
  x = I128(2, 0);
  y = I128(2, 2);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x - y);
  x = I128(2, 0);
  y = I128(2, BANE);
  ASSERT128(I128(-1ul, BANE), x - y);
  x = I128(2, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(-1ul, 1), x - y);
  x = I128(2, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE2, 0), x - y);
  x = I128(2, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE1, 0xfffffffffffffffe), x - y);
  x = I128(2, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE1, BANE), x - y);
  x = I128(2, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE1, 1), x - y);
  x = I128(2, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(3, 0), x - y);
  x = I128(2, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(2, 0xfffffffffffffffe), x - y);
  x = I128(2, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(2, BANE), x - y);
  x = I128(2, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(2, 1), x - y);
  x = I128(2, 2);
  y = I128(0, 0);
  ASSERT128(I128(2, 2), x - y);
  x = I128(2, 2);
  y = I128(0, 2);
  ASSERT128(I128(2, 0), x - y);
  x = I128(2, 2);
  y = I128(0, BANE);
  ASSERT128(I128(1, BANE2), x - y);
  x = I128(2, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(1, 3), x - y);
  x = I128(2, 2);
  y = I128(2, 0);
  ASSERT128(I128(0, 2), x - y);
  x = I128(2, 2);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x - y);
  x = I128(2, 2);
  y = I128(2, BANE);
  ASSERT128(I128(-1ul, BANE2), x - y);
  x = I128(2, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(-1ul, 3), x - y);
  x = I128(2, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE2, 2), x - y);
  x = I128(2, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE2, 0), x - y);
  x = I128(2, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE1, BANE2), x - y);
  x = I128(2, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE1, 3), x - y);
  x = I128(2, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(3, 2), x - y);
  x = I128(2, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(3, 0), x - y);
  x = I128(2, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(2, BANE2), x - y);
  x = I128(2, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(2, 3), x - y);
  x = I128(2, BANE);
  y = I128(0, 0);
  ASSERT128(I128(2, BANE), x - y);
  x = I128(2, BANE);
  y = I128(0, 2);
  ASSERT128(I128(2, 0x7ffffffffffffffe), x - y);
  x = I128(2, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(2, 0), x - y);
  x = I128(2, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(1, BANE1), x - y);
  x = I128(2, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, BANE), x - y);
  x = I128(2, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0, 0x7ffffffffffffffe), x - y);
  x = I128(2, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x - y);
  x = I128(2, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(-1ul, BANE1), x - y);
  x = I128(2, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE2, BANE), x - y);
  x = I128(2, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE2, 0x7ffffffffffffffe), x - y);
  x = I128(2, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE2, 0), x - y);
  x = I128(2, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE1, BANE1), x - y);
  x = I128(2, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(3, BANE), x - y);
  x = I128(2, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(3, 0x7ffffffffffffffe), x - y);
  x = I128(2, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(3, 0), x - y);
  x = I128(2, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(2, BANE1), x - y);
  x = I128(2, -1ul);
  y = I128(0, 0);
  ASSERT128(I128(2, -1ul), x - y);
  x = I128(2, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(2, IMAX2), x - y);
  x = I128(2, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(2, IMAX), x - y);
  x = I128(2, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(2, 0), x - y);
  x = I128(2, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0, -1ul), x - y);
  x = I128(2, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(0, IMAX2), x - y);
  x = I128(2, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0, IMAX), x - y);
  x = I128(2, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x - y);
  x = I128(2, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE2, -1ul), x - y);
  x = I128(2, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE2, IMAX2), x - y);
  x = I128(2, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE2, IMAX), x - y);
  x = I128(2, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE2, 0), x - y);
  x = I128(2, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(3, -1ul), x - y);
  x = I128(2, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(3, IMAX2), x - y);
  x = I128(2, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(3, IMAX), x - y);
  x = I128(2, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(3, 0), x - y);
  x = I128(BANE, 0);
  y = I128(0, 0);
  ASSERT128(I128(BANE, 0), x - y);
  x = I128(BANE, 0);
  y = I128(0, 2);
  ASSERT128(I128(IMAX, 0xfffffffffffffffe), x - y);
  x = I128(BANE, 0);
  y = I128(0, BANE);
  ASSERT128(I128(IMAX, BANE), x - y);
  x = I128(BANE, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(IMAX, 1), x - y);
  x = I128(BANE, 0);
  y = I128(2, 0);
  ASSERT128(I128(0x7ffffffffffffffe, 0), x - y);
  x = I128(BANE, 0);
  y = I128(2, 2);
  ASSERT128(I128(0x7ffffffffffffffd, 0xfffffffffffffffe), x - y);
  x = I128(BANE, 0);
  y = I128(2, BANE);
  ASSERT128(I128(0x7ffffffffffffffd, BANE), x - y);
  x = I128(BANE, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(0x7ffffffffffffffd, 1), x - y);
  x = I128(BANE, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x - y);
  x = I128(BANE, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x - y);
  x = I128(BANE, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(-1ul, BANE), x - y);
  x = I128(BANE, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(-1ul, 1), x - y);
  x = I128(BANE, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(BANE1, 0), x - y);
  x = I128(BANE, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(BANE, 0xfffffffffffffffe), x - y);
  x = I128(BANE, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(BANE, BANE), x - y);
  x = I128(BANE, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(BANE, 1), x - y);
  x = I128(BANE, 2);
  y = I128(0, 0);
  ASSERT128(I128(BANE, 2), x - y);
  x = I128(BANE, 2);
  y = I128(0, 2);
  ASSERT128(I128(BANE, 0), x - y);
  x = I128(BANE, 2);
  y = I128(0, BANE);
  ASSERT128(I128(IMAX, BANE2), x - y);
  x = I128(BANE, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(IMAX, 3), x - y);
  x = I128(BANE, 2);
  y = I128(2, 0);
  ASSERT128(I128(0x7ffffffffffffffe, 2), x - y);
  x = I128(BANE, 2);
  y = I128(2, 2);
  ASSERT128(I128(0x7ffffffffffffffe, 0), x - y);
  x = I128(BANE, 2);
  y = I128(2, BANE);
  ASSERT128(I128(0x7ffffffffffffffd, BANE2), x - y);
  x = I128(BANE, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(0x7ffffffffffffffd, 3), x - y);
  x = I128(BANE, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 2), x - y);
  x = I128(BANE, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x - y);
  x = I128(BANE, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(-1ul, BANE2), x - y);
  x = I128(BANE, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(-1ul, 3), x - y);
  x = I128(BANE, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(BANE1, 2), x - y);
  x = I128(BANE, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(BANE1, 0), x - y);
  x = I128(BANE, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(BANE, BANE2), x - y);
  x = I128(BANE, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(BANE, 3), x - y);
  x = I128(BANE, BANE);
  y = I128(0, 0);
  ASSERT128(I128(BANE, BANE), x - y);
  x = I128(BANE, BANE);
  y = I128(0, 2);
  ASSERT128(I128(BANE, 0x7ffffffffffffffe), x - y);
  x = I128(BANE, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(BANE, 0), x - y);
  x = I128(BANE, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(IMAX, BANE1), x - y);
  x = I128(BANE, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0x7ffffffffffffffe, BANE), x - y);
  x = I128(BANE, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0x7ffffffffffffffe, 0x7ffffffffffffffe), x - y);
  x = I128(BANE, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0x7ffffffffffffffe, 0), x - y);
  x = I128(BANE, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(0x7ffffffffffffffd, BANE1), x - y);
  x = I128(BANE, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, BANE), x - y);
  x = I128(BANE, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0x7ffffffffffffffe), x - y);
  x = I128(BANE, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x - y);
  x = I128(BANE, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(-1ul, BANE1), x - y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(BANE1, BANE), x - y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(BANE1, 0x7ffffffffffffffe), x - y);
  x = I128(BANE, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(BANE1, 0), x - y);
  x = I128(BANE, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(BANE, BANE1), x - y);
  x = I128(BANE, -1ul);
  y = I128(0, 0);
  ASSERT128(I128(BANE, -1ul), x - y);
  x = I128(BANE, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(BANE, IMAX2), x - y);
  x = I128(BANE, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(BANE, IMAX), x - y);
  x = I128(BANE, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(BANE, 0), x - y);
  x = I128(BANE, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0x7ffffffffffffffe, -1ul), x - y);
  x = I128(BANE, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(0x7ffffffffffffffe, IMAX2), x - y);
  x = I128(BANE, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0x7ffffffffffffffe, IMAX), x - y);
  x = I128(BANE, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0x7ffffffffffffffe, 0), x - y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(0, -1ul), x - y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(0, IMAX2), x - y);
  x = I128(BANE, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, IMAX), x - y);
  x = I128(BANE, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x - y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(BANE1, -1ul), x - y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(BANE1, IMAX2), x - y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(BANE1, IMAX), x - y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(BANE1, 0), x - y);
  x = I128(-1ul, 0);
  y = I128(0, 0);
  ASSERT128(I128(-1ul, 0), x - y);
  x = I128(-1ul, 0);
  y = I128(0, 2);
  ASSERT128(I128(0xfffffffffffffffe, 0xfffffffffffffffe), x - y);
  x = I128(-1ul, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0xfffffffffffffffe, BANE), x - y);
  x = I128(-1ul, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0xfffffffffffffffe, 1), x - y);
  x = I128(-1ul, 0);
  y = I128(2, 0);
  ASSERT128(I128(IMAX2, 0), x - y);
  x = I128(-1ul, 0);
  y = I128(2, 2);
  ASSERT128(I128(0xfffffffffffffffc, 0xfffffffffffffffe), x - y);
  x = I128(-1ul, 0);
  y = I128(2, BANE);
  ASSERT128(I128(0xfffffffffffffffc, BANE), x - y);
  x = I128(-1ul, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(0xfffffffffffffffc, 1), x - y);
  x = I128(-1ul, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(IMAX, 0), x - y);
  x = I128(-1ul, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(0x7ffffffffffffffe, 0xfffffffffffffffe), x - y);
  x = I128(-1ul, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(0x7ffffffffffffffe, BANE), x - y);
  x = I128(-1ul, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0x7ffffffffffffffe, 1), x - y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x - y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x - y);
  x = I128(-1ul, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE), x - y);
  x = I128(-1ul, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, 1), x - y);
  x = I128(-1ul, 2);
  y = I128(0, 0);
  ASSERT128(I128(-1ul, 2), x - y);
  x = I128(-1ul, 2);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, 0), x - y);
  x = I128(-1ul, 2);
  y = I128(0, BANE);
  ASSERT128(I128(0xfffffffffffffffe, BANE2), x - y);
  x = I128(-1ul, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0xfffffffffffffffe, 3), x - y);
  x = I128(-1ul, 2);
  y = I128(2, 0);
  ASSERT128(I128(IMAX2, 2), x - y);
  x = I128(-1ul, 2);
  y = I128(2, 2);
  ASSERT128(I128(IMAX2, 0), x - y);
  x = I128(-1ul, 2);
  y = I128(2, BANE);
  ASSERT128(I128(0xfffffffffffffffc, BANE2), x - y);
  x = I128(-1ul, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(0xfffffffffffffffc, 3), x - y);
  x = I128(-1ul, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(IMAX, 2), x - y);
  x = I128(-1ul, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(IMAX, 0), x - y);
  x = I128(-1ul, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(0x7ffffffffffffffe, BANE2), x - y);
  x = I128(-1ul, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0x7ffffffffffffffe, 3), x - y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 2), x - y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x - y);
  x = I128(-1ul, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE2), x - y);
  x = I128(-1ul, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, 3), x - y);
  x = I128(-1ul, BANE);
  y = I128(0, 0);
  ASSERT128(I128(-1ul, BANE), x - y);
  x = I128(-1ul, BANE);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, 0x7ffffffffffffffe), x - y);
  x = I128(-1ul, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, 0), x - y);
  x = I128(-1ul, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0xfffffffffffffffe, BANE1), x - y);
  x = I128(-1ul, BANE);
  y = I128(2, 0);
  ASSERT128(I128(IMAX2, BANE), x - y);
  x = I128(-1ul, BANE);
  y = I128(2, 2);
  ASSERT128(I128(IMAX2, 0x7ffffffffffffffe), x - y);
  x = I128(-1ul, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(IMAX2, 0), x - y);
  x = I128(-1ul, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(0xfffffffffffffffc, BANE1), x - y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(IMAX, BANE), x - y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(IMAX, 0x7ffffffffffffffe), x - y);
  x = I128(-1ul, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(IMAX, 0), x - y);
  x = I128(-1ul, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0x7ffffffffffffffe, BANE1), x - y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, BANE), x - y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0x7ffffffffffffffe), x - y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x - y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, BANE1), x - y);
  x = I128(-1ul, -1ul);
  y = I128(0, 0);
  ASSERT128(I128(-1ul, -1ul), x - y);
  x = I128(-1ul, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, IMAX2), x - y);
  x = I128(-1ul, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, IMAX), x - y);
  x = I128(-1ul, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, 0), x - y);
  x = I128(-1ul, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(IMAX2, -1ul), x - y);
  x = I128(-1ul, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(IMAX2, IMAX2), x - y);
  x = I128(-1ul, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(IMAX2, IMAX), x - y);
  x = I128(-1ul, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(IMAX2, 0), x - y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(IMAX, -1ul), x - y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(IMAX, IMAX2), x - y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(IMAX, IMAX), x - y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(IMAX, 0), x - y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, -1ul), x - y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, IMAX2), x - y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, IMAX), x - y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x - y);
}

void testMul128(void) {
  __int128 x, y;
  x = I128(0, 0);
  y = I128(0, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, 0);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, 0);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, 0);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, 2);
  y = I128(0, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 4), x * y);
  x = I128(0, 2);
  y = I128(0, BANE);
  ASSERT128(I128(1, 0), x * y);
  x = I128(0, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(1, 0xfffffffffffffffe), x * y);
  x = I128(0, 2);
  y = I128(2, 0);
  ASSERT128(I128(4, 0), x * y);
  x = I128(0, 2);
  y = I128(2, 2);
  ASSERT128(I128(4, 4), x * y);
  x = I128(0, 2);
  y = I128(2, BANE);
  ASSERT128(I128(5, 0), x * y);
  x = I128(0, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(5, 0xfffffffffffffffe), x * y);
  x = I128(0, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 4), x * y);
  x = I128(0, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(1, 0), x * y);
  x = I128(0, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(1, 0xfffffffffffffffe), x * y);
  x = I128(0, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(0xfffffffffffffffe, 0), x * y);
  x = I128(0, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0xfffffffffffffffe, 4), x * y);
  x = I128(0, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, 0), x * y);
  x = I128(0, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x * y);
  x = I128(0, BANE);
  y = I128(0, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, BANE);
  y = I128(0, 2);
  ASSERT128(I128(1, 0), x * y);
  x = I128(0, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0x4000000000000000, 0), x * y);
  x = I128(0, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(IMAX, BANE), x * y);
  x = I128(0, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, BANE);
  y = I128(2, 2);
  ASSERT128(I128(1, 0), x * y);
  x = I128(0, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0x4000000000000000, 0), x * y);
  x = I128(0, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(IMAX, BANE), x * y);
  x = I128(0, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(1, 0), x * y);
  x = I128(0, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0x4000000000000000, 0), x * y);
  x = I128(0, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(IMAX, BANE), x * y);
  x = I128(0, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(BANE, 0), x * y);
  x = I128(0, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(BANE1, 0), x * y);
  x = I128(0, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0xc000000000000000, 0), x * y);
  x = I128(0, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, BANE), x * y);
  x = I128(0, -1ul);
  y = I128(0, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(0, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(1, 0xfffffffffffffffe), x * y);
  x = I128(0, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(IMAX, BANE), x * y);
  x = I128(0, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0xfffffffffffffffe, 1), x * y);
  x = I128(0, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0xfffffffffffffffe, 0), x * y);
  x = I128(0, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x * y);
  x = I128(0, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0x7ffffffffffffffd, BANE), x * y);
  x = I128(0, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0xfffffffffffffffc, 1), x * y);
  x = I128(0, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 0), x * y);
  x = I128(0, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE1, 0xfffffffffffffffe), x * y);
  x = I128(0, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(-1ul, BANE), x * y);
  x = I128(0, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0x7ffffffffffffffe, 1), x * y);
  x = I128(0, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(1, 0), x * y);
  x = I128(0, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(2, 0xfffffffffffffffe), x * y);
  x = I128(0, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(BANE, BANE), x * y);
  x = I128(0, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, 1), x * y);
  x = I128(2, 0);
  y = I128(0, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(2, 0);
  y = I128(0, 2);
  ASSERT128(I128(4, 0), x * y);
  x = I128(2, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x * y);
  x = I128(2, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0xfffffffffffffffe, 0), x * y);
  x = I128(2, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(2, 0);
  y = I128(2, 2);
  ASSERT128(I128(4, 0), x * y);
  x = I128(2, 0);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x * y);
  x = I128(2, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(0xfffffffffffffffe, 0), x * y);
  x = I128(2, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(2, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(4, 0), x * y);
  x = I128(2, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x * y);
  x = I128(2, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0xfffffffffffffffe, 0), x * y);
  x = I128(2, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(2, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(4, 0), x * y);
  x = I128(2, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x * y);
  x = I128(2, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0xfffffffffffffffe, 0), x * y);
  x = I128(2, 2);
  y = I128(0, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(2, 2);
  y = I128(0, 2);
  ASSERT128(I128(4, 4), x * y);
  x = I128(2, 2);
  y = I128(0, BANE);
  ASSERT128(I128(1, 0), x * y);
  x = I128(2, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x * y);
  x = I128(2, 2);
  y = I128(2, 0);
  ASSERT128(I128(4, 0), x * y);
  x = I128(2, 2);
  y = I128(2, 2);
  ASSERT128(I128(0x0000000000000008, 4), x * y);
  x = I128(2, 2);
  y = I128(2, BANE);
  ASSERT128(I128(5, 0), x * y);
  x = I128(2, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(3, 0xfffffffffffffffe), x * y);
  x = I128(2, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(2, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(4, 4), x * y);
  x = I128(2, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(1, 0), x * y);
  x = I128(2, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x * y);
  x = I128(2, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(0xfffffffffffffffe, 0), x * y);
  x = I128(2, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(2, 4), x * y);
  x = I128(2, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, 0), x * y);
  x = I128(2, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX2, 0xfffffffffffffffe), x * y);
  x = I128(2, BANE);
  y = I128(0, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(2, BANE);
  y = I128(0, 2);
  ASSERT128(I128(5, 0), x * y);
  x = I128(2, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0x4000000000000000, 0), x * y);
  x = I128(2, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0x7ffffffffffffffd, BANE), x * y);
  x = I128(2, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(2, BANE);
  y = I128(2, 2);
  ASSERT128(I128(5, 0), x * y);
  x = I128(2, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0x4000000000000000, 0), x * y);
  x = I128(2, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(0x7ffffffffffffffd, BANE), x * y);
  x = I128(2, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(2, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(5, 0), x * y);
  x = I128(2, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0x4000000000000000, 0), x * y);
  x = I128(2, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0x7ffffffffffffffd, BANE), x * y);
  x = I128(2, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(BANE, 0), x * y);
  x = I128(2, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(0x8000000000000005, 0), x * y);
  x = I128(2, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0xc000000000000000, 0), x * y);
  x = I128(2, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX2, BANE), x * y);
  x = I128(2, -1ul);
  y = I128(0, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(2, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(5, 0xfffffffffffffffe), x * y);
  x = I128(2, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(IMAX, BANE), x * y);
  x = I128(2, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0xfffffffffffffffc, 1), x * y);
  x = I128(2, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0xfffffffffffffffe, 0), x * y);
  x = I128(2, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(3, 0xfffffffffffffffe), x * y);
  x = I128(2, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0x7ffffffffffffffd, BANE), x * y);
  x = I128(2, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0xfffffffffffffffa, 1), x * y);
  x = I128(2, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 0), x * y);
  x = I128(2, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(0x8000000000000005, 0xfffffffffffffffe), x * y);
  x = I128(2, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(-1ul, BANE), x * y);
  x = I128(2, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0x7ffffffffffffffc, 1), x * y);
  x = I128(2, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(1, 0), x * y);
  x = I128(2, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(0x0000000000000006, 0xfffffffffffffffe), x * y);
  x = I128(2, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(BANE, BANE), x * y);
  x = I128(2, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX2, 1), x * y);
  x = I128(BANE, 0);
  y = I128(0, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(BANE, 0);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x * y);
  x = I128(BANE, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x * y);
  x = I128(BANE, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(BANE, 0), x * y);
  x = I128(BANE, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(BANE, 0);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x * y);
  x = I128(BANE, 0);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x * y);
  x = I128(BANE, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(BANE, 0), x * y);
  x = I128(BANE, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(BANE, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x * y);
  x = I128(BANE, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x * y);
  x = I128(BANE, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, 0), x * y);
  x = I128(BANE, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(BANE, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x * y);
  x = I128(BANE, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x * y);
  x = I128(BANE, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(BANE, 0), x * y);
  x = I128(BANE, 2);
  y = I128(0, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(BANE, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 4), x * y);
  x = I128(BANE, 2);
  y = I128(0, BANE);
  ASSERT128(I128(1, 0), x * y);
  x = I128(BANE, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(BANE1, 0xfffffffffffffffe), x * y);
  x = I128(BANE, 2);
  y = I128(2, 0);
  ASSERT128(I128(4, 0), x * y);
  x = I128(BANE, 2);
  y = I128(2, 2);
  ASSERT128(I128(4, 4), x * y);
  x = I128(BANE, 2);
  y = I128(2, BANE);
  ASSERT128(I128(5, 0), x * y);
  x = I128(BANE, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(0x8000000000000005, 0xfffffffffffffffe), x * y);
  x = I128(BANE, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(BANE, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 4), x * y);
  x = I128(BANE, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(1, 0), x * y);
  x = I128(BANE, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE1, 0xfffffffffffffffe), x * y);
  x = I128(BANE, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(0xfffffffffffffffe, 0), x * y);
  x = I128(BANE, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0xfffffffffffffffe, 4), x * y);
  x = I128(BANE, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, 0), x * y);
  x = I128(BANE, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX, 0xfffffffffffffffe), x * y);
  x = I128(BANE, BANE);
  y = I128(0, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(BANE, BANE);
  y = I128(0, 2);
  ASSERT128(I128(1, 0), x * y);
  x = I128(BANE, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0x4000000000000000, 0), x * y);
  x = I128(BANE, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, BANE), x * y);
  x = I128(BANE, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(BANE, BANE);
  y = I128(2, 2);
  ASSERT128(I128(1, 0), x * y);
  x = I128(BANE, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0x4000000000000000, 0), x * y);
  x = I128(BANE, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(-1ul, BANE), x * y);
  x = I128(BANE, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(BANE, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(1, 0), x * y);
  x = I128(BANE, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0x4000000000000000, 0), x * y);
  x = I128(BANE, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(-1ul, BANE), x * y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(BANE, 0), x * y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(BANE1, 0), x * y);
  x = I128(BANE, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0xc000000000000000, 0), x * y);
  x = I128(BANE, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX, BANE), x * y);
  x = I128(BANE, -1ul);
  y = I128(0, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(BANE, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(1, 0xfffffffffffffffe), x * y);
  x = I128(BANE, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(IMAX, BANE), x * y);
  x = I128(BANE, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0x7ffffffffffffffe, 1), x * y);
  x = I128(BANE, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0xfffffffffffffffe, 0), x * y);
  x = I128(BANE, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x * y);
  x = I128(BANE, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0x7ffffffffffffffd, BANE), x * y);
  x = I128(BANE, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0x7ffffffffffffffc, 1), x * y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 0), x * y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE1, 0xfffffffffffffffe), x * y);
  x = I128(BANE, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(-1ul, BANE), x * y);
  x = I128(BANE, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0xfffffffffffffffe, 1), x * y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(1, 0), x * y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(2, 0xfffffffffffffffe), x * y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(BANE, BANE), x * y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX, 1), x * y);
  x = I128(-1ul, 0);
  y = I128(0, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(-1ul, 0);
  y = I128(0, 2);
  ASSERT128(I128(0xfffffffffffffffe, 0), x * y);
  x = I128(-1ul, 0);
  y = I128(0, BANE);
  ASSERT128(I128(BANE, 0), x * y);
  x = I128(-1ul, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(1, 0), x * y);
  x = I128(-1ul, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(-1ul, 0);
  y = I128(2, 2);
  ASSERT128(I128(0xfffffffffffffffe, 0), x * y);
  x = I128(-1ul, 0);
  y = I128(2, BANE);
  ASSERT128(I128(BANE, 0), x * y);
  x = I128(-1ul, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(1, 0), x * y);
  x = I128(-1ul, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(-1ul, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(0xfffffffffffffffe, 0), x * y);
  x = I128(-1ul, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, 0), x * y);
  x = I128(-1ul, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(1, 0), x * y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(0xfffffffffffffffe, 0), x * y);
  x = I128(-1ul, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(BANE, 0), x * y);
  x = I128(-1ul, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(1, 0), x * y);
  x = I128(-1ul, 2);
  y = I128(0, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(-1ul, 2);
  y = I128(0, 2);
  ASSERT128(I128(0xfffffffffffffffe, 4), x * y);
  x = I128(-1ul, 2);
  y = I128(0, BANE);
  ASSERT128(I128(BANE1, 0), x * y);
  x = I128(-1ul, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(2, 0xfffffffffffffffe), x * y);
  x = I128(-1ul, 2);
  y = I128(2, 0);
  ASSERT128(I128(4, 0), x * y);
  x = I128(-1ul, 2);
  y = I128(2, 2);
  ASSERT128(I128(2, 4), x * y);
  x = I128(-1ul, 2);
  y = I128(2, BANE);
  ASSERT128(I128(0x8000000000000005, 0), x * y);
  x = I128(-1ul, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(0x0000000000000006, 0xfffffffffffffffe), x * y);
  x = I128(-1ul, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(-1ul, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0xfffffffffffffffe, 4), x * y);
  x = I128(-1ul, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE1, 0), x * y);
  x = I128(-1ul, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(2, 0xfffffffffffffffe), x * y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(0xfffffffffffffffe, 0), x * y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0xfffffffffffffffc, 4), x * y);
  x = I128(-1ul, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(IMAX, 0), x * y);
  x = I128(-1ul, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0xfffffffffffffffe), x * y);
  x = I128(-1ul, BANE);
  y = I128(0, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(-1ul, BANE);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, 0), x * y);
  x = I128(-1ul, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0xc000000000000000, 0), x * y);
  x = I128(-1ul, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(BANE, BANE), x * y);
  x = I128(-1ul, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(-1ul, BANE);
  y = I128(2, 2);
  ASSERT128(I128(-1ul, 0), x * y);
  x = I128(-1ul, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0xc000000000000000, 0), x * y);
  x = I128(-1ul, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(BANE, BANE), x * y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(-1ul, 0), x * y);
  x = I128(-1ul, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0xc000000000000000, 0), x * y);
  x = I128(-1ul, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, BANE), x * y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(BANE, 0), x * y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(IMAX, 0), x * y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0x4000000000000000, 0), x * y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, BANE), x * y);
  x = I128(-1ul, -1ul);
  y = I128(0, 0);
  ASSERT128(I128(0, 0), x * y);
  x = I128(-1ul, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x * y);
  x = I128(-1ul, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, BANE), x * y);
  x = I128(-1ul, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, 1), x * y);
  x = I128(-1ul, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0xfffffffffffffffe, 0), x * y);
  x = I128(-1ul, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(IMAX2, 0xfffffffffffffffe), x * y);
  x = I128(-1ul, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(IMAX2, BANE), x * y);
  x = I128(-1ul, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(IMAX2, 1), x * y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 0), x * y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(IMAX, 0xfffffffffffffffe), x * y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(IMAX, BANE), x * y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(IMAX, 1), x * y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(1, 0), x * y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0xfffffffffffffffe), x * y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, BANE), x * y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 1), x * y);
}

void testDiv128(void) {
  __int128 x, y;
  x = I128(0, 0);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(0, 2);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x / y);
  x = I128(0, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0, 0x4000000000000000), x / y);
  x = I128(0, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(0, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, -1ul), x / y);
  x = I128(0, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, BANE), x / y);
  x = I128(0, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(0, IMAX), x / y);
  x = I128(0, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(0, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 1), x / y);
  x = I128(0, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, -1ul), x / y);
  x = I128(0, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, -1ul), x / y);
  x = I128(0, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, 1), x / y);
  x = I128(2, 0);
  y = I128(0, 2);
  ASSERT128(I128(1, 0), x / y);
  x = I128(2, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, 4), x / y);
  x = I128(2, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 2), x / y);
  x = I128(2, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, 0);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 0);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x / y);
  x = I128(2, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x / y);
  x = I128(2, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, 0xfffffffffffffffc), x / y);
  x = I128(2, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0xfffffffffffffffe, 0), x / y);
  x = I128(2, 2);
  y = I128(0, 2);
  ASSERT128(I128(1, 1), x / y);
  x = I128(2, 2);
  y = I128(0, BANE);
  ASSERT128(I128(0, 4), x / y);
  x = I128(2, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 2), x / y);
  x = I128(2, 2);
  y = I128(2, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, 2);
  y = I128(2, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, 2);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x / y);
  x = I128(2, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x / y);
  x = I128(2, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, 0xfffffffffffffffc), x / y);
  x = I128(2, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX2, 0xfffffffffffffffe), x / y);
  x = I128(2, BANE);
  y = I128(0, 2);
  ASSERT128(I128(1, 0x4000000000000000), x / y);
  x = I128(2, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, 5), x / y);
  x = I128(2, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 2), x / y);
  x = I128(2, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x / y);
  x = I128(2, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x / y);
  x = I128(2, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, 0xfffffffffffffffb), x / y);
  x = I128(2, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX2, BANE), x / y);
  x = I128(2, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(1, IMAX), x / y);
  x = I128(2, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(0, 5), x / y);
  x = I128(2, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 3), x / y);
  x = I128(2, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x / y);
  x = I128(2, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, IMAX2), x / y);
  x = I128(2, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, 0xfffffffffffffffb), x / y);
  x = I128(2, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX2, 1), x / y);
  x = I128(BANE, 0);
  y = I128(0, 2);
  ASSERT128(I128(0xc000000000000000, 0), x / y);
  x = I128(BANE, 0);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, 0), x / y);
  x = I128(BANE, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, BANE), x / y);
  x = I128(BANE, 0);
  y = I128(2, 0);
  ASSERT128(I128(-1ul, 0xc000000000000000), x / y);
  x = I128(BANE, 0);
  y = I128(2, 2);
  ASSERT128(I128(-1ul, 0xc000000000000001), x / y);
  x = I128(BANE, 0);
  y = I128(2, BANE);
  ASSERT128(I128(-1ul, 0xcccccccccccccccd), x / y);
  x = I128(BANE, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(-1ul, 0xd555555555555556), x / y);
  x = I128(BANE, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, BANE), x / y);
  x = I128(BANE, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, BANE1), x / y);
  x = I128(BANE, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(1, 0), x / y);
  x = I128(BANE, 2);
  y = I128(0, 2);
  ASSERT128(I128(0xc000000000000000, 1), x / y);
  x = I128(BANE, 2);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, 1), x / y);
  x = I128(BANE, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, BANE), x / y);
  x = I128(BANE, 2);
  y = I128(2, 0);
  ASSERT128(I128(-1ul, 0xc000000000000001), x / y);
  x = I128(BANE, 2);
  y = I128(2, 2);
  ASSERT128(I128(-1ul, 0xc000000000000001), x / y);
  x = I128(BANE, 2);
  y = I128(2, BANE);
  ASSERT128(I128(-1ul, 0xcccccccccccccccd), x / y);
  x = I128(BANE, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(-1ul, 0xd555555555555556), x / y);
  x = I128(BANE, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, IMAX), x / y);
  x = I128(BANE, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, BANE1), x / y);
  x = I128(BANE, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, -1ul), x / y);
  x = I128(BANE, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX, 0xfffffffffffffffe), x / y);
  x = I128(BANE, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0xc000000000000000, 0x4000000000000000), x / y);
  x = I128(BANE, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, 1), x / y);
  x = I128(BANE, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, BANE), x / y);
  x = I128(BANE, BANE);
  y = I128(2, 0);
  ASSERT128(I128(-1ul, 0xc000000000000001), x / y);
  x = I128(BANE, BANE);
  y = I128(2, 2);
  ASSERT128(I128(-1ul, 0xc000000000000001), x / y);
  x = I128(BANE, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(-1ul, 0xcccccccccccccccd), x / y);
  x = I128(BANE, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(-1ul, 0xd555555555555556), x / y);
  x = I128(BANE, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, IMAX), x / y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, BANE), x / y);
  x = I128(BANE, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, -1ul), x / y);
  x = I128(BANE, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX, BANE), x / y);
  x = I128(BANE, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(0xc000000000000000, BANE), x / y);
  x = I128(BANE, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, 2), x / y);
  x = I128(BANE, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, BANE1), x / y);
  x = I128(BANE, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(-1ul, 0xc000000000000001), x / y);
  x = I128(BANE, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(-1ul, 0xc000000000000001), x / y);
  x = I128(BANE, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(-1ul, 0xccccccccccccccce), x / y);
  x = I128(BANE, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(-1ul, 0xd555555555555556), x / y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, IMAX), x / y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, BANE), x / y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0xfffffffffffffffe), x / y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX, 1), x / y);
  x = I128(-1ul, 0);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, BANE), x / y);
  x = I128(-1ul, 0);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x / y);
  x = I128(-1ul, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, -1ul), x / y);
  x = I128(-1ul, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 0);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 0);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 2), x / y);
  x = I128(-1ul, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(1, 0), x / y);
  x = I128(-1ul, 2);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, BANE1), x / y);
  x = I128(-1ul, 2);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, -1ul), x / y);
  x = I128(-1ul, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 2);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 2);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 2);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0xfffffffffffffffe), x / y);
  x = I128(-1ul, BANE);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, 0xc000000000000000), x / y);
  x = I128(-1ul, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, -1ul), x / y);
  x = I128(-1ul, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, BANE), x / y);
  x = I128(-1ul, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 1), x / y);
}

void testDivu128(void) {
  unsigned __int128 x, y;
  x = I128(0, 0);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(0, 2);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0, 0x4000000000000000), x / y);
  x = I128(0, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(0, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(0, IMAX), x / y);
  x = I128(0, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(0, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 1), x / y);
  x = I128(0, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(0, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 0);
  y = I128(0, 2);
  ASSERT128(I128(1, 0), x / y);
  x = I128(2, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, 4), x / y);
  x = I128(2, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 2), x / y);
  x = I128(2, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, 0);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 0);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 2);
  y = I128(0, 2);
  ASSERT128(I128(1, 1), x / y);
  x = I128(2, 2);
  y = I128(0, BANE);
  ASSERT128(I128(0, 4), x / y);
  x = I128(2, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 2), x / y);
  x = I128(2, 2);
  y = I128(2, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, 2);
  y = I128(2, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, 2);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, BANE);
  y = I128(0, 2);
  ASSERT128(I128(1, 0x4000000000000000), x / y);
  x = I128(2, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, 5), x / y);
  x = I128(2, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 2), x / y);
  x = I128(2, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(1, IMAX), x / y);
  x = I128(2, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(0, 5), x / y);
  x = I128(2, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 3), x / y);
  x = I128(2, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 1), x / y);
  x = I128(2, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(2, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, 0);
  y = I128(0, 2);
  ASSERT128(I128(0x4000000000000000, 0), x / y);
  x = I128(BANE, 0);
  y = I128(0, BANE);
  ASSERT128(I128(1, 0), x / y);
  x = I128(BANE, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0, BANE), x / y);
  x = I128(BANE, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 0x4000000000000000), x / y);
  x = I128(BANE, 0);
  y = I128(2, 2);
  ASSERT128(I128(0, 0x3fffffffffffffff), x / y);
  x = I128(BANE, 0);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0x3333333333333333), x / y);
  x = I128(BANE, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0x2aaaaaaaaaaaaaaa), x / y);
  x = I128(BANE, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, 2);
  y = I128(0, 2);
  ASSERT128(I128(0x4000000000000000, 1), x / y);
  x = I128(BANE, 2);
  y = I128(0, BANE);
  ASSERT128(I128(1, 0), x / y);
  x = I128(BANE, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0, BANE), x / y);
  x = I128(BANE, 2);
  y = I128(2, 0);
  ASSERT128(I128(0, 0x4000000000000000), x / y);
  x = I128(BANE, 2);
  y = I128(2, 2);
  ASSERT128(I128(0, 0x3fffffffffffffff), x / y);
  x = I128(BANE, 2);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0x3333333333333333), x / y);
  x = I128(BANE, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0x2aaaaaaaaaaaaaaa), x / y);
  x = I128(BANE, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0x4000000000000000, 0x4000000000000000), x / y);
  x = I128(BANE, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(1, 1), x / y);
  x = I128(BANE, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, BANE1), x / y);
  x = I128(BANE, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, 0x4000000000000000), x / y);
  x = I128(BANE, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0, 0x4000000000000000), x / y);
  x = I128(BANE, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0x3333333333333333), x / y);
  x = I128(BANE, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0x2aaaaaaaaaaaaaaa), x / y);
  x = I128(BANE, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(0x4000000000000000, IMAX), x / y);
  x = I128(BANE, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(1, 1), x / y);
  x = I128(BANE, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, BANE1), x / y);
  x = I128(BANE, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0, 0x4000000000000000), x / y);
  x = I128(BANE, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(0, 0x4000000000000000), x / y);
  x = I128(BANE, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0x3333333333333333), x / y);
  x = I128(BANE, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0x2aaaaaaaaaaaaaab), x / y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 1), x / y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 0);
  y = I128(0, 2);
  ASSERT128(I128(IMAX, BANE), x / y);
  x = I128(-1ul, 0);
  y = I128(0, BANE);
  ASSERT128(I128(1, 0xfffffffffffffffe), x / y);
  x = I128(-1ul, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(1, 0), x / y);
  x = I128(-1ul, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, IMAX), x / y);
  x = I128(-1ul, 0);
  y = I128(2, 2);
  ASSERT128(I128(0, IMAX), x / y);
  x = I128(-1ul, 0);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0x6666666666666666), x / y);
  x = I128(-1ul, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0x5555555555555555), x / y);
  x = I128(-1ul, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 2);
  y = I128(0, 2);
  ASSERT128(I128(IMAX, BANE1), x / y);
  x = I128(-1ul, 2);
  y = I128(0, BANE);
  ASSERT128(I128(1, 0xfffffffffffffffe), x / y);
  x = I128(-1ul, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(1, 0), x / y);
  x = I128(-1ul, 2);
  y = I128(2, 0);
  ASSERT128(I128(0, IMAX), x / y);
  x = I128(-1ul, 2);
  y = I128(2, 2);
  ASSERT128(I128(0, IMAX), x / y);
  x = I128(-1ul, 2);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0x6666666666666666), x / y);
  x = I128(-1ul, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0x5555555555555555), x / y);
  x = I128(-1ul, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, BANE);
  y = I128(0, 2);
  ASSERT128(I128(IMAX, 0xc000000000000000), x / y);
  x = I128(-1ul, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(1, -1ul), x / y);
  x = I128(-1ul, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(1, 0), x / y);
  x = I128(-1ul, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, IMAX), x / y);
  x = I128(-1ul, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0, IMAX), x / y);
  x = I128(-1ul, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0x6666666666666666), x / y);
  x = I128(-1ul, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0x5555555555555555), x / y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x / y);
  x = I128(-1ul, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(IMAX, -1ul), x / y);
  x = I128(-1ul, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(1, -1ul), x / y);
  x = I128(-1ul, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(1, 1), x / y);
  x = I128(-1ul, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0, IMAX), x / y);
  x = I128(-1ul, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(0, IMAX), x / y);
  x = I128(-1ul, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0x6666666666666666), x / y);
  x = I128(-1ul, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0x5555555555555555), x / y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 1), x / y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 1), x / y);
}

void testRem128(void) {
  __int128 x, y;
  x = I128(0, 0);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 2);
  y = I128(0, BANE);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(2, 0);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(2, 2);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(2, BANE);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(0, 1), x % y);
  x = I128(0, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(0, IMAX), x % y);
  x = I128(0, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 1), x % y);
  x = I128(0, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, IMAX), x % y);
  x = I128(0, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, 0);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 2), x % y);
  x = I128(2, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, 0);
  y = I128(2, 2);
  ASSERT128(I128(2, 0), x % y);
  x = I128(2, 0);
  y = I128(2, BANE);
  ASSERT128(I128(2, 0), x % y);
  x = I128(2, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(2, 0), x % y);
  x = I128(2, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(2, 0), x % y);
  x = I128(2, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(2, 0), x % y);
  x = I128(2, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(2, 0), x % y);
  x = I128(2, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(2, 0), x % y);
  x = I128(2, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 4), x % y);
  x = I128(2, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, 2);
  y = I128(0, BANE);
  ASSERT128(I128(0, 2), x % y);
  x = I128(2, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 4), x % y);
  x = I128(2, 2);
  y = I128(2, 0);
  ASSERT128(I128(0, 2), x % y);
  x = I128(2, 2);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, 2);
  y = I128(2, BANE);
  ASSERT128(I128(2, 2), x % y);
  x = I128(2, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(2, 2), x % y);
  x = I128(2, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(2, 2), x % y);
  x = I128(2, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(2, 2), x % y);
  x = I128(2, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(2, 2), x % y);
  x = I128(2, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(2, 2), x % y);
  x = I128(2, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 2), x % y);
  x = I128(2, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0x0000000000000006), x % y);
  x = I128(2, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 2), x % y);
  x = I128(2, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, BANE2), x % y);
  x = I128(2, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(2, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0, 0x7ffffffffffffffe), x % y);
  x = I128(2, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(2, BANE), x % y);
  x = I128(2, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(2, BANE), x % y);
  x = I128(2, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(2, BANE), x % y);
  x = I128(2, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(2, BANE), x % y);
  x = I128(2, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(2, BANE), x % y);
  x = I128(2, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(2, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0x8000000000000004), x % y);
  x = I128(2, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(0, 1), x % y);
  x = I128(2, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(0, IMAX), x % y);
  x = I128(2, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 2), x % y);
  x = I128(2, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(2, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(0, IMAX2), x % y);
  x = I128(2, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0, IMAX), x % y);
  x = I128(2, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(2, -1ul), x % y);
  x = I128(2, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(2, -1ul), x % y);
  x = I128(2, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(2, -1ul), x % y);
  x = I128(2, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(2, -1ul), x % y);
  x = I128(2, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(2, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 5), x % y);
  x = I128(2, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, IMAX), x % y);
  x = I128(2, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, 0);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, BANE), x % y);
  x = I128(BANE, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, 0);
  y = I128(2, 2);
  ASSERT128(I128(0xfffffffffffffffe, 0x7ffffffffffffffe), x % y);
  x = I128(BANE, 0);
  y = I128(2, BANE);
  ASSERT128(I128(-1ul, BANE), x % y);
  x = I128(BANE, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(IMAX2, 0xd555555555555556), x % y);
  x = I128(BANE, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x % y);
  x = I128(BANE, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(-1ul, BANE), x % y);
  x = I128(BANE, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(-1ul, 1), x % y);
  x = I128(BANE, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x % y);
  x = I128(BANE, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, 2);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, BANE2), x % y);
  x = I128(BANE, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, BANE2), x % y);
  x = I128(BANE, 2);
  y = I128(2, 0);
  ASSERT128(I128(0xfffffffffffffffe, 2), x % y);
  x = I128(BANE, 2);
  y = I128(2, 2);
  ASSERT128(I128(0xfffffffffffffffe, BANE), x % y);
  x = I128(BANE, 2);
  y = I128(2, BANE);
  ASSERT128(I128(-1ul, BANE2), x % y);
  x = I128(BANE, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(IMAX2, 0xd555555555555558), x % y);
  x = I128(BANE, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 2), x % y);
  x = I128(BANE, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(-1ul, BANE2), x % y);
  x = I128(BANE, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(-1ul, 3), x % y);
  x = I128(BANE, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 2), x % y);
  x = I128(BANE, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE2), x % y);
  x = I128(BANE, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0xfffffffffffffffe, BANE), x % y);
  x = I128(BANE, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0xfffffffffffffffe, 0xfffffffffffffffe), x % y);
  x = I128(BANE, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(0xfffffffffffffffe, 0x5555555555555556), x % y);
  x = I128(BANE, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, BANE), x % y);
  x = I128(BANE, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, BANE), x % y);
  x = I128(BANE, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(-1ul, BANE1), x % y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, BANE), x % y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, BANE), x % y);
  x = I128(BANE, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(BANE, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(BANE, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, BANE), x % y);
  x = I128(BANE, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0xfffffffffffffffe, -1ul), x % y);
  x = I128(BANE, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(-1ul, 0x7ffffffffffffffd), x % y);
  x = I128(BANE, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(IMAX2, -1ul), x % y);
  x = I128(BANE, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0xfffffffffffffffe, 0xd555555555555555), x % y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, -1ul), x % y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, -1ul), x % y);
  x = I128(BANE, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, -1ul), x % y);
  x = I128(BANE, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(-1ul, 0);
  y = I128(2, 0);
  ASSERT128(I128(-1ul, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(2, 2);
  ASSERT128(I128(-1ul, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(2, BANE);
  ASSERT128(I128(-1ul, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(-1ul, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(-1ul, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(-1ul, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(-1ul, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(-1ul, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x % y);
  x = I128(-1ul, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, 2);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, BANE2), x % y);
  x = I128(-1ul, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, 2), x % y);
  x = I128(-1ul, 2);
  y = I128(2, 0);
  ASSERT128(I128(-1ul, 2), x % y);
  x = I128(-1ul, 2);
  y = I128(2, 2);
  ASSERT128(I128(-1ul, 2), x % y);
  x = I128(-1ul, 2);
  y = I128(2, BANE);
  ASSERT128(I128(-1ul, 2), x % y);
  x = I128(-1ul, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(-1ul, 2), x % y);
  x = I128(-1ul, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(-1ul, 2), x % y);
  x = I128(-1ul, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(-1ul, 2), x % y);
  x = I128(-1ul, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(-1ul, 2), x % y);
  x = I128(-1ul, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(-1ul, 2), x % y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 2), x % y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE2), x % y);
  x = I128(-1ul, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, BANE), x % y);
  x = I128(-1ul, BANE);
  y = I128(2, 0);
  ASSERT128(I128(-1ul, BANE), x % y);
  x = I128(-1ul, BANE);
  y = I128(2, 2);
  ASSERT128(I128(-1ul, BANE), x % y);
  x = I128(-1ul, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(-1ul, BANE), x % y);
  x = I128(-1ul, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(-1ul, BANE), x % y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(-1ul, BANE), x % y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(-1ul, BANE), x % y);
  x = I128(-1ul, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(-1ul, BANE), x % y);
  x = I128(-1ul, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(-1ul, BANE), x % y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, BANE), x % y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, BANE), x % y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(-1ul, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(-1ul, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(-1ul, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(-1ul, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(-1ul, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(-1ul, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, -1ul), x % y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x % y);
}

void testRemu128(void) {
  unsigned __int128 x, y;
  x = I128(0, 0);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, 2);
  y = I128(0, BANE);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(2, 0);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(2, 2);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(2, BANE);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 2), x % y);
  x = I128(0, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(0, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(0, 1), x % y);
  x = I128(0, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(0, IMAX), x % y);
  x = I128(0, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(0, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(0, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(2, 0);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 2), x % y);
  x = I128(2, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, 0);
  y = I128(2, 2);
  ASSERT128(I128(2, 0), x % y);
  x = I128(2, 0);
  y = I128(2, BANE);
  ASSERT128(I128(2, 0), x % y);
  x = I128(2, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(2, 0), x % y);
  x = I128(2, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(2, 0), x % y);
  x = I128(2, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(2, 0), x % y);
  x = I128(2, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(2, 0), x % y);
  x = I128(2, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(2, 0), x % y);
  x = I128(2, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(2, 0), x % y);
  x = I128(2, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(2, 0), x % y);
  x = I128(2, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(2, 0), x % y);
  x = I128(2, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(2, 0), x % y);
  x = I128(2, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, 2);
  y = I128(0, BANE);
  ASSERT128(I128(0, 2), x % y);
  x = I128(2, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 4), x % y);
  x = I128(2, 2);
  y = I128(2, 0);
  ASSERT128(I128(0, 2), x % y);
  x = I128(2, 2);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, 2);
  y = I128(2, BANE);
  ASSERT128(I128(2, 2), x % y);
  x = I128(2, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(2, 2), x % y);
  x = I128(2, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(2, 2), x % y);
  x = I128(2, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(2, 2), x % y);
  x = I128(2, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(2, 2), x % y);
  x = I128(2, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(2, 2), x % y);
  x = I128(2, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(2, 2), x % y);
  x = I128(2, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(2, 2), x % y);
  x = I128(2, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(2, 2), x % y);
  x = I128(2, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(2, 2), x % y);
  x = I128(2, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, BANE2), x % y);
  x = I128(2, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(2, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0, 0x7ffffffffffffffe), x % y);
  x = I128(2, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(2, BANE), x % y);
  x = I128(2, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(2, BANE), x % y);
  x = I128(2, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(2, BANE), x % y);
  x = I128(2, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(2, BANE), x % y);
  x = I128(2, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(2, BANE), x % y);
  x = I128(2, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(2, BANE), x % y);
  x = I128(2, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(2, BANE), x % y);
  x = I128(2, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(2, BANE), x % y);
  x = I128(2, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(2, BANE), x % y);
  x = I128(2, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(0, 1), x % y);
  x = I128(2, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(0, IMAX), x % y);
  x = I128(2, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 2), x % y);
  x = I128(2, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(2, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(0, IMAX2), x % y);
  x = I128(2, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0, IMAX), x % y);
  x = I128(2, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(2, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(2, -1ul), x % y);
  x = I128(2, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(2, -1ul), x % y);
  x = I128(2, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(2, -1ul), x % y);
  x = I128(2, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(2, -1ul), x % y);
  x = I128(2, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(2, -1ul), x % y);
  x = I128(2, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(2, -1ul), x % y);
  x = I128(2, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(2, -1ul), x % y);
  x = I128(2, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(2, -1ul), x % y);
  x = I128(BANE, 0);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(BANE, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, 0);
  y = I128(2, 2);
  ASSERT128(I128(1, BANE2), x % y);
  x = I128(BANE, 0);
  y = I128(2, BANE);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(BANE, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(2, 0x2aaaaaaaaaaaaaaa), x % y);
  x = I128(BANE, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 0), x % y);
  x = I128(BANE, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, 0), x % y);
  x = I128(BANE, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, 0), x % y);
  x = I128(BANE, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(BANE, 0), x % y);
  x = I128(BANE, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(BANE, 0), x % y);
  x = I128(BANE, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(BANE, 0), x % y);
  x = I128(BANE, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, 2);
  y = I128(0, BANE);
  ASSERT128(I128(0, 2), x % y);
  x = I128(BANE, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0, BANE2), x % y);
  x = I128(BANE, 2);
  y = I128(2, 0);
  ASSERT128(I128(0, 2), x % y);
  x = I128(BANE, 2);
  y = I128(2, 2);
  ASSERT128(I128(1, 0x8000000000000004), x % y);
  x = I128(BANE, 2);
  y = I128(2, BANE);
  ASSERT128(I128(0, BANE2), x % y);
  x = I128(BANE, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(2, 0x2aaaaaaaaaaaaaac), x % y);
  x = I128(BANE, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 2), x % y);
  x = I128(BANE, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, 2), x % y);
  x = I128(BANE, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, 2), x % y);
  x = I128(BANE, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(BANE, 2), x % y);
  x = I128(BANE, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(BANE, 2), x % y);
  x = I128(BANE, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(BANE, 2), x % y);
  x = I128(BANE, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(BANE, 2), x % y);
  x = I128(BANE, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 1), x % y);
  x = I128(BANE, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(BANE, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(1, 0), x % y);
  x = I128(BANE, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(2, 0xaaaaaaaaaaaaaaaa), x % y);
  x = I128(BANE, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(BANE, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0x7ffffffffffffffe), x % y);
  x = I128(BANE, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, BANE), x % y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(BANE, BANE), x % y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(BANE, BANE), x % y);
  x = I128(BANE, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(BANE, BANE), x % y);
  x = I128(BANE, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(BANE, BANE), x % y);
  x = I128(BANE, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(0, 1), x % y);
  x = I128(BANE, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(0, IMAX), x % y);
  x = I128(BANE, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(BANE, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(BANE, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(0, IMAX), x % y);
  x = I128(BANE, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(1, IMAX), x % y);
  x = I128(BANE, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0x2aaaaaaaaaaaaaaa), x % y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(0, IMAX2), x % y);
  x = I128(BANE, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, IMAX), x % y);
  x = I128(BANE, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(BANE, -1ul), x % y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(BANE, -1ul), x % y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(BANE, -1ul), x % y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(BANE, -1ul), x % y);
  x = I128(-1ul, 0);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(2, 0);
  ASSERT128(I128(1, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(2, 2);
  ASSERT128(I128(0, 2), x % y);
  x = I128(-1ul, 0);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0x5555555555555555), x % y);
  x = I128(-1ul, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(IMAX, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(0x7ffffffffffffffe, 0xfffffffffffffffe), x % y);
  x = I128(-1ul, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(0x7ffffffffffffffe, BANE), x % y);
  x = I128(-1ul, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0x7ffffffffffffffe, 1), x % y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, 0), x % y);
  x = I128(-1ul, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, 0), x % y);
  x = I128(-1ul, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, 2);
  y = I128(0, BANE);
  ASSERT128(I128(0, 2), x % y);
  x = I128(-1ul, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 2), x % y);
  x = I128(-1ul, 2);
  y = I128(2, 0);
  ASSERT128(I128(1, 2), x % y);
  x = I128(-1ul, 2);
  y = I128(2, 2);
  ASSERT128(I128(0, 4), x % y);
  x = I128(-1ul, 2);
  y = I128(2, BANE);
  ASSERT128(I128(0, 2), x % y);
  x = I128(-1ul, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0x5555555555555557), x % y);
  x = I128(-1ul, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(IMAX, 2), x % y);
  x = I128(-1ul, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(IMAX, 0), x % y);
  x = I128(-1ul, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(0x7ffffffffffffffe, BANE2), x % y);
  x = I128(-1ul, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0x7ffffffffffffffe, 3), x % y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 2), x % y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, 2), x % y);
  x = I128(-1ul, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, 2), x % y);
  x = I128(-1ul, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(-1ul, BANE);
  y = I128(2, 0);
  ASSERT128(I128(1, BANE), x % y);
  x = I128(-1ul, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0, BANE2), x % y);
  x = I128(-1ul, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(-1ul, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0xd555555555555555), x % y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(IMAX, BANE), x % y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(IMAX, 0x7ffffffffffffffe), x % y);
  x = I128(-1ul, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(IMAX, 0), x % y);
  x = I128(-1ul, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0x7ffffffffffffffe, BANE1), x % y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, BANE), x % y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0x7ffffffffffffffe), x % y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, BANE), x % y);
  x = I128(-1ul, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(0, 1), x % y);
  x = I128(-1ul, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(0, IMAX), x % y);
  x = I128(-1ul, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x % y);
  x = I128(-1ul, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(1, -1ul), x % y);
  x = I128(-1ul, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(1, 1), x % y);
  x = I128(-1ul, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(-1ul, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(1, 0x5555555555555554), x % y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(IMAX, -1ul), x % y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(IMAX, IMAX2), x % y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(IMAX, IMAX), x % y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(IMAX, 0), x % y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, -1ul), x % y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, IMAX2), x % y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, IMAX), x % y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x % y);
}

void testShr128(void) {
  unsigned __int128 x;
  x = I128(0, 0);
  x >>= 0;
  ASSERT128(I128(0, 0), x);
  x = I128(0, 0);
  x >>= 1;
  ASSERT128(I128(0, 0), x);
  x = I128(0, 0);
  x >>= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(0, 0);
  x >>= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(0, 2);
  x >>= 0;
  ASSERT128(I128(0, 2), x);
  x = I128(0, 2);
  x >>= 1;
  ASSERT128(I128(0, 1), x);
  x = I128(0, 2);
  x >>= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(0, 2);
  x >>= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(0, BANE);
  x >>= 0;
  ASSERT128(I128(0, BANE), x);
  x = I128(0, BANE);
  x >>= 1;
  ASSERT128(I128(0, 0x4000000000000000), x);
  x = I128(0, BANE);
  x >>= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(0, BANE);
  x >>= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(0, -1ul);
  x >>= 0;
  ASSERT128(I128(0, -1ul), x);
  x = I128(0, -1ul);
  x >>= 1;
  ASSERT128(I128(0, IMAX), x);
  x = I128(0, -1ul);
  x >>= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(0, -1ul);
  x >>= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(2, 0);
  x >>= 0;
  ASSERT128(I128(2, 0), x);
  x = I128(2, 0);
  x >>= 1;
  ASSERT128(I128(1, 0), x);
  x = I128(2, 0);
  x >>= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(2, 0);
  x >>= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(2, 2);
  x >>= 0;
  ASSERT128(I128(2, 2), x);
  x = I128(2, 2);
  x >>= 1;
  ASSERT128(I128(1, 1), x);
  x = I128(2, 2);
  x >>= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(2, 2);
  x >>= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(2, BANE);
  x >>= 0;
  ASSERT128(I128(2, BANE), x);
  x = I128(2, BANE);
  x >>= 1;
  ASSERT128(I128(1, 0x4000000000000000), x);
  x = I128(2, BANE);
  x >>= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(2, BANE);
  x >>= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(2, -1ul);
  x >>= 0;
  ASSERT128(I128(2, -1ul), x);
  x = I128(2, -1ul);
  x >>= 1;
  ASSERT128(I128(1, IMAX), x);
  x = I128(2, -1ul);
  x >>= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(2, -1ul);
  x >>= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(BANE, 0);
  x >>= 0;
  ASSERT128(I128(BANE, 0), x);
  x = I128(BANE, 0);
  x >>= 1;
  ASSERT128(I128(0x4000000000000000, 0), x);
  x = I128(BANE, 0);
  x >>= 126;
  ASSERT128(I128(0, 2), x);
  x = I128(BANE, 0);
  x >>= 127;
  ASSERT128(I128(0, 1), x);
  x = I128(BANE, 2);
  x >>= 0;
  ASSERT128(I128(BANE, 2), x);
  x = I128(BANE, 2);
  x >>= 1;
  ASSERT128(I128(0x4000000000000000, 1), x);
  x = I128(BANE, 2);
  x >>= 126;
  ASSERT128(I128(0, 2), x);
  x = I128(BANE, 2);
  x >>= 127;
  ASSERT128(I128(0, 1), x);
  x = I128(BANE, BANE);
  x >>= 0;
  ASSERT128(I128(BANE, BANE), x);
  x = I128(BANE, BANE);
  x >>= 1;
  ASSERT128(I128(0x4000000000000000, 0x4000000000000000), x);
  x = I128(BANE, BANE);
  x >>= 126;
  ASSERT128(I128(0, 2), x);
  x = I128(BANE, BANE);
  x >>= 127;
  ASSERT128(I128(0, 1), x);
  x = I128(BANE, -1ul);
  x >>= 0;
  ASSERT128(I128(BANE, -1ul), x);
  x = I128(BANE, -1ul);
  x >>= 1;
  ASSERT128(I128(0x4000000000000000, IMAX), x);
  x = I128(BANE, -1ul);
  x >>= 126;
  ASSERT128(I128(0, 2), x);
  x = I128(BANE, -1ul);
  x >>= 127;
  ASSERT128(I128(0, 1), x);
  x = I128(-1ul, 0);
  x >>= 0;
  ASSERT128(I128(-1ul, 0), x);
  x = I128(-1ul, 0);
  x >>= 1;
  ASSERT128(I128(IMAX, BANE), x);
  x = I128(-1ul, 0);
  x >>= 126;
  ASSERT128(I128(0, 3), x);
  x = I128(-1ul, 0);
  x >>= 127;
  ASSERT128(I128(0, 1), x);
  x = I128(-1ul, 2);
  x >>= 0;
  ASSERT128(I128(-1ul, 2), x);
  x = I128(-1ul, 2);
  x >>= 1;
  ASSERT128(I128(IMAX, BANE1), x);
  x = I128(-1ul, 2);
  x >>= 126;
  ASSERT128(I128(0, 3), x);
  x = I128(-1ul, 2);
  x >>= 127;
  ASSERT128(I128(0, 1), x);
  x = I128(-1ul, BANE);
  x >>= 0;
  ASSERT128(I128(-1ul, BANE), x);
  x = I128(-1ul, BANE);
  x >>= 1;
  ASSERT128(I128(IMAX, 0xc000000000000000), x);
  x = I128(-1ul, BANE);
  x >>= 126;
  ASSERT128(I128(0, 3), x);
  x = I128(-1ul, BANE);
  x >>= 127;
  ASSERT128(I128(0, 1), x);
  x = I128(-1ul, -1ul);
  x >>= 0;
  ASSERT128(I128(-1ul, -1ul), x);
  x = I128(-1ul, -1ul);
  x >>= 1;
  ASSERT128(I128(IMAX, -1ul), x);
  x = I128(-1ul, -1ul);
  x >>= 126;
  ASSERT128(I128(0, 3), x);
  x = I128(-1ul, -1ul);
  x >>= 127;
  ASSERT128(I128(0, 1), x);
}

void testSar128(void) {
  __int128 x;
  x = I128(0, 0);
  x >>= 0;
  ASSERT128(I128(0, 0), x);
  x = I128(0, 0);
  x >>= 1;
  ASSERT128(I128(0, 0), x);
  x = I128(0, 0);
  x >>= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(0, 0);
  x >>= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(0, 2);
  x >>= 0;
  ASSERT128(I128(0, 2), x);
  x = I128(0, 2);
  x >>= 1;
  ASSERT128(I128(0, 1), x);
  x = I128(0, 2);
  x >>= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(0, 2);
  x >>= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(0, BANE);
  x >>= 0;
  ASSERT128(I128(0, BANE), x);
  x = I128(0, BANE);
  x >>= 1;
  ASSERT128(I128(0, 0x4000000000000000), x);
  x = I128(0, BANE);
  x >>= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(0, BANE);
  x >>= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(0, -1ul);
  x >>= 0;
  ASSERT128(I128(0, -1ul), x);
  x = I128(0, -1ul);
  x >>= 1;
  ASSERT128(I128(0, IMAX), x);
  x = I128(0, -1ul);
  x >>= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(0, -1ul);
  x >>= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(2, 0);
  x >>= 0;
  ASSERT128(I128(2, 0), x);
  x = I128(2, 0);
  x >>= 1;
  ASSERT128(I128(1, 0), x);
  x = I128(2, 0);
  x >>= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(2, 0);
  x >>= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(2, 2);
  x >>= 0;
  ASSERT128(I128(2, 2), x);
  x = I128(2, 2);
  x >>= 1;
  ASSERT128(I128(1, 1), x);
  x = I128(2, 2);
  x >>= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(2, 2);
  x >>= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(2, BANE);
  x >>= 0;
  ASSERT128(I128(2, BANE), x);
  x = I128(2, BANE);
  x >>= 1;
  ASSERT128(I128(1, 0x4000000000000000), x);
  x = I128(2, BANE);
  x >>= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(2, BANE);
  x >>= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(2, -1ul);
  x >>= 0;
  ASSERT128(I128(2, -1ul), x);
  x = I128(2, -1ul);
  x >>= 1;
  ASSERT128(I128(1, IMAX), x);
  x = I128(2, -1ul);
  x >>= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(2, -1ul);
  x >>= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(BANE, 0);
  x >>= 0;
  ASSERT128(I128(BANE, 0), x);
  x = I128(BANE, 0);
  x >>= 1;
  ASSERT128(I128(0xc000000000000000, 0), x);
  x = I128(BANE, 0);
  x >>= 126;
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x);
  x = I128(BANE, 0);
  x >>= 127;
  ASSERT128(I128(-1ul, -1ul), x);
  x = I128(BANE, 2);
  x >>= 0;
  ASSERT128(I128(BANE, 2), x);
  x = I128(BANE, 2);
  x >>= 1;
  ASSERT128(I128(0xc000000000000000, 1), x);
  x = I128(BANE, 2);
  x >>= 126;
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x);
  x = I128(BANE, 2);
  x >>= 127;
  ASSERT128(I128(-1ul, -1ul), x);
  x = I128(BANE, BANE);
  x >>= 0;
  ASSERT128(I128(BANE, BANE), x);
  x = I128(BANE, BANE);
  x >>= 1;
  ASSERT128(I128(0xc000000000000000, 0x4000000000000000), x);
  x = I128(BANE, BANE);
  x >>= 126;
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x);
  x = I128(BANE, BANE);
  x >>= 127;
  ASSERT128(I128(-1ul, -1ul), x);
  x = I128(BANE, -1ul);
  x >>= 0;
  ASSERT128(I128(BANE, -1ul), x);
  x = I128(BANE, -1ul);
  x >>= 1;
  ASSERT128(I128(0xc000000000000000, IMAX), x);
  x = I128(BANE, -1ul);
  x >>= 126;
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x);
  x = I128(BANE, -1ul);
  x >>= 127;
  ASSERT128(I128(-1ul, -1ul), x);
  x = I128(-1ul, 0);
  x >>= 0;
  ASSERT128(I128(-1ul, 0), x);
  x = I128(-1ul, 0);
  x >>= 1;
  ASSERT128(I128(-1ul, BANE), x);
  x = I128(-1ul, 0);
  x >>= 126;
  ASSERT128(I128(-1ul, -1ul), x);
  x = I128(-1ul, 0);
  x >>= 127;
  ASSERT128(I128(-1ul, -1ul), x);
  x = I128(-1ul, 2);
  x >>= 0;
  ASSERT128(I128(-1ul, 2), x);
  x = I128(-1ul, 2);
  x >>= 1;
  ASSERT128(I128(-1ul, BANE1), x);
  x = I128(-1ul, 2);
  x >>= 126;
  ASSERT128(I128(-1ul, -1ul), x);
  x = I128(-1ul, 2);
  x >>= 127;
  ASSERT128(I128(-1ul, -1ul), x);
  x = I128(-1ul, BANE);
  x >>= 0;
  ASSERT128(I128(-1ul, BANE), x);
  x = I128(-1ul, BANE);
  x >>= 1;
  ASSERT128(I128(-1ul, 0xc000000000000000), x);
  x = I128(-1ul, BANE);
  x >>= 126;
  ASSERT128(I128(-1ul, -1ul), x);
  x = I128(-1ul, BANE);
  x >>= 127;
  ASSERT128(I128(-1ul, -1ul), x);
  x = I128(-1ul, -1ul);
  x >>= 0;
  ASSERT128(I128(-1ul, -1ul), x);
  x = I128(-1ul, -1ul);
  x >>= 1;
  ASSERT128(I128(-1ul, -1ul), x);
  x = I128(-1ul, -1ul);
  x >>= 126;
  ASSERT128(I128(-1ul, -1ul), x);
  x = I128(-1ul, -1ul);
  x >>= 127;
  ASSERT128(I128(-1ul, -1ul), x);
}

void testShl128(void) {
  __int128 x;
  x = I128(0, 0);
  x <<= 0;
  ASSERT128(I128(0, 0), x);
  x = I128(0, 0);
  x <<= 1;
  ASSERT128(I128(0, 0), x);
  x = I128(0, 0);
  x <<= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(0, 0);
  x <<= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(0, 2);
  x <<= 0;
  ASSERT128(I128(0, 2), x);
  x = I128(0, 2);
  x <<= 1;
  ASSERT128(I128(0, 4), x);
  x = I128(0, 2);
  x <<= 126;
  ASSERT128(I128(BANE, 0), x);
  x = I128(0, 2);
  x <<= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(0, BANE);
  x <<= 0;
  ASSERT128(I128(0, BANE), x);
  x = I128(0, BANE);
  x <<= 1;
  ASSERT128(I128(1, 0), x);
  x = I128(0, BANE);
  x <<= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(0, BANE);
  x <<= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(0, -1ul);
  x <<= 0;
  ASSERT128(I128(0, -1ul), x);
  x = I128(0, -1ul);
  x <<= 1;
  ASSERT128(I128(1, 0xfffffffffffffffe), x);
  x = I128(0, -1ul);
  x <<= 126;
  ASSERT128(I128(0xc000000000000000, 0), x);
  x = I128(0, -1ul);
  x <<= 127;
  ASSERT128(I128(BANE, 0), x);
  x = I128(2, 0);
  x <<= 0;
  ASSERT128(I128(2, 0), x);
  x = I128(2, 0);
  x <<= 1;
  ASSERT128(I128(4, 0), x);
  x = I128(2, 0);
  x <<= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(2, 0);
  x <<= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(2, 2);
  x <<= 0;
  ASSERT128(I128(2, 2), x);
  x = I128(2, 2);
  x <<= 1;
  ASSERT128(I128(4, 4), x);
  x = I128(2, 2);
  x <<= 126;
  ASSERT128(I128(BANE, 0), x);
  x = I128(2, 2);
  x <<= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(2, BANE);
  x <<= 0;
  ASSERT128(I128(2, BANE), x);
  x = I128(2, BANE);
  x <<= 1;
  ASSERT128(I128(5, 0), x);
  x = I128(2, BANE);
  x <<= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(2, BANE);
  x <<= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(2, -1ul);
  x <<= 0;
  ASSERT128(I128(2, -1ul), x);
  x = I128(2, -1ul);
  x <<= 1;
  ASSERT128(I128(5, 0xfffffffffffffffe), x);
  x = I128(2, -1ul);
  x <<= 126;
  ASSERT128(I128(0xc000000000000000, 0), x);
  x = I128(2, -1ul);
  x <<= 127;
  ASSERT128(I128(BANE, 0), x);
  x = I128(BANE, 0);
  x <<= 0;
  ASSERT128(I128(BANE, 0), x);
  x = I128(BANE, 0);
  x <<= 1;
  ASSERT128(I128(0, 0), x);
  x = I128(BANE, 0);
  x <<= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(BANE, 0);
  x <<= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(BANE, 2);
  x <<= 0;
  ASSERT128(I128(BANE, 2), x);
  x = I128(BANE, 2);
  x <<= 1;
  ASSERT128(I128(0, 4), x);
  x = I128(BANE, 2);
  x <<= 126;
  ASSERT128(I128(BANE, 0), x);
  x = I128(BANE, 2);
  x <<= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(BANE, BANE);
  x <<= 0;
  ASSERT128(I128(BANE, BANE), x);
  x = I128(BANE, BANE);
  x <<= 1;
  ASSERT128(I128(1, 0), x);
  x = I128(BANE, BANE);
  x <<= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(BANE, BANE);
  x <<= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(BANE, -1ul);
  x <<= 0;
  ASSERT128(I128(BANE, -1ul), x);
  x = I128(BANE, -1ul);
  x <<= 1;
  ASSERT128(I128(1, 0xfffffffffffffffe), x);
  x = I128(BANE, -1ul);
  x <<= 126;
  ASSERT128(I128(0xc000000000000000, 0), x);
  x = I128(BANE, -1ul);
  x <<= 127;
  ASSERT128(I128(BANE, 0), x);
  x = I128(-1ul, 0);
  x <<= 0;
  ASSERT128(I128(-1ul, 0), x);
  x = I128(-1ul, 0);
  x <<= 1;
  ASSERT128(I128(0xfffffffffffffffe, 0), x);
  x = I128(-1ul, 0);
  x <<= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(-1ul, 0);
  x <<= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(-1ul, 2);
  x <<= 0;
  ASSERT128(I128(-1ul, 2), x);
  x = I128(-1ul, 2);
  x <<= 1;
  ASSERT128(I128(0xfffffffffffffffe, 4), x);
  x = I128(-1ul, 2);
  x <<= 126;
  ASSERT128(I128(BANE, 0), x);
  x = I128(-1ul, 2);
  x <<= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(-1ul, BANE);
  x <<= 0;
  ASSERT128(I128(-1ul, BANE), x);
  x = I128(-1ul, BANE);
  x <<= 1;
  ASSERT128(I128(-1ul, 0), x);
  x = I128(-1ul, BANE);
  x <<= 126;
  ASSERT128(I128(0, 0), x);
  x = I128(-1ul, BANE);
  x <<= 127;
  ASSERT128(I128(0, 0), x);
  x = I128(-1ul, -1ul);
  x <<= 0;
  ASSERT128(I128(-1ul, -1ul), x);
  x = I128(-1ul, -1ul);
  x <<= 1;
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), x);
  x = I128(-1ul, -1ul);
  x <<= 126;
  ASSERT128(I128(0xc000000000000000, 0), x);
  x = I128(-1ul, -1ul);
  x <<= 127;
  ASSERT128(I128(BANE, 0), x);
}

void testNeg128(void) {
  __int128 x;
  x = I128(0, 0);
  ASSERT128(I128(0, 0), -x);
  x = I128(0, 2);
  ASSERT128(I128(-1ul, 0xfffffffffffffffe), -x);
  x = I128(0, BANE);
  ASSERT128(I128(-1ul, BANE), -x);
  x = I128(0, -1ul);
  ASSERT128(I128(-1ul, 1), -x);
  x = I128(2, 0);
  ASSERT128(I128(0xfffffffffffffffe, 0), -x);
  x = I128(2, 2);
  ASSERT128(I128(IMAX2, 0xfffffffffffffffe), -x);
  x = I128(2, BANE);
  ASSERT128(I128(IMAX2, BANE), -x);
  x = I128(2, -1ul);
  ASSERT128(I128(IMAX2, 1), -x);
  x = I128(BANE, 0);
  ASSERT128(I128(BANE, 0), -x);
  x = I128(BANE, 2);
  ASSERT128(I128(IMAX, 0xfffffffffffffffe), -x);
  x = I128(BANE, BANE);
  ASSERT128(I128(IMAX, BANE), -x);
  x = I128(BANE, -1ul);
  ASSERT128(I128(IMAX, 1), -x);
  x = I128(-1ul, 0);
  ASSERT128(I128(1, 0), -x);
  x = I128(-1ul, 2);
  ASSERT128(I128(0, 0xfffffffffffffffe), -x);
  x = I128(-1ul, BANE);
  ASSERT128(I128(0, BANE), -x);
  x = I128(-1ul, -1ul);
  ASSERT128(I128(0, 1), -x);
}

void testXor128(void) {
  __int128 x, y;
  x = I128(0, 0);
  y = I128(0, 2);
  ASSERT128(I128(0, 2), x ^ y);
  x = I128(0, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, BANE), x ^ y);
  x = I128(0, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0, -1ul), x ^ y);
  x = I128(0, 0);
  y = I128(2, 0);
  ASSERT128(I128(2, 0), x ^ y);
  x = I128(0, 0);
  y = I128(2, 2);
  ASSERT128(I128(2, 2), x ^ y);
  x = I128(0, 0);
  y = I128(2, BANE);
  ASSERT128(I128(2, BANE), x ^ y);
  x = I128(0, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(2, -1ul), x ^ y);
  x = I128(0, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 0), x ^ y);
  x = I128(0, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 2), x ^ y);
  x = I128(0, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, BANE), x ^ y);
  x = I128(0, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, -1ul), x ^ y);
  x = I128(0, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 0), x ^ y);
  x = I128(0, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 2), x ^ y);
  x = I128(0, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE), x ^ y);
  x = I128(0, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, -1ul), x ^ y);
  x = I128(0, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x ^ y);
  x = I128(0, 2);
  y = I128(0, BANE);
  ASSERT128(I128(0, BANE2), x ^ y);
  x = I128(0, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0, IMAX2), x ^ y);
  x = I128(0, 2);
  y = I128(2, 0);
  ASSERT128(I128(2, 2), x ^ y);
  x = I128(0, 2);
  y = I128(2, 2);
  ASSERT128(I128(2, 0), x ^ y);
  x = I128(0, 2);
  y = I128(2, BANE);
  ASSERT128(I128(2, BANE2), x ^ y);
  x = I128(0, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(2, IMAX2), x ^ y);
  x = I128(0, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 2), x ^ y);
  x = I128(0, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 0), x ^ y);
  x = I128(0, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, BANE2), x ^ y);
  x = I128(0, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, IMAX2), x ^ y);
  x = I128(0, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 2), x ^ y);
  x = I128(0, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 0), x ^ y);
  x = I128(0, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE2), x ^ y);
  x = I128(0, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, IMAX2), x ^ y);
  x = I128(0, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0, BANE2), x ^ y);
  x = I128(0, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x ^ y);
  x = I128(0, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, IMAX), x ^ y);
  x = I128(0, BANE);
  y = I128(2, 0);
  ASSERT128(I128(2, BANE), x ^ y);
  x = I128(0, BANE);
  y = I128(2, 2);
  ASSERT128(I128(2, BANE2), x ^ y);
  x = I128(0, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(2, 0), x ^ y);
  x = I128(0, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(2, IMAX), x ^ y);
  x = I128(0, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, BANE), x ^ y);
  x = I128(0, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, BANE2), x ^ y);
  x = I128(0, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, 0), x ^ y);
  x = I128(0, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, IMAX), x ^ y);
  x = I128(0, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, BANE), x ^ y);
  x = I128(0, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, BANE2), x ^ y);
  x = I128(0, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, 0), x ^ y);
  x = I128(0, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, IMAX), x ^ y);
  x = I128(0, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(0, IMAX2), x ^ y);
  x = I128(0, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(0, IMAX), x ^ y);
  x = I128(0, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x ^ y);
  x = I128(0, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(2, -1ul), x ^ y);
  x = I128(0, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(2, IMAX2), x ^ y);
  x = I128(0, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(2, IMAX), x ^ y);
  x = I128(0, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(2, 0), x ^ y);
  x = I128(0, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, -1ul), x ^ y);
  x = I128(0, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, IMAX2), x ^ y);
  x = I128(0, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, IMAX), x ^ y);
  x = I128(0, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, 0), x ^ y);
  x = I128(0, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, -1ul), x ^ y);
  x = I128(0, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, IMAX2), x ^ y);
  x = I128(0, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, IMAX), x ^ y);
  x = I128(0, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, 0), x ^ y);
  x = I128(2, 0);
  y = I128(0, 2);
  ASSERT128(I128(2, 2), x ^ y);
  x = I128(2, 0);
  y = I128(0, BANE);
  ASSERT128(I128(2, BANE), x ^ y);
  x = I128(2, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(2, -1ul), x ^ y);
  x = I128(2, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x ^ y);
  x = I128(2, 0);
  y = I128(2, 2);
  ASSERT128(I128(0, 2), x ^ y);
  x = I128(2, 0);
  y = I128(2, BANE);
  ASSERT128(I128(0, BANE), x ^ y);
  x = I128(2, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(0, -1ul), x ^ y);
  x = I128(2, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE2, 0), x ^ y);
  x = I128(2, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE2, 2), x ^ y);
  x = I128(2, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE2, BANE), x ^ y);
  x = I128(2, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE2, -1ul), x ^ y);
  x = I128(2, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(IMAX2, 0), x ^ y);
  x = I128(2, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(IMAX2, 2), x ^ y);
  x = I128(2, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(IMAX2, BANE), x ^ y);
  x = I128(2, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX2, -1ul), x ^ y);
  x = I128(2, 2);
  y = I128(0, 2);
  ASSERT128(I128(2, 0), x ^ y);
  x = I128(2, 2);
  y = I128(0, BANE);
  ASSERT128(I128(2, BANE2), x ^ y);
  x = I128(2, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(2, IMAX2), x ^ y);
  x = I128(2, 2);
  y = I128(2, 0);
  ASSERT128(I128(0, 2), x ^ y);
  x = I128(2, 2);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x ^ y);
  x = I128(2, 2);
  y = I128(2, BANE);
  ASSERT128(I128(0, BANE2), x ^ y);
  x = I128(2, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(0, IMAX2), x ^ y);
  x = I128(2, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE2, 2), x ^ y);
  x = I128(2, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE2, 0), x ^ y);
  x = I128(2, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE2, BANE2), x ^ y);
  x = I128(2, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE2, IMAX2), x ^ y);
  x = I128(2, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(IMAX2, 2), x ^ y);
  x = I128(2, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(IMAX2, 0), x ^ y);
  x = I128(2, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(IMAX2, BANE2), x ^ y);
  x = I128(2, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX2, IMAX2), x ^ y);
  x = I128(2, BANE);
  y = I128(0, 2);
  ASSERT128(I128(2, BANE2), x ^ y);
  x = I128(2, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(2, 0), x ^ y);
  x = I128(2, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(2, IMAX), x ^ y);
  x = I128(2, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, BANE), x ^ y);
  x = I128(2, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0, BANE2), x ^ y);
  x = I128(2, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x ^ y);
  x = I128(2, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(0, IMAX), x ^ y);
  x = I128(2, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE2, BANE), x ^ y);
  x = I128(2, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE2, BANE2), x ^ y);
  x = I128(2, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE2, 0), x ^ y);
  x = I128(2, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE2, IMAX), x ^ y);
  x = I128(2, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(IMAX2, BANE), x ^ y);
  x = I128(2, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(IMAX2, BANE2), x ^ y);
  x = I128(2, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(IMAX2, 0), x ^ y);
  x = I128(2, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX2, IMAX), x ^ y);
  x = I128(2, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(2, IMAX2), x ^ y);
  x = I128(2, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(2, IMAX), x ^ y);
  x = I128(2, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(2, 0), x ^ y);
  x = I128(2, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0, -1ul), x ^ y);
  x = I128(2, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(0, IMAX2), x ^ y);
  x = I128(2, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0, IMAX), x ^ y);
  x = I128(2, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x ^ y);
  x = I128(2, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE2, -1ul), x ^ y);
  x = I128(2, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE2, IMAX2), x ^ y);
  x = I128(2, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE2, IMAX), x ^ y);
  x = I128(2, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE2, 0), x ^ y);
  x = I128(2, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(IMAX2, -1ul), x ^ y);
  x = I128(2, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(IMAX2, IMAX2), x ^ y);
  x = I128(2, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(IMAX2, IMAX), x ^ y);
  x = I128(2, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX2, 0), x ^ y);
  x = I128(BANE, 0);
  y = I128(0, 2);
  ASSERT128(I128(BANE, 2), x ^ y);
  x = I128(BANE, 0);
  y = I128(0, BANE);
  ASSERT128(I128(BANE, BANE), x ^ y);
  x = I128(BANE, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(BANE, -1ul), x ^ y);
  x = I128(BANE, 0);
  y = I128(2, 0);
  ASSERT128(I128(BANE2, 0), x ^ y);
  x = I128(BANE, 0);
  y = I128(2, 2);
  ASSERT128(I128(BANE2, 2), x ^ y);
  x = I128(BANE, 0);
  y = I128(2, BANE);
  ASSERT128(I128(BANE2, BANE), x ^ y);
  x = I128(BANE, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(BANE2, -1ul), x ^ y);
  x = I128(BANE, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x ^ y);
  x = I128(BANE, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 2), x ^ y);
  x = I128(BANE, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, BANE), x ^ y);
  x = I128(BANE, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, -1ul), x ^ y);
  x = I128(BANE, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(IMAX, 0), x ^ y);
  x = I128(BANE, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(IMAX, 2), x ^ y);
  x = I128(BANE, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(IMAX, BANE), x ^ y);
  x = I128(BANE, 2);
  y = I128(0, 2);
  ASSERT128(I128(BANE, 0), x ^ y);
  x = I128(BANE, 2);
  y = I128(0, BANE);
  ASSERT128(I128(BANE, BANE2), x ^ y);
  x = I128(BANE, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(BANE, IMAX2), x ^ y);
  x = I128(BANE, 2);
  y = I128(2, 0);
  ASSERT128(I128(BANE2, 2), x ^ y);
  x = I128(BANE, 2);
  y = I128(2, 2);
  ASSERT128(I128(BANE2, 0), x ^ y);
  x = I128(BANE, 2);
  y = I128(2, BANE);
  ASSERT128(I128(BANE2, BANE2), x ^ y);
  x = I128(BANE, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(BANE2, IMAX2), x ^ y);
  x = I128(BANE, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 2), x ^ y);
  x = I128(BANE, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x ^ y);
  x = I128(BANE, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, BANE2), x ^ y);
  x = I128(BANE, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, IMAX2), x ^ y);
  x = I128(BANE, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(IMAX, 2), x ^ y);
  x = I128(BANE, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(IMAX, 0), x ^ y);
  x = I128(BANE, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(IMAX, BANE2), x ^ y);
  x = I128(BANE, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX, IMAX2), x ^ y);
  x = I128(BANE, BANE);
  y = I128(0, 2);
  ASSERT128(I128(BANE, BANE2), x ^ y);
  x = I128(BANE, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(BANE, 0), x ^ y);
  x = I128(BANE, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(BANE, IMAX), x ^ y);
  x = I128(BANE, BANE);
  y = I128(2, 0);
  ASSERT128(I128(BANE2, BANE), x ^ y);
  x = I128(BANE, BANE);
  y = I128(2, 2);
  ASSERT128(I128(BANE2, BANE2), x ^ y);
  x = I128(BANE, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(BANE2, 0), x ^ y);
  x = I128(BANE, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(BANE2, IMAX), x ^ y);
  x = I128(BANE, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, BANE), x ^ y);
  x = I128(BANE, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(0, BANE2), x ^ y);
  x = I128(BANE, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x ^ y);
  x = I128(BANE, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, IMAX), x ^ y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(IMAX, BANE), x ^ y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(IMAX, BANE2), x ^ y);
  x = I128(BANE, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(IMAX, 0), x ^ y);
  x = I128(BANE, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX, IMAX), x ^ y);
  x = I128(BANE, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(BANE, IMAX2), x ^ y);
  x = I128(BANE, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(BANE, IMAX), x ^ y);
  x = I128(BANE, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(BANE, 0), x ^ y);
  x = I128(BANE, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(BANE2, -1ul), x ^ y);
  x = I128(BANE, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(BANE2, IMAX2), x ^ y);
  x = I128(BANE, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(BANE2, IMAX), x ^ y);
  x = I128(BANE, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(BANE2, 0), x ^ y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(0, -1ul), x ^ y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(0, IMAX2), x ^ y);
  x = I128(BANE, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, IMAX), x ^ y);
  x = I128(BANE, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x ^ y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(IMAX, -1ul), x ^ y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(IMAX, IMAX2), x ^ y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(IMAX, IMAX), x ^ y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(IMAX, 0), x ^ y);
  x = I128(-1ul, 0);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, 2), x ^ y);
  x = I128(-1ul, 0);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, BANE), x ^ y);
  x = I128(-1ul, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, -1ul), x ^ y);
  x = I128(-1ul, 0);
  y = I128(2, 0);
  ASSERT128(I128(IMAX2, 0), x ^ y);
  x = I128(-1ul, 0);
  y = I128(2, 2);
  ASSERT128(I128(IMAX2, 2), x ^ y);
  x = I128(-1ul, 0);
  y = I128(2, BANE);
  ASSERT128(I128(IMAX2, BANE), x ^ y);
  x = I128(-1ul, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(IMAX2, -1ul), x ^ y);
  x = I128(-1ul, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(IMAX, 0), x ^ y);
  x = I128(-1ul, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(IMAX, 2), x ^ y);
  x = I128(-1ul, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(IMAX, BANE), x ^ y);
  x = I128(-1ul, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(IMAX, -1ul), x ^ y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x ^ y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 2), x ^ y);
  x = I128(-1ul, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, BANE), x ^ y);
  x = I128(-1ul, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, -1ul), x ^ y);
  x = I128(-1ul, 2);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, 0), x ^ y);
  x = I128(-1ul, 2);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, BANE2), x ^ y);
  x = I128(-1ul, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, IMAX2), x ^ y);
  x = I128(-1ul, 2);
  y = I128(2, 0);
  ASSERT128(I128(IMAX2, 2), x ^ y);
  x = I128(-1ul, 2);
  y = I128(2, 2);
  ASSERT128(I128(IMAX2, 0), x ^ y);
  x = I128(-1ul, 2);
  y = I128(2, BANE);
  ASSERT128(I128(IMAX2, BANE2), x ^ y);
  x = I128(-1ul, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(IMAX2, IMAX2), x ^ y);
  x = I128(-1ul, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(IMAX, 2), x ^ y);
  x = I128(-1ul, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(IMAX, 0), x ^ y);
  x = I128(-1ul, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(IMAX, BANE2), x ^ y);
  x = I128(-1ul, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(IMAX, IMAX2), x ^ y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 2), x ^ y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x ^ y);
  x = I128(-1ul, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, BANE2), x ^ y);
  x = I128(-1ul, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, IMAX2), x ^ y);
  x = I128(-1ul, BANE);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, BANE2), x ^ y);
  x = I128(-1ul, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, 0), x ^ y);
  x = I128(-1ul, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, IMAX), x ^ y);
  x = I128(-1ul, BANE);
  y = I128(2, 0);
  ASSERT128(I128(IMAX2, BANE), x ^ y);
  x = I128(-1ul, BANE);
  y = I128(2, 2);
  ASSERT128(I128(IMAX2, BANE2), x ^ y);
  x = I128(-1ul, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(IMAX2, 0), x ^ y);
  x = I128(-1ul, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(IMAX2, IMAX), x ^ y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(IMAX, BANE), x ^ y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(IMAX, BANE2), x ^ y);
  x = I128(-1ul, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(IMAX, 0), x ^ y);
  x = I128(-1ul, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(IMAX, IMAX), x ^ y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, BANE), x ^ y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, BANE2), x ^ y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x ^ y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, IMAX), x ^ y);
  x = I128(-1ul, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, IMAX2), x ^ y);
  x = I128(-1ul, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, IMAX), x ^ y);
  x = I128(-1ul, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, 0), x ^ y);
  x = I128(-1ul, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(IMAX2, -1ul), x ^ y);
  x = I128(-1ul, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(IMAX2, IMAX2), x ^ y);
  x = I128(-1ul, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(IMAX2, IMAX), x ^ y);
  x = I128(-1ul, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(IMAX2, 0), x ^ y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(IMAX, -1ul), x ^ y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(IMAX, IMAX2), x ^ y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(IMAX, IMAX), x ^ y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(IMAX, 0), x ^ y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, -1ul), x ^ y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, IMAX2), x ^ y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, IMAX), x ^ y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x ^ y);
}

void testAnd128(void) {
  __int128 x, y;
  x = I128(0, 0);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 0);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 0);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 2), x & y);
  x = I128(0, 2);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 2), x & y);
  x = I128(0, 2);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 2);
  y = I128(2, 2);
  ASSERT128(I128(0, 2), x & y);
  x = I128(0, 2);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 2), x & y);
  x = I128(0, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 2), x & y);
  x = I128(0, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 2), x & y);
  x = I128(0, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 2), x & y);
  x = I128(0, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, 2), x & y);
  x = I128(0, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(0, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(0, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(0, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(0, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(0, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(0, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(0, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(0, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(0, 2), x & y);
  x = I128(0, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(0, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, -1ul), x & y);
  x = I128(0, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(0, 2), x & y);
  x = I128(0, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(0, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0, -1ul), x & y);
  x = I128(0, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 2), x & y);
  x = I128(0, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(0, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, -1ul), x & y);
  x = I128(0, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(0, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(0, 2), x & y);
  x = I128(0, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(0, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(0, -1ul), x & y);
  x = I128(2, 0);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x & y);
  x = I128(2, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x & y);
  x = I128(2, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x & y);
  x = I128(2, 0);
  y = I128(2, 0);
  ASSERT128(I128(2, 0), x & y);
  x = I128(2, 0);
  y = I128(2, 2);
  ASSERT128(I128(2, 0), x & y);
  x = I128(2, 0);
  y = I128(2, BANE);
  ASSERT128(I128(2, 0), x & y);
  x = I128(2, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(2, 0), x & y);
  x = I128(2, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(2, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x & y);
  x = I128(2, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x & y);
  x = I128(2, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 0), x & y);
  x = I128(2, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(2, 0), x & y);
  x = I128(2, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(2, 0), x & y);
  x = I128(2, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(2, 0), x & y);
  x = I128(2, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(2, 0), x & y);
  x = I128(2, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 2), x & y);
  x = I128(2, 2);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x & y);
  x = I128(2, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 2), x & y);
  x = I128(2, 2);
  y = I128(2, 0);
  ASSERT128(I128(2, 0), x & y);
  x = I128(2, 2);
  y = I128(2, 2);
  ASSERT128(I128(2, 2), x & y);
  x = I128(2, 2);
  y = I128(2, BANE);
  ASSERT128(I128(2, 0), x & y);
  x = I128(2, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(2, 2), x & y);
  x = I128(2, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(2, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 2), x & y);
  x = I128(2, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, 0), x & y);
  x = I128(2, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, 2), x & y);
  x = I128(2, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(2, 0), x & y);
  x = I128(2, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(2, 2), x & y);
  x = I128(2, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(2, 0), x & y);
  x = I128(2, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(2, 2), x & y);
  x = I128(2, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x & y);
  x = I128(2, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(2, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(2, BANE);
  y = I128(2, 0);
  ASSERT128(I128(2, 0), x & y);
  x = I128(2, BANE);
  y = I128(2, 2);
  ASSERT128(I128(2, 0), x & y);
  x = I128(2, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(2, BANE), x & y);
  x = I128(2, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(2, BANE), x & y);
  x = I128(2, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(2, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 0), x & y);
  x = I128(2, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(2, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(2, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(2, 0), x & y);
  x = I128(2, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(2, 0), x & y);
  x = I128(2, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(2, BANE), x & y);
  x = I128(2, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(2, BANE), x & y);
  x = I128(2, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(0, 2), x & y);
  x = I128(2, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(2, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, -1ul), x & y);
  x = I128(2, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(2, 0), x & y);
  x = I128(2, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(2, 2), x & y);
  x = I128(2, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(2, BANE), x & y);
  x = I128(2, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(2, -1ul), x & y);
  x = I128(2, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(2, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(0, 2), x & y);
  x = I128(2, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(2, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(0, -1ul), x & y);
  x = I128(2, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(2, 0), x & y);
  x = I128(2, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(2, 2), x & y);
  x = I128(2, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(2, BANE), x & y);
  x = I128(2, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(2, -1ul), x & y);
  x = I128(BANE, 0);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x & y);
  x = I128(BANE, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x & y);
  x = I128(BANE, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x & y);
  x = I128(BANE, 0);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(BANE, 0);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x & y);
  x = I128(BANE, 0);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x & y);
  x = I128(BANE, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 0), x & y);
  x = I128(BANE, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(BANE, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(BANE, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(BANE, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(BANE, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(BANE, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(BANE, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(BANE, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 2), x & y);
  x = I128(BANE, 2);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x & y);
  x = I128(BANE, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 2), x & y);
  x = I128(BANE, 2);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(BANE, 2);
  y = I128(2, 2);
  ASSERT128(I128(0, 2), x & y);
  x = I128(BANE, 2);
  y = I128(2, BANE);
  ASSERT128(I128(0, 0), x & y);
  x = I128(BANE, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(0, 2), x & y);
  x = I128(BANE, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(BANE, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 2), x & y);
  x = I128(BANE, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(BANE, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, 2), x & y);
  x = I128(BANE, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(BANE, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(BANE, 2), x & y);
  x = I128(BANE, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(BANE, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(BANE, 2), x & y);
  x = I128(BANE, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x & y);
  x = I128(BANE, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(BANE, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(BANE, BANE);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(BANE, BANE);
  y = I128(2, 2);
  ASSERT128(I128(0, 0), x & y);
  x = I128(BANE, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(BANE, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(BANE, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(BANE, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(BANE, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, BANE), x & y);
  x = I128(BANE, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, BANE), x & y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(BANE, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(BANE, BANE), x & y);
  x = I128(BANE, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(BANE, BANE), x & y);
  x = I128(BANE, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(0, 2), x & y);
  x = I128(BANE, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(BANE, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, -1ul), x & y);
  x = I128(BANE, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(0, 0), x & y);
  x = I128(BANE, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(0, 2), x & y);
  x = I128(BANE, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(BANE, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(0, -1ul), x & y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 2), x & y);
  x = I128(BANE, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, BANE), x & y);
  x = I128(BANE, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, -1ul), x & y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(BANE, 2), x & y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(BANE, BANE), x & y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(BANE, -1ul), x & y);
  x = I128(-1ul, 0);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x & y);
  x = I128(-1ul, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x & y);
  x = I128(-1ul, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 0), x & y);
  x = I128(-1ul, 0);
  y = I128(2, 0);
  ASSERT128(I128(2, 0), x & y);
  x = I128(-1ul, 0);
  y = I128(2, 2);
  ASSERT128(I128(2, 0), x & y);
  x = I128(-1ul, 0);
  y = I128(2, BANE);
  ASSERT128(I128(2, 0), x & y);
  x = I128(-1ul, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(2, 0), x & y);
  x = I128(-1ul, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(-1ul, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(-1ul, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(-1ul, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 0), x & y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 0), x & y);
  x = I128(-1ul, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, 0), x & y);
  x = I128(-1ul, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, 0), x & y);
  x = I128(-1ul, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 2), x & y);
  x = I128(-1ul, 2);
  y = I128(0, BANE);
  ASSERT128(I128(0, 0), x & y);
  x = I128(-1ul, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0, 2), x & y);
  x = I128(-1ul, 2);
  y = I128(2, 0);
  ASSERT128(I128(2, 0), x & y);
  x = I128(-1ul, 2);
  y = I128(2, 2);
  ASSERT128(I128(2, 2), x & y);
  x = I128(-1ul, 2);
  y = I128(2, BANE);
  ASSERT128(I128(2, 0), x & y);
  x = I128(-1ul, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(2, 2), x & y);
  x = I128(-1ul, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(-1ul, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 2), x & y);
  x = I128(-1ul, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(-1ul, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, 2), x & y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 0), x & y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 2), x & y);
  x = I128(-1ul, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, 0), x & y);
  x = I128(-1ul, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, 2), x & y);
  x = I128(-1ul, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0, 0), x & y);
  x = I128(-1ul, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(-1ul, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(-1ul, BANE);
  y = I128(2, 0);
  ASSERT128(I128(2, 0), x & y);
  x = I128(-1ul, BANE);
  y = I128(2, 2);
  ASSERT128(I128(2, 0), x & y);
  x = I128(-1ul, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(2, BANE), x & y);
  x = I128(-1ul, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(2, BANE), x & y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(-1ul, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, BANE), x & y);
  x = I128(-1ul, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, BANE), x & y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 0), x & y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 0), x & y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE), x & y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, BANE), x & y);
  x = I128(-1ul, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(0, 2), x & y);
  x = I128(-1ul, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(0, BANE), x & y);
  x = I128(-1ul, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, -1ul), x & y);
  x = I128(-1ul, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(2, 0), x & y);
  x = I128(-1ul, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(2, 2), x & y);
  x = I128(-1ul, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(2, BANE), x & y);
  x = I128(-1ul, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(2, -1ul), x & y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 0), x & y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 2), x & y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, BANE), x & y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, -1ul), x & y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 0), x & y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 2), x & y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE), x & y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, -1ul), x & y);
}

void testOr128(void) {
  __int128 x, y;
  x = I128(0, 0);
  y = I128(0, 2);
  ASSERT128(I128(0, 2), x | y);
  x = I128(0, 0);
  y = I128(0, BANE);
  ASSERT128(I128(0, BANE), x | y);
  x = I128(0, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(0, -1ul), x | y);
  x = I128(0, 0);
  y = I128(2, 0);
  ASSERT128(I128(2, 0), x | y);
  x = I128(0, 0);
  y = I128(2, 2);
  ASSERT128(I128(2, 2), x | y);
  x = I128(0, 0);
  y = I128(2, BANE);
  ASSERT128(I128(2, BANE), x | y);
  x = I128(0, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(0, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 0), x | y);
  x = I128(0, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 2), x | y);
  x = I128(0, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, BANE), x | y);
  x = I128(0, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(0, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 0), x | y);
  x = I128(0, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(0, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(0, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(0, 2);
  y = I128(0, 2);
  ASSERT128(I128(0, 2), x | y);
  x = I128(0, 2);
  y = I128(0, BANE);
  ASSERT128(I128(0, BANE2), x | y);
  x = I128(0, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(0, -1ul), x | y);
  x = I128(0, 2);
  y = I128(2, 0);
  ASSERT128(I128(2, 2), x | y);
  x = I128(0, 2);
  y = I128(2, 2);
  ASSERT128(I128(2, 2), x | y);
  x = I128(0, 2);
  y = I128(2, BANE);
  ASSERT128(I128(2, BANE2), x | y);
  x = I128(0, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(0, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 2), x | y);
  x = I128(0, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 2), x | y);
  x = I128(0, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, BANE2), x | y);
  x = I128(0, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(0, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(0, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(0, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE2), x | y);
  x = I128(0, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(0, BANE);
  y = I128(0, 2);
  ASSERT128(I128(0, BANE2), x | y);
  x = I128(0, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(0, BANE), x | y);
  x = I128(0, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(0, -1ul), x | y);
  x = I128(0, BANE);
  y = I128(2, 0);
  ASSERT128(I128(2, BANE), x | y);
  x = I128(0, BANE);
  y = I128(2, 2);
  ASSERT128(I128(2, BANE2), x | y);
  x = I128(0, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(2, BANE), x | y);
  x = I128(0, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(0, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, BANE), x | y);
  x = I128(0, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, BANE2), x | y);
  x = I128(0, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, BANE), x | y);
  x = I128(0, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(0, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(0, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, BANE2), x | y);
  x = I128(0, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(0, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(0, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(0, -1ul), x | y);
  x = I128(0, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(0, -1ul), x | y);
  x = I128(0, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(0, -1ul), x | y);
  x = I128(0, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(0, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(0, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(0, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(0, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(0, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(0, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(0, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(0, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(0, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(0, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(0, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(2, 0);
  y = I128(0, 2);
  ASSERT128(I128(2, 2), x | y);
  x = I128(2, 0);
  y = I128(0, BANE);
  ASSERT128(I128(2, BANE), x | y);
  x = I128(2, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(2, 0);
  y = I128(2, 0);
  ASSERT128(I128(2, 0), x | y);
  x = I128(2, 0);
  y = I128(2, 2);
  ASSERT128(I128(2, 2), x | y);
  x = I128(2, 0);
  y = I128(2, BANE);
  ASSERT128(I128(2, BANE), x | y);
  x = I128(2, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(2, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE2, 0), x | y);
  x = I128(2, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE2, 2), x | y);
  x = I128(2, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE2, BANE), x | y);
  x = I128(2, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE2, -1ul), x | y);
  x = I128(2, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 0), x | y);
  x = I128(2, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(2, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(2, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(2, 2);
  y = I128(0, 2);
  ASSERT128(I128(2, 2), x | y);
  x = I128(2, 2);
  y = I128(0, BANE);
  ASSERT128(I128(2, BANE2), x | y);
  x = I128(2, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(2, 2);
  y = I128(2, 0);
  ASSERT128(I128(2, 2), x | y);
  x = I128(2, 2);
  y = I128(2, 2);
  ASSERT128(I128(2, 2), x | y);
  x = I128(2, 2);
  y = I128(2, BANE);
  ASSERT128(I128(2, BANE2), x | y);
  x = I128(2, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(2, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE2, 2), x | y);
  x = I128(2, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE2, 2), x | y);
  x = I128(2, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE2, BANE2), x | y);
  x = I128(2, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE2, -1ul), x | y);
  x = I128(2, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(2, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(2, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE2), x | y);
  x = I128(2, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(2, BANE);
  y = I128(0, 2);
  ASSERT128(I128(2, BANE2), x | y);
  x = I128(2, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(2, BANE), x | y);
  x = I128(2, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(2, BANE);
  y = I128(2, 0);
  ASSERT128(I128(2, BANE), x | y);
  x = I128(2, BANE);
  y = I128(2, 2);
  ASSERT128(I128(2, BANE2), x | y);
  x = I128(2, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(2, BANE), x | y);
  x = I128(2, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(2, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE2, BANE), x | y);
  x = I128(2, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE2, BANE2), x | y);
  x = I128(2, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE2, BANE), x | y);
  x = I128(2, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE2, -1ul), x | y);
  x = I128(2, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(2, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, BANE2), x | y);
  x = I128(2, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(2, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(2, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(2, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(2, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(2, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(2, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(2, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(2, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(2, -1ul), x | y);
  x = I128(2, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE2, -1ul), x | y);
  x = I128(2, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE2, -1ul), x | y);
  x = I128(2, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE2, -1ul), x | y);
  x = I128(2, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE2, -1ul), x | y);
  x = I128(2, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(2, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(2, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(2, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(BANE, 0);
  y = I128(0, 2);
  ASSERT128(I128(BANE, 2), x | y);
  x = I128(BANE, 0);
  y = I128(0, BANE);
  ASSERT128(I128(BANE, BANE), x | y);
  x = I128(BANE, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(BANE, 0);
  y = I128(2, 0);
  ASSERT128(I128(BANE2, 0), x | y);
  x = I128(BANE, 0);
  y = I128(2, 2);
  ASSERT128(I128(BANE2, 2), x | y);
  x = I128(BANE, 0);
  y = I128(2, BANE);
  ASSERT128(I128(BANE2, BANE), x | y);
  x = I128(BANE, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(BANE2, -1ul), x | y);
  x = I128(BANE, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 0), x | y);
  x = I128(BANE, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 2), x | y);
  x = I128(BANE, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, BANE), x | y);
  x = I128(BANE, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(BANE, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 0), x | y);
  x = I128(BANE, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(BANE, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(BANE, 2);
  y = I128(0, 2);
  ASSERT128(I128(BANE, 2), x | y);
  x = I128(BANE, 2);
  y = I128(0, BANE);
  ASSERT128(I128(BANE, BANE2), x | y);
  x = I128(BANE, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(BANE, 2);
  y = I128(2, 0);
  ASSERT128(I128(BANE2, 2), x | y);
  x = I128(BANE, 2);
  y = I128(2, 2);
  ASSERT128(I128(BANE2, 2), x | y);
  x = I128(BANE, 2);
  y = I128(2, BANE);
  ASSERT128(I128(BANE2, BANE2), x | y);
  x = I128(BANE, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(BANE2, -1ul), x | y);
  x = I128(BANE, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, 2), x | y);
  x = I128(BANE, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, 2), x | y);
  x = I128(BANE, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, BANE2), x | y);
  x = I128(BANE, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(BANE, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(BANE, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(BANE, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE2), x | y);
  x = I128(BANE, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(BANE, BANE);
  y = I128(0, 2);
  ASSERT128(I128(BANE, BANE2), x | y);
  x = I128(BANE, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(BANE, BANE), x | y);
  x = I128(BANE, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(BANE, BANE);
  y = I128(2, 0);
  ASSERT128(I128(BANE2, BANE), x | y);
  x = I128(BANE, BANE);
  y = I128(2, 2);
  ASSERT128(I128(BANE2, BANE2), x | y);
  x = I128(BANE, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(BANE2, BANE), x | y);
  x = I128(BANE, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(BANE2, -1ul), x | y);
  x = I128(BANE, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, BANE), x | y);
  x = I128(BANE, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, BANE2), x | y);
  x = I128(BANE, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, BANE), x | y);
  x = I128(BANE, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(BANE, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, BANE2), x | y);
  x = I128(BANE, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(BANE, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(BANE, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(BANE, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(BANE, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(BANE, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(BANE2, -1ul), x | y);
  x = I128(BANE, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(BANE2, -1ul), x | y);
  x = I128(BANE, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(BANE2, -1ul), x | y);
  x = I128(BANE, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(BANE2, -1ul), x | y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(BANE, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(BANE, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(BANE, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(BANE, -1ul), x | y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(BANE, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, 0);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(-1ul, 0);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(-1ul, 0);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, 0);
  y = I128(2, 0);
  ASSERT128(I128(-1ul, 0), x | y);
  x = I128(-1ul, 0);
  y = I128(2, 2);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(-1ul, 0);
  y = I128(2, BANE);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(-1ul, 0);
  y = I128(2, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, 0);
  y = I128(BANE, 0);
  ASSERT128(I128(-1ul, 0), x | y);
  x = I128(-1ul, 0);
  y = I128(BANE, 2);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(-1ul, 0);
  y = I128(BANE, BANE);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(-1ul, 0);
  y = I128(BANE, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 0), x | y);
  x = I128(-1ul, 0);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(-1ul, 0);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(-1ul, 0);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, 2);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(-1ul, 2);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, BANE2), x | y);
  x = I128(-1ul, 2);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, 2);
  y = I128(2, 0);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(-1ul, 2);
  y = I128(2, 2);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(-1ul, 2);
  y = I128(2, BANE);
  ASSERT128(I128(-1ul, BANE2), x | y);
  x = I128(-1ul, 2);
  y = I128(2, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, 2);
  y = I128(BANE, 0);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(-1ul, 2);
  y = I128(BANE, 2);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(-1ul, 2);
  y = I128(BANE, BANE);
  ASSERT128(I128(-1ul, BANE2), x | y);
  x = I128(-1ul, 2);
  y = I128(BANE, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(-1ul, 2);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, 2), x | y);
  x = I128(-1ul, 2);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE2), x | y);
  x = I128(-1ul, 2);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, BANE);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, BANE2), x | y);
  x = I128(-1ul, BANE);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(-1ul, BANE);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, BANE);
  y = I128(2, 0);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(-1ul, BANE);
  y = I128(2, 2);
  ASSERT128(I128(-1ul, BANE2), x | y);
  x = I128(-1ul, BANE);
  y = I128(2, BANE);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(-1ul, BANE);
  y = I128(2, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 0);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(-1ul, BANE);
  y = I128(BANE, 2);
  ASSERT128(I128(-1ul, BANE2), x | y);
  x = I128(-1ul, BANE);
  y = I128(BANE, BANE);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(-1ul, BANE);
  y = I128(BANE, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, BANE2), x | y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, BANE), x | y);
  x = I128(-1ul, BANE);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, -1ul);
  y = I128(0, 2);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, -1ul);
  y = I128(0, BANE);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, -1ul);
  y = I128(0, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, -1ul);
  y = I128(2, 0);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, -1ul);
  y = I128(2, 2);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, -1ul);
  y = I128(2, BANE);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, -1ul);
  y = I128(2, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 0);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, 2);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, BANE);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, -1ul);
  y = I128(BANE, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 0);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, 2);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, BANE);
  ASSERT128(I128(-1ul, -1ul), x | y);
  x = I128(-1ul, -1ul);
  y = I128(-1ul, -1ul);
  ASSERT128(I128(-1ul, -1ul), x | y);
}

void testNot128(void) {
  __int128 x;
  x = I128(0, 0);
  ASSERT128(I128(-1ul, -1ul), ~x);
  x = I128(0, 2);
  ASSERT128(I128(-1ul, IMAX2), ~x);
  x = I128(0, BANE);
  ASSERT128(I128(-1ul, IMAX), ~x);
  x = I128(0, -1ul);
  ASSERT128(I128(-1ul, 0), ~x);
  x = I128(2, 0);
  ASSERT128(I128(IMAX2, -1ul), ~x);
  x = I128(2, 2);
  ASSERT128(I128(IMAX2, IMAX2), ~x);
  x = I128(2, BANE);
  ASSERT128(I128(IMAX2, IMAX), ~x);
  x = I128(2, -1ul);
  ASSERT128(I128(IMAX2, 0), ~x);
  x = I128(BANE, 0);
  ASSERT128(I128(IMAX, -1ul), ~x);
  x = I128(BANE, 2);
  ASSERT128(I128(IMAX, IMAX2), ~x);
  x = I128(BANE, BANE);
  ASSERT128(I128(IMAX, IMAX), ~x);
  x = I128(BANE, -1ul);
  ASSERT128(I128(IMAX, 0), ~x);
  x = I128(-1ul, 0);
  ASSERT128(I128(0, -1ul), ~x);
  x = I128(-1ul, 2);
  ASSERT128(I128(0, IMAX2), ~x);
  x = I128(-1ul, BANE);
  ASSERT128(I128(0, IMAX), ~x);
  x = I128(-1ul, -1ul);
  ASSERT128(I128(0, 0), ~x);
}

// Helper macro to append a 128-bit value to a string in minimal hex
#define PRINT_I128(buf, v) do { \
    unsigned long long hi = (unsigned long long)((v) >> 64); \
    unsigned long long lo = (unsigned long long)(v); \
    char tmp[32]; \
    sprintf(tmp, "%llx%llx", hi, lo); \
    strcat(buf, tmp); \
} while(0)

void testAbi(void) {
  ASSERT(11, ({
           char buf[200];
           sprintf(buf, "%d %d %d %d %032jjx %032jjx", 1, 2, 3, 4,
                   I128(0x1ffffffff, 0x2ffffffff),
                   I128(0x3eeeeeeee, 0x4eeeeeeee));
           strcmp("1 2 3 4 00000001ffffffff00000002ffffffff "
                  "00000003eeeeeeee00000004eeeeeeee",
                  buf);
         }));
  ASSERT(11, ({
           char buf[200];
           sprintf(buf, "%d %d %d %d %d %032jjx %032jjx", 1, 2, 3, 4, 5,
                   I128(0x1ffffffff, 0x2ffffffff),
                   I128(0x3eeeeeeee, 0x4eeeeeeee));
           strcmp("1 2 3 4 5 00000001ffffffff00000002ffffffff "
                  "00000003eeeeeeee00000004eeeeeeee",
                  buf);
         }));
}

int main(void) {
  testLang128();
  testCompare128();
  testAdd128();
  testSub128();
  testMul128();
  testDiv128();
  testDivu128();
  testRem128();
  testRemu128();
  testShr128();
  testSar128();
  testShl128();
  testNeg128();
  testXor128();
  testAnd128();
  testOr128();
  testNot128();
  testCastDblInt128();
  testCastDblUint128();
  testCastLdblInt128();
  testCastLdblUint128();
  testAbi();
  printf("OK\n");
  return 0;
}