{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetInitialDestination: Single;
    procedure SetInitialDestination(const Value: Single);
    function GetInitialValue: Single;
    procedure SetInitialValue(const Value: Single);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FEventSet_destination: TSFFloatEvent;
    {  }
    public property EventSet_destination: TSFFloatEvent read FEventSet_destination;

    strict private FEventSet_value: TSFFloatEvent;
    {  }
    public property EventSet_value: TSFFloatEvent read FEventSet_value;

    strict private FEventValue_changed: TSFFloatEvent;
    {  }
    public property EventValue_changed: TSFFloatEvent read FEventValue_changed;

    strict private FFdInitialDestination: TSFFloat;
    { Internal wrapper for property @code(InitialDestination). This wrapper API may change, we advise to access simpler @code(InitialDestination) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdInitialDestination: TSFFloat read FFdInitialDestination;
    {  }
    property InitialDestination: Single read GetInitialDestination write SetInitialDestination;

    strict private FFdInitialValue: TSFFloat;
    { Internal wrapper for property @code(InitialValue). This wrapper API may change, we advise to access simpler @code(InitialValue) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdInitialValue: TSFFloat read FFdInitialValue;
    {  }
    property InitialValue: Single read GetInitialValue write SetInitialValue;

{$endif read_interface}

{$ifdef read_implementation}

{ TScalarChaserNode ----------------------------------------------- }

function TScalarChaserNode.GetInitialDestination: Single;
begin
  Result := FdInitialDestination.Value;
end;

procedure TScalarChaserNode.SetInitialDestination(const Value: Single);
begin
  FdInitialDestination.Send(Value);
end;

function TScalarChaserNode.GetInitialValue: Single;
begin
  Result := FdInitialValue.Value;
end;

procedure TScalarChaserNode.SetInitialValue(const Value: Single);
begin
  FdInitialValue.Send(Value);
end;

class function TScalarChaserNode.ClassX3DType: String;
begin
  Result := 'ScalarChaser';
end;

procedure TScalarChaserNode.CreateNode;
begin
  inherited;

  FEventSet_destination := TSFFloatEvent.Create(Self, 'set_destination', true);
  AddEvent(FEventSet_destination);

  FEventSet_value := TSFFloatEvent.Create(Self, 'set_value', true);
  AddEvent(FEventSet_value);

  FEventValue_changed := TSFFloatEvent.Create(Self, 'value_changed', false);
  AddEvent(FEventValue_changed);

  FFdInitialDestination := TSFFloat.Create(Self, False, 'initialDestination', 0);
   FdInitialDestination.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdInitialDestination);

  FFdInitialValue := TSFFloat.Create(Self, False, 'initialValue', 0);
   FdInitialValue.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdInitialValue);
end;

{$endif read_implementation}
