{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetUDimension: Integer;
    procedure SetUDimension(const Value: Integer);
    function GetUOrder: Integer;
    procedure SetUOrder(const Value: Integer);
    function GetVDimension: Integer;
    procedure SetVDimension(const Value: Integer);
    function GetVOrder: Integer;
    procedure SetVOrder(const Value: Integer);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdControlPoint: TMFVec2f;
    { Internal wrapper for property @code(ControlPoint). This wrapper API may change, we advise to access simpler @code(ControlPoint) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdControlPoint: TMFVec2f read FFdControlPoint;
    {  }
    procedure SetControlPoint(const Value: array of TVector2); overload;
    {  }
    procedure SetControlPoint(const Value: TVector2List); overload;

    strict private FFdWeight: TMFFloat;
    { Internal wrapper for property @code(Weight). This wrapper API may change, we advise to access simpler @code(Weight) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdWeight: TMFFloat read FFdWeight;
    {  }
    procedure SetWeight(const Value: array of Single); overload;
    {  }
    procedure SetWeight(const Value: TSingleList); overload;

    strict private FFdUDimension: TSFInt32;
    { Internal wrapper for property @code(UDimension). This wrapper API may change, we advise to access simpler @code(UDimension) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdUDimension: TSFInt32 read FFdUDimension;
    {  }
    property UDimension: Integer read GetUDimension write SetUDimension;

    strict private FFdUKnot: TMFDouble;
    { Internal wrapper for property @code(UKnot). This wrapper API may change, we advise to access simpler @code(UKnot) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdUKnot: TMFDouble read FFdUKnot;
    {  }
    procedure SetUKnot(const Value: array of Double); overload;
    {  }
    procedure SetUKnot(const Value: TDoubleList); overload;

    strict private FFdUOrder: TSFInt32;
    { Internal wrapper for property @code(UOrder). This wrapper API may change, we advise to access simpler @code(UOrder) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdUOrder: TSFInt32 read FFdUOrder;
    {  }
    property UOrder: Integer read GetUOrder write SetUOrder;

    strict private FFdVDimension: TSFInt32;
    { Internal wrapper for property @code(VDimension). This wrapper API may change, we advise to access simpler @code(VDimension) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdVDimension: TSFInt32 read FFdVDimension;
    {  }
    property VDimension: Integer read GetVDimension write SetVDimension;

    strict private FFdVKnot: TMFDouble;
    { Internal wrapper for property @code(VKnot). This wrapper API may change, we advise to access simpler @code(VKnot) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdVKnot: TMFDouble read FFdVKnot;
    {  }
    procedure SetVKnot(const Value: array of Double); overload;
    {  }
    procedure SetVKnot(const Value: TDoubleList); overload;

    strict private FFdVOrder: TSFInt32;
    { Internal wrapper for property @code(VOrder). This wrapper API may change, we advise to access simpler @code(VOrder) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdVOrder: TSFInt32 read FFdVOrder;
    {  }
    property VOrder: Integer read GetVOrder write SetVOrder;

{$endif read_interface}

{$ifdef read_implementation}

{ TNurbsTextureCoordinateNode ----------------------------------------------- }

procedure TNurbsTextureCoordinateNode.SetControlPoint(const Value: array of TVector2);
begin
  FdControlPoint.Send(Value);
end;

procedure TNurbsTextureCoordinateNode.SetControlPoint(const Value: TVector2List);
begin
  FdControlPoint.Send(Value);
end;

procedure TNurbsTextureCoordinateNode.SetWeight(const Value: array of Single);
begin
  FdWeight.Send(Value);
end;

procedure TNurbsTextureCoordinateNode.SetWeight(const Value: TSingleList);
begin
  FdWeight.Send(Value);
end;

function TNurbsTextureCoordinateNode.GetUDimension: Integer;
begin
  Result := FdUDimension.Value;
end;

procedure TNurbsTextureCoordinateNode.SetUDimension(const Value: Integer);
begin
  FdUDimension.Send(Value);
end;

procedure TNurbsTextureCoordinateNode.SetUKnot(const Value: array of Double);
begin
  FdUKnot.Send(Value);
end;

procedure TNurbsTextureCoordinateNode.SetUKnot(const Value: TDoubleList);
begin
  FdUKnot.Send(Value);
end;

function TNurbsTextureCoordinateNode.GetUOrder: Integer;
begin
  Result := FdUOrder.Value;
end;

procedure TNurbsTextureCoordinateNode.SetUOrder(const Value: Integer);
begin
  FdUOrder.Send(Value);
end;

function TNurbsTextureCoordinateNode.GetVDimension: Integer;
begin
  Result := FdVDimension.Value;
end;

procedure TNurbsTextureCoordinateNode.SetVDimension(const Value: Integer);
begin
  FdVDimension.Send(Value);
end;

procedure TNurbsTextureCoordinateNode.SetVKnot(const Value: array of Double);
begin
  FdVKnot.Send(Value);
end;

procedure TNurbsTextureCoordinateNode.SetVKnot(const Value: TDoubleList);
begin
  FdVKnot.Send(Value);
end;

function TNurbsTextureCoordinateNode.GetVOrder: Integer;
begin
  Result := FdVOrder.Value;
end;

procedure TNurbsTextureCoordinateNode.SetVOrder(const Value: Integer);
begin
  FdVOrder.Send(Value);
end;

class function TNurbsTextureCoordinateNode.ClassX3DType: String;
begin
  Result := 'NurbsTextureCoordinate';
end;

procedure TNurbsTextureCoordinateNode.CreateNode;
begin
  inherited;

  FFdControlPoint := TMFVec2f.Create(Self, True, 'controlPoint', []);
   FdControlPoint.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdControlPoint);

  FFdWeight := TMFFloat.Create(Self, True, 'weight', []);
   FdWeight.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdWeight);

  FFdUDimension := TSFInt32.Create(Self, False, 'uDimension', 0);
   FdUDimension.ChangeAlways := chVisibleNonGeometry;
   FdUDimension.MustBeNonnegative := true;
  AddField(FFdUDimension);

  FFdUKnot := TMFDouble.Create(Self, False, 'uKnot', []);
   FdUKnot.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdUKnot);

  FFdUOrder := TSFInt32.Create(Self, False, 'uOrder', 3);
   FdUOrder.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdUOrder);

  FFdVDimension := TSFInt32.Create(Self, False, 'vDimension', 0);
   FdVDimension.ChangeAlways := chVisibleNonGeometry;
   FdVDimension.MustBeNonnegative := true;
  AddField(FFdVDimension);

  FFdVKnot := TMFDouble.Create(Self, False, 'vKnot', []);
   FdVKnot.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdVKnot);

  FFdVOrder := TSFInt32.Create(Self, False, 'vOrder', 3);
   FdVOrder.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdVOrder);

  DefaultContainerField := 'texCoord';
end;

{$endif read_implementation}
