{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetAddress: String;
    procedure SetAddress(const Value: String);
    function GetApplicationID: Integer;
    procedure SetApplicationID(const Value: Integer);
    function GetArticulationParameterCount: Integer;
    procedure SetArticulationParameterCount(const Value: Integer);
    function GetCenter: TVector3;
    procedure SetCenter(const Value: TVector3);
    function GetCollisionType: Integer;
    procedure SetCollisionType(const Value: Integer);
    function GetDeadReckoning: Integer;
    procedure SetDeadReckoning(const Value: Integer);
    function GetDetonationLocation: TVector3;
    procedure SetDetonationLocation(const Value: TVector3);
    function GetDetonationRelativeLocation: TVector3;
    procedure SetDetonationRelativeLocation(const Value: TVector3);
    function GetDetonationResult: Integer;
    procedure SetDetonationResult(const Value: Integer);
    function GetEnabled: Boolean;
    procedure SetEnabled(const Value: Boolean);
    function GetEntityCategory: Integer;
    procedure SetEntityCategory(const Value: Integer);
    function GetEntityCountry: Integer;
    procedure SetEntityCountry(const Value: Integer);
    function GetEntityDomain: Integer;
    procedure SetEntityDomain(const Value: Integer);
    function GetEntityExtra: Integer;
    procedure SetEntityExtra(const Value: Integer);
    function GetEntityID: Integer;
    procedure SetEntityID(const Value: Integer);
    function GetEntityKind: Integer;
    procedure SetEntityKind(const Value: Integer);
    function GetEntitySpecific: Integer;
    procedure SetEntitySpecific(const Value: Integer);
    function GetEntitySubCategory: Integer;
    procedure SetEntitySubCategory(const Value: Integer);
    function GetEventApplicationID: Integer;
    procedure SetEventApplicationID(const Value: Integer);
    function GetEventEntityID: Integer;
    procedure SetEventEntityID(const Value: Integer);
    function GetEventNumber: Integer;
    procedure SetEventNumber(const Value: Integer);
    function GetEventSiteID: Integer;
    procedure SetEventSiteID(const Value: Integer);
    function GetFired1: Boolean;
    procedure SetFired1(const Value: Boolean);
    function GetFired2: Boolean;
    procedure SetFired2(const Value: Boolean);
    function GetFireMissionIndex: Integer;
    procedure SetFireMissionIndex(const Value: Integer);
    function GetFiringRange: Single;
    procedure SetFiringRange(const Value: Single);
    function GetFiringRate: Integer;
    procedure SetFiringRate(const Value: Integer);
    function GetForceID: Integer;
    procedure SetForceID(const Value: Integer);
    function GetFuse: Integer;
    procedure SetFuse(const Value: Integer);
    function GetLinearVelocity: TVector3;
    procedure SetLinearVelocity(const Value: TVector3);
    function GetLinearAcceleration: TVector3;
    procedure SetLinearAcceleration(const Value: TVector3);
    function GetMarking: String;
    procedure SetMarking(const Value: String);
    function GetMulticastRelayHost: String;
    procedure SetMulticastRelayHost(const Value: String);
    function GetMulticastRelayPort: Integer;
    procedure SetMulticastRelayPort(const Value: Integer);
    function GetMunitionApplicationID: Integer;
    procedure SetMunitionApplicationID(const Value: Integer);
    function GetMunitionEndPoint: TVector3;
    procedure SetMunitionEndPoint(const Value: TVector3);
    function GetMunitionEntityID: Integer;
    procedure SetMunitionEntityID(const Value: Integer);
    function GetMunitionQuantity: Integer;
    procedure SetMunitionQuantity(const Value: Integer);
    function GetMunitionSiteID: Integer;
    procedure SetMunitionSiteID(const Value: Integer);
    function GetMunitionStartPoint: TVector3;
    procedure SetMunitionStartPoint(const Value: TVector3);
    function GetNetworkMode: TDISNetworkMode;
    procedure SetNetworkMode(const Value: TDISNetworkMode);
    function GetPort: Integer;
    procedure SetPort(const Value: Integer);
    function GetReadInterval: TFloatTime;
    procedure SetReadInterval(const Value: TFloatTime);
    function GetRotation: TVector4;
    procedure SetRotation(const Value: TVector4);
    function GetScale: TVector3;
    procedure SetScale(const Value: TVector3);
    function GetScaleOrientation: TVector4;
    procedure SetScaleOrientation(const Value: TVector4);
    function GetSiteID: Integer;
    procedure SetSiteID(const Value: Integer);
    function GetTranslation: TVector3;
    procedure SetTranslation(const Value: TVector3);
    function GetWarhead: Integer;
    procedure SetWarhead(const Value: Integer);
    function GetWriteInterval: TFloatTime;
    procedure SetWriteInterval(const Value: TFloatTime);
    function GetRtpHeaderExpected: Boolean;
    procedure SetRtpHeaderExpected(const Value: Boolean);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FEventSet_articulationParameterValue0: TSFFloatEvent;
    {  }
    public property EventSet_articulationParameterValue0: TSFFloatEvent read FEventSet_articulationParameterValue0;

    strict private FEventSet_articulationParameterValue1: TSFFloatEvent;
    {  }
    public property EventSet_articulationParameterValue1: TSFFloatEvent read FEventSet_articulationParameterValue1;

    strict private FEventSet_articulationParameterValue2: TSFFloatEvent;
    {  }
    public property EventSet_articulationParameterValue2: TSFFloatEvent read FEventSet_articulationParameterValue2;

    strict private FEventSet_articulationParameterValue3: TSFFloatEvent;
    {  }
    public property EventSet_articulationParameterValue3: TSFFloatEvent read FEventSet_articulationParameterValue3;

    strict private FEventSet_articulationParameterValue4: TSFFloatEvent;
    {  }
    public property EventSet_articulationParameterValue4: TSFFloatEvent read FEventSet_articulationParameterValue4;

    strict private FEventSet_articulationParameterValue5: TSFFloatEvent;
    {  }
    public property EventSet_articulationParameterValue5: TSFFloatEvent read FEventSet_articulationParameterValue5;

    strict private FEventSet_articulationParameterValue6: TSFFloatEvent;
    {  }
    public property EventSet_articulationParameterValue6: TSFFloatEvent read FEventSet_articulationParameterValue6;

    strict private FEventSet_articulationParameterValue7: TSFFloatEvent;
    {  }
    public property EventSet_articulationParameterValue7: TSFFloatEvent read FEventSet_articulationParameterValue7;

    strict private FFdAddress: TSFString;
    { Internal wrapper for property @code(Address). This wrapper API may change, we advise to access simpler @code(Address) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAddress: TSFString read FFdAddress;
    {  }
    property Address: String read GetAddress write SetAddress;

    strict private FFdApplicationID: TSFInt32;
    { Internal wrapper for property @code(ApplicationID). This wrapper API may change, we advise to access simpler @code(ApplicationID) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdApplicationID: TSFInt32 read FFdApplicationID;
    {  }
    property ApplicationID: Integer read GetApplicationID write SetApplicationID;

    strict private FFdArticulationParameterCount: TSFInt32;
    { Internal wrapper for property @code(ArticulationParameterCount). This wrapper API may change, we advise to access simpler @code(ArticulationParameterCount) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdArticulationParameterCount: TSFInt32 read FFdArticulationParameterCount;
    {  }
    property ArticulationParameterCount: Integer read GetArticulationParameterCount write SetArticulationParameterCount;

    strict private FFdArticulationParameterDesignatorArray: TMFInt32;
    { Internal wrapper for property @code(ArticulationParameterDesignatorArray). This wrapper API may change, we advise to access simpler @code(ArticulationParameterDesignatorArray) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdArticulationParameterDesignatorArray: TMFInt32 read FFdArticulationParameterDesignatorArray;
    {  }
    procedure SetArticulationParameterDesignatorArray(const Value: array of Int32); overload;
    {  }
    procedure SetArticulationParameterDesignatorArray(const Value: TInt32List); overload;

    strict private FFdArticulationParameterChangeIndicatorArray: TMFInt32;
    { Internal wrapper for property @code(ArticulationParameterChangeIndicatorArray). This wrapper API may change, we advise to access simpler @code(ArticulationParameterChangeIndicatorArray) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdArticulationParameterChangeIndicatorArray: TMFInt32 read FFdArticulationParameterChangeIndicatorArray;
    {  }
    procedure SetArticulationParameterChangeIndicatorArray(const Value: array of Int32); overload;
    {  }
    procedure SetArticulationParameterChangeIndicatorArray(const Value: TInt32List); overload;

    strict private FFdArticulationParameterIdPartAttachedToArray: TMFInt32;
    { Internal wrapper for property @code(ArticulationParameterIdPartAttachedToArray). This wrapper API may change, we advise to access simpler @code(ArticulationParameterIdPartAttachedToArray) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdArticulationParameterIdPartAttachedToArray: TMFInt32 read FFdArticulationParameterIdPartAttachedToArray;
    {  }
    procedure SetArticulationParameterIdPartAttachedToArray(const Value: array of Int32); overload;
    {  }
    procedure SetArticulationParameterIdPartAttachedToArray(const Value: TInt32List); overload;

    strict private FFdArticulationParameterTypeArray: TMFInt32;
    { Internal wrapper for property @code(ArticulationParameterTypeArray). This wrapper API may change, we advise to access simpler @code(ArticulationParameterTypeArray) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdArticulationParameterTypeArray: TMFInt32 read FFdArticulationParameterTypeArray;
    {  }
    procedure SetArticulationParameterTypeArray(const Value: array of Int32); overload;
    {  }
    procedure SetArticulationParameterTypeArray(const Value: TInt32List); overload;

    strict private FFdArticulationParameterArray: TMFFloat;
    { Internal wrapper for property @code(ArticulationParameterArray). This wrapper API may change, we advise to access simpler @code(ArticulationParameterArray) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdArticulationParameterArray: TMFFloat read FFdArticulationParameterArray;
    {  }
    procedure SetArticulationParameterArray(const Value: array of Single); overload;
    {  }
    procedure SetArticulationParameterArray(const Value: TSingleList); overload;

    strict private FFdCenter: TSFVec3f;
    { Internal wrapper for property @code(Center). This wrapper API may change, we advise to access simpler @code(Center) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCenter: TSFVec3f read FFdCenter;
    {  }
    property Center: TVector3 read GetCenter write SetCenter;

    strict private FFdCollisionType: TSFInt32;
    { Internal wrapper for property @code(CollisionType). This wrapper API may change, we advise to access simpler @code(CollisionType) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCollisionType: TSFInt32 read FFdCollisionType;
    {  }
    property CollisionType: Integer read GetCollisionType write SetCollisionType;

    strict private FFdDeadReckoning: TSFInt32;
    { Internal wrapper for property @code(DeadReckoning). This wrapper API may change, we advise to access simpler @code(DeadReckoning) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDeadReckoning: TSFInt32 read FFdDeadReckoning;
    {  }
    property DeadReckoning: Integer read GetDeadReckoning write SetDeadReckoning;

    strict private FFdDetonationLocation: TSFVec3f;
    { Internal wrapper for property @code(DetonationLocation). This wrapper API may change, we advise to access simpler @code(DetonationLocation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDetonationLocation: TSFVec3f read FFdDetonationLocation;
    {  }
    property DetonationLocation: TVector3 read GetDetonationLocation write SetDetonationLocation;

    strict private FFdDetonationRelativeLocation: TSFVec3f;
    { Internal wrapper for property @code(DetonationRelativeLocation). This wrapper API may change, we advise to access simpler @code(DetonationRelativeLocation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDetonationRelativeLocation: TSFVec3f read FFdDetonationRelativeLocation;
    {  }
    property DetonationRelativeLocation: TVector3 read GetDetonationRelativeLocation write SetDetonationRelativeLocation;

    strict private FFdDetonationResult: TSFInt32;
    { Internal wrapper for property @code(DetonationResult). This wrapper API may change, we advise to access simpler @code(DetonationResult) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDetonationResult: TSFInt32 read FFdDetonationResult;
    {  }
    property DetonationResult: Integer read GetDetonationResult write SetDetonationResult;

    strict private FFdEnabled: TSFBool;
    { Internal wrapper for property @code(Enabled). This wrapper API may change, we advise to access simpler @code(Enabled) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEnabled: TSFBool read FFdEnabled;
    {  }
    property Enabled: Boolean read GetEnabled write SetEnabled;

    strict private FFdEntityCategory: TSFInt32;
    { Internal wrapper for property @code(EntityCategory). This wrapper API may change, we advise to access simpler @code(EntityCategory) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEntityCategory: TSFInt32 read FFdEntityCategory;
    {  }
    property EntityCategory: Integer read GetEntityCategory write SetEntityCategory;

    strict private FFdEntityCountry: TSFInt32;
    { Internal wrapper for property @code(EntityCountry). This wrapper API may change, we advise to access simpler @code(EntityCountry) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEntityCountry: TSFInt32 read FFdEntityCountry;
    {  }
    property EntityCountry: Integer read GetEntityCountry write SetEntityCountry;

    strict private FFdEntityDomain: TSFInt32;
    { Internal wrapper for property @code(EntityDomain). This wrapper API may change, we advise to access simpler @code(EntityDomain) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEntityDomain: TSFInt32 read FFdEntityDomain;
    {  }
    property EntityDomain: Integer read GetEntityDomain write SetEntityDomain;

    strict private FFdEntityExtra: TSFInt32;
    { Internal wrapper for property @code(EntityExtra). This wrapper API may change, we advise to access simpler @code(EntityExtra) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEntityExtra: TSFInt32 read FFdEntityExtra;
    {  }
    property EntityExtra: Integer read GetEntityExtra write SetEntityExtra;

    strict private FFdEntityID: TSFInt32;
    { Internal wrapper for property @code(EntityID). This wrapper API may change, we advise to access simpler @code(EntityID) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEntityID: TSFInt32 read FFdEntityID;
    {  }
    property EntityID: Integer read GetEntityID write SetEntityID;

    strict private FFdEntityKind: TSFInt32;
    { Internal wrapper for property @code(EntityKind). This wrapper API may change, we advise to access simpler @code(EntityKind) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEntityKind: TSFInt32 read FFdEntityKind;
    {  }
    property EntityKind: Integer read GetEntityKind write SetEntityKind;

    strict private FFdEntitySpecific: TSFInt32;
    { Internal wrapper for property @code(EntitySpecific). This wrapper API may change, we advise to access simpler @code(EntitySpecific) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEntitySpecific: TSFInt32 read FFdEntitySpecific;
    {  }
    property EntitySpecific: Integer read GetEntitySpecific write SetEntitySpecific;

    strict private FFdEntitySubCategory: TSFInt32;
    { Internal wrapper for property @code(EntitySubCategory). This wrapper API may change, we advise to access simpler @code(EntitySubCategory) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEntitySubCategory: TSFInt32 read FFdEntitySubCategory;
    {  }
    property EntitySubCategory: Integer read GetEntitySubCategory write SetEntitySubCategory;

    strict private FFdEventApplicationID: TSFInt32;
    { Internal wrapper for property @code(EventApplicationID). This wrapper API may change, we advise to access simpler @code(EventApplicationID) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEventApplicationID: TSFInt32 read FFdEventApplicationID;
    {  }
    property EventApplicationID: Integer read GetEventApplicationID write SetEventApplicationID;

    strict private FFdEventEntityID: TSFInt32;
    { Internal wrapper for property @code(EventEntityID). This wrapper API may change, we advise to access simpler @code(EventEntityID) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEventEntityID: TSFInt32 read FFdEventEntityID;
    {  }
    property EventEntityID: Integer read GetEventEntityID write SetEventEntityID;

    strict private FFdEventNumber: TSFInt32;
    { Internal wrapper for property @code(EventNumber). This wrapper API may change, we advise to access simpler @code(EventNumber) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEventNumber: TSFInt32 read FFdEventNumber;
    {  }
    property EventNumber: Integer read GetEventNumber write SetEventNumber;

    strict private FFdEventSiteID: TSFInt32;
    { Internal wrapper for property @code(EventSiteID). This wrapper API may change, we advise to access simpler @code(EventSiteID) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEventSiteID: TSFInt32 read FFdEventSiteID;
    {  }
    property EventSiteID: Integer read GetEventSiteID write SetEventSiteID;

    strict private FFdFired1: TSFBool;
    { Internal wrapper for property @code(Fired1). This wrapper API may change, we advise to access simpler @code(Fired1) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFired1: TSFBool read FFdFired1;
    {  }
    property Fired1: Boolean read GetFired1 write SetFired1;

    strict private FFdFired2: TSFBool;
    { Internal wrapper for property @code(Fired2). This wrapper API may change, we advise to access simpler @code(Fired2) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFired2: TSFBool read FFdFired2;
    {  }
    property Fired2: Boolean read GetFired2 write SetFired2;

    strict private FFdFireMissionIndex: TSFInt32;
    { Internal wrapper for property @code(FireMissionIndex). This wrapper API may change, we advise to access simpler @code(FireMissionIndex) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFireMissionIndex: TSFInt32 read FFdFireMissionIndex;
    {  }
    property FireMissionIndex: Integer read GetFireMissionIndex write SetFireMissionIndex;

    strict private FFdFiringRange: TSFFloat;
    { Internal wrapper for property @code(FiringRange). This wrapper API may change, we advise to access simpler @code(FiringRange) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFiringRange: TSFFloat read FFdFiringRange;
    {  }
    property FiringRange: Single read GetFiringRange write SetFiringRange;

    strict private FFdFiringRate: TSFInt32;
    { Internal wrapper for property @code(FiringRate). This wrapper API may change, we advise to access simpler @code(FiringRate) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFiringRate: TSFInt32 read FFdFiringRate;
    {  }
    property FiringRate: Integer read GetFiringRate write SetFiringRate;

    strict private FFdForceID: TSFInt32;
    { Internal wrapper for property @code(ForceID). This wrapper API may change, we advise to access simpler @code(ForceID) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdForceID: TSFInt32 read FFdForceID;
    {  }
    property ForceID: Integer read GetForceID write SetForceID;

    strict private FFdFuse: TSFInt32;
    { Internal wrapper for property @code(Fuse). This wrapper API may change, we advise to access simpler @code(Fuse) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFuse: TSFInt32 read FFdFuse;
    {  }
    property Fuse: Integer read GetFuse write SetFuse;

    strict private FFdLinearVelocity: TSFVec3f;
    { Internal wrapper for property @code(LinearVelocity). This wrapper API may change, we advise to access simpler @code(LinearVelocity) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLinearVelocity: TSFVec3f read FFdLinearVelocity;
    {  }
    property LinearVelocity: TVector3 read GetLinearVelocity write SetLinearVelocity;

    strict private FFdLinearAcceleration: TSFVec3f;
    { Internal wrapper for property @code(LinearAcceleration). This wrapper API may change, we advise to access simpler @code(LinearAcceleration) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLinearAcceleration: TSFVec3f read FFdLinearAcceleration;
    {  }
    property LinearAcceleration: TVector3 read GetLinearAcceleration write SetLinearAcceleration;

    strict private FFdMarking: TSFString;
    { Internal wrapper for property @code(Marking). This wrapper API may change, we advise to access simpler @code(Marking) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMarking: TSFString read FFdMarking;
    {  }
    property Marking: String read GetMarking write SetMarking;

    strict private FFdMulticastRelayHost: TSFString;
    { Internal wrapper for property @code(MulticastRelayHost). This wrapper API may change, we advise to access simpler @code(MulticastRelayHost) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMulticastRelayHost: TSFString read FFdMulticastRelayHost;
    {  }
    property MulticastRelayHost: String read GetMulticastRelayHost write SetMulticastRelayHost;

    strict private FFdMulticastRelayPort: TSFInt32;
    { Internal wrapper for property @code(MulticastRelayPort). This wrapper API may change, we advise to access simpler @code(MulticastRelayPort) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMulticastRelayPort: TSFInt32 read FFdMulticastRelayPort;
    {  }
    property MulticastRelayPort: Integer read GetMulticastRelayPort write SetMulticastRelayPort;

    strict private FFdMunitionApplicationID: TSFInt32;
    { Internal wrapper for property @code(MunitionApplicationID). This wrapper API may change, we advise to access simpler @code(MunitionApplicationID) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMunitionApplicationID: TSFInt32 read FFdMunitionApplicationID;
    {  }
    property MunitionApplicationID: Integer read GetMunitionApplicationID write SetMunitionApplicationID;

    strict private FFdMunitionEndPoint: TSFVec3f;
    { Internal wrapper for property @code(MunitionEndPoint). This wrapper API may change, we advise to access simpler @code(MunitionEndPoint) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMunitionEndPoint: TSFVec3f read FFdMunitionEndPoint;
    {  }
    property MunitionEndPoint: TVector3 read GetMunitionEndPoint write SetMunitionEndPoint;

    strict private FFdMunitionEntityID: TSFInt32;
    { Internal wrapper for property @code(MunitionEntityID). This wrapper API may change, we advise to access simpler @code(MunitionEntityID) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMunitionEntityID: TSFInt32 read FFdMunitionEntityID;
    {  }
    property MunitionEntityID: Integer read GetMunitionEntityID write SetMunitionEntityID;

    strict private FFdMunitionQuantity: TSFInt32;
    { Internal wrapper for property @code(MunitionQuantity). This wrapper API may change, we advise to access simpler @code(MunitionQuantity) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMunitionQuantity: TSFInt32 read FFdMunitionQuantity;
    {  }
    property MunitionQuantity: Integer read GetMunitionQuantity write SetMunitionQuantity;

    strict private FFdMunitionSiteID: TSFInt32;
    { Internal wrapper for property @code(MunitionSiteID). This wrapper API may change, we advise to access simpler @code(MunitionSiteID) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMunitionSiteID: TSFInt32 read FFdMunitionSiteID;
    {  }
    property MunitionSiteID: Integer read GetMunitionSiteID write SetMunitionSiteID;

    strict private FFdMunitionStartPoint: TSFVec3f;
    { Internal wrapper for property @code(MunitionStartPoint). This wrapper API may change, we advise to access simpler @code(MunitionStartPoint) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMunitionStartPoint: TSFVec3f read FFdMunitionStartPoint;
    {  }
    property MunitionStartPoint: TVector3 read GetMunitionStartPoint write SetMunitionStartPoint;

    strict private FFdNetworkMode: TSFStringEnum;
    { Internal wrapper for property @code(NetworkMode). This wrapper API may change, we advise to access simpler @code(NetworkMode) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNetworkMode: TSFStringEnum read FFdNetworkMode;
    {  }
    property NetworkMode: TDISNetworkMode read GetNetworkMode write SetNetworkMode;

    strict private FFdPort: TSFInt32;
    { Internal wrapper for property @code(Port). This wrapper API may change, we advise to access simpler @code(Port) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdPort: TSFInt32 read FFdPort;
    {  }
    property Port: Integer read GetPort write SetPort;

    strict private FFdReadInterval: TSFTime;
    { Internal wrapper for property @code(ReadInterval). This wrapper API may change, we advise to access simpler @code(ReadInterval) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdReadInterval: TSFTime read FFdReadInterval;
    {  }
    property ReadInterval: TFloatTime read GetReadInterval write SetReadInterval;

    strict private FFdRotation: TSFRotation;
    { Internal wrapper for property @code(Rotation). This wrapper API may change, we advise to access simpler @code(Rotation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRotation: TSFRotation read FFdRotation;
    {  }
    property Rotation: TVector4 read GetRotation write SetRotation;

    strict private FFdScale: TSFVec3f;
    { Internal wrapper for property @code(Scale). This wrapper API may change, we advise to access simpler @code(Scale) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdScale: TSFVec3f read FFdScale;
    {  }
    property Scale: TVector3 read GetScale write SetScale;

    strict private FFdScaleOrientation: TSFRotation;
    { Internal wrapper for property @code(ScaleOrientation). This wrapper API may change, we advise to access simpler @code(ScaleOrientation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdScaleOrientation: TSFRotation read FFdScaleOrientation;
    {  }
    property ScaleOrientation: TVector4 read GetScaleOrientation write SetScaleOrientation;

    strict private FFdSiteID: TSFInt32;
    { Internal wrapper for property @code(SiteID). This wrapper API may change, we advise to access simpler @code(SiteID) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSiteID: TSFInt32 read FFdSiteID;
    {  }
    property SiteID: Integer read GetSiteID write SetSiteID;

    strict private FFdTranslation: TSFVec3f;
    { Internal wrapper for property @code(Translation). This wrapper API may change, we advise to access simpler @code(Translation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTranslation: TSFVec3f read FFdTranslation;
    {  }
    property Translation: TVector3 read GetTranslation write SetTranslation;

    strict private FFdWarhead: TSFInt32;
    { Internal wrapper for property @code(Warhead). This wrapper API may change, we advise to access simpler @code(Warhead) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdWarhead: TSFInt32 read FFdWarhead;
    {  }
    property Warhead: Integer read GetWarhead write SetWarhead;

    strict private FFdWriteInterval: TSFTime;
    { Internal wrapper for property @code(WriteInterval). This wrapper API may change, we advise to access simpler @code(WriteInterval) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdWriteInterval: TSFTime read FFdWriteInterval;
    {  }
    property WriteInterval: TFloatTime read GetWriteInterval write SetWriteInterval;

    strict private FEventArticulationParameterValue0_changed: TSFFloatEvent;
    {  }
    public property EventArticulationParameterValue0_changed: TSFFloatEvent read FEventArticulationParameterValue0_changed;

    strict private FEventArticulationParameterValue1_changed: TSFFloatEvent;
    {  }
    public property EventArticulationParameterValue1_changed: TSFFloatEvent read FEventArticulationParameterValue1_changed;

    strict private FEventArticulationParameterValue2_changed: TSFFloatEvent;
    {  }
    public property EventArticulationParameterValue2_changed: TSFFloatEvent read FEventArticulationParameterValue2_changed;

    strict private FEventArticulationParameterValue3_changed: TSFFloatEvent;
    {  }
    public property EventArticulationParameterValue3_changed: TSFFloatEvent read FEventArticulationParameterValue3_changed;

    strict private FEventArticulationParameterValue4_changed: TSFFloatEvent;
    {  }
    public property EventArticulationParameterValue4_changed: TSFFloatEvent read FEventArticulationParameterValue4_changed;

    strict private FEventArticulationParameterValue5_changed: TSFFloatEvent;
    {  }
    public property EventArticulationParameterValue5_changed: TSFFloatEvent read FEventArticulationParameterValue5_changed;

    strict private FEventArticulationParameterValue6_changed: TSFFloatEvent;
    {  }
    public property EventArticulationParameterValue6_changed: TSFFloatEvent read FEventArticulationParameterValue6_changed;

    strict private FEventArticulationParameterValue7_changed: TSFFloatEvent;
    {  }
    public property EventArticulationParameterValue7_changed: TSFFloatEvent read FEventArticulationParameterValue7_changed;

    strict private FEventCollideTime: TSFTimeEvent;
    {  }
    public property EventCollideTime: TSFTimeEvent read FEventCollideTime;

    strict private FEventDetonateTime: TSFTimeEvent;
    {  }
    public property EventDetonateTime: TSFTimeEvent read FEventDetonateTime;

    strict private FEventFiredTime: TSFTimeEvent;
    {  }
    public property EventFiredTime: TSFTimeEvent read FEventFiredTime;

    strict private FEventIsActive: TSFBoolEvent;
    {  }
    public property EventIsActive: TSFBoolEvent read FEventIsActive;

    strict private FEventIsCollided: TSFBoolEvent;
    {  }
    public property EventIsCollided: TSFBoolEvent read FEventIsCollided;

    strict private FEventIsDetonated: TSFBoolEvent;
    {  }
    public property EventIsDetonated: TSFBoolEvent read FEventIsDetonated;

    strict private FEventIsNetworkReader: TSFBoolEvent;
    {  }
    public property EventIsNetworkReader: TSFBoolEvent read FEventIsNetworkReader;

    strict private FEventIsNetworkWriter: TSFBoolEvent;
    {  }
    public property EventIsNetworkWriter: TSFBoolEvent read FEventIsNetworkWriter;

    strict private FEventIsRtpHeaderHeard: TSFBoolEvent;
    {  }
    public property EventIsRtpHeaderHeard: TSFBoolEvent read FEventIsRtpHeaderHeard;

    strict private FEventIsStandAlone: TSFBoolEvent;
    {  }
    public property EventIsStandAlone: TSFBoolEvent read FEventIsStandAlone;

    strict private FEventTimestamp: TSFTimeEvent;
    {  }
    public property EventTimestamp: TSFTimeEvent read FEventTimestamp;

    strict private FFdRtpHeaderExpected: TSFBool;
    { Internal wrapper for property @code(RtpHeaderExpected). This wrapper API may change, we advise to access simpler @code(RtpHeaderExpected) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRtpHeaderExpected: TSFBool read FFdRtpHeaderExpected;
    {  }
    property RtpHeaderExpected: Boolean read GetRtpHeaderExpected write SetRtpHeaderExpected;

{$endif read_interface}

{$ifdef read_implementation}

{ TEspduTransformNode ----------------------------------------------- }

function TEspduTransformNode.GetAddress: String;
begin
  Result := FdAddress.Value;
end;

procedure TEspduTransformNode.SetAddress(const Value: String);
begin
  FdAddress.Send(Value);
end;

function TEspduTransformNode.GetApplicationID: Integer;
begin
  Result := FdApplicationID.Value;
end;

procedure TEspduTransformNode.SetApplicationID(const Value: Integer);
begin
  FdApplicationID.Send(Value);
end;

function TEspduTransformNode.GetArticulationParameterCount: Integer;
begin
  Result := FdArticulationParameterCount.Value;
end;

procedure TEspduTransformNode.SetArticulationParameterCount(const Value: Integer);
begin
  FdArticulationParameterCount.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterDesignatorArray(const Value: array of Int32);
begin
  FdArticulationParameterDesignatorArray.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterDesignatorArray(const Value: TInt32List);
begin
  FdArticulationParameterDesignatorArray.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterChangeIndicatorArray(const Value: array of Int32);
begin
  FdArticulationParameterChangeIndicatorArray.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterChangeIndicatorArray(const Value: TInt32List);
begin
  FdArticulationParameterChangeIndicatorArray.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterIdPartAttachedToArray(const Value: array of Int32);
begin
  FdArticulationParameterIdPartAttachedToArray.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterIdPartAttachedToArray(const Value: TInt32List);
begin
  FdArticulationParameterIdPartAttachedToArray.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterTypeArray(const Value: array of Int32);
begin
  FdArticulationParameterTypeArray.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterTypeArray(const Value: TInt32List);
begin
  FdArticulationParameterTypeArray.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterArray(const Value: array of Single);
begin
  FdArticulationParameterArray.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterArray(const Value: TSingleList);
begin
  FdArticulationParameterArray.Send(Value);
end;

function TEspduTransformNode.GetCenter: TVector3;
begin
  Result := FdCenter.Value;
end;

procedure TEspduTransformNode.SetCenter(const Value: TVector3);
begin
  FdCenter.Send(Value);
end;

function TEspduTransformNode.GetCollisionType: Integer;
begin
  Result := FdCollisionType.Value;
end;

procedure TEspduTransformNode.SetCollisionType(const Value: Integer);
begin
  FdCollisionType.Send(Value);
end;

function TEspduTransformNode.GetDeadReckoning: Integer;
begin
  Result := FdDeadReckoning.Value;
end;

procedure TEspduTransformNode.SetDeadReckoning(const Value: Integer);
begin
  FdDeadReckoning.Send(Value);
end;

function TEspduTransformNode.GetDetonationLocation: TVector3;
begin
  Result := FdDetonationLocation.Value;
end;

procedure TEspduTransformNode.SetDetonationLocation(const Value: TVector3);
begin
  FdDetonationLocation.Send(Value);
end;

function TEspduTransformNode.GetDetonationRelativeLocation: TVector3;
begin
  Result := FdDetonationRelativeLocation.Value;
end;

procedure TEspduTransformNode.SetDetonationRelativeLocation(const Value: TVector3);
begin
  FdDetonationRelativeLocation.Send(Value);
end;

function TEspduTransformNode.GetDetonationResult: Integer;
begin
  Result := FdDetonationResult.Value;
end;

procedure TEspduTransformNode.SetDetonationResult(const Value: Integer);
begin
  FdDetonationResult.Send(Value);
end;

function TEspduTransformNode.GetEnabled: Boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TEspduTransformNode.SetEnabled(const Value: Boolean);
begin
  FdEnabled.Send(Value);
end;

function TEspduTransformNode.GetEntityCategory: Integer;
begin
  Result := FdEntityCategory.Value;
end;

procedure TEspduTransformNode.SetEntityCategory(const Value: Integer);
begin
  FdEntityCategory.Send(Value);
end;

function TEspduTransformNode.GetEntityCountry: Integer;
begin
  Result := FdEntityCountry.Value;
end;

procedure TEspduTransformNode.SetEntityCountry(const Value: Integer);
begin
  FdEntityCountry.Send(Value);
end;

function TEspduTransformNode.GetEntityDomain: Integer;
begin
  Result := FdEntityDomain.Value;
end;

procedure TEspduTransformNode.SetEntityDomain(const Value: Integer);
begin
  FdEntityDomain.Send(Value);
end;

function TEspduTransformNode.GetEntityExtra: Integer;
begin
  Result := FdEntityExtra.Value;
end;

procedure TEspduTransformNode.SetEntityExtra(const Value: Integer);
begin
  FdEntityExtra.Send(Value);
end;

function TEspduTransformNode.GetEntityID: Integer;
begin
  Result := FdEntityID.Value;
end;

procedure TEspduTransformNode.SetEntityID(const Value: Integer);
begin
  FdEntityID.Send(Value);
end;

function TEspduTransformNode.GetEntityKind: Integer;
begin
  Result := FdEntityKind.Value;
end;

procedure TEspduTransformNode.SetEntityKind(const Value: Integer);
begin
  FdEntityKind.Send(Value);
end;

function TEspduTransformNode.GetEntitySpecific: Integer;
begin
  Result := FdEntitySpecific.Value;
end;

procedure TEspduTransformNode.SetEntitySpecific(const Value: Integer);
begin
  FdEntitySpecific.Send(Value);
end;

function TEspduTransformNode.GetEntitySubCategory: Integer;
begin
  Result := FdEntitySubCategory.Value;
end;

procedure TEspduTransformNode.SetEntitySubCategory(const Value: Integer);
begin
  FdEntitySubCategory.Send(Value);
end;

function TEspduTransformNode.GetEventApplicationID: Integer;
begin
  Result := FdEventApplicationID.Value;
end;

procedure TEspduTransformNode.SetEventApplicationID(const Value: Integer);
begin
  FdEventApplicationID.Send(Value);
end;

function TEspduTransformNode.GetEventEntityID: Integer;
begin
  Result := FdEventEntityID.Value;
end;

procedure TEspduTransformNode.SetEventEntityID(const Value: Integer);
begin
  FdEventEntityID.Send(Value);
end;

function TEspduTransformNode.GetEventNumber: Integer;
begin
  Result := FdEventNumber.Value;
end;

procedure TEspduTransformNode.SetEventNumber(const Value: Integer);
begin
  FdEventNumber.Send(Value);
end;

function TEspduTransformNode.GetEventSiteID: Integer;
begin
  Result := FdEventSiteID.Value;
end;

procedure TEspduTransformNode.SetEventSiteID(const Value: Integer);
begin
  FdEventSiteID.Send(Value);
end;

function TEspduTransformNode.GetFired1: Boolean;
begin
  Result := FdFired1.Value;
end;

procedure TEspduTransformNode.SetFired1(const Value: Boolean);
begin
  FdFired1.Send(Value);
end;

function TEspduTransformNode.GetFired2: Boolean;
begin
  Result := FdFired2.Value;
end;

procedure TEspduTransformNode.SetFired2(const Value: Boolean);
begin
  FdFired2.Send(Value);
end;

function TEspduTransformNode.GetFireMissionIndex: Integer;
begin
  Result := FdFireMissionIndex.Value;
end;

procedure TEspduTransformNode.SetFireMissionIndex(const Value: Integer);
begin
  FdFireMissionIndex.Send(Value);
end;

function TEspduTransformNode.GetFiringRange: Single;
begin
  Result := FdFiringRange.Value;
end;

procedure TEspduTransformNode.SetFiringRange(const Value: Single);
begin
  FdFiringRange.Send(Value);
end;

function TEspduTransformNode.GetFiringRate: Integer;
begin
  Result := FdFiringRate.Value;
end;

procedure TEspduTransformNode.SetFiringRate(const Value: Integer);
begin
  FdFiringRate.Send(Value);
end;

function TEspduTransformNode.GetForceID: Integer;
begin
  Result := FdForceID.Value;
end;

procedure TEspduTransformNode.SetForceID(const Value: Integer);
begin
  FdForceID.Send(Value);
end;

function TEspduTransformNode.GetFuse: Integer;
begin
  Result := FdFuse.Value;
end;

procedure TEspduTransformNode.SetFuse(const Value: Integer);
begin
  FdFuse.Send(Value);
end;

function TEspduTransformNode.GetLinearVelocity: TVector3;
begin
  Result := FdLinearVelocity.Value;
end;

procedure TEspduTransformNode.SetLinearVelocity(const Value: TVector3);
begin
  FdLinearVelocity.Send(Value);
end;

function TEspduTransformNode.GetLinearAcceleration: TVector3;
begin
  Result := FdLinearAcceleration.Value;
end;

procedure TEspduTransformNode.SetLinearAcceleration(const Value: TVector3);
begin
  FdLinearAcceleration.Send(Value);
end;

function TEspduTransformNode.GetMarking: String;
begin
  Result := FdMarking.Value;
end;

procedure TEspduTransformNode.SetMarking(const Value: String);
begin
  FdMarking.Send(Value);
end;

function TEspduTransformNode.GetMulticastRelayHost: String;
begin
  Result := FdMulticastRelayHost.Value;
end;

procedure TEspduTransformNode.SetMulticastRelayHost(const Value: String);
begin
  FdMulticastRelayHost.Send(Value);
end;

function TEspduTransformNode.GetMulticastRelayPort: Integer;
begin
  Result := FdMulticastRelayPort.Value;
end;

procedure TEspduTransformNode.SetMulticastRelayPort(const Value: Integer);
begin
  FdMulticastRelayPort.Send(Value);
end;

function TEspduTransformNode.GetMunitionApplicationID: Integer;
begin
  Result := FdMunitionApplicationID.Value;
end;

procedure TEspduTransformNode.SetMunitionApplicationID(const Value: Integer);
begin
  FdMunitionApplicationID.Send(Value);
end;

function TEspduTransformNode.GetMunitionEndPoint: TVector3;
begin
  Result := FdMunitionEndPoint.Value;
end;

procedure TEspduTransformNode.SetMunitionEndPoint(const Value: TVector3);
begin
  FdMunitionEndPoint.Send(Value);
end;

function TEspduTransformNode.GetMunitionEntityID: Integer;
begin
  Result := FdMunitionEntityID.Value;
end;

procedure TEspduTransformNode.SetMunitionEntityID(const Value: Integer);
begin
  FdMunitionEntityID.Send(Value);
end;

function TEspduTransformNode.GetMunitionQuantity: Integer;
begin
  Result := FdMunitionQuantity.Value;
end;

procedure TEspduTransformNode.SetMunitionQuantity(const Value: Integer);
begin
  FdMunitionQuantity.Send(Value);
end;

function TEspduTransformNode.GetMunitionSiteID: Integer;
begin
  Result := FdMunitionSiteID.Value;
end;

procedure TEspduTransformNode.SetMunitionSiteID(const Value: Integer);
begin
  FdMunitionSiteID.Send(Value);
end;

function TEspduTransformNode.GetMunitionStartPoint: TVector3;
begin
  Result := FdMunitionStartPoint.Value;
end;

procedure TEspduTransformNode.SetMunitionStartPoint(const Value: TVector3);
begin
  FdMunitionStartPoint.Send(Value);
end;

function TEspduTransformNode.GetNetworkMode: TDISNetworkMode;
begin
  Result := TDISNetworkMode(FdNetworkMode.EnumValue);
end;

procedure TEspduTransformNode.SetNetworkMode(const Value: TDISNetworkMode);
begin
  FdNetworkMode.SendEnumValue(Ord(Value));
end;

function TEspduTransformNode.GetPort: Integer;
begin
  Result := FdPort.Value;
end;

procedure TEspduTransformNode.SetPort(const Value: Integer);
begin
  FdPort.Send(Value);
end;

function TEspduTransformNode.GetReadInterval: TFloatTime;
begin
  Result := FdReadInterval.Value;
end;

procedure TEspduTransformNode.SetReadInterval(const Value: TFloatTime);
begin
  FdReadInterval.Send(Value);
end;

function TEspduTransformNode.GetRotation: TVector4;
begin
  Result := FdRotation.Value;
end;

procedure TEspduTransformNode.SetRotation(const Value: TVector4);
begin
  FdRotation.Send(Value);
end;

function TEspduTransformNode.GetScale: TVector3;
begin
  Result := FdScale.Value;
end;

procedure TEspduTransformNode.SetScale(const Value: TVector3);
begin
  FdScale.Send(Value);
end;

function TEspduTransformNode.GetScaleOrientation: TVector4;
begin
  Result := FdScaleOrientation.Value;
end;

procedure TEspduTransformNode.SetScaleOrientation(const Value: TVector4);
begin
  FdScaleOrientation.Send(Value);
end;

function TEspduTransformNode.GetSiteID: Integer;
begin
  Result := FdSiteID.Value;
end;

procedure TEspduTransformNode.SetSiteID(const Value: Integer);
begin
  FdSiteID.Send(Value);
end;

function TEspduTransformNode.GetTranslation: TVector3;
begin
  Result := FdTranslation.Value;
end;

procedure TEspduTransformNode.SetTranslation(const Value: TVector3);
begin
  FdTranslation.Send(Value);
end;

function TEspduTransformNode.GetWarhead: Integer;
begin
  Result := FdWarhead.Value;
end;

procedure TEspduTransformNode.SetWarhead(const Value: Integer);
begin
  FdWarhead.Send(Value);
end;

function TEspduTransformNode.GetWriteInterval: TFloatTime;
begin
  Result := FdWriteInterval.Value;
end;

procedure TEspduTransformNode.SetWriteInterval(const Value: TFloatTime);
begin
  FdWriteInterval.Send(Value);
end;

function TEspduTransformNode.GetRtpHeaderExpected: Boolean;
begin
  Result := FdRtpHeaderExpected.Value;
end;

procedure TEspduTransformNode.SetRtpHeaderExpected(const Value: Boolean);
begin
  FdRtpHeaderExpected.Send(Value);
end;

class function TEspduTransformNode.ClassX3DType: String;
begin
  Result := 'EspduTransform';
end;

procedure TEspduTransformNode.CreateNode;
begin
  inherited;

  FEventSet_articulationParameterValue0 := TSFFloatEvent.Create(Self, 'set_articulationParameterValue0', true);
  AddEvent(FEventSet_articulationParameterValue0);

  FEventSet_articulationParameterValue1 := TSFFloatEvent.Create(Self, 'set_articulationParameterValue1', true);
  AddEvent(FEventSet_articulationParameterValue1);

  FEventSet_articulationParameterValue2 := TSFFloatEvent.Create(Self, 'set_articulationParameterValue2', true);
  AddEvent(FEventSet_articulationParameterValue2);

  FEventSet_articulationParameterValue3 := TSFFloatEvent.Create(Self, 'set_articulationParameterValue3', true);
  AddEvent(FEventSet_articulationParameterValue3);

  FEventSet_articulationParameterValue4 := TSFFloatEvent.Create(Self, 'set_articulationParameterValue4', true);
  AddEvent(FEventSet_articulationParameterValue4);

  FEventSet_articulationParameterValue5 := TSFFloatEvent.Create(Self, 'set_articulationParameterValue5', true);
  AddEvent(FEventSet_articulationParameterValue5);

  FEventSet_articulationParameterValue6 := TSFFloatEvent.Create(Self, 'set_articulationParameterValue6', true);
  AddEvent(FEventSet_articulationParameterValue6);

  FEventSet_articulationParameterValue7 := TSFFloatEvent.Create(Self, 'set_articulationParameterValue7', true);
  AddEvent(FEventSet_articulationParameterValue7);

  FFdAddress := TSFString.Create(Self, True, 'address', 'localhost');
   FdAddress.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAddress);

  FFdApplicationID := TSFInt32.Create(Self, True, 'applicationID', 1);
   FdApplicationID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdApplicationID);

  FFdArticulationParameterCount := TSFInt32.Create(Self, True, 'articulationParameterCount', 0);
   FdArticulationParameterCount.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdArticulationParameterCount);

  FFdArticulationParameterDesignatorArray := TMFInt32.Create(Self, True, 'articulationParameterDesignatorArray', []);
   FdArticulationParameterDesignatorArray.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdArticulationParameterDesignatorArray);

  FFdArticulationParameterChangeIndicatorArray := TMFInt32.Create(Self, True, 'articulationParameterChangeIndicatorArray', []);
   FdArticulationParameterChangeIndicatorArray.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdArticulationParameterChangeIndicatorArray);

  FFdArticulationParameterIdPartAttachedToArray := TMFInt32.Create(Self, True, 'articulationParameterIdPartAttachedToArray', []);
   FdArticulationParameterIdPartAttachedToArray.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdArticulationParameterIdPartAttachedToArray);

  FFdArticulationParameterTypeArray := TMFInt32.Create(Self, True, 'articulationParameterTypeArray', []);
   FdArticulationParameterTypeArray.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdArticulationParameterTypeArray);

  FFdArticulationParameterArray := TMFFloat.Create(Self, True, 'articulationParameterArray', []);
   FdArticulationParameterArray.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdArticulationParameterArray);

  FFdCenter := TSFVec3f.Create(Self, True, 'center', Vector3(0, 0, 0));
   FdCenter.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCenter);

  FFdCollisionType := TSFInt32.Create(Self, True, 'collisionType', 0);
   FdCollisionType.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCollisionType);

  FFdDeadReckoning := TSFInt32.Create(Self, True, 'deadReckoning', 0);
   FdDeadReckoning.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDeadReckoning);

  FFdDetonationLocation := TSFVec3f.Create(Self, True, 'detonationLocation', Vector3(0, 0, 0));
   FdDetonationLocation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDetonationLocation);

  FFdDetonationRelativeLocation := TSFVec3f.Create(Self, True, 'detonationRelativeLocation', Vector3(0, 0, 0));
   FdDetonationRelativeLocation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDetonationRelativeLocation);

  FFdDetonationResult := TSFInt32.Create(Self, True, 'detonationResult', 0);
   FdDetonationResult.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDetonationResult);

  FFdEnabled := TSFBool.Create(Self, True, 'enabled', true);
   FdEnabled.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEnabled);

  FFdEntityCategory := TSFInt32.Create(Self, True, 'entityCategory', 0);
   FdEntityCategory.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEntityCategory);

  FFdEntityCountry := TSFInt32.Create(Self, True, 'entityCountry', 0);
   FdEntityCountry.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEntityCountry);

  FFdEntityDomain := TSFInt32.Create(Self, True, 'entityDomain', 0);
   FdEntityDomain.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEntityDomain);

  FFdEntityExtra := TSFInt32.Create(Self, True, 'entityExtra', 0);
   FdEntityExtra.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEntityExtra);

  FFdEntityID := TSFInt32.Create(Self, True, 'entityID', 0);
   FdEntityID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEntityID);

  FFdEntityKind := TSFInt32.Create(Self, True, 'entityKind', 0);
   FdEntityKind.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEntityKind);

  FFdEntitySpecific := TSFInt32.Create(Self, True, 'entitySpecific', 0);
   FdEntitySpecific.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEntitySpecific);

  FFdEntitySubCategory := TSFInt32.Create(Self, True, 'entitySubCategory', 0);
   FdEntitySubCategory.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEntitySubCategory);

  FFdEventApplicationID := TSFInt32.Create(Self, True, 'eventApplicationID', 1);
   FdEventApplicationID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEventApplicationID);

  FFdEventEntityID := TSFInt32.Create(Self, True, 'eventEntityID', 0);
   FdEventEntityID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEventEntityID);

  FFdEventNumber := TSFInt32.Create(Self, True, 'eventNumber', 0);
   FdEventNumber.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEventNumber);

  FFdEventSiteID := TSFInt32.Create(Self, True, 'eventSiteID', 0);
   FdEventSiteID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEventSiteID);

  FFdFired1 := TSFBool.Create(Self, True, 'fired1', false);
   FdFired1.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFired1);

  FFdFired2 := TSFBool.Create(Self, True, 'fired2', false);
   FdFired2.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFired2);

  FFdFireMissionIndex := TSFInt32.Create(Self, True, 'fireMissionIndex', 0);
   FdFireMissionIndex.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFireMissionIndex);

  FFdFiringRange := TSFFloat.Create(Self, True, 'firingRange', 0.0);
   FdFiringRange.ChangeAlways := chVisibleNonGeometry;
   FdFiringRange.MustBeNonnegative := true;
  AddField(FFdFiringRange);

  FFdFiringRate := TSFInt32.Create(Self, True, 'firingRate', 0);
   FdFiringRate.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFiringRate);

  FFdForceID := TSFInt32.Create(Self, True, 'forceID', 0);
   FdForceID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdForceID);

  FFdFuse := TSFInt32.Create(Self, True, 'fuse', 0);
   FdFuse.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFuse);

  FFdLinearVelocity := TSFVec3f.Create(Self, True, 'linearVelocity', Vector3(0, 0, 0));
   FdLinearVelocity.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLinearVelocity);

  FFdLinearAcceleration := TSFVec3f.Create(Self, True, 'linearAcceleration', Vector3(0, 0, 0));
   FdLinearAcceleration.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLinearAcceleration);

  FFdMarking := TSFString.Create(Self, True, 'marking', '');
   FdMarking.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMarking);

  FFdMulticastRelayHost := TSFString.Create(Self, True, 'multicastRelayHost', '');
   FdMulticastRelayHost.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMulticastRelayHost);

  FFdMulticastRelayPort := TSFInt32.Create(Self, True, 'multicastRelayPort', 0);
   FdMulticastRelayPort.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMulticastRelayPort);

  FFdMunitionApplicationID := TSFInt32.Create(Self, True, 'munitionApplicationID', 1);
   FdMunitionApplicationID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMunitionApplicationID);

  FFdMunitionEndPoint := TSFVec3f.Create(Self, True, 'munitionEndPoint', Vector3(0, 0, 0));
   FdMunitionEndPoint.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMunitionEndPoint);

  FFdMunitionEntityID := TSFInt32.Create(Self, True, 'munitionEntityID', 0);
   FdMunitionEntityID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMunitionEntityID);

  FFdMunitionQuantity := TSFInt32.Create(Self, True, 'munitionQuantity', 0);
   FdMunitionQuantity.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMunitionQuantity);

  FFdMunitionSiteID := TSFInt32.Create(Self, True, 'munitionSiteID', 0);
   FdMunitionSiteID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMunitionSiteID);

  FFdMunitionStartPoint := TSFVec3f.Create(Self, True, 'munitionStartPoint', Vector3(0, 0, 0));
   FdMunitionStartPoint.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMunitionStartPoint);

  FFdNetworkMode := TSFStringEnum.Create(Self, True, 'networkMode', @DISNetworkModeNames, Ord(High(DISNetworkModeNames)) + 1, Ord(nmStandAlone));
   FdNetworkMode.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdNetworkMode);

  FFdPort := TSFInt32.Create(Self, True, 'port', 0);
   FdPort.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdPort);

  FFdReadInterval := TSFTime.Create(Self, True, 'readInterval', 0.1);
   FdReadInterval.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdReadInterval);

  FFdRotation := TSFRotation.Create(Self, True, 'rotation', Vector3(0, 0, 1), 0);
   FdRotation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRotation);

  FFdScale := TSFVec3f.Create(Self, True, 'scale', Vector3(1, 1, 1));
   FdScale.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdScale);

  FFdScaleOrientation := TSFRotation.Create(Self, True, 'scaleOrientation', Vector3(0, 0, 1), 0);
   FdScaleOrientation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdScaleOrientation);

  FFdSiteID := TSFInt32.Create(Self, True, 'siteID', 0);
   FdSiteID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSiteID);

  FFdTranslation := TSFVec3f.Create(Self, True, 'translation', Vector3(0, 0, 0));
   FdTranslation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTranslation);

  FFdWarhead := TSFInt32.Create(Self, True, 'warhead', 0);
   FdWarhead.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdWarhead);

  FFdWriteInterval := TSFTime.Create(Self, True, 'writeInterval', 1.0);
   FdWriteInterval.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdWriteInterval);

  FEventArticulationParameterValue0_changed := TSFFloatEvent.Create(Self, 'articulationParameterValue0_changed', false);
  AddEvent(FEventArticulationParameterValue0_changed);

  FEventArticulationParameterValue1_changed := TSFFloatEvent.Create(Self, 'articulationParameterValue1_changed', false);
  AddEvent(FEventArticulationParameterValue1_changed);

  FEventArticulationParameterValue2_changed := TSFFloatEvent.Create(Self, 'articulationParameterValue2_changed', false);
  AddEvent(FEventArticulationParameterValue2_changed);

  FEventArticulationParameterValue3_changed := TSFFloatEvent.Create(Self, 'articulationParameterValue3_changed', false);
  AddEvent(FEventArticulationParameterValue3_changed);

  FEventArticulationParameterValue4_changed := TSFFloatEvent.Create(Self, 'articulationParameterValue4_changed', false);
  AddEvent(FEventArticulationParameterValue4_changed);

  FEventArticulationParameterValue5_changed := TSFFloatEvent.Create(Self, 'articulationParameterValue5_changed', false);
  AddEvent(FEventArticulationParameterValue5_changed);

  FEventArticulationParameterValue6_changed := TSFFloatEvent.Create(Self, 'articulationParameterValue6_changed', false);
  AddEvent(FEventArticulationParameterValue6_changed);

  FEventArticulationParameterValue7_changed := TSFFloatEvent.Create(Self, 'articulationParameterValue7_changed', false);
  AddEvent(FEventArticulationParameterValue7_changed);

  FEventCollideTime := TSFTimeEvent.Create(Self, 'collideTime', false);
  AddEvent(FEventCollideTime);

  FEventDetonateTime := TSFTimeEvent.Create(Self, 'detonateTime', false);
  AddEvent(FEventDetonateTime);

  FEventFiredTime := TSFTimeEvent.Create(Self, 'firedTime', false);
  AddEvent(FEventFiredTime);

  FEventIsActive := TSFBoolEvent.Create(Self, 'isActive', false);
  AddEvent(FEventIsActive);

  FEventIsCollided := TSFBoolEvent.Create(Self, 'isCollided', false);
  AddEvent(FEventIsCollided);

  FEventIsDetonated := TSFBoolEvent.Create(Self, 'isDetonated', false);
  AddEvent(FEventIsDetonated);

  FEventIsNetworkReader := TSFBoolEvent.Create(Self, 'isNetworkReader', false);
  AddEvent(FEventIsNetworkReader);

  FEventIsNetworkWriter := TSFBoolEvent.Create(Self, 'isNetworkWriter', false);
  AddEvent(FEventIsNetworkWriter);

  FEventIsRtpHeaderHeard := TSFBoolEvent.Create(Self, 'isRtpHeaderHeard', false);
  AddEvent(FEventIsRtpHeaderHeard);

  FEventIsStandAlone := TSFBoolEvent.Create(Self, 'isStandAlone', false);
  AddEvent(FEventIsStandAlone);

  FEventTimestamp := TSFTimeEvent.Create(Self, 'timestamp', false);
  AddEvent(FEventTimestamp);

  FFdRtpHeaderExpected := TSFBool.Create(Self, False, 'rtpHeaderExpected', false);
   FdRtpHeaderExpected.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRtpHeaderExpected);
end;

{$endif read_implementation}
