{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetAxisRotation: TVector4;
    procedure SetAxisRotation(const Value: TVector4);
    function GetDiskAngle: Single;
    procedure SetDiskAngle(const Value: Single);
    function GetMaxAngle: Single;
    procedure SetMaxAngle(const Value: Single);
    function GetMinAngle: Single;
    procedure SetMinAngle(const Value: Single);
    function GetOffset: Single;
    procedure SetOffset(const Value: Single);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdAxisRotation: TSFRotation;
    { Internal wrapper for property @code(AxisRotation). This wrapper API may change, we advise to access simpler @code(AxisRotation) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAxisRotation: TSFRotation read FFdAxisRotation;
    {  }
    property AxisRotation: TVector4 read GetAxisRotation write SetAxisRotation;

    strict private FFdDiskAngle: TSFFloat;
    { Internal wrapper for property @code(DiskAngle). This wrapper API may change, we advise to access simpler @code(DiskAngle) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDiskAngle: TSFFloat read FFdDiskAngle;
    {  }
    property DiskAngle: Single read GetDiskAngle write SetDiskAngle;

    strict private FFdMaxAngle: TSFFloat;
    { Internal wrapper for property @code(MaxAngle). This wrapper API may change, we advise to access simpler @code(MaxAngle) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMaxAngle: TSFFloat read FFdMaxAngle;
    {  }
    property MaxAngle: Single read GetMaxAngle write SetMaxAngle;

    strict private FFdMinAngle: TSFFloat;
    { Internal wrapper for property @code(MinAngle). This wrapper API may change, we advise to access simpler @code(MinAngle) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMinAngle: TSFFloat read FFdMinAngle;
    {  }
    property MinAngle: Single read GetMinAngle write SetMinAngle;

    strict private FFdOffset: TSFFloat;
    { Internal wrapper for property @code(Offset). This wrapper API may change, we advise to access simpler @code(Offset) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdOffset: TSFFloat read FFdOffset;
    {  }
    property Offset: Single read GetOffset write SetOffset;

    strict private FEventRotation_changed: TSFRotationEvent;
    {  }
    public property EventRotation_changed: TSFRotationEvent read FEventRotation_changed;

{$endif read_interface}

{$ifdef read_implementation}

{ TCylinderSensorNode ----------------------------------------------- }

function TCylinderSensorNode.GetAxisRotation: TVector4;
begin
  Result := FdAxisRotation.Value;
end;

procedure TCylinderSensorNode.SetAxisRotation(const Value: TVector4);
begin
  FdAxisRotation.Send(Value);
end;

function TCylinderSensorNode.GetDiskAngle: Single;
begin
  Result := FdDiskAngle.Value;
end;

procedure TCylinderSensorNode.SetDiskAngle(const Value: Single);
begin
  FdDiskAngle.Send(Value);
end;

function TCylinderSensorNode.GetMaxAngle: Single;
begin
  Result := FdMaxAngle.Value;
end;

procedure TCylinderSensorNode.SetMaxAngle(const Value: Single);
begin
  FdMaxAngle.Send(Value);
end;

function TCylinderSensorNode.GetMinAngle: Single;
begin
  Result := FdMinAngle.Value;
end;

procedure TCylinderSensorNode.SetMinAngle(const Value: Single);
begin
  FdMinAngle.Send(Value);
end;

function TCylinderSensorNode.GetOffset: Single;
begin
  Result := FdOffset.Value;
end;

procedure TCylinderSensorNode.SetOffset(const Value: Single);
begin
  FdOffset.Send(Value);
end;

class function TCylinderSensorNode.ClassX3DType: String;
begin
  Result := 'CylinderSensor';
end;

procedure TCylinderSensorNode.CreateNode;
begin
  inherited;

  FFdAxisRotation := TSFRotation.Create(Self, True, 'axisRotation', Vector3(0, 1, 0), 0);
   FdAxisRotation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAxisRotation);

  FFdDiskAngle := TSFFloat.Create(Self, True, 'diskAngle', Pi/12);
   FdDiskAngle.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDiskAngle);

  FFdMaxAngle := TSFFloat.Create(Self, True, 'maxAngle', -1);
   FdMaxAngle.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMaxAngle);

  FFdMinAngle := TSFFloat.Create(Self, True, 'minAngle', 0);
   FdMinAngle.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMinAngle);

  FFdOffset := TSFFloat.Create(Self, True, 'offset', 0);
   FdOffset.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdOffset);

  FEventRotation_changed := TSFRotationEvent.Create(Self, 'rotation_changed', false);
  AddEvent(FEventRotation_changed);
end;

{$endif read_implementation}
