/*
    This file is part of xmms-curses, copyright 2003-2005 Knut Auvor Grythe.

    xmms-curses is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    xmms-curses is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with xmms-curses; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _PLAYLIST_H_

#define _PLAYLIST_H_

typedef struct {
	gchar *title;
	gchar *file;
	gint length;
} song;

typedef struct {
	gint pos;
	gint prev_pos;
	gint length;
	gint selector;
	gint scrolledto;
	song *song;
	gint *song_mask;
} playlist;

void playlist_paint(playlist *plist);
void playlist_read(gint length);
gint song_length(gint song);
gchar *song_title(gint song);

#endif
