/**************************************************************************
 *
 * Copyright 2014 VMware, Inc.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 **************************************************************************/


/*
 * Helper functions for C++ code generated by dxgitrace.py.
 *
 */

#pragma once


#include <assert.h>

#include "d3dcommonshader.hpp"

#include "d3d10imports.hpp"
#include "d3d10size.hpp"
#include "d3d11imports.hpp"
#include "d3d11size.hpp"
#include "dcompimports.hpp"
#include "d2dimports.hpp" // WINCODEC_ERR_UNSUPPORTEDPIXELFORMAT
#include "d3d9imports.hpp" // D3DPERF_*
#include "memtrace.hpp"


/*
 * Overloaded function to determine whether a given resource be have maps
 * shadowed or not.
 */

inline bool
_shouldShadowMap(IDXGISurface *pSurface)
{
    return false;
}

inline bool
_shouldShadowMap(ID3D10Resource *pResource)
{
    D3D10_RESOURCE_DIMENSION Type = D3D10_RESOURCE_DIMENSION_UNKNOWN;
    pResource->GetType(&Type);
    return Type == D3D10_RESOURCE_DIMENSION_BUFFER;
}

inline bool
_shouldShadowMap(ID3D11Resource *pResource)
{
    D3D11_RESOURCE_DIMENSION Type = D3D11_RESOURCE_DIMENSION_UNKNOWN;
    pResource->GetType(&Type);
    return Type == D3D11_RESOURCE_DIMENSION_BUFFER;
}


/*
 * Overloaded function to initialize buffer resources upon creation time.
 */

inline void
_initialBufferAlloc(const D3D10_BUFFER_DESC *pDesc, D3D10_SUBRESOURCE_DATA *pInitialData)
{
    void *data = malloc(pDesc->ByteWidth);
    assert(data);
    MemoryShadow::zero(data, pDesc->ByteWidth);

    pInitialData->SysMemPitch = 0;
    pInitialData->SysMemSlicePitch = 0;
    pInitialData->pSysMem = data;
}

inline void
_initialBufferFree(D3D10_SUBRESOURCE_DATA *pInitialData)
{
    free(const_cast<void*>(pInitialData->pSysMem));
}

inline void
_initialBufferAlloc(const D3D11_BUFFER_DESC *pDesc, D3D11_SUBRESOURCE_DATA *pInitialData)
{
    void *data = malloc(pDesc->ByteWidth);
    assert(data);
    MemoryShadow::zero(data, pDesc->ByteWidth);

    pInitialData->SysMemPitch = 0;
    pInitialData->SysMemSlicePitch = 0;
    pInitialData->pSysMem = data;
}

inline void
_initialBufferFree(D3D11_SUBRESOURCE_DATA *pInitialData)
{
    free(const_cast<void*>(pInitialData->pSysMem));
}
