# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function

__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The arg spec for the eos_ospfv3 module
"""


class Ospfv3Args(object):  # pylint: disable=R0903
    """The arg spec for the eos_ospfv3 module
    """

    def __init__(self, **kwargs):
        pass

    argument_spec = {
        "running_config": {"type": "str"},
        "state": {
            "default": "merged",
            "type": "str",
            "choices": [
                "deleted",
                "merged",
                "overridden",
                "replaced",
                "gathered",
                "rendered",
                "parsed",
            ],
        },
        "config": {
            "type": "dict",
            "options": {
                "processes": {
                    "elements": "dict",
                    "type": "list",
                    "options": {
                        "router_id": {"type": "str"},
                        "shutdown": {"type": "bool"},
                        "fips_restrictions": {"type": "bool"},
                        "graceful_restart_helper": {"type": "bool"},
                        "adjacency": {
                            "type": "dict",
                            "options": {
                                "exchange_start": {
                                    "type": "dict",
                                    "options": {"threshold": {"type": "int"}},
                                }
                            },
                        },
                        "max_metric": {
                            "type": "dict",
                            "options": {
                                "router_lsa": {
                                    "type": "dict",
                                    "options": {
                                        "external_lsa": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "max_metric_value": {
                                                    "type": "int"
                                                },
                                            },
                                        },
                                        "summary_lsa": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "max_metric_value": {
                                                    "type": "int"
                                                },
                                            },
                                        },
                                        "set": {"type": "bool"},
                                        "on_startup": {
                                            "type": "dict",
                                            "options": {
                                                "wait_for_bgp": {
                                                    "type": "bool"
                                                },
                                                "wait_period": {"type": "int"},
                                            },
                                        },
                                        "include_stub": {"type": "bool"},
                                    },
                                }
                            },
                        },
                        "log_adjacency_changes": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "detail": {"type": "bool"},
                            },
                        },
                        "graceful_restart": {
                            "type": "dict",
                            "options": {
                                "grace_period": {"type": "int"},
                                "set": {"type": "bool"},
                            },
                        },
                        "timers": {
                            "type": "dict",
                            "options": {
                                "throttle": {
                                    "type": "dict",
                                    "options": {
                                        "max": {"type": "int"},
                                        "initial": {"type": "int"},
                                        "min": {"type": "int"},
                                        "spf": {"type": "bool"},
                                        "lsa": {"type": "bool"},
                                    },
                                },
                                "out_delay": {"type": "int"},
                                "pacing": {"type": "int"},
                                "lsa": {"type": "int"},
                            },
                        },
                        "vrf": {"type": "str"},
                        "auto_cost": {
                            "type": "dict",
                            "options": {
                                "reference_bandwidth": {"type": "int"}
                            },
                        },
                        "passive_interface": {"type": "bool"},
                        "bfd": {
                            "type": "dict",
                            "options": {"all_interfaces": {"type": "bool"}},
                        },
                        "areas": {
                            "elements": "dict",
                            "type": "list",
                            "options": {
                                "area_id": {"type": "str"},
                                "encryption": {
                                    "type": "dict",
                                    "options": {
                                        "hidden_key": {"type": "bool"},
                                        "key": {"type": "str"},
                                        "algorithm": {
                                            "type": "str",
                                            "choices": ["sha1", "md5"],
                                        },
                                        "encrypt_key": {"type": "bool"},
                                        "encryption": {
                                            "type": "str",
                                            "choices": [
                                                "3des-cbc",
                                                "aes-128-cbc",
                                                "aes-192-cbc",
                                                "aes-256-cbc",
                                                "null",
                                            ],
                                        },
                                        "spi": {"type": "int"},
                                        "passphrase": {"type": "str"},
                                    },
                                },
                                "nssa": {
                                    "type": "dict",
                                    "options": {
                                        "translate": {"type": "bool"},
                                        "default_information_originate": {
                                            "type": "dict",
                                            "options": {
                                                "metric_type": {"type": "int"},
                                                "metric": {"type": "int"},
                                                "nssa_only": {"type": "bool"},
                                                "set": {"type": "bool"},
                                            },
                                        },
                                        "nssa_only": {"type": "bool"},
                                        "set": {"type": "bool"},
                                        "no_summary": {"type": "bool"},
                                    },
                                },
                                "stub": {
                                    "type": "dict",
                                    "options": {
                                        "summary_lsa": {"type": "bool"},
                                        "set": {"type": "bool"},
                                    },
                                },
                                "default_cost": {"type": "int"},
                                "authentication": {
                                    "type": "dict",
                                    "options": {
                                        "hidden_key": {"type": "bool"},
                                        "key": {"type": "str"},
                                        "algorithm": {
                                            "type": "str",
                                            "choices": ["md5", "sha1"],
                                        },
                                        "encrypt_key": {"type": "bool"},
                                        "spi": {"type": "int"},
                                        "passphrase": {"type": "str"},
                                    },
                                },
                            },
                        },
                        "address_family": {
                            "elements": "dict",
                            "type": "list",
                            "options": {
                                "router_id": {"type": "str"},
                                "distance": {"type": "int"},
                                "redistribute": {
                                    "elements": "dict",
                                    "type": "list",
                                    "options": {
                                        "routes": {
                                            "type": "str",
                                            "choices": [
                                                "bgp",
                                                "connected",
                                                "static",
                                            ],
                                        },
                                        "route_map": {"type": "str"},
                                    },
                                },
                                "default_information": {
                                    "type": "dict",
                                    "options": {
                                        "metric_type": {"type": "int"},
                                        "always": {"type": "bool"},
                                        "metric": {"type": "int"},
                                        "originate": {"type": "bool"},
                                        "route_map": {"type": "str"},
                                    },
                                },
                                "afi": {
                                    "choices": ["ipv4", "ipv6"],
                                    "type": "str",
                                },
                                "fips_restrictions": {"type": "bool"},
                                "default_metric": {"type": "int"},
                                "maximum_paths": {"type": "int"},
                                "adjacency": {
                                    "type": "dict",
                                    "options": {
                                        "exchange_start": {
                                            "type": "dict",
                                            "options": {
                                                "threshold": {"type": "int"}
                                            },
                                        }
                                    },
                                },
                                "max_metric": {
                                    "type": "dict",
                                    "options": {
                                        "router_lsa": {
                                            "type": "dict",
                                            "options": {
                                                "external_lsa": {
                                                    "type": "dict",
                                                    "options": {
                                                        "set": {
                                                            "type": "bool"
                                                        },
                                                        "max_metric_value": {
                                                            "type": "int"
                                                        },
                                                    },
                                                },
                                                "summary_lsa": {
                                                    "type": "dict",
                                                    "options": {
                                                        "set": {
                                                            "type": "bool"
                                                        },
                                                        "max_metric_value": {
                                                            "type": "int"
                                                        },
                                                    },
                                                },
                                                "set": {"type": "bool"},
                                                "on_startup": {
                                                    "type": "dict",
                                                    "options": {
                                                        "wait_for_bgp": {
                                                            "type": "bool"
                                                        },
                                                        "wait_period": {
                                                            "type": "int"
                                                        },
                                                    },
                                                },
                                                "include_stub": {
                                                    "type": "bool"
                                                },
                                            },
                                        }
                                    },
                                },
                                "log_adjacency_changes": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "detail": {"type": "bool"},
                                    },
                                },
                                "timers": {
                                    "type": "dict",
                                    "options": {
                                        "throttle": {
                                            "type": "dict",
                                            "options": {
                                                "max": {"type": "int"},
                                                "initial": {"type": "int"},
                                                "min": {"type": "int"},
                                                "spf": {"type": "bool"},
                                                "lsa": {"type": "bool"},
                                            },
                                        },
                                        "out_delay": {"type": "int"},
                                        "pacing": {"type": "int"},
                                        "lsa": {"type": "int"},
                                    },
                                },
                                "shutdown": {"type": "bool"},
                                "auto_cost": {
                                    "type": "dict",
                                    "options": {
                                        "reference_bandwidth": {"type": "int"}
                                    },
                                },
                                "graceful_restart_helper": {"type": "bool"},
                                "passive_interface": {"type": "bool"},
                                "bfd": {
                                    "type": "dict",
                                    "options": {
                                        "all_interfaces": {"type": "bool"}
                                    },
                                },
                                "areas": {
                                    "elements": "dict",
                                    "type": "list",
                                    "options": {
                                        "ranges": {
                                            "elements": "dict",
                                            "type": "list",
                                            "options": {
                                                "subnet_mask": {"type": "str"},
                                                "advertise": {"type": "bool"},
                                                "cost": {"type": "int"},
                                                "subnet_address": {
                                                    "type": "str"
                                                },
                                                "address": {"type": "str"},
                                            },
                                        },
                                        "area_id": {"type": "str"},
                                        "encryption": {
                                            "type": "dict",
                                            "options": {
                                                "hidden_key": {"type": "bool"},
                                                "key": {"type": "str"},
                                                "algorithm": {
                                                    "type": "str",
                                                    "choices": ["sha1", "md5"],
                                                },
                                                "encrypt_key": {
                                                    "type": "bool"
                                                },
                                                "encryption": {
                                                    "type": "str",
                                                    "choices": [
                                                        "3des-cbc",
                                                        "aes-128-cbc",
                                                        "aes-192-cbc",
                                                        "aes-256-cbc",
                                                        "null",
                                                    ],
                                                },
                                                "spi": {"type": "int"},
                                                "passphrase": {"type": "str"},
                                            },
                                        },
                                        "nssa": {
                                            "type": "dict",
                                            "options": {
                                                "translate": {"type": "bool"},
                                                "default_information_originate": {
                                                    "type": "dict",
                                                    "options": {
                                                        "metric_type": {
                                                            "type": "int"
                                                        },
                                                        "metric": {
                                                            "type": "int"
                                                        },
                                                        "nssa_only": {
                                                            "type": "bool"
                                                        },
                                                        "set": {
                                                            "type": "bool"
                                                        },
                                                    },
                                                },
                                                "nssa_only": {"type": "bool"},
                                                "set": {"type": "bool"},
                                                "no_summary": {"type": "bool"},
                                            },
                                        },
                                        "stub": {
                                            "type": "dict",
                                            "options": {
                                                "summary_lsa": {
                                                    "type": "bool"
                                                },
                                                "set": {"type": "bool"},
                                            },
                                        },
                                        "default_cost": {"type": "int"},
                                        "authentication": {
                                            "type": "dict",
                                            "options": {
                                                "hidden_key": {"type": "bool"},
                                                "key": {"type": "str"},
                                                "algorithm": {
                                                    "type": "str",
                                                    "choices": ["md5", "sha1"],
                                                },
                                                "encrypt_key": {
                                                    "type": "bool"
                                                },
                                                "spi": {"type": "int"},
                                                "passphrase": {"type": "str"},
                                            },
                                        },
                                    },
                                },
                                "graceful_restart": {
                                    "type": "dict",
                                    "options": {
                                        "grace_period": {"type": "int"},
                                        "set": {"type": "bool"},
                                    },
                                },
                            },
                        },
                    },
                }
            },
        },
    }  # pylint: disable=C0301
